from api import *

from random import randint

def getInd(ind):
    me = moi()
    ind = troupes_joueur(me)[ind].id
    return ind


def getDir(pos1, pos2):
    x1, x2 = pos1[1], pos2[1]
    y1, y2 = pos1[0], pos2[0]
    if x1 > x2:
        print(f"{pos1} => {pos2}, OUEST")
        return direction.OUEST
    if x1 < x2:
        print(f"{pos1} => {pos2}, EST")
        return direction.EST
    if y1 > y2:
        print(f"{pos1} => {pos2}, SUD")
        return direction.SUD
    if y1 < y2:
        print(f"{pos1} => {pos2}, NORD")
        return direction.NORD
    print("ERREUR")
    return None

def getPos(ind):
    me = moi()
    maman = troupes_joueur(me)[ind].maman
    return maman

def convertNum(x, y):
    return str(x + y*HAUTEUR)

def convertCoord(i):
    return i%LARGEUR, i//LARGEUR

def getGraph():
    graph = []
    for i in range(HAUTEUR):
        row = []
        for j in range(LARGEUR):
            row.append(str(j+i*HAUTEUR))
        graph.append(row)
    dGraph = {}
    for i, row in enumerate(graph):
        for j , el in enumerate(row):
            case = (j, i, 0)
            if info_case(case).contenu != type_case.BUISSON:
                dGraph[el] = []
                x, y, z = case
                if x == 0:
                    new_case = (x+1, y, z)
                    if info_case(new_case).contenu != type_case.BUISSON:
                        dGraph[el].append(convertNum(x+1, y))
                elif x == LARGEUR-1:
                    new_case = (x-1, y, z)
                    if info_case(new_case).contenu != type_case.BUISSON:
                        dGraph[el].append(convertNum(x-1, y))
                else:
                    new_case = (x+1, y, z)
                    if info_case(new_case).contenu != type_case.BUISSON:
                        dGraph[el].append(convertNum(x+1, y))
                    new_case = (x-1, y, z)
                    if info_case(new_case).contenu != type_case.BUISSON:
                        dGraph[el].append(convertNum(x-1, y))
                if y == 0:
                    new_case = (x, y+1, z)
                    if info_case(new_case).contenu != type_case.BUISSON:
                        dGraph[el].append(convertNum(x, y+1))
                elif y == HAUTEUR-1:
                    new_case = (x, y-1, z)
                    if info_case(new_case).contenu != type_case.BUISSON:
                        dGraph[el].append(convertNum(x, y-1))
                else:
                    new_case = (x, y-1, z)
                    if info_case(new_case).contenu != type_case.BUISSON:
                        dGraph[el].append(convertNum(x, y-1))
                    new_case = (x, y+1, z)
                    if info_case(new_case).contenu != type_case.BUISSON:
                        dGraph[el].append(convertNum(x, y+1))
    return graph, dGraph

def djikstra(from_, to_, graph):
    dgraph = {}
    for node in graph:
        dgraph[node] = [0, float("inf"), "FROM"]
    x, y = from_
    from_ = convertNum(x, y)
    dgraph[from_] = [1, 0, "INIT"] 
    case = from_
    x, y = to_
    caseFinale = convertNum(x, y)
    dist = 0
    prev = []
    while case != caseFinale:
        poss = graph[case]
        allPoss = []
        allDist = []
        for p in poss:
            if dgraph[p][0] == 0:
                allPoss.append(p)
                distance = min(dist+1, dgraph[p][1])
                if distance == dist+1:
                    dgraph[p][1] = distance
                    dgraph[p][2] = case
                allDist.append(distance)
        prev.append(case)
        try:
            newCase = allPoss[allDist.index(min(allDist))]
            dgraph[newCase][0] = [1]
            case = newCase
        except:
            case = prev[-2]
            del prev[-1]
            del prev[-1]
    path = [case]
    distance = dgraph[case][1]
    while case != from_:
        path.append(dgraph[case][2])
        case = dgraph[case][2]
    path = path[::-1]
    return path, distance

def getEL(for_, graph):
    tab = []
    for y, row in enumerate(graph):
        for x, el in enumerate(row): 
            case = (x, y, 0)
            if info_case(case).contenu == for_:
                #case = (x, HAUTEUR-y-1, 0)
                case = (x, y, 0)
                tab.append(case)
    return tab

def getObj(graph, i):
    objectifs = [pains(), getEL(type_case.PAPY, graph), getEL(type_case.NID, graph)]
    if troupes_joueur(moi())[i].inventaire > 0:
        return objectifs[2]
    if objectifs[0]:
        return objectifs[0]
    
    return objectifs[randint(1, 2)]

def partie_init():
    print("Partie INIT")

def jouer_tour():
    graph, dgraph = getGraph()
    for i in range(2):
        if randint(0, 1) == 0:
            grandir(getInd(i))
        print("poule numéro {}".format(i))
        print("Choix de l'objectif...")
        obj = getObj(graph, i)
        allDist = []
        allPath = []
        for o in obj:
            road = trouver_chemin(getPos(i), o)
            if len(road) != 0:
                allDist.append(len(road))
                allPath.append(road)
        if allDist:
            path = allPath[allDist.index(min(allDist))]
            for direc in path:
                avancer(getInd(i), direc)
        else:
            pass
        if troupes_joueur(moi())[i].pts_action > 0:
            for o in obj:
                road = trouver_chemin(getPos(i), o)
                if len(road) != 0:
                    allDist.append(len(road))
                    allPath.append(road)
            if allDist:
                path = allPath[allDist.index(min(allDist))]
                for direc in path:
                    avancer(getInd(i), direc)
        j = 4
        while troupes_joueur(moi())[i].pts_action > 0:
            for dire in [direction.NORD, direction.SUD, direction.EST, direction.OUEST]:
                tailleAvt = troupes_joueur(moi())[i].taille
                avancer(i, dire)
                if tailleAvt > troupes_joueur(moi())[i].taille:
                    annuler()
            j -= 1
            if j < 0:
                break


         




    

def partie_fin():
    pass
