from api import *
from functools import lru_cache
import random
import time

NIDS = []
VIEUX = []
TROUS =[]
OBS = []
GR = []
ID = []
MOI = []
CHARGES = {}

trouver_chemin = lru_cache()(trouver_chemin)

def partie_init():
    global OBS
    global ID
    global CHARGES
    global TROUS
    OBS = [[True for i in range(LARGEUR)] for j in range(HAUTEUR)]
    for j in range(HAUTEUR):
        for i in range(LARGEUR):
            if info_case((i, j, 0)).contenu is type_case.BUISSON:
                OBS[i][j] = False
            if info_case((i, j, 0)).contenu is type_case.TROU:
                TROUS.append((i, j))
    for troupe in troupes_joueur(moi()):
        ID.append(troupe.id)
    CHARGES[ID[0]], CHARGES[ID[1]] = 0, 0

def gtroupe(id):
    for troupe in troupes_joueur(moi()):
        if troupe.id == id:
            return troupe
    for troupe in troupes_joueur(adversaire()):
        if troupe.id == id:
            return troupe

def tunnel(a, b):
    x, y = a
    x2, y2 = b
    if x > x2:
        pas = -1
    else:
        pas = 1
    for i in range(x, x2+pas, pas):
        if info_case((i, y, -1)).contenu is type_case.TERRE:
            creuser_tunnel((i, y, -1))
            return False
    if y > y2:
        pas = -1
    else:
        pas = 1
    for i in range(y, y2+pas, pas):
        if info_case((x2, i, -1)).contenu is type_case.TERRE:
            creuser_tunnel((x2, i, -1))
            return False
    return True

def manhat(a, b):
    x, y = a
    x2, y2 = b
    return abs(x-x2)+abs(y-y2)

@lru_cache()
def plus_proche(pos, liste):
    x, y = pos
    dmax = 40*40
    pmax = None
    for trou in liste:
        dist = len(trouver_chemin((x, y, 0), (trou[0], trou[1], 0)))
        if 0 < dist < dmax:
            dmax, pmax = dist, trou
    return pmax

def bouger(id, dire):
    global GR
    if dire is direction.EST:
        dx, dy, dz = 1, 0, 0
    elif dire is direction.OUEST:
        dx, dy, dz = -1, 0, 0
    elif dire is direction.SUD:
        dx, dy, dz = 0, -1, 0
    elif dire is direction.NORD:
        dx, dy, dz = 0, 1, 0
    elif dire is direction.BAS:
        dx, dy, dz = 0, 0, -1
    elif dire is direction.HAUT:
        dx, dy, dz = 0, 0, 1
    x, y, z = gtroupe(id).maman
    nx, ny, nz = x+dx, y+dy, z+dz
    majc()
    if 0 <= nx < LARGEUR and 0 <= ny < HAUTEUR:
        if nz == 0 and not GR[nx][ny]:
            CHARGES[id] = 0
        elif info_case((nx, ny, nz)).contenu is type_case.TERRE:
            CHARGES[id] = 0
        elif info_case((nx, ny, nz)).contenu is type_case.NID and not (info_nid((nx, ny, nz)) == adversaire()+1):
            CHARGES[id] = 0
        else:
            CHARGES[id] = min(inventaire(gtroupe(id).taille), CHARGES[id]+info_case((nx, ny, nz)).nb_pains)
        avancer(id, dire)

def case_vers(case, dire):
    if dire is direction.EST:
        dx, dy, dz = 1, 0, 0
    elif dire is direction.OUEST:
        dx, dy, dz = -1, 0, 0
    elif dire is direction.SUD:
        dx, dy, dz = 0, -1, 0
    elif dire is direction.NORD:
        dx, dy, dz = 0, 1, 0
    return (case[0]+dx, case[1]+dy)

def majc():
    global GR, MOI
    NIDS.clear()
    VIEUX.clear()
    MOI.clear()
    plus_proche.cache_clear()
    trouver_chemin.cache_clear()
    GR = [i.copy() for i in OBS]
    for troupe in troupes_joueur(adversaire()):
        for (x, y, z) in troupe.canards:
            if z == 0:
                GR[x][y] = False
    for troupe in troupes_joueur(moi()):
        for (x, y, z) in troupe.canards:
            if z == 0:
                GR[x][y] = False
    for i in range(LARGEUR):
        for j in range(HAUTEUR):
            if GR[i][j]:
                if info_case((i, j, 0)).contenu is type_case.NID and info_nid((i, j, 0)) is etat_nid.LIBRE:
                    NIDS.append((i, j))
                    MOI.append((i, j))
                elif info_case((i, j, 0)).contenu is type_case.NID and int(info_nid((i, j, 0))) == 1+int(moi()):
                    MOI.append((i, j))
                elif info_case((i, j, 0)).contenu is type_case.PAPY:
                    VIEUX.append((i, j))
                elif info_case((i, j, 0)).contenu is type_case.BARRIERE and info_barriere((i, j, 0)) is etat_barriere.FERMEE:
                    GR[i][j] = False

def jouer_tour():
    majc()
    for i in range(2):
        id = ID[i]
        while gtroupe(id).pts_action > 0:
            if gtroupe(id).pts_action > 3 and CHARGES[id] >= gtroupe(id).taille // 3:
                grandir(id)
            x, y, z = gtroupe(id).maman
            if CHARGES[id] > (400-tour_actuel())/80:
                print(MOI, "MOI")
                if z == 0:
                    cible = plus_proche((x, y), tuple(MOI))
                    if cible:
                        print("Decharge")
                        bouger(id, trouver_chemin((x, y, 0), (cible[0], cible[1], 0))[0])
                        continue
                    deb = plus_proche((x, y), tuple(TROUS))
                    if deb:
                        dmin = 40*40
                        trou = None
                        for nid in MOI:
                            tr = plus_proche(nid, tuple(TROUS))
                            if tr:
                                dist = manhat(deb, tr)+len(trouver_chemin((tr[0], tr[1], 0), (nid[0], nid[1], 0)))
                                if dist < dmin:
                                    trou, dmin = tr, dist
                        if trou:
                            print("Soulagement")
                            tunnel(deb, trou)
                            if (x, y) == deb:
                                bouger(id, direction.BAS)
                                continue
                            bouger(id, trouver_chemin((x, y, z), (deb[0], deb[1], 0))[0])
                            continue
                else:
                    deb = (x, y)
                    dmin = 40*40
                    trou = None
                    for nid in MOI:
                        tr = plus_proche(nid, tuple(TROUS))
                        if tr:
                            dist = manhat(deb, tr)+len(trouver_chemin((tr[0], tr[1], 0), (nid[0], nid[1], 0)))
                            if dist < dmin:
                                trou, dmin = tr, dist
                    if trou:
                        tunnel(deb, trou)
                        if (x, y) == trou:
                            bouger(id, direction.HAUT)
                            continue
                        xn, yn = trou
                        if xn > x:
                            bouger(id, direction.EST)
                            continue
                        if xn < x:
                            bouger(id, direction.OUEST)
                            continue
                        if yn > y:
                            bouger(id, direction.NORD)
                            continue
                        if yn < y:
                            bouger(id, direction.SUD)
            if NIDS:
                if z == 0:
                    cible = plus_proche((x, y), tuple(NIDS))
                    if cible:
                        bouger(id, trouver_chemin((x, y, 0), (cible[0], cible[1], 0))[0])
                        continue
                    deb = plus_proche((x, y), tuple(TROUS))
                    print(deb)
                    print(TROUS)
                    if deb:
                        print("Oui")
                        dmin = 40*40
                        trou = None
                        for nid in NIDS:
                            tr = plus_proche(nid, tuple(TROUS))
                            if tr:
                                dist = manhat(deb, tr)+len(trouver_chemin((tr[0], tr[1], 0), (nid[0], nid[1], 0)))
                                if dist < dmin:
                                    trou, dmin = tr, dist
                        if trou:
                            tunnel(deb, trou)
                            if (x, y) == deb:
                                bouger(id, direction.BAS)
                                continue
                            bouger(id, trouver_chemin((x, y, z), (deb[0], deb[1], 0))[0])
                            continue
                else:
                    deb = (x, y)
                    dmin = 40*40
                    trou = None
                    for nid in NIDS:
                        tr = plus_proche(nid, tuple(TROUS))
                        if tr:
                            dist = manhat(deb, tr)+len(trouver_chemin((tr[0], tr[1], 0), (nid[0], nid[1], 0)))
                            if dist < dmin:
                                trou, dmin = tr, dist
                    if trou:
                        tunnel(deb, trou)
                        if (x, y) == trou:
                            bouger(id, direction.HAUT)
                            continue
                        xn, yn = trou
                        if xn > x:
                            bouger(id, direction.EST)
                            continue
                        if xn < x:
                            bouger(id, direction.OUEST)
                            continue
                        if yn > y:
                            bouger(id, direction.NORD)
                            continue
                        if yn < y:
                            bouger(id, direction.SUD)
            if VIEUX:
                if z == 0:
                    cible = plus_proche((x, y), tuple(VIEUX))
                    if cible:
                        bouger(id, trouver_chemin((x, y, 0), (cible[0], cible[1], 0))[0])
                        continue
                    deb = plus_proche((x, y), tuple(TROUS))
                    if deb:
                        dmin = 40*40
                        trou = None
                        for nid in VIEUX:
                            tr = plus_proche(nid, tuple(TROUS))
                            if tr:
                                dist = manhat(deb, tr)+len(trouver_chemin((tr[0], tr[1], 0), (nid[0], nid[1], 0)))
                                if dist < dmin:
                                    trou, dmin = tr, dist
                        if trou:
                            tunnel(deb, trou)
                            if (x, y) == deb:
                                bouger(id, direction.BAS)
                                continue
                            bouger(id, trouver_chemin((x, y, z), (deb[0], deb[1], 0))[0])
                            continue
                else:
                    deb = (x, y)
                    dmin = 40*40
                    trou = None
                    for nid in VIEUX:
                        tr = plus_proche(nid, tuple(TROUS))
                        if tr:
                            dist = manhat(deb, tr)+len(trouver_chemin((tr[0], tr[1], 0), (nid[0], nid[1], 0)))
                            if dist < dmin:
                                trou, dmin = tr, dist
                    if trou:
                        tunnel(deb, trou)
                        if (x, y) == trou:
                            bouger(id, direction.HAUT)
                            continue
                        xn, yn = trou
                        if xn > x:
                            bouger(id, direction.EST)
                            continue
                        if xn < x:
                            bouger(id, direction.OUEST)
                            continue
                        if yn > y:
                            bouger(id, direction.NORD)
                            continue
                        if yn < y:
                            bouger(id, direction.SUD)
            dirs = [direction.EST, direction.OUEST, direction.NORD, direction.SUD]
            random.shuffle(dirs)
            while dirs:
                dire = dirs.pop(-1)
                xs, ys = case_vers((gtroupe(id).maman[0], gtroupe(id).maman[1]), dire)
                if (0 <= xs < LARGEUR and 0 <= ys < HAUTEUR and GR[xs][ys]) or CHARGES[id] == 0:
                    print("Sauve", tour_actuel())
                    bouger(id, dire)
                    break
            else:     
                bouger(id, random.choice((direction.EST, direction.OUEST, direction.NORD, direction.SUD)))

def partie_fin():
    if score(adversaire())-score(moi()) > 10:
        print("J'ai beaucoup appris de cette partie.")
    elif score(moi())-score(adversaire()) > 10:
        print("Une revanche ?")
    else:
        print("Un match serre...")

