from time import monotonic
from api import *
from collections import deque
from functools import lru_cache
import random as rd
import time
t = time

class Deque(deque):
    
    def __hash__(self):
        return hash(tuple(self))

OBS = []
GR = []
OBJ = {40*40}
ID = []
NIDS = []
VIEUX = []
MOI = []
CHARGES = [0, 0]
vis = set()
# Fonction appelée au début de la partie.
def partie_init():
    global OBS
    OBS = [[True for i in range(LARGEUR)] for j in range(HAUTEUR)]
    OBS = Deque(OBS)
    for j in range(HAUTEUR):
        for i in range(LARGEUR):
            if info_case((i, j, 0)).contenu is type_case.BUISSON:
                OBS[i][j] = False
    for troupe in troupes_joueur(moi()):
        OBJ[troupe.id] = 0
        ID[:] = list(OBJ.keys())

def gtroupe(id):
    for troupe in troupes_joueur(moi()):
        if troupe.id == id:
            return troupe
    for troupe in troupes_joueur(adversaire()):
        if troupe.id == id:
            return troupe

def tunnel(a, b):
    x, y = a
    x2, y2 = b
    if x > x2:
        pas = -1
    else:
        pas = 1
    for i in range(x, x2+pas, pas):
        if info_case((i, y, -1)).contenu is type_case.TERRE:
            creuser_tunnel((i, y, -1))
            return False
    if y > y2:
        pas = -1
    else:
        pas = 1
    for i in range(y, y2+pas, pas):
        if info_case((x2, i, -1)).contenu is type_case.TERRE:
            creuser_tunnel((x2, i, -1))
            return False
    return True

def manhat(a, b):
    x, y = a
    x2, y2 = b
    return abs(x-x2)+abs(y-y2)

def directio(a, b):
    x1, y1 = a
    x2, y2 = b
    if x2-x1 == 1 and y1 == y2:
        return direction.EST
    elif x1-x2 == 1 and y1 == y2:
        return direction.OUEST
    elif x1 == x2 and y2-y1 == 1:
        return direction.NORD
    elif x1 == x2 and y1-y2 == 1:
        return direction.SUD
    else:
        print(a, b, tour_actuel(), "Bug1")
        return direction.NORD

def majc():
    global GR
    GR = Deque(Deque(i.copy()) for i in OBS)
    NIDS.clear()
    VIEUX.clear()
    MOI.clear()
    chemins3.cache_clear()
    for troupe in troupes_joueur(adversaire()):
        for (x, y, z) in troupe.canards:
            if z == 0:
                GR[x][y] = False
    for i in range(LARGEUR):
        for j in range(HAUTEUR):
            if GR[j][i]:
                if info_case((i, j, 0)).contenu is type_case.NID and info_nid((i, j, 0)) is etat_nid.LIBRE:
                    NIDS.append((i, j))
                elif info_case((i, j, 0)).contenu is type_case.NID and info_nid((i, j, 0)) == moi():
                    MOI.append((i, j))
                elif info_case((i, j, 0)).contenu is type_case.PAPY:
                    VIEUX.append((i, j))



# Fonction appelée à chaque tour.
def jouer_tour():
    s = t.monotonic()
    majc()
    print(t.monotonic()-s)
    for nt in range(NB_TROUPES):
        id = ID[nt]
        tr = gtroupe(id)
        for _ in range(10):
            if OBJ[id] == 0 and NIDS:
                chem = vchemins(tr, lambda tup: tup in NIDS and OBJ[ID[1-nt]] != tup)
                if chem:
                    OBJ[id] = chem
                else:
                    try:
                        dep = Deque([(tr.maman[0], tr.maman[1])]) if info_case((tr.maman[0], tr.maman[1], 0)).contenu is type_case.TROU else vchemins(tr, lambda tup: info_case((tup[0], tup[1], 0)).contenu is type_case.TROU)
                        but = None
                        vfin = None
                        dist = 40**2
                        for cible in NIDS:
                            tr.maman = cible
                            tr.canards = [cible]*len(tr.canards)
                            chem = vchemins(trm, lambda tup: info_case((tup[0], tup[1], 0)).contenu is type_case.TROU)
                            fin = chem[-1]
                            if len(chem) + manhat(dep[-1], fin) < dist:
                                dist, but, vfin = len(chem)+manhat(dep[-1], fin), cible, fin
                        if but and tunnel(dep, vfin):
                            OBJ[ID[nt]] = dep
                    except: pass
            if OBJ[id] == 0 and VIEUX:
                chem = (vchemins(tr, lambda tup: tup in VIEUX and OBJ[ID[1-nt]] != tup))
                if chem:
                    OBJ[id] = chem
                else:
                    try:
                        dep = Deque([(tr.maman[0], tr.maman[1])]) if info_case((tr.maman[0], tr.maman[1], 0)).contenu is type_case.TROU else vchemins(tr, lambda tup: info_case((tup[0], tup[1], 0)).contenu is type_case.TROU)
                        but = None
                        vfin = None
                        dist = 40**2
                        for cible in VIEUX:
                            tr.maman = cible
                            tr.canards = [cible]*len(tr.canards)
                            chem = vchemins(trm, lambda tup: info_case((tup[0], tup[1], 0)).contenu is type_case.TROU)
                            fin = chem[-1]
                            if len(chem) + manhat(dep[-1], fin) < dist:
                                dist, but, vfin = len(chem)+manhat(dep[-1], fin), cible, fin
                        if but and tunnel(dep[-1], vfin):
                            OBJ[ID[nt]] = dep
                    except: pass
            if OBJ[id] in (0, 1):
                if CHARGES[nt]:
                    chem = (vchemins(tr, lambda tup: info_case((tup[0], tup[1], 0)).contenu is type_case.NID and OBJ[ID[1-nt]] != tup and info_nid((tup[0], tup[1], 0)) != adversaire()))
                    if chem:
                        OBJ[id] = chem
                    else:
                        try:
                            dep = Deque([(tr.maman[0], tr.maman[1])]) if info_case((tr.maman[0], tr.maman[1], 0)).contenu is type_case.TROU else vchemins(tr, lambda tup: info_case((tup[0], tup[1], 0)).contenu is type_case.TROU)
                            but = None
                            vfin = None
                            dist = 40**2
                            for cible in MOI:
                                tr.maman = cible
                                tr.canards = [cible]*len(tr.canards)
                                chem = vchemins(tr, lambda tup: info_case((tup[0], tup[1], 0)).contenu is type_case.TROU)
                                fin = chem[-1]
                                if len(chem) + manhat(dep[-1], fin) < dist:
                                    dist, but, vfin = len(chem)+manhat(dep[-1], fin), cible, fin
                            if but and tunnel(dep[-1], vfin):
                                OBJ[ID[nt]] = dep
                        except: pass
                else:
                    chem = (vchemins(tr, lambda tup: any(tup in voisins((a.maman[0], a.maman[1]), GR) for a in troupes_joueur(adversaire()))))
                    if chem:
                        OBJ[id] = chem
            tr = gtroupe(id)
            if OBJ[id] == 0:
                if CHARGES[nt]:
                    try:
                        avancer(ID[nt], directio(*vchemins(tr, lambda x: True)))
                    except:
                        print("Kaputt")
                else:
                    avancer(id, rd.choice((direction.NORD, direction.SUD, direction.EST, direction.OUEST)))
            elif tr.maman[2] == 0:
                chem = OBJ[id]
                if chem:
                    if len(chem) > 1:
                        while gtroupe(id).pts_action > 0 and len(chem) > 1:
                            if gtroupe(id).pts_action > 3:
                                if gtroupe(id).taille // 3 <= CHARGES[nt]:
                                    grandir(id)
                            pos = chem.popleft()
                            avancer(ID[nt], directio(pos, chem[0]))
                            if chem[0] == OBJ[id]:
                                OBJ[id] = 0
                                if info_case((chem[0][0], chem[0][1], 0)).contenu is type_case.PAPY:
                                    CHARGES[nt] += 1
                                elif info_case((chem[0][0], chem[0][1], 0)).contenu is type_case.NID:
                                    CHARGES[nt] = 0
                                break
                        else:
                            break
                    else:
                        avancer(id, direction.BAS)
                else:
                    avancer(id, direction.BAS)
            else:
                tr = gtroupe(id)
                x, y, z = tr.maman
                print("Je t'embete")
        print(time.monotonic() -s)


def voisins(pos, grille):
    for (dx, dy) in [(1, 0), (-1, 0), (0, 1), (0, -1)]:
        x, y = pos[0]+dx, pos[1]+dy
        if 0 <= x < LARGEUR and 0 <= y < HAUTEUR and grille[pos[0]+dx][pos[1]+dy]:
            yield (x, y) 

@lru_cache(50)
def chemins3(fin, q):
    global vis
    if not q:
        return
    (jeu, grille, troupe) = q.popleft()
    x, y = jeu[-1]
    for case in voisins((x, y), grille):
        if case not in vis:
            vis.add(case)
            e = Deque(i.copy() for i in grille)
            f = troupe.copy()
            xf, yf = f.popleft()
            e[xf][yf] = True
            e[x][y] = False
            f.append(case)
            jeu.append(case)
            if fin(case):
                return jeu
            q.append((jeu, grille, f))
    try:
        return chemins4(fin, q)
    except:return

def chemins4(fin, q):
    global vis
    if not q:
        return
    (jeu, grille, troupe) = q.popleft()
    x, y = jeu[-1]
    for case in voisins((x, y), grille):
        if case not in vis:
            e = Deque(i.copy() for i in grille)
            f = troupe.copy()
            xf, yf = f.popleft()
            e[xf][yf] = True
            e[x][y] = False
            f.append(case)
            jeu.append(case)
            if fin(case):
                return jeu
            q.append((jeu, grille, f))
    return chemins4(fin, q)
    

def vchemins(t, fin):
    global vis
    vis.clear()
    grille = Deque(i.copy() for i in GR)
    troupe = Deque()
    for (x, y, z) in t.canards:
        try:
            troupe.appendleft((x, y))
            grille[x][y] = False
        except:
            print(grille, "grille")
    return chemins3(fin, Deque([Deque([Deque([(t.maman[0], t.maman[1])]), grille, troupe])]))

# Fonction appelée à la fin de la partie.
def partie_fin():
    if score(adversaire())-score(moi()) > 10:
        print("J'ai beaucoup appris de cette partie.")
    elif score(moi())-adversaire() > 10:
        print("Une revanche ?")
    else:
        print("Un match serre...")
