

// This file was generated by stechec2-generator. DO NOT EDIT.

/**
 * Erreurs possibles après avoir effectué une action
 */
enum Erreur {
    /**
     * L'action a été effectuée avec succès
     */
    OK,
    /**
     * Mauvais identifiant de troupe
     */
    TROUPE_INVALIDE,
    /**
     * Aucune action n'est possible hors de joueur_tour
     */
    HORS_TOUR,
    /**
     * Il ne reste plus assez de points de mouvements pour effectuer l'action
     * demandée
     */
    MOUVEMENTS_INSUFFISANTS,
    /**
     * La troupe a déjà trop grandi pendant le tour
     */
    TROP_GRANDI,
    /**
     * Trop de trous ont déjà été creusés pendant le tour
     */
    TROP_CREUSE,
    /**
     * Il n'est pas possible de creuser à la position demandée
     */
    NON_CREUSABLE,
    /**
     * La zone demandée n'est pas constructible
     */
    NON_CONSTRUCTIBLE,
    /**
     * Le joueur n'a pas assez de points pour construire un buisson
     */
    SCORE_INSUFFISANT,
    /**
     * La position demandée est hors du parc
     */
    POSITION_INVALIDE,
    /**
     * La direction spécifiée n'existe pas.
     */
    DIRECTION_INVALIDE,
    /**
     * Le pigeon spécifié n'existe pas.
     */
    PIGEON_INVALIDE,
}

/**
 * Directions possibles
 */
enum Direction {
    /**
     * Sens positif pour les lignes
     */
    NORD,
    /**
     * Sens négatif pour les lignes
     */
    SUD,
    /**
     * Sens positif pour les colonnes
     */
    EST,
    /**
     * Sens négatif pour les colonnes
     */
    OUEST,
    /**
     * Sens positif pour le niveau
     */
    HAUT,
    /**
     * Sens négatif pour le niveau
     */
    BAS,
}

/**
 * Type de l'élément présent sur une case
 */
enum TypeCase {
    /**
     * Absence d'élément
     */
    GAZON,
    /**
     * Obstacle impossible à traverser
     */
    BUISSON,
    /**
     * Élément pouvant être ouvert ou fermé. Une barrière fermée est
     * infranchissable alors qu'une barrière ouverte est analogue à une case
     * vide
     */
    BARRIERE,
    /**
     * Élément traversable permettant à la troupe de déposer son inventaire en
     * échange de points
     */
    NID,
    /**
     * Élément traversable générant de manière périodique des miches de pain
     */
    PAPY,
    /**
     * Interface entre le niveau principal est le niveau souterrain
     */
    TROU,
    /**
     * Bloc du souterrain ayant été creusé
     */
    TUNNEL,
    /**
     * Bloc du souterrain n'ayant pas encore été creusé
     */
    TERRE,
}

/**
 * État d'une barrière, soit ouvert, soit fermé, soit non-applicable
 */
enum EtatBarriere {
    /**
     * La barrière est ouverte
     */
    OUVERTE,
    /**
     * La barrière est fermée
     */
    FERMEE,
    /**
     * L'élément dont on requiert l'état n'est pas une barrière
     */
    PAS_DE_BARRIERE,
}

/**
 * Joueur auquel appartient un nid
 */
enum EtatNid {
    /**
     * Le nid n'a pas été attribué
     */
    LIBRE,
    /**
     * Joueur 0
     */
    JOUEUR_0,
    /**
     * Joueur 1
     */
    JOUEUR_1,
    /**
     * L'élément dont on requiert l'état n'est pas un nid
     */
    PAS_DE_NID,
}

/**
 * Type de pigeon de debug
 */
enum PigeonDebug {
    /**
     * Aucun pigeon, enlève le pigeon présent
     */
    PAS_DE_PIGEON,
    /**
     * Pigeon bleu
     */
    PIGEON_BLEU,
    /**
     * Pigeon jaune
     */
    PIGEON_JAUNE,
    /**
     * Pigeon rouge
     */
    PIGEON_ROUGE,
}

/**
 * Types d'actions
 */
enum TypeAction {
    /**
     * Action ``avancer``
     */
    ACTION_AVANCER,
    /**
     * Action ``grandir``
     */
    ACTION_GRANDIR,
    /**
     * Action ``construire buisson``
     */
    ACTION_CONSTRUIRE,
    /**
     * Action ``creuser tunnel``
     */
    ACTION_CREUSER,
}

/**
 * Position dans la carte, donnée par trois coordonnées
 */
class Position {
    /**
     * Abscisse
     */
    public int colonne;
    /**
     * Ordonnée
     */
    public int ligne;
    /**
     * Niveau
     */
    public int niveau;
}

/**
 * Une troupe, composée de la maman canard et de ses canetons
 */
class Troupe {
    /**
     * Position de la maman canard
     */
    public Position maman = new Position();
    /**
     * Position des différents canards de la troupe, incluant la maman en
     * première position
     */
    public Position[] canards;
    /**
     * Taille de la troupe
     */
    public int taille;
    /**
     * Direction de la troupe
     */
    public Direction dir;
    /**
     * Nombre de pains de la troupe
     */
    public int inventaire;
    /**
     * Nombre de points d'action de la troupe
     */
    public int pts_action;
    /**
     * Identifiant de la troupe
     */
    public int id;
}

/**
 * Élément constituant le parc
 */
class EtatCase {
    /**
     * Position de la case. Le niveau vaut nécessairement 0
     */
    public Position pos = new Position();
    /**
     * Type de la case
     */
    public TypeCase contenu;
    /**
     * La case est constructible
     */
    public boolean est_constructible;
    /**
     * Nombre de pains contenus sur la case
     */
    public int nb_pains;
}

/**
 * Action représentée dans l'historique
 */
class ActionHist {
    /**
     * Type de l'action
     */
    public TypeAction action_type;
    /**
     * Identifiant de la troupe
     */
    public int troupe_id;
    /**
     * Direction de l'action
     */
    public Direction action_dir;
    /**
     * Position de l'action
     */
    public Position action_pos = new Position();
}

public class Api
{
    /**
     * Nombre de lignes dans la carte
     */
    public static final int HAUTEUR = 40;

    /**
     * Nombre de colonnes dans la carte
     */
    public static final int LARGEUR = 40;

    /**
     * Nombre de tours à jouer avant la fin de la partie
     */
    public static final int NB_TOURS = 400;

    /**
     * Taille de départ d'une troupe
     */
    public static final int TAILLE_DEPART = 5;

    /**
     * Taille minimale qu'une troupe peut avoir avant de se disperser
     */
    public static final int TAILLE_MIN = 3;

    /**
     * Nombre de troupes que chaque joueur controle
     */
    public static final int NB_TROUPES = 2;

    /**
     * Intervalle de distribution de pains par les papys
     */
    public static final int INTERVALLE_DISTRIB = 5;

    /**
     * Nombre de tunnels qu'un joueur peut creuser par tour
     */
    public static final int FREQ_TUNNEL = 1;

    /**
     * Nombre de déplacements que peut faire une troupe en un tour
     */
    public static final int PTS_ACTION = 5;

    /**
     * Nombre de points de mouvement requis pour incrémenter la taille
     */
    public static final int COUT_CROISSANCE = 3;

    /**
     * Coût en score de la pose de buisson
     */
    public static final int COUT_BUISSON = 3;

    /**
     * Round à la fin duquel les barrières s'ouvrent ou se ferment
     */
    public static final int ROUND_FERMETURE = 99;

    /**
     * La troupe avance d'une case vers une direction donnée
     */
    public static native Erreur avancer(int id, Direction dir);

    /**
     * La troupe grandit
     */
    public static native Erreur grandir(int id);

    /**
     * Construit un buisson à la position donnée
     */
    public static native Erreur construire_buisson(Position pos);

    /**
     * Creuse un tunnel à la position donnée
     */
    public static native Erreur creuser_tunnel(Position pos);

    /**
     * Renvoie les informations concernant une case
     */
    public static native EtatCase info_case(Position pos);

    /**
     * Renvoie les informations d'état d'une barrière
     */
    public static native EtatBarriere info_barriere(Position pos);

    /**
     * Renvoie les informations d'état d'un nid
     */
    public static native EtatNid info_nid(Position pos);

    /**
     * Renvoie le nombre de tours restants avant qu'un papy dépose une miche de
     * pain. Retourne -1 si aucun papy ne se trouve à la position demandée
     */
    public static native int papy_tours_restants(Position pos);

    /**
     * Renvoie les troupes d'un joueur. Si le joueur est invalide, tous les
     * champs valent -1.
     */
    public static native Troupe[] troupes_joueur(int id_joueur);

    /**
     * Renvoie la position des pains récupérables
     */
    public static native Position[] pains();

    /**
     * Pose un pigeon de debug sur la case indiquée
     */
    public static native Erreur debug_poser_pigeon(Position pos, PigeonDebug pigeon);

    /**
     * Renvoie la liste des actions effectuées par l'adversaire durant son
     * tour, dans l'ordre chronologique. Les actions de débug n'apparaissent
     * pas dans cette liste.
     */
    public static native ActionHist[] historique();

    /**
     * Renvoie le gain en score que le nombre de pains passé en entrée
     * rapporterait s'ils étaient tous déposés d'un coup dans un nid
     */
    public static native int gain(int nb_pains);

    /**
     * Renvoie la taille de l'inventaire d'une troupe de taille donnée
     */
    public static native int inventaire(int taille);

    /**
     * Trouve un plus court chemin ouvert entre deux positions. Renvoie une
     * liste vide si les deux positions sont égales ou si aucun chemin
     * n'existe.
     */
    public static native Direction[] trouver_chemin(Position depart, Position arrivee);

    /**
     * Renvoie votre numéro de joueur.
     */
    public static native int moi();

    /**
     * Renvoie le numéro du joueur adverse.
     */
    public static native int adversaire();

    /**
     * Renvoie le score du joueur `id_joueur`. Renvoie -1 si le joueur est
     * invalide.
     */
    public static native int score(int id_joueur);

    /**
     * Annule la dernière action. Renvoie faux quand il n'y a pas d'action à
     * annuler ce tour-ci
     */
    public static native boolean annuler();

    /**
     * Retourne le numéro du tour actuel.
     */
    public static native int tour_actuel();

    /**
     * Affiche le contenu d'une valeur de type erreur
     */
    public static native void afficher_erreur(Erreur v);

    /**
     * Affiche le contenu d'une valeur de type direction
     */
    public static native void afficher_direction(Direction v);

    /**
     * Affiche le contenu d'une valeur de type type_case
     */
    public static native void afficher_type_case(TypeCase v);

    /**
     * Affiche le contenu d'une valeur de type etat_barriere
     */
    public static native void afficher_etat_barriere(EtatBarriere v);

    /**
     * Affiche le contenu d'une valeur de type etat_nid
     */
    public static native void afficher_etat_nid(EtatNid v);

    /**
     * Affiche le contenu d'une valeur de type pigeon_debug
     */
    public static native void afficher_pigeon_debug(PigeonDebug v);

    /**
     * Affiche le contenu d'une valeur de type type_action
     */
    public static native void afficher_type_action(TypeAction v);

    /**
     * Affiche le contenu d'une valeur de type position
     */
    public static native void afficher_position(Position v);

    /**
     * Affiche le contenu d'une valeur de type troupe
     */
    public static native void afficher_troupe(Troupe v);

    /**
     * Affiche le contenu d'une valeur de type etat_case
     */
    public static native void afficher_etat_case(EtatCase v);

    /**
     * Affiche le contenu d'une valeur de type action_hist
     */
    public static native void afficher_action_hist(ActionHist v);
}
