from api import *
import time
import collections

#################################### Utils ####################################

MUR = 1
EMPTY = 0
BENCHMARK = {}  # benchmark[fct name] = [number of call, total time]
DEBUT = time.time()


def benchmark(fct):
    def wrapper(*args, **kargs):
        DEBUT = time.time()
        resultat = fct(*args, **kargs)
        fin = time.time()

        nom = fct.__name__
        if not nom in BENCHMARK.keys():
            BENCHMARK[nom] = [0, 0]
        BENCHMARK[nom][0] += 1
        BENCHMARK[nom][1] += fin - DEBUT
        return resultat

    return wrapper

def show_benchmark():
    print(f"Benchmark tour n°{tour_actuel()} :")
    for nom, (call, total_temps) in BENCHMARK.items():
        total_temps = round(total_temps * 100, 1)
        print("\t- {:<20} : {:>4} | {:<5} | {:<9}".format(
            nom, call, total_temps, round(total_temps / call, 5)
        ))
    print("Total time : {:>4}%\n".format(round((time.time() - DEBUT) * 100, 2)))

@benchmark
def is_empty(x, y, z):
    cell_type = info_case((x, y, 0)).contenu
    if z == 0:
        if cell_type == type_case.BUISSON:
            return False
        if cell_type == type_case.BARRIERE and info_barriere((x, y, z)) == etat_barriere.FERMEE:
            return False
        return True
    else:
        return False

def exist(x, y):
    return 0 <= x <= LARGEUR and 0 <= y <= HAUTEUR

def debug_chemin(chemin):
    for x,y in chemin:
        debug_poser_pigeon((x,y,0), pigeon_debug.PIGEON_BLEU)

def get_troupe(id)


#################################### Function ####################################
@benchmark
def get_basic_terrain():
    """return a matrix of type_case"""
    terrain = []
    for y in range(LARGEUR):
        ligne = []
        for x in range(HAUTEUR):
            if is_empty(x, y, 0):
                ligne.append(EMPTY)
            else:
                ligne.append(MUR)
        terrain.append(ligne)
    return terrain


@benchmark
def get_nids():
    nids = []
    for y in range(HAUTEUR):
        for x in range(LARGEUR):
            if info_case((x, y, 0)).contenu == type_case.NID:
                nids.append((x, y))
    return nids
    

def get_nids_libres(nids):
    return [n for n in nids if info_nid((n[0], n[1], 0)) == moi()]

def get_voisins(terrain, x, y):
    for dx, dy in ((0, -1), (0, 1), (-1, 0), (1, 0)):
        if exist(x + dx, y + dy) and terrain[y + dy][x + dx] == EMPTY:
            yield (x + dx, y + dy)

@benchmark
def get_chemin(debut, fin, terrain):
    debut, fin = debut[:2:], fin[:2:]
    parent = [[(-1, -1) for _ in range(LARGEUR)] for _ in range(HAUTEUR)]

    en_cours = [debut]
    en_attente = []
    while en_cours != []:
        if parent[fin[1]][fin[0]] != (-1, -1):
           break
        while en_cours != []:
            x, y = en_cours.pop()
            for nx, ny in get_voisins(terrain ,x, y):
                if parent[ny][nx] == (-1, -1):
                    parent[ny][nx] = (x, y)
                    en_attente.append((nx, ny))

        en_cours = en_attente
        en_attente = []
    if parent[fin[1]][fin[0]] == (-1, -1):
        return []

    chemin = [fin]
    while chemin[-1] != debut:
        chemin.append(parent[chemin[-1][1]][chemin[-1][0]])
    return chemin[::-1]

def action_aller_chemin(chemin, id):
    PM = troupes_joueur(moi())
    #for min()
    #    avancer direction dir)
#################################### Main ####################################
def partie_init():
    DEBUT = time.time()
    print("debut")

    NIDS = get_nids()
    print("NIDS :", NIDS)

    #test terrain
    terrain = get_basic_terrain()
    for ligne in terrain:
        print("".join([(" ", "#")[i] for i in ligne]))

    # test chemin
    chemin = get_chemin(troupes_joueur(moi())[0].maman, NIDS[0], terrain)
    print("chemin :", chemin)

    # vrac
    print("position maman : ", troupes_joueur(moi())[0].maman)
    show_benchmark()
    print("fin partie_init")


def jouer_tour():
    pass

# DEBUT = time.time()
# print("fin jouer tour")
# show_benchmark()


def partie_fin():
    pass
