from api import *
import time
import collections
from copy import deepcopy
import sys
sys.setrecursionlimit(40*40*2 + 1000)


#################################### Utils ####################################

MUR = 1
VIDE = 0
BENCHMARK = {}  # benchmark[fct name] = [number of call, total time]
DEBUT = time.time()
NIDS = []
ENEMIE = "e"
ENEMIE_MAMAN = "E"
MOI = "m"
MOI_MAMAN = "M"
SEPARATEUR = "|"
LEVEL_DEBUG = 0  # variable pour stocker la profondeur des debugs
LEVEL_MIN_DEBUG = -2  # affiche les debug au dessus de LEVEL_MIN_DEBUG



def cell_to_string(t):
    if type(t) == int:
        if t > 9: return str(t % 10)
        if t < -1: return "-"
    if t == SEPARATEUR: return "  |  "
    if type(t) == str:
        return t[:1]
    return {
        type_case.GAZON: " ",
        type_case.BUISSON: "#",
        type_case.BARRIERE: "=",
        type_case.NID: "X",
        type_case.PAPY: "*",
        type_case.TROU: "O",
        type_case.TUNNEL: " ",
        type_case.TERRE: " ",
        0: " ",
        -1: "#"
    }.get(t, "?")


def debug(*args, debut=0, fin=100, level=0):
    global LEVEL_DEBUG
    if debut <= tour_actuel() <= fin or tour_actuel() <= 2:
        if level >= LEVEL_MIN_DEBUG or True:
            print(*args)


def analyse_dim(a):
    if type(a) == type([]) and len(a) > 0:
        return f"{len(a)}*" + analyse_dim(a[0])
    return str(type(a)) + " " + str(a)


def debug_fct(fct):
    def wrapper(*args, **kargs):
        global LEVEL_DEBUG
        debug("\t" * LEVEL_DEBUG + f"*debut : {fct.__name__} avec",
              " ".join(list(map(str,
                                list(map(analyse_dim, args))
                                + [(nom, analyse_dim(val)) for nom, val in kargs.items()]
                                ))), level=LEVEL_DEBUG
              )
        LEVEL_DEBUG += 1
        resultat = fct(*args, **kargs)
        LEVEL_DEBUG -= 1
        debug("\t" * LEVEL_DEBUG + f"*fin : {fct.__name__}", level=LEVEL_DEBUG)
        return resultat

    return wrapper


def show_benchmark():
    debug(f"Benchmark tour n°{tour_actuel()} :")
    for nom, (call, total_temps) in BENCHMARK.items():
        total_temps = round(total_temps * 100, 1)
        debug("\t- {:<30} : {:>4} | {:<5} | {:<9}".format(
            nom, call, total_temps, round(total_temps / call, 5)
        ))
    debug("Total time : {:>4}%\n".format(round((time.time() - DEBUT) * 100, 2)))


def info(*args, **kargs):
    return debug(*args, level=0, **kargs)


def flatten(matrice, sep=[]):
    if len(matrice) == 1: sep = []
    return [
        elem
        for ligne in
        [l + sep for l in matrice]
        for elem in ligne
    ]


def show_matrices(*matrices):
    matrice_total = [
        flatten([
            matrices[m][y]
            for m in range(len(matrices))
        ], sep=[SEPARATEUR])
        for y in range(HAUTEUR)
    ]
    for l, ligne in enumerate(matrice_total):
        debug(f"({l}) " + "".join(map(cell_to_string, ligne)))


def matrice_visualisation():
    terrain = [[info_case((x, y, 0)).contenu for x in range(LARGEUR)] for y in range(HAUTEUR)]
    for j, t, j_tag, J_tag in (
            (adversaire(), 0, ENEMIE, ENEMIE_MAMAN),
            (adversaire(), 1, ENEMIE, ENEMIE_MAMAN),
            (moi(), 0, MOI, MOI_MAMAN),
            (moi(), 1, MOI, MOI_MAMAN)
    ):
        for x, y, z in troupes_joueur(j)[t].canards:
            terrain[y][x] = j_tag
        x, y, z = troupe_maman(j, t)
        terrain[y][x] = J_tag
    return terrain


def benchmark(fct):
    def wrapper(*args, **kargs):
        debut = time.time()
        resultat = fct(*args, **kargs)
        fin = time.time()

        nom = fct.__name__
        if not nom in BENCHMARK.keys():
            BENCHMARK[nom] = [0, 0]
        BENCHMARK[nom][0] += 1
        BENCHMARK[nom][1] += fin - debut
        return resultat

    return wrapper


def cell_binaire(x, y, z):
    cell_type = info_case((x, y, z)).contenu
    if z == 0:
        if cell_type == type_case.BUISSON:
            return MUR
        if cell_type == type_case.BARRIERE and info_barriere((x, y, z)) == etat_barriere.FERMEE:
            return MUR
        return VIDE
    else:
        if cell_type == type_case.TERRE:
            return MUR
        return VIDE


def existe(x, y, z):
    return 0 <= x < LARGEUR and 0 <= y < HAUTEUR and z in (0, -1)


def debug_chemin(chemin):
    for x, y, z in chemin[:6]:
        debug_poser_pigeon((x, y, z), pigeon_debug.PIGEON_BLEU)
    for x, y, z in chemin[7::3]:
        debug_poser_pigeon((x, y, z), pigeon_debug.PIGEON_JAUNE)
    debug_poser_pigeon(chemin[-1], pigeon_debug.PIGEON_ROUGE)


def direction_AB(A, B):
    return {
        (0, -1, 0): direction.SUD,
        (0, 1, 0): direction.NORD,
        (-1, 0, 0): direction.OUEST,
        (1, 0, 0): direction.EST,
        (0, 0, 1): direction.HAUT,
        (0, 0, -1): direction.BAS
    }.get((B[0] - A[0], B[1] - A[1], B[2] - A[2]), None)


def troupe_maman(j, id):
    return troupes_joueur(j)[id].maman


#################################### Function ####################################
@benchmark
def get_terrain():
    """renvoie une matrice de 0 si la cellule est libre, 1 si pleine : terrain[z][y][x]"""
    return [[[
        cell_binaire(x, y, z)
        for x in range(LARGEUR)
    ] for y in range(HAUTEUR)
    ] for z in (0, -1)
    ]


@benchmark
def get_terrain_simplifie():
    """enlève les culs de sac"""
    NON_FAIT = 3
    EN_COURS = 2
    FAIT = VIDE
    terrain_base = get_terrain()
    terrain_simplifie = list(map(lambda terrain:
                                 [[NON_FAIT if case == VIDE else MUR
                                   for case in ligne
                                   ] for ligne in terrain],
                                 terrain_base
                                 ))

    ctr = 0
    def DFS(x, y, z):
        nonlocal ctr
        if terrain_simplifie[z][y][x] != NON_FAIT: return  # dejà fait
        terrain_simplifie[z][y][x] = EN_COURS

        compteur = 0
        for nx, ny, nz in get_voisins(terrain_base, x, y, z):
            DFS(nx, ny, nz)
            if terrain_simplifie[nz][ny][nx] != MUR:
                compteur += 1

        if compteur <= 1 and info_case((x, y, z)).contenu not in (type_case.NID, type_case.TROU):
            terrain_simplifie[z][y][x] = MUR  # cul de sac
        else:
            terrain_simplifie[z][y][x] = FAIT

    for x in range(LARGEUR):
        for y in range(HAUTEUR):
            DFS(x, y, 0)
    return terrain_simplifie


def protege_troupe(terrain, troupe):
    for troupe in (0, 1):
        for joueur in (0, 1):
            for x, y, z in troupes_joueur(joueur)[troupe].canards:
                terrain[z][y][x] = MUR

    x, y, z = troupe_maman(moi(), troupe)
    terrain[z][y][x] = VIDE
    return terrain


def get_voisins(terrain, x, y, z):
    for dx, dy in ((0, -1), (0, 1), (-1, 0), (1, 0)):
        if existe(x + dx, y + dy, z) and terrain[z][y + dy][x + dx] == VIDE:
            yield (x + dx, y + dy, z)
    if info_case((x, y, z)).contenu == type_case.TROU:
        yield (x, y, [-1, 0][z])


@benchmark
def get_deplacements(terrain, debut, PM=-1):
    """renvoie deux matrices :
    - Matrice des distances depuis la mère de la troupe id jusqu'à la case (y, x)
    - Matrice de la première case du chemin de la case (y, x) à la mère de la troupe id
    """
    matrice_parent = [[[(None, None, None)
                        for x in range(LARGEUR)] for y in range(HAUTEUR)] for z in (0, -1)]
    matrice_distance = [[[-1
                          for x in range(LARGEUR)] for y in range(HAUTEUR)] for z in (0, -1)]

    en_cours = [debut]
    en_attente = []
    matrice_distance[debut[2]][debut[1]][debut[0]] = 0
    distance = 0

    while en_cours != []:
        distance += 1
        if distance > PM and PM != -1: break

        while en_cours != []:
            x, y, z = en_cours.pop()
            for nx, ny, nz in get_voisins(terrain, x, y, z):
                if matrice_distance[nz][ny][nx] == -1:
                    matrice_distance[nz][ny][nx] = distance
                    matrice_parent[nz][ny][nx] = (x, y, z)
                    en_attente.append((nx, ny, nz))

        en_cours = en_attente
        en_attente = []

    return matrice_distance, matrice_parent


@benchmark
def get_chemin(matrice_parent, fin):
    """remonte la matrice des parents des chemins menant à la maman de la troupe"""
    chemin = [fin]
    x, y, z = chemin[-1]

    while matrice_parent[z][y][x] != (None, None, None):
        chemin.append(matrice_parent[z][y][x])
        x, y, z = chemin[-1]
    if chemin == [fin]: return []  # pas de chemin trouvé
    return chemin[::-1]  # source -> fin


def avancer_chemin(chemin, id):
    if chemin == []: return
    PM = troupes_joueur(moi())[id].pts_action

    for x in range(min(PM, len(chemin) - 1)):
        err = avancer(id + 1, direction_AB(chemin[x], chemin[x + 1]))
        if err != erreur.OK: debug(err)


@benchmark
def get_nids():
    nids = []
    for y in range(HAUTEUR):
        for x in range(LARGEUR):
            if info_case((x, y, 0)).contenu == type_case.NID:
                nids.append((x, y, 0))
    return nids


def mes_nids():
    return [(x, y, 0) for x, y, z in get_nids() if info_nid((x, y, 0)) == moi() + 1]


def nids_libres():
    return [(x, y, 0) for x, y, z in get_nids() if info_nid((x, y, 0)) == etat_nid.LIBRE]


def get_papy():
    resultat = []
    for x in range(LARGEUR):
        for y in range(HAUTEUR):
            if info_case((x, y, 0)).contenu == type_case.PAPY:
                resultat.append((x, y, 0))
    return resultat


def get_pm(troupe):
    return troupes_joueur(moi())[troupe].pts_action


#################################### Main ####################################

@debug_fct
def partie_init():
    DEBUT = time.time()
    NIDS.extend(get_nids())
    # show_benchmark()


def jouer_tour():
    global BENCHMARK, DEBUT
    DEBUT = time.time()
    BENCHMARK = {}

    info(f"#Début tour {tour_actuel()} du joueur {moi()} avec {score(moi())} points")
    terrain = get_terrain_simplifie()
    m_distance_adversaire = [[[
        min(d1, d2)
        for d1, d2 in zip(ligne1, ligne2)
    ] for ligne1, ligne2 in zip(terrain1, terrain2)
    ] for terrain1, terrain2 in zip(
        get_deplacements(terrain, troupe_maman(adversaire(), 0))[0],
        get_deplacements(terrain, troupe_maman(adversaire(), 1))[0]
    )
    ]

    p_objectif = main(0, terrain, m_distance_adversaire)
    main(1, terrain, m_distance_adversaire, objectif_skip=[p_objectif])

    # show_matrices(matrice_visualisation())
    show_benchmark()
    debug()


def partie_fin():
    pass


def inventaire_t(t, j=moi()):
    return troupes_joueur(j)[t].inventaire


def inventaire_max(t, j=moi()):
    return max(TAILLE_MIN, inventaire(troupes_joueur(j)[t].taille))


def scan(troupe):
    terrain = get_terrain_simplifie()
    for i, (x,y,z) in enumerate(troupes_joueur(adversaire())[troupe].canars):
        terrain[z][y][x] = i

    show_matrices(terrain)



@benchmark
@debug_fct
def main(troupe, terrain, m_distance_adversaire, objectif_skip=[]):
    m_distance, m_parent = get_deplacements(protege_troupe(terrain, troupe), troupe_maman(moi(), troupe))

    def d(pos):
        return m_distance[pos[2]][pos[1]][pos[0]]

    destination = (None, None, None)
    # objectif : score, fonction de réalisation, identifiant
    # le score se compte en pain

    while get_pm(troupe) > 0:
        # Prendre les nids
        objectifs = []

        if nids_libres() != []:
            objectifs.extend([
                (100 + 1 / d(p), "nids libre", p)
                for p in nids_libres() if d(p) > 0
            ])

        info(f"\t- Nids libres: {objectifs}")

        # Grandir
        if get_pm(troupe) > COUT_CROISSANCE and tour_actuel() % 3 == 0:
            info(f"- Grandir : pm : {get_pm(troupe)}")
            objectifs.append((3, "grandir", None))

        # Collecte de pain
        if inventaire_t(troupe) < min(10, inventaire_max(troupe)):
            objectifs.extend([
                (1 + 1 / d(p), "pain", p)
                for p in pains() if d(p) > 0
            ])
            info(f"\t- On cherche du pain : pm : {get_pm(troupe)} Inventaire : {inventaire_t(troupe)} sur {inventaire_max(troupe)}\n\tCapture pain : {analyse_dim(objectifs)}")

        # S'approcher papy
        objectifs.extend([
            (0.2 + 1 / d(p), "papy", p)
            for p in get_papy() if d(p) > 0
        ])

        # Déposer pain
        if inventaire_t(troupe) > 2:
            objectifs.extend([
                (0.5 + 1 / d(p) + inventaire_t(troupe)*0.15, "deposer pain", p)
                for p in mes_nids() if d(p) > 0
            ])

        # On applique
        if objectifs != []:
            maxi = (None, None)
            score_maxi = 0
            for priorite, action, destination in objectifs:
                if priorite > score_maxi and destination not in objectif_skip:
                    maxi = (action, destination)
                    score_maxi = priorite
            action, destination = maxi

            debug("\t*Action :", action, "priorite", round(priorite, 2), "destination", destination)

            if action in ("pain", "papy", "nids libre", "deposer pain"):
                chemin = get_chemin(m_parent, destination)
                debug_chemin(chemin)
                info("\tChemin vers objectif à la position", destination, "distance", len(chemin))
                avancer_chemin(chemin, troupe)
                if troupe_maman(moi(), troupe) == destination:
                    info("-> On à atteint notre destination !")
                m_distance, m_parent = get_deplacements(protege_troupe(terrain, troupe), troupe_maman(moi(), troupe))

            elif action == "grandir":
                grandir(troupe + 1)
            elif action == None:
                print("Que des mauvais coup à jouer :\'(")
                break
            else:
                print("Erreur, action non reconnue")
                break
        else:
            info("Je n'ai plus d'objectif :\'(")
            break
    return destination
