from api import *
import time
import collections
import itertools
from copy import deepcopy
import sys
sys.setrecursionlimit(40*40*2 + 1000)

"""README
Champion : lmxV5
Champion organisé pour la finale 2022 de Prologin, merci aux Organisateurs !

Le jeux est assez difficile à s'

"""

"""           CONSTANTES
En vracs !
"""
MUR = 1
VIDE = 0
BENCHMARK = {}  # benchmark[fct name] = [number of call, total time]
DEBUT = time.time()
NIDS = []
ENEMIE = "e"
ENEMIE_MAMAN = "E"
MOI = "m"
MOI_MAMAN = "M"
SEPARATEUR = "|"
LEVEL_DEBUG = 0  # variable pour stocker la profondeur des debugs
LEVEL_MIN_DEBUG = -2  # affiche les debug au dessus de LEVEL_MIN_DEBUG
MALUS_TUNNEL = 0
SCORES_T0 = (#coef de la troupe 1, plus agressive
    0.1, #COEF_DISTANCE_NIDS
    0.2, #COEF_DISTANCE_PAPYS
    0.1, # COEF_NOMBRE_MUR
    3,   # COEF_DISTANCE_ADVERSAIRE
)
SCORES_T1 = (#coef de la troupe 2, plus defensive
    0.2, #COEF_DISTANCE_NIDS
    0.2, #COEF_DISTANCE_PAPYS
    0.2, # COEF_NOMBRE_MUR
    -0.2,   # COEF_DISTANCE_ADVERSAIRE
)
voisins_directes = []

"""           UTILS
Fonction pouvant servir indépendament du jeux
"""
def show_benchmark():
    debug(f"Benchmark tour n°{tour_actuel()} :")
    for nom, (call, total_temps) in BENCHMARK.items():
        total_temps = round(total_temps * 100, 1)
        debug("\t- {:<30} : {:>4}% | x{:<5} | {:<5}%".format(
            nom, call, total_temps, round(total_temps / call, 5)
        ))
    debug("Total time : {:>4}%\n".format(round((time.time() - DEBUT) * 100, 2)))

def flatten(matrice, sep=[]):
    if len(matrice) == 1: sep = []
    return [
        elem
        for ligne in
        [l + sep for l in matrice]
        for elem in ligne
    ]

def benchmark(fct):
    def wrapper(*args, **kargs):
        debut = time.time()
        resultat = fct(*args, **kargs)
        fin = time.time()

        nom = fct.__name__
        if not nom in BENCHMARK.keys():
            BENCHMARK[nom] = [0, 0]
        BENCHMARK[nom][0] += 1
        BENCHMARK[nom][1] += fin - debut
        return resultat

    return wrapper

def analyse_dim(a):
    if type(a) == type([]) and len(a) > 0:
        return f"{len(a)}*" + analyse_dim(a[0])
    return str(type(a)) + " " + str(a)

def debug_fct(fct):
    def wrapper(*args, **kargs):
        global LEVEL_DEBUG
        debug("\t" * LEVEL_DEBUG + f"*debut : {fct.__name__} avec",
              " ".join(list(map(str,
                                list(map(analyse_dim, args))
                                + [(nom, analyse_dim(val)) for nom, val in kargs.items()]
                                ))), level=LEVEL_DEBUG
              )
        LEVEL_DEBUG += 1
        resultat = fct(*args, **kargs)
        LEVEL_DEBUG -= 1
        debug("\t" * LEVEL_DEBUG + f"*fin : {fct.__name__}", level=LEVEL_DEBUG)
        return resultat

    return wrapper

def direction_AB(A, B):
    return {
        (0, -1, 0): direction.SUD,
        (0, 1, 0): direction.NORD,
        (-1, 0, 0): direction.OUEST,
        (1, 0, 0): direction.EST,
        (0, 0, 1): direction.HAUT,
        (0, 0, -1): direction.BAS
    }.get((B[0] - A[0], B[1] - A[1], B[2] - A[2]), None)

def troupe_maman(j, id):
    return troupes_joueur(j)[id].maman

def get_nids():
    nids = []
    for y in range(HAUTEUR):
        for x in range(LARGEUR):
            if info_case((x, y, 0)).contenu == type_case.NID:
                nids.append((x, y, 0))
    return nids

def mes_nids():
    return [(x, y, 0) for x, y, z in get_nids() if info_nid((x, y, 0)) == moi() + 1]

def nids_libres():
    return [(x, y, 0) for x, y, z in get_nids() if info_nid((x, y, 0)) == etat_nid.LIBRE]

def get_papy():
    resultat = []
    for x in range(LARGEUR):
        for y in range(HAUTEUR):
            if info_case((x, y, 0)).contenu == type_case.PAPY:
                resultat.append((x, y, 0))
    return resultat

def get_pm(troupe):
    return troupes_joueur(moi())[troupe].pts_action

def get_taille(t):
    return troupes_joueurs(moi())[t].taille

def cibler_troupe(t):
    """Pure flex, affiche un pigeon rouge sur l'adverser, utilisé quand on sait qu'il se disperser"""
    debug_poser_pigeon(troupe_maman(adversaire(), t), pigeon_debug.PIGEON_ROUGE)


"""           BASE
Fonction qui completent d'API
"""
def existe(x, y, z):
    return 0 <= x < LARGEUR and 0 <= y < HAUTEUR and z in (0, -1)

def inventaire_t(t, j=moi()):
    return troupes_joueur(j)[t].inventaire

def inventaire_max(t, j=moi()):
    return max(TAILLE_MIN, inventaire(troupes_joueur(j)[t].taille))

"""           DEBUG
Fonction qui aide à l'affiche et au debug du jeux
"""
def debug(*args, debut=0, fin=100, level=0):
    global LEVEL_DEBUG
    if debut <= tour_actuel() <= fin or tour_actuel() <= 2:
        if level >= LEVEL_MIN_DEBUG or True:
            print(*args)

def info(*args, **kargs):
    return debug(*args, level=0, **kargs)


def cell_to_string(t, entier=False):
    if type(t) in (int, float) and entier:
        if t == float("inf"): return "#"
        if t > 0: return str(t % 10)
        if t ==0: return " "
        if t < 0: return " "
        return " "
    if t == SEPARATEUR: return "  |  "
    if type(t) == str:
        return t[:1]
    return {
        type_case.GAZON: " ",
        type_case.BUISSON: "#",
        type_case.BARRIERE: "=",
        type_case.NID: "X",
        type_case.PAPY: "*",
        type_case.TROU: "O",
        type_case.TUNNEL: " ",
        type_case.TERRE: " ",
        0: " ",
        -1: "#"
    }.get(t, "?")

def matrice_to_string(matrice, entier=False):
    return ["".join([
            cell_to_string(c, entier=entier)
            for c in ligne])
        for ligne in matrice
    ]

def show_matrices(*matrices, entier=False, tunnels=False, sep="  |  "):
    for y in range(HAUTEUR):
        debug("("+ "{:>2}".format(y) + ") | "  + sep.join([matrice[y] for matrice in matrices]) + " |")
    print()

def matrice_visualisation():
    terrain = [[info_case((x, y, 0)).contenu for x in range(LARGEUR)] for y in range(HAUTEUR)]
    for j, t, j_tag, J_tag in (
            (adversaire(), 0, ENEMIE, ENEMIE_MAMAN),
            (adversaire(), 1, ENEMIE, ENEMIE_MAMAN),
            (moi(), 0, MOI, MOI_MAMAN),
            (moi(), 1, MOI, MOI_MAMAN)
    ):
        for x, y, z in troupes_joueur(j)[t].canards:
            terrain[y][x] = j_tag
        x, y, z = troupe_maman(j, t)
        terrain[y][x] = J_tag
    return terrain

def debug_chemin(chemin):
    for x, y, z in chemin[:6]:
        debug_poser_pigeon((x, y, z), pigeon_debug.PIGEON_BLEU)
    for x, y, z in chemin[7::3]:
        debug_poser_pigeon((x, y, z), pigeon_debug.PIGEON_JAUNE)
    debug_poser_pigeon(chemin[-1], pigeon_debug.PIGEON_ROUGE)

"""           TERRAIN
Fonction qui permettent de gerer des matrice représentant le jeux
"""
def cell_binaire(x, y, z):
    cell_type = info_case((x, y, z)).contenu
    if z == 0:
        if cell_type == type_case.BUISSON:
            return MUR
        if cell_type == type_case.BARRIERE and info_barriere((x, y, z)) == etat_barriere.FERMEE:
            return MUR
        return VIDE
    else:
        if cell_type == type_case.TERRE:
            return MUR
        return VIDE

def get_voisins(terrain, x, y, z):
    for dx, dy in ((0, -1), (0, 1), (-1, 0), (1, 0)):
        if existe(x + dx, y + dy, z) and terrain[z][y + dy][x + dx] == VIDE:
            yield (x + dx, y + dy, z)
    if info_case((x, y, z)).contenu == type_case.TROU:
        yield (x, y, [-1, 0][z])

def bin_matrice(liste):
    return [[[
         1 if (x,y,z) in liste else 0
         for x in range(LARGEUR)
        ]for y in range(HAUTEUR)
        ]for z in (0, -1)
    ]

@benchmark
def get_terrain():
    """renvoie une matrice de 0 si la cellule est libre, 1 si pleine : terrain[z][y][x]"""
    return [[[
        cell_binaire(x, y, z)
        for x in range(LARGEUR)
    ] for y in range(HAUTEUR)
    ] for z in (0, -1)
    ]

@benchmark
def get_terrain_simplifie():
    """enlève les culs de sac"""
    NON_FAIT = 3
    EN_COURS = 2
    FAIT = VIDE
    terrain_base = get_terrain()
    terrain_simplifie = list(map(lambda terrain:
                                 [[NON_FAIT if case == VIDE else MUR
                                   for case in ligne
                                   ] for ligne in terrain],
                                 terrain_base
                                 ))

    ctr = 0
    def DFS(x, y, z):
        nonlocal ctr
        if terrain_simplifie[z][y][x] != NON_FAIT: return  # dejà fait
        terrain_simplifie[z][y][x] = EN_COURS

        compteur = 0
        for nx, ny, nz in get_voisins_fast(terrain_base, x, y, z):
            DFS(nx, ny, nz)
            if terrain_simplifie[nz][ny][nx] != MUR:
                compteur += 1

        if compteur <= 1 and info_case((x, y, z)).contenu not in (type_case.NID, type_case.TROU):
            terrain_simplifie[z][y][x] = MUR  # cul de sac
        else:
            terrain_simplifie[z][y][x] = FAIT

    for x in range(LARGEUR):
        for y in range(HAUTEUR):
            DFS(x, y, 0)
    return terrain_simplifie

def protege_troupe(terrain, troupe):
    for troupe in (0, 1):
        for joueur in (0, 1):
            for x, y, z in troupes_joueur(joueur)[troupe].canards:
                terrain[z][y][x] = MUR

    x, y, z = troupe_maman(moi(), troupe)
    terrain[z][y][x] = VIDE
    return terrain

"""           DEPLACEMENT
Fonction qui permettent de se déplacer
"""
@benchmark
def get_deplacements(terrain, debut, match=set()):
    """renvoie deux matrices :
    - Matrice des distances depuis la mère de la troupe id jusqu'à la case (y, x)
    - Matrice de la première case du chemin de la case (y, x) à la mère de la troupe id
    """
    matrice_parent = [[[(None, None, None)
                        for x in range(LARGEUR)] for y in range(HAUTEUR)] for z in (0, -1)]
    matrice_distance = [[[-1
                          for x in range(LARGEUR)] for y in range(HAUTEUR)] for z in (0, -1)]
    stop_if_match = len(match) > 1

    en_attente = []
    en_cours = [debut] if type(debut[0]) == int else debut
    for x,y,z in en_cours:
        matrice_distance[z][y][x] = 0
    distance = 0

    while en_cours != []:
        distance += 1

        while en_cours != []:
            x, y, z = en_cours.pop()
            for nx, ny, nz in get_voisins_fast(terrain, x, y, z):
                if matrice_distance[nz][ny][nx] == -1:
                    if stop_if_match and (nx, ny, nz) in match:
                        return (nx, ny, nz), matrice_distance, matrice_parent
                    matrice_distance[nz][ny][nx] = distance
                    matrice_parent[nz][ny][nx] = (x, y, z)
                    en_attente.append((nx, ny, nz))

        en_cours = en_attente
        en_attente = []

    return matrice_distance, matrice_parent

@benchmark
def get_chemin(matrice_parent, fin):
    """remonte la matrice des parents des chemins menant à la maman de la troupe"""
    chemin = [fin]
    x, y, z = chemin[-1]

    while matrice_parent[z][y][x] != (None, None, None):
        chemin.append(matrice_parent[z][y][x])
        x, y, z = chemin[-1]
    if chemin == [fin]: return []  # pas de chemin trouvé
    return chemin[::-1]  # source -> fin

def avancer_chemin(chemin, id):
    if chemin == []: return
    PM = troupes_joueur(moi())[id].pts_action

    for x in range(min(PM, len(chemin) - 1)):
        err = avancer(id + 1, direction_AB(chemin[x], chemin[x + 1]))
        if err != erreur.OK: debug(err)

"""           AJUSTEMENT
Fonction pour affiner le déplacement
"""
@benchmark
def set_voisins_directes(scores):
    global voisins_directes, MALUS_TUNNEL
    terrain = get_terrain()
    voisins_directes = [[[
        [] for _ in range(LARGEUR)
        ]  for _ in range(HAUTEUR)
        ]  for z in (0, -1)
    ]

    for z in (0, -1):
        for x in range(LARGEUR):
            for y in range(HAUTEUR):
                for (nx, ny, nz) in get_voisins_fast(terrain, x, y, z):
                    voisins_directes[nz][nx][ny].append((scores[ny][nx] + MALUS_TUNNEL*nz, (nx,ny,nz)))
                voisins_directes[z][x][y] = [cell for score, cell in sorted(voisins_directes[z][x][y])]

def get_voisins_fast(terrain, x, y, z):
    global voisins_directes
    if voisins_directes != [] and False:
        for x,y,z in voisins_directes[z][y][x]:
            if terrain[z][y][x] == VIDE:
                yield (x,y,z)
    else:
        for x,y,z in get_voisins(terrain, x, y, z):
            yield (x,y,z)

"""           ATTAQUE
Fonction pour disperser l'adversaire
"""
@benchmark
@debug_fct
def get_parcours(t, cells):
    """renvoie un chemin depuis la troupe t qui passe par toutes les cellules cells"""

    terrain = protege_troupe(get_terrain_simplifie(), t)
    cells = set(cells)

    def aux(cells, terrain, resultat=[]):
        if len(cells) == 0: return resultat, cells

        if resultat != []:
            for x,y,z in resultat[max(0, len(resultat-get_taille()))::]:
                terrain[z][y][x] = MUR

        deplacements = get_deplacements(terrain, debut, match=cells)
        if len(deplacements) == 2: # pas de match sinon renvoie aussi la cell trouvée
            return resultat, cells
        destination, matrice_parent = retour
        resultat.extend(get_chemin(matrice_parent, destination))
        cells.remove(destination)

        return aux(cells, terrain, resultat)
    return aux(cells, terrain, [])

def get_cells_score(COEF_DISTANCE_NIDS, COEF_DISTANCE_PAPYS, COEF_NOMBRE_MUR, COEF_DISTANCE_ADVERSAIRE):
    terrain = get_terrain()
    nids_distances, _ = get_deplacements(terrain, nids_libres() + mes_nids())
    papys_distances, _ = get_deplacements(terrain, get_papy())
    adversaire_distances, _ = get_deplacements(
        protege_troupe(terrain, 0),
        [troupe_maman(adversaire(), 0), troupe_maman(adversaire(), 1)]
    )

    scores_vracs = []
    for x in range(LARGEUR):
        for y in range(HAUTEUR):
            nb_murs = sum([
                1
                for nx, ny in itertools.product((-1, 0, 1), repeat=2)
                if existe(x+nx, y + ny, 0) and terrain[0][y+ny][x+nx] == MUR
            ])

            scores_vracs.append((
                (
                    +COEF_DISTANCE_NIDS  * nids_distances[0][y][x]
                    +COEF_DISTANCE_PAPYS * papys_distances[0][y][x]
                    +COEF_NOMBRE_MUR * (1, 1, 1, 1, 0.7, 0.2, -0.2, -0.4,0,0)[nb_murs]
                    +COEF_DISTANCE_ADVERSAIRE * adversaire_distances[0][y][x]
                ),x,y
            ))

    scores_vracs.sort()
    scores = [[
        -float("inf")
     for x in range(LARGEUR)
    ]for y in range(HAUTEUR)]
    for classement, (score, x, y) in enumerate(scores_vracs):
        scores[y][x] = classement/40*40 # lissage linéaire
    return scores

@benchmark
@debug_fct
def necessaire_adversaire(t):
    troupe = troupes_joueur(adversaire())[t]
    taille = troupe.taille

    terrain = get_terrain_simplifie()
    terrain_parcours = [[[
         -taille if cell == VIDE else float("inf")
         for cell in ligne
        ]for ligne in etage
        ]for etage in get_terrain_simplifie()
    ]

    for i, (x,y,z) in enumerate(troupe.canards):
        terrain_parcours[z][y][x] = -i

    distance = 0
    fait = [[troupe_maman(adversaire(), t)]]
    circonference = [set(troupe_maman(adversaire(), t))]
    en_cours = []
    while distance < 10 and len(fait[-1]) < taille*4:
        distance += 1

        """
        debug(f"Distance : {distance}, Matrices : Visualisation/Parcours/Actualisé/Circonférences")
        show_matrices(
            matrice_to_string(matrice_visualisation()),
            matrice_to_string(terrain_parcours[0], entier=True),
            matrice_to_string(bin_matrice(fait[-1])[0],entier=True),
            matrice_to_string(bin_matrice(circonference[-1])[0], entier=True)
        )
        """
        circonference.append(set())

        for x,y,z in fait[-1]:
            for nx,ny,nz in get_voisins_fast(terrain, x,y,z):
                # On peut repasser sur cette case
                if  terrain_parcours[nz][ny][nx] + taille < distance:
                    if terrain_parcours[nz][ny][nx] == -taille:
                        circonference[-1].add((nx, ny, nz)) # Nouvelle case

                    terrain_parcours[nz][ny][nx] = max(terrain_parcours[z][y][x], distance)
                    en_cours.append((nx, ny, nz))

                if  terrain_parcours[nz][ny][nx] == terrain_parcours[z][y][x]:
                    # déjà rejoins par un autre endroit, on peut re-prendre ce chemin dans l'autre sens
                    terrain_parcours[nz][ny][nx] = terrain_parcours[nz][ny][nx] * 2 + 1
                    en_cours.append((nx, ny, nz))
        fait.append(en_cours)
        en_cours = []

    return circonference

@benchmark
@debug_fct
def get_chemin_attaque(t, terrain):
    m_distance, _ = get_deplacements(protege_troupe(terrain, troupe), troupe_maman(moi(), t))
    d = lambda c: m_distance[c[2]][c[1]][c[0]]
    distance, cible = min(
        (d(troupe_maman(adversaire(), 0)), 0),
        (d(troupe_maman(adversaire(), 1)), 1)
    )

    # Pas de cibles
    if distance == -1:
        return []

    choix = sorted(
        [(len(cells), capacite, cells)
         for capacite, cells in enumerate(necessaire_adversaire(cible))],
        key = lambda l, capacite, c: l - 1/capacite, # de préférence peux de capacite pour l'enemie
        reverse = True
    )

    # One shot
    if inventaire_t(cible, adversaire()) + inventaire_max(cible, adversaire())/3 > 6:
        for [cell] in [cells for nb, capacite, cells in choix if nb == 1]:
            if info_case(cell[0]).est_constructible:
                construire_buisson(cell)
                cibler_troupe(cible) # pur flex
                return []

    for nb, distance, cells in choix:
        chemin, restant = get_parcours(t, cells)
        if restant == 0: # on ne fait pas de buisson en plus
            if len(chemin) < capacite:
                return chemin # réalisable, sinon l'enemie sera forcé de prendre la sortie qu'on lui laisse
        else:
            break
    return []


"""           MAIN
Fonction de jeu
"""

@debug_fct
def partie_init():
    DEBUT = time.time()
    NIDS.extend(get_nids())
    # show_benchmark()

def jouer_tour():
    global BENCHMARK, DEBUT, SCORES_T0, SCORES_T1
    DEBUT = time.time()
    BENCHMARK = {}

    info(f"#Début tour {tour_actuel()} du joueur {moi()} avec {score(moi())} points")
    #Troupe 0
    scores = get_cells_score(*SCORES_T0)
    set_voisins_directes(scores)
    p_objectif = main(0, scores)

    #Troupe 1
    scores = get_cells_score(*SCORES_T1)
    set_voisins_directes(scores)
    main(1, scores, objectif_skip=[p_objectif])

    show_benchmark()
    debug()

def partie_fin():
    pass

@benchmark
@debug_fct
def main(troupe, scores, objectif_skip=[]):
    terrain = get_terrain_simplifie()
    m_distance, m_parent = get_deplacements(protege_troupe(terrain, troupe), troupe_maman(moi(), troupe))

    def d(pos):
        return m_distance[pos[2]][pos[1]][pos[0]]

    destination = (None, None, None)
    # objectif : score, fonction de réalisation, identifiant
    # le score se compte en pain

    while get_pm(troupe) > 0:
        objectifs = []

        # Attaquer si possible
        attaque = get_chemin_attaque(troupe, terrain)
        if attaque != []:
            objectifs.append((200, "attaque", attaque))

        # Prendre les nids
        if nids_libres() != []:
            objectifs.extend([
                (100 + 1 / d(p), "nids libre", p)
                for p in nids_libres() if d(p) > 0
            ])

        info(f"\t- Nids libres: {nids_libres()}")

        # Grandir
        if get_pm(troupe) > COUT_CROISSANCE and (tour_actuel() % 3 == 0 or tour_actuel() % 4 == 0):
            info(f"- Grandir : pm : {get_pm(troupe)}")
            objectifs.append((3, "grandir", None))

        # Collecte de pain
        if inventaire_t(troupe) < min(10, inventaire_max(troupe)):
            objectifs.extend([
                (1 + 1 / d(p), "pain", p)
                for p in pains() if d(p) > 0
            ])
            info(f"\t- On cherche du pain : pm : {get_pm(troupe)} Inventaire : {inventaire_t(troupe)} sur {inventaire_max(troupe)}\n\tCapture pain : {analyse_dim(objectifs)}")

        # S'approcher papy
        objectifs.extend([
            (0.2 + 1 / d(p), "papy", p)
            for p in get_papy() if d(p) > 0
        ])

        # Déposer pain
        if inventaire_t(troupe) > 2:
            objectifs.extend([
                (0.5 + 1 / d(p) + inventaire_t(troupe)*0.15, "deposer pain", p)
                for p in mes_nids() if d(p) > 0
            ])

        # On applique
        if objectifs != []:
            selection = (None, None)
            score_maxi = 0
            for priorite, action, destination in objectifs:
                if priorite >= score_maxi and destination not in objectif_skip:
                    selection = (action, destination)
                    score_maxi = priorite
            action, destination = selection

            debug("\t*Action :", action, "priorite", round(priorite, 2), "destination", destination)

            if action in ("pain", "papy", "nids libre", "deposer pain"):
                chemin = get_chemin(m_parent, destination)
                debug_chemin(chemin)
                info("\tChemin vers objectif à la position", destination, "distance", len(chemin))
                avancer_chemin(chemin, troupe)
                if troupe_maman(moi(), troupe) == destination:
                    info("-> On à atteint notre destination !")
                m_distance, m_parent = get_deplacements(protege_troupe(terrain, troupe), troupe_maman(moi(), troupe))

            elif action == "grandir":
                grandir(troupe + 1)

            elif action == "attaque":
                print("Charger !")
                avancer_chemin(destination, troupe)
                for pos in destination:
                    debug_poser_pigeon(pos, pigeon_debug.PIGEON_ROUGE)

            elif action == None:
                print("Que des mauvais coup à jouer :\'(")
                break
            else:
                print("Erreur, action non reconnue :", action)
                break
        else:
            info("Je n'ai plus d'objectif :\'(")
            break
    return destination
