from api import *
import time
import collections
from copy import deepcopy

#################################### Utils ####################################

MUR = 1
VIDE = 0
BENCHMARK = {}  # benchmark[fct name] = [number of call, total time]
DEBUT = time.time()
NIDS = []
ENEMIE = "e"
ENEMIE_MAMAN = "E"
MOI = "m"
MOI_MAMAN = "M"
SEPARATEUR = "|"
LEVEL_DEBUG = 0     # variable pour stocker la profondeur des debugs
LEVEL_MIN_DEBUG = -2 # affiche les debug au dessus de LEVEL_MIN_DEBUG


def cell_to_string(t):
    if type(t) == int:
        if t > 9: return str(t % 10)
        if t < -1: return "-"
    if t == SEPARATEUR: return "  |  "
    if type(t) == str:
        return t[:1]
    return {
        type_case.GAZON: " ",
        type_case.BUISSON: "#",
        type_case.BARRIERE: "=",
        type_case.NID: "X",
        type_case.PAPY: "*",
        type_case.TROU: "O",
        type_case.TUNNEL: " ",
        type_case.TERRE: " ",
        0: " ",
        -1: "#"
    }.get(t, "?")


def debug(*args, debut=100, fin=500, level=0):
    global LEVEL_DEBUG
    if debut <= tour_actuel() <= fin:
        if level >= LEVEL_MIN_DEBUG or True:
            print(*args)

def analyse_dim(a):
    if type(a) == type([]):
        return f"{len(a)}*" + analyse_dim(a[0])
    return str(type(a)) + str(a)

def debug_fct(fct):
    def wrapper(*args, **kargs):
        global LEVEL_DEBUG
        debug("\t"*LEVEL_DEBUG + f"*debut : {fct.__name__} avec",
              " ".join(list(map(str,
                  list(map(analyse_dim, args))
                + [(nom, analyse_dim(val)) for nom, val in kargs.items()]
              ))), level = LEVEL_DEBUG
        )
        LEVEL_DEBUG += 1
        resultat = fct(*args, **kargs)
        LEVEL_DEBUG -= 1
        debug("\t"*LEVEL_DEBUG+f"*fin : {fct.__name__}", level=LEVEL_DEBUG)
        return resultat
    return wrapper

def show_benchmark():
    debug(f"Benchmark tour n°{tour_actuel()} :")
    for nom, (call, total_temps) in BENCHMARK.items():
        total_temps = round(total_temps * 100, 1)
        debug("\t- {:<30} : {:>4} | {:<5} | {:<9}".format(
            nom, call, total_temps, round(total_temps / call, 5)
        ))
    debug("Total time : {:>4}%\n".format(round((time.time() - DEBUT) * 100, 2)))

def info(*args, **kargs):
    return debug(*args, level=0, **kargs)


def flatten(matrice, sep=[]):
    if len(matrice) == 1: sep = []
    return [
        elem
        for ligne in
        [l + sep for l in matrice]
        for elem in ligne
    ]


def show_matrices(*matrices):
    matrice_total = [
        flatten([
            matrices[m][y]
            for m in range(len(matrices))
        ], sep=[SEPARATEUR])
        for y in range(HAUTEUR)
    ]
    for l, ligne in enumerate(matrice_total):
        debug(f"({l}) " + "".join(map(cell_to_string, ligne)))


def matrice_visualisation():
    terrain = [[info_case((x, y, 0)).contenu for x in range(LARGEUR)] for y in range(HAUTEUR)]
    for j, t, j_tag, J_tag in (
            (adversaire(), 0, ENEMIE, ENEMIE_MAMAN),
            (adversaire(), 1, ENEMIE, ENEMIE_MAMAN),
            (moi(), 0, MOI, MOI_MAMAN),
            (moi(), 1, MOI, MOI_MAMAN)
    ):
        for x, y, z in troupes_joueur(j)[t].canards:
            terrain[y][x] = j_tag
        x, y, z = troupe_maman(j, t)
        terrain[y][x] = J_tag
    return terrain


def benchmark(fct):
    def wrapper(*args, **kargs):
        debut = time.time()
        resultat = fct(*args, **kargs)
        fin = time.time()

        nom = fct.__name__
        if not nom in BENCHMARK.keys():
            BENCHMARK[nom] = [0, 0]
        BENCHMARK[nom][0] += 1
        BENCHMARK[nom][1] += fin - debut
        return resultat
    return wrapper


def cell_binaire(x, y, z):
    cell_type = info_case((x, y, z)).contenu
    if z == 0:
        if cell_type == type_case.BUISSON:
            return MUR
        if cell_type == type_case.BARRIERE and info_barriere((x, y, z)) == etat_barriere.FERMEE:
            return MUR
        return VIDE
    else:
        if cell_type == type_case.TERRE:
            return MUR
        return VIDE


def exist(x, y, z):
    return 0 <= x < LARGEUR and 0 <= y < HAUTEUR and z in (0, -1)


def debug_chemin(chemin):
    for x, y, z in chemin[:6]:
        debug_poser_pigeon((x, y, z), pigeon_debug.PIGEON_BLEU)
    for x, y, z in chemin[7::3]:
        debug_poser_pigeon((x, y, z), pigeon_debug.PIGEON_JAUNE)
    debug_poser_pigeon(chemin[-1], pigeon_debug.PIGEON_ROUGE)


def direction_AB(A, B):
    return {
        (0, -1, 0): direction.SUD,
        (0, 1, 0): direction.NORD,
        (-1, 0, 0): direction.OUEST,
        (1, 0, 0): direction.EST,
        (0, 0, 1): direction.HAUT,
        (0, 0, -1): direction.BAS
    }.get((B[0] - A[0], B[1] - A[1], B[2] - A[2]), None)


def troupe_maman(j, id):
    return troupes_joueur(j)[id].maman


#################################### Function ####################################
@benchmark
def get_terrain():
    """renvoie une matrice de 0 si la cellule est libre, 1 si pleine : terrain[z][y][x]"""
    return [[[
        cell_binaire(x, y, z)
        for x in range(LARGEUR)
    ] for y in range(HAUTEUR)
    ] for z in (0, -1)
    ]


@benchmark
def get_terrain_simplifie():
    """enlève les culs de sac"""
    NON_FAIT = 3
    EN_COURS = 2
    FAIT = VIDE
    terrain_base = get_terrain()
    terrain_simplifie = list(map(lambda terrain:
                                 [[NON_FAIT if case == VIDE else MUR
                                   for case in ligne
                                   ] for ligne in terrain],
                                 terrain_base
                                 ))
    def DFS(x, y, z):
        if terrain_simplifie[z][y][x] != NON_FAIT: return  # dejà fait
        terrain_simplifie[z][y][x] = EN_COURS

        compteur = 0
        for nx, ny, nz in get_voisins(terrain_base, x, y, z):
            DFS(nx, ny, nz)
            if terrain_simplifie[nz][ny][nx] != MUR:
                compteur += 1

        if compteur <= 1 and info_case((x, y, z)).contenu not in (type_case.NID, type_case.TROU):
            terrain_simplifie[z][y][x] = MUR  # cul de sac
        else:
            terrain_simplifie[z][y][x] = FAIT
    for x in range(LARGEUR):
        for y in range(HAUTEUR):
            DFS(x, y, 0)
    return terrain_simplifie


def protege_troupe(terrain, troupe):
    for x, y, z in troupes_joueur(moi())[(troupe + 1) % 2].canards:
        terrain[z][y][x] = MUR
    for x, y, z in troupes_joueur(moi())[troupe].canards:
        if (x, y, z) != troupe_maman(moi(), troupe):
            terrain[z][y][x] = MUR
    return terrain


def get_voisins(terrain, x, y, z):
    for dx, dy in ((0, -1), (0, 1), (-1, 0), (1, 0)):
        if exist(x + dx, y + dy, z) and terrain[z][y + dy][x + dx] == VIDE:
            yield (x + dx, y + dy, z)
    if info_case((x, y, z)).contenu == type_case.TROU:
        yield (x, y, [-1, 0][z])


@benchmark
def get_deplacements(terrain, debut, PM=-1):
    """renvoie deux matrices :
    - Matrice des distances depuis la mère de la troupe id jusqu'à la case (y, x)
    - Matrice de la première case du chemin de la case (y, x) à la mère de la troupe id
    """
    matrice_parent =[[[(None, None, None)
                        for x in range(LARGEUR)] for y in range(HAUTEUR)] for z in (0, -1)]
    matrice_distance = [[[-1
                        for x in range(LARGEUR)] for y in range(HAUTEUR)] for z in (0, -1)]

    en_cours = [debut]
    en_attente = []
    matrice_distance[debut[2]][debut[1]][debut[0]] = 0
    distance = 0

    while en_cours != []:
        distance += 1
        if distance > PM and PM != -1: break

        while en_cours != []:
            x, y, z = en_cours.pop()
            for nx, ny, nz in get_voisins(terrain, x, y, z):
                if matrice_distance[nz][ny][nx] == -1:
                    matrice_distance[nz][ny][nx] = distance
                    matrice_parent[nz][ny][nx] = (x, y, z)
                    en_attente.append((nx, ny, nz))

        en_cours = en_attente
        en_attente = []


    return matrice_distance, matrice_parent


@benchmark
def get_chemin(matrice_parent, fin):
    """remonte la matrice des parents des chemins menant à la maman de la troupe"""
    chemin = [fin]
    x, y, z = chemin[-1]

    while matrice_parent[z][y][x] != (None, None, None):
        chemin.append(matrice_parent[z][y][x])
        x, y, z = chemin[-1]
    if chemin == [fin]: return []  # pas de chemin trouvé
    return chemin[::-1]  # source -> fin


def action_avancer_chemin(chemin, id):
    if chemin == []: return
    PM = troupes_joueur(moi())[id].pts_action

    for x in range(min(PM, len(chemin) - 1)):
        err = avancer(id + 1, direction_AB(chemin[x], chemin[x + 1]))
        if err != erreur.OK: debug(err)


@benchmark
def get_nids():
    nids = []
    for y in range(HAUTEUR):
        for x in range(LARGEUR):
            if info_case((x, y, 0)).contenu == type_case.NID:
                nids.append((x, y, 0))
    return nids


def mes_nids():
    return [(x, y, 0) for x, y, z in get_nids() if info_nid((x, y, 0)) == moi() + 1]


def nids_libres():
    return [(x, y, 0) for x, y, z in get_nids() if info_nid((x, y, 0)) == etat_nid.LIBRE]

def get_papy():
    resultat = []
    for x in range(LARGEUR):
        for y in range(HAUTEUR):
            if info_case((x, y, 0)).contenu == type_case.PAPY:
                resultat.append((x, y, 0))
    return resultat

def get_pm(troupe):
    return troupes_joueur(moi())[troupe].pts_action

#################################### Main ####################################

@debug_fct
def partie_init():
    DEBUT = time.time()
    NIDS.extend(get_nids())
    #show_benchmark()



def jouer_tour():
    jouer_custom()

def jouer_custom():
    info(f"#Début tour {tour_actuel()} du joueur {moi()} avec {score(moi())} points")
    terrain = get_terrain_simplifie()
    m_distance_adversaire = [[[
        min(d1, d2)
        for d1, d2 in zip(ligne1, ligne2)
    ] for ligne1, ligne2 in zip(terrain1, terrain2)
    ] for terrain1, terrain2 in zip(
        get_deplacements(terrain, troupe_maman(adversaire(), 0))[0],
        get_deplacements(terrain, troupe_maman(adversaire(), 1))[0]
    )
    ]

    main(0, terrain, m_distance_adversaire)
    main(1, terrain, m_distance_adversaire)

    # show_matrices(matrice_visualisation())
    show_benchmark()
    debug()

def partie_fin():
    pass

@benchmark
@debug_fct
def main(troupe, terrain, m_distance_adversaire):
    m_distance, m_parent = get_deplacements(protege_troupe(terrain, troupe), troupe_maman(moi(), troupe))

    while get_pm(troupe) > 0:
        objectifs = nids_libres()
        info(f"\t- Objectif nids libres: {objectifs}\n\tMaman: {(troupe_maman(moi(), troupe))}")

        if objectifs == [] and get_pm(troupe) > COUT_CROISSANCE and tour_actuel() % 3 == 0:
            info(f"- On grandit : pm : {get_pm(troupe)}")
            grandir(troupe+1)
            continue

        if objectifs == [] and troupes_joueur(moi())[troupe].inventaire < inventaire(
                max(troupes_joueur(moi())[troupe].taille, 5)):
            objectifs = pains()
            info(f"\t- On cherche du pain : pm : {get_pm(troupe)} Inventaire : {troupes_joueur(moi())[troupe].inventaire} sur {inventaire(troupes_joueur(moi())[troupe].taille)}\n\tCapture pain : {analyse_dim(objectifs)}")

        if objectifs == []:
            objectifs = get_papy()
            info(f"\t- Pas de pain, cherche Papy : {objectifs}")

        if objectifs == []:
            debug("\t- On dépose le pain")
            objectifs = mes_nids()

        objectifs = [
            (m_distance[z][y][x], (x, y, z))
            for x, y, z in objectifs
            if m_distance[z][y][x] > 0
        ]

        if objectifs != []:
            distance, position = min(objectifs)
            debug_chemin(get_chemin(m_parent, position))
            info("\tChemin vers objectif à la position", position, "distance",distance)
            action_avancer_chemin(get_chemin(m_parent, position), troupe)

            if troupe_maman(moi(), troupe) == position:
                info("-> On à atteint notre objectif !")
            m_distance, m_parent = get_deplacements(protege_troupe(terrain, troupe), troupe_maman(moi(), troupe))
        else:
            info("Je n'ai plus d'objectif :\'(")
            break