from api import *
import time
import collections
from copy import deepcopy

#################################### Utils ####################################

MUR = 1
VIDE = 0
BENCHMARK = {}  # benchmark[fct name] = [number of call, total time]
DEBUT = time.time()
NIDS = []
LOGS = ""
ENEMIE = "e"
ENEMIE_MAMAN = "E"
MOI = "m"
MOI_MAMAN = "M"
SEPARATEUR = "|"


def cell_to_string(t):
    if type(t) == int:
        if t > 9: return str(t % 10)
        if t < -1: return "-"
    if t == SEPARATEUR: return "  |  "
    if type(t) == str:
        return t[:1]
    return {
        type_case.GAZON: " ",
        type_case.BUISSON: "#",
        type_case.BARRIERE: "=",
        type_case.NID: "X",
        type_case.PAPY: "*",
        type_case.TROU: "O",
        type_case.TUNNEL: " ",
        type_case.TERRE: " ",
        0: " ",
        -1: "#"
    }.get(t, "?")


def debug(*args, debut=0, fin=500, progressivement=True):
    global LOGS
    if debut <= tour_actuel() <= fin and moi() == 1:
        if progressivement:
            print(*args)
        else:
            LOGS += "".join(map(str, args)) + "\n"


def flatten(matrice, sep=[]):
    if len(matrice) == 1: sep = []
    return [
        elem
        for ligne in
        [l + sep for l in matrice]
        for elem in ligne
    ]


def show_matrices(*matrices):
    matrice_total = [
        flatten([
            matrices[m][y]
            for m in range(len(matrices))
        ], sep=[SEPARATEUR])
        for y in range(HAUTEUR)
    ]
    for l, ligne in enumerate(matrice_total):
        print(f"({l}) " + "".join(map(cell_to_string, ligne)))


def matrice_visualisation():
    terrain = [[info_case((x, y, 0)).contenu for x in range(LARGEUR)] for y in range(HAUTEUR)]
    for j, t, j_tag, J_tag in (
            (adversaire(), 0, ENEMIE, ENEMIE_MAMAN),
            (adversaire(), 1, ENEMIE, ENEMIE_MAMAN),
            (moi(), 0, MOI, MOI_MAMAN),
            (moi(), 1, MOI, MOI_MAMAN)
    ):
        for x, y, z in troupes_joueur(j)[t].canards:
            terrain[y][x] = j_tag
        x, y, z = troupes_joueur(j)[t].maman
        terrain[y][x] = J_tag
    return terrain


def benchmark(fct):
    def wrapper(*args, **kargs):
        DEBUT = time.time()
        resultat = fct(*args, **kargs)
        fin = time.time()

        nom = fct.__name__
        if not nom in BENCHMARK.keys():
            BENCHMARK[nom] = [0, 0]
        BENCHMARK[nom][0] += 1
        BENCHMARK[nom][1] += fin - DEBUT
        return resultat

    return wrapper


def show_benchmark():
    debug(f"Benchmark tour n°{tour_actuel()} :")
    for nom, (call, total_temps) in BENCHMARK.items():
        total_temps = round(total_temps * 100, 1)
        debug("\t- {:<30} : {:>4} | {:<5} | {:<9}".format(
            nom, call, total_temps, round(total_temps / call, 5)
        ))
    debug("Total time : {:>4}%\n".format(round((time.time() - DEBUT) * 100, 2)))


@benchmark
def cell_vide(x, y, z):
    cell_type = info_case((x, y, 0)).contenu
    if z == 0:
        if cell_type == type_case.BUISSON:
            return False
        if cell_type == type_case.BARRIERE and info_barriere((x, y, z)) == etat_barriere.FERMEE:
            return False
        return True
    else:
        return False


def exist(x, y):
    return 0 <= x < LARGEUR and 0 <= y < HAUTEUR


def debug_chemin(chemin):
    for x, y in chemin[:6]:
        debug_poser_pigeon((x, y, 0), pigeon_debug.PIGEON_BLEU)


def direction_AB(A, B):
    return {
        (0, -1): direction.SUD,
        (0, 1): direction.NORD,
        (-1, 0): direction.OUEST,
        (1, 0): direction.EST
    }.get((B[0] - A[0], B[1] - A[1]), None)


def troupe_maman(j, id):
    return troupes_joueur(j)[id].maman[:2]


#################################### Function ####################################
@benchmark
def get_terrain():
    """renvoie une matrice de 0 si la cellule est libre, 1 si pleine"""
    terrain = []
    for y in range(HAUTEUR):
        ligne = []
        for x in range(LARGEUR):
            if cell_vide(x, y, 0):
                ligne.append(VIDE)
            else:
                ligne.append(MUR)
        terrain.append(ligne)
    return terrain


@benchmark
def get_terrain_simplifie():
    """enlève les culs de sac"""
    NON_FAIT = 3
    EN_COURS = 2
    FAIT = VIDE

    terrain_base = get_terrain()
    terrain_simplifie = [[
        NON_FAIT if case == VIDE else MUR
        for case in ligne
    ] for ligne in terrain_base]

    def DFS(x, y):
        if terrain_simplifie[y][x] != NON_FAIT: return  # dejà fait
        terrain_simplifie[y][x] = EN_COURS

        compteur = 0
        for nx, ny in get_voisins(terrain_base, x, y):
            DFS(nx, ny)
            if terrain_simplifie[ny][nx] != MUR:
                compteur += 1

        if compteur <= 1 and info_case((x, y, 0)).contenu not in (type_case.NID, type_case.TROU):
            terrain_simplifie[y][x] = MUR  # cul de sac
        else:
            terrain_simplifie[y][x] = FAIT

    for x in range(LARGEUR):
        for y in range(HAUTEUR):
            DFS(x, y)

    return terrain_simplifie


def protege_troupe(terrain, troupe):
    for x, y, z in troupes_joueur(moi())[(troupe + 1) % 2].canards:
        terrain[y][x] = MUR
    for x, y, z in troupes_joueur(moi())[troupe].canards:
        if (x, y) != troupe_maman(moi(), troupe):
            terrain[y][x] = MUR
    return terrain


@benchmark
def get_nids():
    nids = []
    for y in range(HAUTEUR):
        for x in range(LARGEUR):
            if info_case((x, y, 0)).contenu == type_case.NID:
                nids.append((x, y))
    return nids


def get_nids_libres(nids):
    return [n for n in nids if info_nid((n[0], n[1], 0)) == moi()]


def get_voisins(terrain, x, y):
    for dx, dy in ((0, -1), (0, 1), (-1, 0), (1, 0)):
        if exist(x + dx, y + dy) and terrain[y + dy][x + dx] == VIDE:
            yield (x + dx, y + dy)


@benchmark
def get_deplacements(terrain, debut, PM=-1):
    """renvoie deux matrices :
    - Matrice des distances depuis la mère de la troupe id jusqu'à la case (y, x)
    - Matrice de la première case du chemin de la case (y, x) à la mère de la troupe id
    """
    matrice_parent = [[(None, None) for _ in range(LARGEUR)] for _ in range(HAUTEUR)]
    matrice_distance = [[-1 for _ in range(LARGEUR)] for _ in range(HAUTEUR)]

    en_cours = [debut]
    en_attente = []
    matrice_distance[debut[1]][debut[0]] = 0
    distance = 0

    while en_cours != []:
        distance += 1
        if distance > PM and PM != -1: break

        while en_cours != []:
            x, y = en_cours.pop()
            for nx, ny in get_voisins(terrain, x, y):
                if matrice_distance[ny][nx] == -1:
                    matrice_parent[ny][nx] = (x, y)
                    matrice_distance[ny][nx] = distance
                    en_attente.append((nx, ny))

        en_cours = en_attente
        en_attente = []

    return matrice_distance, matrice_parent


@benchmark
def get_chemin(matrice_parent, fin):
    """remonte la matrice des parents des chemins menant à la maman de la troupe"""
    fin = fin[:2:]
    chemin = [fin]
    while matrice_parent[chemin[-1][1]][chemin[-1][0]] != (None, None):
        chemin.append(matrice_parent[chemin[-1][1]][chemin[-1][0]])
    if chemin == [fin]: return []
    return chemin[::-1]


def action_avancer_chemin(chemin, id):
    if chemin == []: return
    PM = troupes_joueur(moi())[id].pts_action

    for x in range(min(PM, len(chemin) - 1)):
        err = avancer(id + 1, direction_AB(chemin[x], chemin[x + 1]))
        debug(f"\t{err}")


def mes_nids():
    return [(x, y) for (x, y) in get_nids() if info_nid((x, y, 0)) == moi() + 1]


def nids_libres():
    return [(x, y) for (x, y) in get_nids() if info_nid((x, y, 0)) == etat_nid.LIBRE]


def get_papy():
    resultat = []
    for x in range(LARGEUR):
        for y in range(HAUTEUR):
            if info_case((x, y, 0)).contenu == type_case.PAPY:
                resultat.append((x, y))
    return resultat


def get_pains():
    return [(x, y) for x, y, z in pains()]


#################################### Main ####################################
def partie_init():
    DEBUT = time.time()
    debug("Initialisation :")

    NIDS.extend(get_nids())

    show_benchmark()
    debug("Fin initialisation")


def get_pm(troupe):
    return troupes_joueur(moi())[troupe].pts_action


@benchmark
def main(troupe, terrain, m_distance_adversaire):
    print("Début main pour troupe :", troupe)
    m_distance, m_parent = get_deplacements(protege_troupe(terrain, troupe), troupe_maman(moi(), troupe))

    # Capture des nids
    objectifs = [
        (m_distance[y][x], (x, y))
        for x, y in nids_libres()
        if 0 <= m_distance[y][x]  # <= m_distance_adversaire[y][x]
    ]

    while get_pm(troupe) > 0 and objectifs != []:
        print("\twhile objectifs")
        distance, objectif = min(objectifs)
        print("\tObjectif :", objectif)
        debug_chemin(get_chemin(m_parent, objectif))
        print("\tchemin :", get_chemin(m_parent, objectif))
        print("\t", troupe_maman(moi(), troupe))
        action_avancer_chemin(get_chemin(m_parent, objectif), troupe)
        m_distance, m_parent = get_deplacements(protege_troupe(terrain, troupe), troupe_maman(moi(), troupe))

        objectifs = [
            (m_distance[y][x], (x, y))
            for x, y in nids_libres()
            if 0 <= m_distance[y][x]  # <= m_distance_adversaire[y][x]
        ]

    if get_pm(troupe) > COUT_CROISSANCE and tour_actuel() % 3 == 0:
        print("On grandit")
        grandir(troupe)

    while get_pm(troupe) > 0:
        if troupes_joueur(moi())[troupe].inventaire < inventaire(max(troupes_joueur(moi())[troupe].taille, 5)):
            print("\tpm :", get_pm(troupe), "inventaire :", troupes_joueur(moi())[troupe].inventaire, "taille maxi",
                  inventaire(troupes_joueur(moi())[troupe].taille))
            debug("\tCapture pain")
            sources = get_pains()
            if sources == []:
                print("\tPas de pain, cherche Papy")
                sources = get_papy()
                print("\tPapy :", sources)
            else:
                print("\ton cherche du pain !")

        else:
            print("\tOn dépose le pain")
            sources = mes_nids()

        objectifs = sorted([
            (m_distance[y][x], (x, y))
            for x, y in sources
            if m_distance[y][x] > 0
        ])
        if objectifs != []:
            distance, position = objectifs[0]
            debug_chemin(get_chemin(m_parent, position))
            print("\tchemin vers objectif", get_chemin(m_parent, position))
            action_avancer_chemin(get_chemin(m_parent, position), troupe)
            if troupe_maman(moi(), troupe) == position:
                print("-> On à atteint notre objectif !")
            m_distance, m_parent = get_deplacements(protege_troupe(terrain, troupe), troupe_maman(moi(), troupe))
        else:
            print("Suicide, pas d'objectif")
            break


def jouer_tour():
    print(f"#############Début tour {tour_actuel()} du joueur {moi()} avec {score(moi())} points")
    terrain = get_terrain_simplifie()
    m_distance_adversaire = [[
        min(d1, d2)
        for d1, d2 in zip(ligne1, ligne2)]
        for ligne1, ligne2 in zip(
            get_deplacements(terrain, troupe_maman(adversaire(), 0))[0],
            get_deplacements(terrain, troupe_maman(adversaire(), 1))[0]
        )
    ]

    main(0, terrain, m_distance_adversaire)
    main(1, terrain, m_distance_adversaire)

    # show_matrices(matrice_visualisation())
    show_benchmark()


def partie_fin():
    print(LOGS)


"""Vracs
    debug("position maman : ", troupes_joueur(moi())[0].maman)
debug("troupes :", troupes_joueur(moi()))
"""
