// Include standard library in documentation: `cargo doc --open`
#[doc(inline)]
pub use std;
use std::{collections::{HashMap, HashSet}, ops::RangeBounds};

mod ffi;
pub mod api;

use api::*;

use api::TypeCase::*;

static mut nids: Vec<Position> = Vec::new();
static mut a_moi: Vec<Position> = Vec::new();
static mut libres: Vec<Position> = Vec::new();

static mut POINTSPRE: Option<PointsMvtComplet> = None;
static mut POINTSPAR: Option<PointsMvtPartiel> = None;


const DIRECTIONS: [Direction; 4] = [Direction::Nord, Direction::Sud, Direction::Est, Direction::Ouest];

const A: u32 = 47813;
const B: u32 = 65537;
const P: u32 = 4294967295;



fn dir_to_pos(dir: Direction) -> Position {

    match dir {

        Direction::Est => (1, 0, 0),
        Direction::Ouest => (-1, 0, 0),
        Direction::Nord => (0, 1, 0),
        Direction::Sud => (0, -1, 0),
        _ => (0, 0, 0)


    }

}

struct PRng {
    n: u32,
    s: u32
}

impl PRng {

    fn new() -> PRng {

        let mut obj = PRng {n: 0, s: 1};
        obj.advance();
        obj.advance();
        obj.advance();
        obj.advance();
        obj.advance();
        obj


    }

    fn advance(&mut self) -> u32 {
        self.s = (self.s * A + self.n + B) % P;
        self.n += 1;
        self.s
    }

}

struct PointsMvtComplet{
    points: Vec<Position>,
    position_to_id: HashMap<Position, usize>,
    chemins: Vec<Vec<[Direction; 5]>>

}

impl PointsMvtComplet {

    fn new() -> PointsMvtComplet {
        let mut obj = PointsMvtComplet{
            points: Vec::new(),
            position_to_id: HashMap::new(),
            chemins: Vec::new()
        };

        obj.compute();
        obj
    }

    fn compute(&mut self) {

        self.explo(&mut vec![], 0);

    }

    fn explo(&mut self, v: &mut Vec<Direction>, depth: u8) {

        if depth == 5 {

            let mut intermediary_positions: Vec<Position> = vec![(0, 0, 0)];
            let mut cur_pos = (0, 0, 0);

            for dir in v.iter() {

                let delta = dir_to_pos(*dir);
                cur_pos.0 += delta.0;
                cur_pos.1 += delta.1;
                cur_pos.2 += delta.2;

                if intermediary_positions.contains(&cur_pos) {
                    return
                }
                intermediary_positions.push(cur_pos);

            }

            let mut arr = [Direction::Nord; 5];
            for i in 0..5 {
                arr[i] = v[i]
            }

            if self.position_to_id.contains_key(&cur_pos) {
                let id = self.position_to_id[&cur_pos];
                
                self.chemins.get_mut(id).unwrap().push(arr)
            } else {

                let id = self.points.len();

                self.position_to_id.insert(cur_pos, id);

                self.points.push(cur_pos);
                self.chemins.push(vec![arr]);

            }



        } else {

            for dir in DIRECTIONS {
                v.push(dir);
                self.explo(v, depth + 1);
                v.pop();
            }

        }

    }

}

struct PointsMvtPartiel{
    points: Vec<Position>,
    position_to_id: HashMap<Position, usize>,
    chemins: Vec<Vec<[Direction; 2]>>

}

impl PointsMvtPartiel {

    fn new() -> PointsMvtPartiel {
        let mut obj = PointsMvtPartiel{
            points: Vec::new(),
            position_to_id: HashMap::new(),
            chemins: Vec::new()
        };

        obj.compute();
        obj
    }

    fn compute(&mut self) {

        self.explo(&mut vec![], 0);

    }

    fn explo(&mut self, v: &mut Vec<Direction>, depth: u8) {

        if depth == 2 {

            let mut intermediary_positions: Vec<Position> = vec![(0, 0, 0)];
            let mut cur_pos = (0, 0, 0);

            for dir in v.iter() {

                let delta = dir_to_pos(*dir);
                cur_pos.0 += delta.0;
                cur_pos.1 += delta.1;
                cur_pos.2 += delta.2;

                if intermediary_positions.contains(&cur_pos) {
                    return
                }
                intermediary_positions.push(cur_pos);

            }

            let mut arr = [Direction::Nord; 2];
            for i in 0..2 {
                arr[i] = v[i]
            }

            if self.position_to_id.contains_key(&cur_pos) {
                let id = self.position_to_id[&cur_pos];
                
                self.chemins.get_mut(id).unwrap().push(arr)
            } else {

                let id = self.points.len();

                self.position_to_id.insert(cur_pos, id);

                self.points.push(cur_pos);
                self.chemins.push(vec![arr]);

            }



        } else {

            for dir in DIRECTIONS {
                v.push(dir);
                self.explo(v, depth + 1);
                v.pop();
            }

        }

    }

}

struct MTroupe {
    id: i32,
    joueur: i32,
    taille: i32,
    recolte: i32
}



struct GameState {
    troupes: Vec<MTroupe>,
    pain: Vec<Position>,
    nids: Vec<(Position, EtatNid)>,
    score: u32
}

impl GameState {

    fn trouver_troupe(&self, joueur: i32, id: i32) -> &MTroupe {

        for m_troupe in self.troupes.iter() {
            if m_troupe.joueur == joueur && m_troupe.id == id {
                return m_troupe
            }
        };
        panic!()
    }

    fn nids_allies(&self, joueur: i32) -> Vec<(Position, EtatNid)> {

        let mut out = Vec::new();

        for (pos, e) in self.nids.iter() {
            if e == &EtatNid::Libre || 
                (e == &EtatNid::Joueur0 && joueur == 0) ||
                (e == &EtatNid::Joueur1 && joueur == 1) {
                    out.push((*pos, *e))
                }
        }



        out

    }


}



/// Fonction appelée au début de la partie.
pub fn partie_init()
{
    let troupes = troupes_joueur(moi());

    println!("joueur: {}", moi());
    println!("t1: {:?}", troupes[0]);
    println!("t2: {:?}", troupes[1]);

    unsafe {

        POINTSPRE = Some(PointsMvtComplet::new());
        match &POINTSPRE {

            Some(v) => {
                println!("{}", v.points.len());

                for point in v.points.iter() {

                    println!("{} {}", point.0, point.1);

                }
            
            
            
            },
            None => ()

        };

        POINTSPAR = Some(PointsMvtPartiel::new());


        trouver_nids(&mut nids, &mut a_moi, &mut libres);
    }



}


fn case_libre(position: Position, canards: &HashSet<Position>) -> bool {

    let info = info_case(position);

    match info.contenu {
        Gazon | Nid | Papy | Trou => !canards.contains(&position),
        Barriere => info_barriere(position) == EtatBarriere::Ouverte && !canards.contains(&position),
        _ => false
        
    }


}


fn trouver_cases_avec_canard(output: &mut HashSet<Position>) {

    let troupes_m = troupes_joueur(moi());
    let troupes_a = troupes_joueur(adversaire());

    for t in troupes_a {
        for pos in t.canards {
            output.insert(pos);
        }
    }

    for t in troupes_m {
        for pos in t.canards {
            output.insert(pos);
        }
    }



}

enum Action {

    Deplacer5(i32, i32, Position),
    GrandirDeplacer2(i32, i32, Position)

}

fn trouver_actions_approx1(joueur: i32, troupe: i32, position_maman: Position) -> Vec<Action> {

    let mut position_a_atteindre: Position;
    let mut out = Vec::new();

    let mut canards = HashSet::new();

    unsafe {

        match &POINTSPRE {
            Some(points) => {

                for delta in points.points.iter() {

                    position_a_atteindre = position_maman;
                    position_a_atteindre.0 += delta.0;
                    position_a_atteindre.1 += delta.1;
                    position_a_atteindre.2 += delta.2;

                    if 0 <= position_a_atteindre.0 && position_a_atteindre.0 < LARGEUR && 0 <= position_a_atteindre.1 && position_a_atteindre.1 < HAUTEUR {
                        if case_libre(position_a_atteindre, &canards) {
                            out.push(Action::Deplacer5(joueur, troupe, position_a_atteindre))
                        }
                    }


                };

            },
            _ => ()
        };

        match &POINTSPAR {
            Some(points) => {

                for delta in points.points.iter() {

                    position_a_atteindre = position_maman;
                    position_a_atteindre.0 += delta.0;
                    position_a_atteindre.1 += delta.1;
                    position_a_atteindre.2 += delta.2;

                    if 0 <= position_a_atteindre.0 && position_a_atteindre.0 < LARGEUR && 0 <= position_a_atteindre.1 && position_a_atteindre.1 < HAUTEUR {
                        if case_libre(position_a_atteindre, &canards) {
                            out.push(Action::GrandirDeplacer2(joueur, troupe, position_a_atteindre))
                        }
                    }


                };

            },
            _ => ()
        };

    };

    out




}



pub fn jouer_tour() {


}



fn distance(p1: Position, p2: Position) -> f32 {

    ((p1.0 - p2.0).abs() + (p1.1 - p2.1).abs()) as f32

}

fn eval_approx1(gm: GameState, action: Action) -> f32 {

    let mut out = 0.0;

    let mut mpos;
    let mut msize;

    let mut troupe;
    let mut joueur;

    match action {
        Action::Deplacer5(j, t, pos) => {
            joueur = j;
            troupe = gm.trouver_troupe(j, t);
            mpos = pos;
            msize = troupe.taille;

        },
        Action::GrandirDeplacer2(j, t, pos) => {
            joueur = j;
            troupe = gm.trouver_troupe(j, t);
            mpos = pos;
            msize = troupe.taille + 1;
        }

    }

    // distance au pain le plus proche
    {
        let mut current_min_dist = 80.0;
        for p in gm.pain.iter() {
            current_min_dist = f32::min(current_min_dist, distance(*p, mpos))
        }

        let capacity = msize as f32 / 3.0;
        let multiplicator = capacity - troupe.recolte as f32;

        let value = (80.0 - current_min_dist) * multiplicator;

        out += value / 80.0 * 0.2;

    }

    // distance au nid le plus proche
    {

        let mut current_min_dist = 80.0;
        for (p, _) in gm.nids_allies(joueur).iter() {
            current_min_dist = f32::min(current_min_dist, distance(*p, mpos))
        }

        let multiplicator = troupe.recolte as f32;

        let value = (80.0 - current_min_dist) * multiplicator * multiplicator;

        out += value / 80.0 * 0.1;



    }




    out




}

fn trouver_nids(output: &mut Vec<Position>, o2: &mut Vec<Position>, o3: &mut Vec<Position>) {
    for x in 0..LARGEUR {
        for y in 0..HAUTEUR {

            match info_case((x, y, 0)).contenu {

                TypeCase::Nid => {
                    output.push((x, y, 0));
                    match info_nid((x, y, 0)) {

                        EtatNid::Libre => {o3.push((x, y, 0)); },
                        EtatNid::Joueur0 => {if moi() == 0 {o2.push((x, y, 0))}; },
                        EtatNid::Joueur1 => { if moi() == 1 {o2.push((x, y, 0))}; },
                        _ => ()
                    }
                
                
                },
                _ => ()

            }

        }
    }


}



/// Fonction appelée à la fin de la partie.
pub fn partie_fin()
{
    // TODO
}
