use core::time;
// Include standard library in documentation: `cargo doc --open`
#[doc(inline)]
pub use std;
use std::{cmp::Reverse, collections::{BinaryHeap, HashMap, HashSet}};

mod ffi;
pub mod api;

use api::*;
use api::TypeCase::*;


const DIRECTIONS: [Direction; 4] = [Direction::Nord, Direction::Sud, Direction::Est, Direction::Ouest];

static mut OBJECTIF: i32 = 1;
static mut states: [i32; 2] = [0, 0];

fn dir_to_pos(dir: Direction) -> Position {

    match dir {

        Direction::Est => (1, 0, 0),
        Direction::Ouest => (-1, 0, 0),
        Direction::Nord => (0, 1, 0),
        Direction::Sud => (0, -1, 0),
        _ => (0, 0, 0)
    }

}

fn pos_to_dir(p: Position) -> Direction {
    
    match p {

        (1, 0, 0) => Direction::Est,
        (-1, 0, 0) => Direction::Ouest,
        (0, 1, 0) => Direction::Nord,
        (0, -1, 0) => Direction::Sud,
        _ => panic!()
    }
}



/// Fonction appelée au début de la partie.
pub fn partie_init()
{
    let troupes = troupes_joueur(moi());

    println!("joueur: {}", moi());
    println!("t1: {:?}", troupes[0]);
    println!("t2: {:?}", troupes[1]);




}


fn case_libre(position: Position, canards: &HashSet<Position>) -> bool {

    if position.0 < 0 || position.1 < 0 || position.0 > 39 || position.1 > 39{
        return false
    }

    let info = info_case(position);

    match info.contenu {
        Gazon | Nid | Papy | Trou => !canards.contains(&position),
        Barriere => info_barriere(position) == EtatBarriere::Ouverte && !canards.contains(&position),
        _ => false
        
    }


}


fn trouver_cases_avec_canard(output: &mut HashSet<Position>) {

    let troupes_m = troupes_joueur(moi());
    let troupes_a = troupes_joueur(adversaire());

    for t in troupes_a {
        for pos in t.canards {
            output.insert(pos);
        }
    }
    
    for t in troupes_m {
        for pos in t.canards {
            output.insert(pos);
        }
    }


}

fn dfs(depart: Position, cibles: &Vec<Position>, canards: &HashSet<Position>) -> (Vec<Direction>, Vec<Position>, HashSet<Position>, bool) {
    let mut ch5 = (Vec::new(), 0);

    let mut hashch = HashSet::from([depart]);

    explore(depart, cibles, canards, &mut vec![depart], &mut hashch, &mut ch5, &mut 0);

    let mut grow = false;
    let chemin = ch5.0;

    let mut output = Vec::new();
    if chemin.len() > 0 {
        for i in 0..(chemin.len() - 2) {
            output.push(get_direction(chemin[i], chemin[i + 1]))
        }
    };
    (output, chemin, hashch, grow)


}

fn get_direction(p1: Position, p2: Position) -> Direction {
    let mut delta = p2;
    delta.0 -= p1.0;
    delta.1 -= p1.1;
    delta.2 -= p1.2;
    pos_to_dir(delta)

}

fn get_sorted_directions(p1: Position, cible: Position) -> [Direction; 4] {

    let mut dirs = [Direction::Nord; 4];

    let dx = cible.0 - p1.0;
    let dy = cible.1 - p1.1;

    if dx.abs() > dy.abs() {
        if dx < 0 {
            dirs[0] = Direction::Ouest;
            dirs[3] = Direction::Est;
        } else {
            dirs[0] = Direction::Est;
            dirs[3] = Direction::Ouest;
        }
        if dy < 0 {
            dirs[1] = Direction::Sud;
            dirs[2] = Direction::Nord;
        } else {
            dirs[1] = Direction::Nord;
            dirs[2] = Direction::Sud;
        }
    }

    else {
        if dx < 0 {
            dirs[1] = Direction::Ouest;
            dirs[2] = Direction::Est;
        } else {
            dirs[1] = Direction::Est;
            dirs[2] = Direction::Ouest;
        }
        if dy < 0 {
            dirs[0] = Direction::Sud;
            dirs[3] = Direction::Nord;
        } else {
            dirs[0] = Direction::Nord;
            dirs[3] = Direction::Sud;
        }
    };
    dirs



}



fn explore(noeud: Position, cibles: &Vec<Position>, canards: &HashSet<Position>, chemin: &mut Vec<Position>, chemin_set: &mut HashSet<Position>,
           ch: &mut (Vec<Position>, u32), counter: &mut u32
        ) {
            
            *counter += 1;

            if counter > &mut 30000 {
                return
            }

            let mut cibles_a_cibler = Vec::new();

            if cibles.contains(&noeud) {
                let mut c = 0;
                for cible in cibles.iter() {

                    if chemin_set.contains(&cible) {
                        c += 1;
                    } else {
                        cibles_a_cibler.push(cible)
                    }
                };

                if c > ch.1 {
                    if chemin.len() < ch.0.len() * 2 {
                        *ch = (chemin.clone(), c)
                    }
                } else if c == ch.1 {
                    if chemin.len() < ch.0.len() {
                        *ch = (chemin.clone(), c)
                    }

                }

            }



            for direction in get_sorted_directions(noeud, **cibles_a_cibler.first().unwrap_or(&&(20, 20, 0))).iter() {

                let delta = dir_to_pos(*direction);

                let mut nouveau_noeud = noeud.clone();
                nouveau_noeud.0 += delta.0;
                nouveau_noeud.1 += delta.1;
                nouveau_noeud.2 += delta.2;

                if case_libre(nouveau_noeud, canards) && !chemin_set.contains(&nouveau_noeud) {

                    chemin.push(nouveau_noeud);
                    chemin_set.insert(nouveau_noeud);
                    explore(nouveau_noeud, cibles, canards, chemin, chemin_set, ch, counter);
                    chemin_set.remove(&nouveau_noeud);
                    chemin.pop();

                }

            }

            



}



fn deplacements_safes(t: &Troupe, canards: &HashSet<Position>, chemin: &HashSet<Position>, n: u32) {

    let mut ch2 = HashSet::new();

    for _ in 0..n {
        for dir in DIRECTIONS.iter() {

            let delta = dir_to_pos(*dir);
            let pos = (t.maman.0 + delta.0, t.maman.1 + delta.1, t.maman.2 + delta.2);
            if case_libre(pos, canards) && !chemin.contains(&pos) && !ch2.contains(&pos) {
                avancer(t.id, *dir);
                ch2.insert(pos);
            }

        }        


    }


}

fn jouer_troupe(t: &Troupe, nids_a_moi: &Vec<Position>, canards: &HashSet<Position>) {

    unsafe  {

        if t.inventaire < OBJECTIF {

            let cibles = pains();

            let data = dfs(t.maman, &cibles, canards);

            if t.taille / 3 < OBJECTIF {
                grandir(t.id);
                for i in 0..2 {
                    if i < data.0.len() {
                        avancer(t.id, data.0[i]);
                    } else {

                        deplacements_safes(t, canards, &data.2, 2 - i as u32);
                        break

                    }
                }
            } else {
                for i in 0..5 {
                    if i < data.0.len() {
                        avancer(t.id, data.0[i]);
                    } else {

                        deplacements_safes(t, canards, &data.2, 5 - i as u32);
                        break

                    }
                }
            
            }

        } else {

            let cibles = nids_a_moi;

            let data = dfs(t.maman, cibles, canards);

            for i in 0..5 {
                if i < data.0.len() {
                    avancer(t.id, data.0[i]);
                } else {

                    deplacements_safes(t, canards, &data.2, 5 - i as u32);
                    break

                }
            }
            
            



        }

    }



}

pub fn jouer_tour() {

    let troupes = troupes_joueur(moi());

    let t1 = &troupes[0];
    let t2 = &troupes[1];

    let mut canards = HashSet::new();
    trouver_cases_avec_canard(&mut canards);

    let mut nids = Vec::new();
    let mut nids_a_moi = Vec::new();
    trouver_nids(&mut nids, &mut nids_a_moi);

    unsafe {
        println!("la");

        jouer_troupe(t1, &nids_a_moi, &canards);
        jouer_troupe(t2, &nids_a_moi, &canards);

    }

}


fn trouver_plus_proche(pos: Position, v: &Vec<Position>) -> (i32, usize) {

    let mut current_min = 8100;

    let mut current_min_index = 42;

    for (i, p) in v.iter().enumerate() {
        let dist = distance(*p, pos);

        if dist < current_min && dist != 0{
            current_min = dist;
            current_min_index = i;
        }
    };

    (current_min, current_min_index)

}



fn distance(p1: Position, p2: Position) -> i32 {

    ((p1.0 - p2.0).abs() + (p1.1 - p2.1).abs()) as i32

}

fn trouver_nids(output: &mut Vec<Position>, o2: &mut Vec<Position>) {
    for x in 0..LARGEUR {
        for y in 0..HAUTEUR {

            match info_case((x, y, 0)).contenu {

                TypeCase::Nid => {
                    output.push((x, y, 0));
                    match info_nid((x, y, 0)) {

                        EtatNid::Libre => {o2.push((x, y, 0))},
                        EtatNid::Joueur0 => {if moi() == 0 {o2.push((x, y, 0))}; },
                        EtatNid::Joueur1 => { if moi() == 1 {o2.push((x, y, 0))}; },
                        _ => ()
                    }
                
                
                },
                _ => ()

            }

        }
    }


}



/// Fonction appelée à la fin de la partie.
pub fn partie_fin()
{
    // TODO
}











