// SPDX-License-Identifier: GPL-2.0-or-later
// Copyright (c) 2020 Association Prologin <association@prologin.org>

// This file contains the code to call the API functions from the C language.
// This file was generated by stechec2-generator. DO NOT EDIT.

#include <string>
#include <vector>

extern "C"
{
#include "api.h"
}

template <typename CType, typename CxxType>
CxxType c_to_cxx(CType in)
{
    return in;
}

template <>
std::string c_to_cxx<char*, std::string>(char* in)
{
    return in;
}

template <typename CType, typename CType_array, typename CxxType>
std::vector<CxxType> c_to_cxx_array(CType_array in)
{
    std::vector<CxxType> out(in.length);
    for (size_t i = 0; i < in.length; ++i)
        out[i] = c_to_cxx<CType, CxxType>(in.items[i]);
    return out;
}

template <typename CType, typename CxxType>
CType cxx_to_c(CxxType in)
{
    return in;
}

template <>
char* cxx_to_c<char*, std::string>(std::string in)
{
    size_t l = in.length();
    char* out = (char *) malloc(l + 1);
    for (size_t i = 0; i < l; i++)
        out[i] = in[i];
    out[l] = 0;
    return out;
}

template <typename CType, typename CType_array, typename CxxType>
CType_array cxx_to_c_array(const std::vector<CxxType>& in)
{
    CType_array out = {NULL, in.size()};
    out.items = (CType*)malloc((out.length) * sizeof(CType));
    for (size_t i = 0; i < out.length; ++i)
        out.items[i] = cxx_to_c<CType, CxxType>(in[i]);
    return out;
}

/// Position dans la carte, donnée par trois coordonnées

typedef struct __internal__cxx__position
{
    int colonne; ///< Abscisse
    int ligne; ///< Ordonnée
    int niveau; ///< Niveau
} __internal__cxx__position;

template <>
__internal__cxx__position c_to_cxx<position, __internal__cxx__position>(position in)
{
    __internal__cxx__position out;
    out.colonne = c_to_cxx<int, int>(in.colonne);
    out.ligne = c_to_cxx<int, int>(in.ligne);
    out.niveau = c_to_cxx<int, int>(in.niveau);
    return out;
}

template <>
position cxx_to_c<position, __internal__cxx__position>(__internal__cxx__position in)
{
    position out;
    out.colonne = cxx_to_c<int, int>(in.colonne);
    out.ligne = cxx_to_c<int, int>(in.ligne);
    out.niveau = cxx_to_c<int, int>(in.niveau);
    return out;
}

/// Une troupe, composée de la maman canard et de ses canetons

typedef struct __internal__cxx__troupe
{
    __internal__cxx__position maman; ///< Position de la maman canard
    std::vector<__internal__cxx__position> canards; ///< Position des différents canards de la troupe, incluant la maman en première position
    int taille; ///< Taille de la troupe
    direction dir; ///< Direction de la troupe
    int inventaire; ///< Nombre de pains de la troupe
    int pts_action; ///< Nombre de points d'action de la troupe
    int id; ///< Identifiant de la troupe
} __internal__cxx__troupe;

template <>
__internal__cxx__troupe c_to_cxx<troupe, __internal__cxx__troupe>(troupe in)
{
    __internal__cxx__troupe out;
    out.maman = c_to_cxx<position, __internal__cxx__position>(in.maman);
    out.canards = c_to_cxx_array<position, position_array, __internal__cxx__position>(in.canards);
    out.taille = c_to_cxx<int, int>(in.taille);
    out.dir = c_to_cxx<direction, direction>(in.dir);
    out.inventaire = c_to_cxx<int, int>(in.inventaire);
    out.pts_action = c_to_cxx<int, int>(in.pts_action);
    out.id = c_to_cxx<int, int>(in.id);
    return out;
}

template <>
troupe cxx_to_c<troupe, __internal__cxx__troupe>(__internal__cxx__troupe in)
{
    troupe out;
    out.maman = cxx_to_c<position, __internal__cxx__position>(in.maman);
    out.canards = cxx_to_c_array<position, position_array, __internal__cxx__position>(in.canards);
    out.taille = cxx_to_c<int, int>(in.taille);
    out.dir = cxx_to_c<direction, direction>(in.dir);
    out.inventaire = cxx_to_c<int, int>(in.inventaire);
    out.pts_action = cxx_to_c<int, int>(in.pts_action);
    out.id = cxx_to_c<int, int>(in.id);
    return out;
}

/// Élément constituant le parc

typedef struct __internal__cxx__etat_case
{
    __internal__cxx__position pos; ///< Position de la case. Le niveau vaut nécessairement 0
    type_case contenu; ///< Type de la case
    bool est_constructible; ///< La case est constructible
    int nb_pains; ///< Nombre de pains contenus sur la case
} __internal__cxx__etat_case;

template <>
__internal__cxx__etat_case c_to_cxx<etat_case, __internal__cxx__etat_case>(etat_case in)
{
    __internal__cxx__etat_case out;
    out.pos = c_to_cxx<position, __internal__cxx__position>(in.pos);
    out.contenu = c_to_cxx<type_case, type_case>(in.contenu);
    out.est_constructible = c_to_cxx<bool, bool>(in.est_constructible);
    out.nb_pains = c_to_cxx<int, int>(in.nb_pains);
    return out;
}

template <>
etat_case cxx_to_c<etat_case, __internal__cxx__etat_case>(__internal__cxx__etat_case in)
{
    etat_case out;
    out.pos = cxx_to_c<position, __internal__cxx__position>(in.pos);
    out.contenu = cxx_to_c<type_case, type_case>(in.contenu);
    out.est_constructible = cxx_to_c<bool, bool>(in.est_constructible);
    out.nb_pains = cxx_to_c<int, int>(in.nb_pains);
    return out;
}

/// Action représentée dans l'historique

typedef struct __internal__cxx__action_hist
{
    type_action action_type; ///< Type de l'action
    int troupe_id; ///< Identifiant de la troupe
    direction action_dir; ///< Direction de l'action
    __internal__cxx__position action_pos; ///< Position de l'action
} __internal__cxx__action_hist;

template <>
__internal__cxx__action_hist c_to_cxx<action_hist, __internal__cxx__action_hist>(action_hist in)
{
    __internal__cxx__action_hist out;
    out.action_type = c_to_cxx<type_action, type_action>(in.action_type);
    out.troupe_id = c_to_cxx<int, int>(in.troupe_id);
    out.action_dir = c_to_cxx<direction, direction>(in.action_dir);
    out.action_pos = c_to_cxx<position, __internal__cxx__position>(in.action_pos);
    return out;
}

template <>
action_hist cxx_to_c<action_hist, __internal__cxx__action_hist>(__internal__cxx__action_hist in)
{
    action_hist out;
    out.action_type = cxx_to_c<type_action, type_action>(in.action_type);
    out.troupe_id = cxx_to_c<int, int>(in.troupe_id);
    out.action_dir = cxx_to_c<direction, direction>(in.action_dir);
    out.action_pos = cxx_to_c<position, __internal__cxx__position>(in.action_pos);
    return out;
}


extern "C" erreur api_avancer(int id, direction dir);

extern "C" erreur avancer(int id, direction dir)
{
    return cxx_to_c<erreur, erreur>(api_avancer(c_to_cxx<int, int>(id), c_to_cxx<direction, direction>(dir)));
}

extern "C" erreur api_grandir(int id);

extern "C" erreur grandir(int id)
{
    return cxx_to_c<erreur, erreur>(api_grandir(c_to_cxx<int, int>(id)));
}

extern "C" erreur api_construire_buisson(__internal__cxx__position pos);

extern "C" erreur construire_buisson(position pos)
{
    return cxx_to_c<erreur, erreur>(api_construire_buisson(c_to_cxx<position, __internal__cxx__position>(pos)));
}

extern "C" erreur api_creuser_tunnel(__internal__cxx__position pos);

extern "C" erreur creuser_tunnel(position pos)
{
    return cxx_to_c<erreur, erreur>(api_creuser_tunnel(c_to_cxx<position, __internal__cxx__position>(pos)));
}

extern "C" __internal__cxx__etat_case api_info_case(__internal__cxx__position pos);

extern "C" etat_case info_case(position pos)
{
    return cxx_to_c<etat_case, __internal__cxx__etat_case>(api_info_case(c_to_cxx<position, __internal__cxx__position>(pos)));
}

extern "C" etat_barriere api_info_barriere(__internal__cxx__position pos);

extern "C" etat_barriere info_barriere(position pos)
{
    return cxx_to_c<etat_barriere, etat_barriere>(api_info_barriere(c_to_cxx<position, __internal__cxx__position>(pos)));
}

extern "C" etat_nid api_info_nid(__internal__cxx__position pos);

extern "C" etat_nid info_nid(position pos)
{
    return cxx_to_c<etat_nid, etat_nid>(api_info_nid(c_to_cxx<position, __internal__cxx__position>(pos)));
}

extern "C" int api_papy_tours_restants(__internal__cxx__position pos);

extern "C" int papy_tours_restants(position pos)
{
    return cxx_to_c<int, int>(api_papy_tours_restants(c_to_cxx<position, __internal__cxx__position>(pos)));
}

extern "C" std::vector<__internal__cxx__troupe> api_troupes_joueur(int id_joueur);

extern "C" troupe_array troupes_joueur(int id_joueur)
{
    return cxx_to_c_array<troupe, troupe_array, __internal__cxx__troupe>(api_troupes_joueur(c_to_cxx<int, int>(id_joueur)));
}

extern "C" std::vector<__internal__cxx__position> api_pains();

extern "C" position_array pains(void)
{
    return cxx_to_c_array<position, position_array, __internal__cxx__position>(api_pains());
}

extern "C" erreur api_debug_poser_pigeon(__internal__cxx__position pos, pigeon_debug pigeon);

extern "C" erreur debug_poser_pigeon(position pos, pigeon_debug pigeon)
{
    return cxx_to_c<erreur, erreur>(api_debug_poser_pigeon(c_to_cxx<position, __internal__cxx__position>(pos), c_to_cxx<pigeon_debug, pigeon_debug>(pigeon)));
}

extern "C" std::vector<__internal__cxx__action_hist> api_historique();

extern "C" action_hist_array historique(void)
{
    return cxx_to_c_array<action_hist, action_hist_array, __internal__cxx__action_hist>(api_historique());
}

extern "C" int api_gain(int nb_pains);

extern "C" int gain(int nb_pains)
{
    return cxx_to_c<int, int>(api_gain(c_to_cxx<int, int>(nb_pains)));
}

extern "C" int api_inventaire(int taille);

extern "C" int inventaire(int taille)
{
    return cxx_to_c<int, int>(api_inventaire(c_to_cxx<int, int>(taille)));
}

extern "C" std::vector<direction> api_trouver_chemin(__internal__cxx__position depart, __internal__cxx__position arrivee);

extern "C" direction_array trouver_chemin(position depart, position arrivee)
{
    return cxx_to_c_array<direction, direction_array, direction>(api_trouver_chemin(c_to_cxx<position, __internal__cxx__position>(depart), c_to_cxx<position, __internal__cxx__position>(arrivee)));
}

extern "C" int api_moi();

extern "C" int moi(void)
{
    return cxx_to_c<int, int>(api_moi());
}

extern "C" int api_adversaire();

extern "C" int adversaire(void)
{
    return cxx_to_c<int, int>(api_adversaire());
}

extern "C" int api_score(int id_joueur);

extern "C" int score(int id_joueur)
{
    return cxx_to_c<int, int>(api_score(c_to_cxx<int, int>(id_joueur)));
}

extern "C" bool api_annuler();

extern "C" bool annuler(void)
{
    return cxx_to_c<bool, bool>(api_annuler());
}

extern "C" int api_tour_actuel();

extern "C" int tour_actuel(void)
{
    return cxx_to_c<int, int>(api_tour_actuel());
}

extern "C" void api_afficher_erreur(erreur v);

extern "C" void afficher_erreur(erreur v)
{
api_afficher_erreur(c_to_cxx<erreur, erreur>(v));
}

extern "C" void api_afficher_direction(direction v);

extern "C" void afficher_direction(direction v)
{
api_afficher_direction(c_to_cxx<direction, direction>(v));
}

extern "C" void api_afficher_type_case(type_case v);

extern "C" void afficher_type_case(type_case v)
{
api_afficher_type_case(c_to_cxx<type_case, type_case>(v));
}

extern "C" void api_afficher_etat_barriere(etat_barriere v);

extern "C" void afficher_etat_barriere(etat_barriere v)
{
api_afficher_etat_barriere(c_to_cxx<etat_barriere, etat_barriere>(v));
}

extern "C" void api_afficher_etat_nid(etat_nid v);

extern "C" void afficher_etat_nid(etat_nid v)
{
api_afficher_etat_nid(c_to_cxx<etat_nid, etat_nid>(v));
}

extern "C" void api_afficher_pigeon_debug(pigeon_debug v);

extern "C" void afficher_pigeon_debug(pigeon_debug v)
{
api_afficher_pigeon_debug(c_to_cxx<pigeon_debug, pigeon_debug>(v));
}

extern "C" void api_afficher_type_action(type_action v);

extern "C" void afficher_type_action(type_action v)
{
api_afficher_type_action(c_to_cxx<type_action, type_action>(v));
}

extern "C" void api_afficher_position(__internal__cxx__position v);

extern "C" void afficher_position(position v)
{
api_afficher_position(c_to_cxx<position, __internal__cxx__position>(v));
}

extern "C" void api_afficher_troupe(__internal__cxx__troupe v);

extern "C" void afficher_troupe(troupe v)
{
api_afficher_troupe(c_to_cxx<troupe, __internal__cxx__troupe>(v));
}

extern "C" void api_afficher_etat_case(__internal__cxx__etat_case v);

extern "C" void afficher_etat_case(etat_case v)
{
api_afficher_etat_case(c_to_cxx<etat_case, __internal__cxx__etat_case>(v));
}

extern "C" void api_afficher_action_hist(__internal__cxx__action_hist v);

extern "C" void afficher_action_hist(action_hist v)
{
api_afficher_action_hist(c_to_cxx<action_hist, __internal__cxx__action_hist>(v));
}
