from defs_utiles import *
from api import NB_TROUPES,HAUTEUR,LARGEUR,info_case

def position_relative(p,direction):
    # Renvoie la position de la case adjacente à la case en `position`,
    # dans la direction `direction`.
    # Pas d'hypothèse particulière
    if direction == NORD:
        return (p[0]-1,p[1],p[2])
    elif direction == SUD:
        return (p[0]+1,p[1],p[2])
    elif direction == EST:
        return (p[0],p[1]+1,p[2])
    elif direction == OUEST:
        return (p[0],p[1]-1,p[2])
    elif direction == HAUT:
        return (p[0],p[1],p[2]-1)
    elif direction == BAS:
        return (p[0],p[1],p[2]+1)

def est_position_valide(position):
    # Vérifie si une position existe sur la carte
    if not -1 <= position[2] <= 0:
        return False
    elif not 0 <= position[1] < HAUTEUR:
        return False
    elif not 0 <= position[0] < LARGEUR:
        return False
    else:
        return True

def est_case_libre(position):
    # Vérifie si un groupe de canards peut avancer dans une direction sans se disloquer
    typeCase = info_case(position)[1]
    if typeCase in (GAZON,NID,PAPY,TROU,TUNNEL):
        return True
    elif typeCase == BARRIERE:
        if info_barriere(position) == OUVERTE:
            return True
        else:
            return False
    else:
        return False
