from defs_utiles import *
from api import NB_TROUPES,HAUTEUR,LARGEUR,info_case,troupes_joueur,info_barriere
NOMBRE_JOUEURS = 2

def position_relative(p,direction):
    # Renvoie la position de la case adjacente à la case en `position`,
    # dans la direction `direction`.
    # Pas d'hypothèse particulière
    if direction == NORD:
        return (p[0],p[1]+1,p[2])
    elif direction == SUD:
        return (p[0],p[1]-1,p[2])
    elif direction == EST:
        return (p[0]+1,p[1],p[2])
    elif direction == OUEST:
        return (p[0]-1,p[1],p[2])
    elif direction == HAUT:
        return (p[0],p[1],p[2]-1)
    elif direction == BAS:
        return (p[0],p[1],p[2]+1)

def est_position_valide(position):
    # Vérifie si une position existe sur la carte
    if not -1 <= position[2] <= 0:
        return False
    elif not 0 <= position[1] < HAUTEUR:
        return False
    elif not 0 <= position[0] < LARGEUR:
        return False
    else:
        return True

def est_case_libre(position):
    # Vérifie si un groupe de canards peut avancer dans une direction sans se disloquer
    typeCase = info_case(position)[1]
    if typeCase in (GAZON,NID,PAPY,TROU,TUNNEL):
        print("Case OK")
        return True
    elif typeCase == BARRIERE:
        print("Barrière")
        if info_barriere(position) == OUVERTE:
            return True
        else:
            return False
    else:
        print("Autre")
        return False

def est_sans_canard(position):
    # Vérifie que la case à la position `position` est sans canard
    for i in range(NOMBRE_JOUEURS):
        for troupe in troupes_joueur(i):
            if position in troupe.canards:
                return False
    return True
