# -*- coding: utf-8 -*-

from api import *

import math, queue

MAXLEN = 100

def tm(f):
    def wrapper(*args, **kwargs):
        global timeleft
        if timeleft <= 0:
            return timeleft
        else:
            start = time.time()
            ret = f(*args, **kwargs)
            end = time.time()
            timeleft -= end - start
            return ret
    return wrapper


def debug(*args, player=1, **kwargs):
    if moi() == player: print(*args, **kwargs)

class Nain:
    def __init__(self, id_):
        self.id = id_
        self._reset_values()
    def _ptvalues(self):
        self.pm = NB_POINTS_DEPLACEMENT
        self.pa = NB_POINTS_ACTION
    def _reset_values(self):
        self.x, self.y = position_taverne(moi())[::-1]
        self.pos = (self.y, self.x)
        self.pv = VIE_NAIN
        self.pm = NB_POINTS_DEPLACEMENT
        self.pa = NB_POINTS_ACTION
        self.accroche = False
        self.butin = 0
        self.chemin = []
        self.objectif = None
    def update(self):
        nain = info_nain(moi(), self.id)
        self.pos = nain.pos
        self.y, self.x = self.pos
        self.pv = nain.vie
        self.pm = nain.pm
        self.pa = nain.pa
        self.accroche = nain.accroche
        self.butin = nain.butin
        self.update_goal()
    def update_goal(self):
        self.chemin = find_chemin((self.x, self.y), self.objectif) if self.objectif else []
    def _update_pos(self):
        nain = info_nain(moi(), self.id)
        self.pos = nain.pos
        self.y, self.x = self.pos
    def update_pos(self, x, y):
        self.x = x
        self.y = y
        self.pos = (y, x)
    def accrocher(self):
        self.accroche = True
        agripper(self.id)
    def lacher(self):
        self.accroche = False
        lacher(self.id)
    def deplacer(self, step):
        # est possible
        if moi() == 1:
            assert self.pos == info_nain(moi(), self.id).pos, (self.pos, info_nain(moi(), self.id).pos)
        self.pm -= cout_de_deplacement(self.id, step)
        deplacer(self.id, step)
        self._update_pos()
    def goal(self, objectif):
        self.objectif = objectif
        self.chemin = find_chemin((self.x, self.y), objectif)
    def step(self):
        # 0: ne peut plus rien faire
        # 1: ne peut rien faire sans l'aide d'un autre nain
        # 2: a fait ce qu'on lui a demandé de faire
        if not self.chemin:
            return 0
        action, arg = self.chemin[0]
        self._update_pos()
        if action == "deplacer":
            if arg in {direction.GAUCHE, direction.DROITE}:
                dx, dy = dir2coords[arg]
                nx, ny = self.x+dx, self.y+dy
                if (len(self.chemin) == 1 or self.chemin[1][0] != "tomber") and not is_stable(nx, ny):
                    self.accrocher()
                elif (is_stable(self.x, self.y) and is_stable(nx, ny)) or (is_stable(self.x, self.y) and len(self.chemin) > 1 and self.chemin[1][0] == "tomber"):
                    self.lacher()
                else:
                    self.accrocher()
            else:
                self.accrocher()
            if cout_de_deplacement(self.id, arg) > self.pm:
                return 1
            self.deplacer(arg)
            self.chemin.pop(0)
            if is_stable(self.x, self.y):
                self.lacher()
        elif action == "tomber":
            self.lacher()
            self._update_pos()
            self.chemin.pop(0)
        elif action == "miner":
            if COUT_MINER > self.pa:
                return 1
            miner(self.id, arg)
            self._update_pos()
            self.chemin.pop(0)
        else:
            print("FATAL - this should not happend. Who knows what happens next...")
        return 2
    def endstep(self):
        self.accrocher()


def is_free(x, y):
    return type_case((y, x)) == case_type.LIBRE and nain_sur_case((y, x)) != adversaire()

def is_stable(x, y):
    return y == TAILLE_MINE - 1 or not is_free(x, y+1)

def is_not_et(x, y):
    return position_taverne(adversaire()) != (y, x)


def grav_dmg(dy):
    if dy <= 3:
        return 0
    else:
        return 2**(dy-4)
        
def fall(x, y, dy=0):
    while not is_stable(x, y+dy):
        dy += 1
    
    return (x, y+dy), grav_dmg(dy) if is_not_et(x, y+dy) else (VIE_NAIN + 1)

def compute_pac(resistance):
    if resistance == -1:
        return COUT_MINER
    else:
        return COUT_MINER * resistance

def compute_nain_resistance(pos):
    vie = 0
    for nain in (info_nain(adversaire(), id_) for id_ in range(6)):
        if nain.pos == pos:
            vie = max(vie, nain.vie)
    return math.ceil(vie/DEGAT_PIOCHE)

def extend_movements(x, y):
    moves = []
    # Bas
    if y < TAILLE_MINE - 1:
        go = True if is_not_et(x, y+1) else False
        if type_case((y+1, x)) == case_type.GRANITE:
            if corde_sur_case((y, x)):
                pmc = 1
            else:
                pmc = 2
            pac = compute_pac(info_minerai((y+1, x)).resistance)
        elif is_free(x, y+1):
            if corde_sur_case((y, x)):
                pmc = 1
            else:
                pmc = 2
            pac = 0
        elif nain_sur_case((y+1, x)) == adversaire():
            if corde_sur_case((y, x)):
                pmc = 1
            else:
                pmc = 2
            pac = COUT_MINER * compute_nain_resistance((y+1, x))
        else:
            go = False
        if go:
            moves.append((pac, pmc, (x, y+1)))
            if type_case((y+1, x)) == case_type.GRANITE:
                (nx, ny), dmg = fall(x, y+1, dy=1)
            else:
                (nx, ny), dmg = fall(x, y)
            if dmg == 0: moves.append((pac, 0, (nx, ny)))

    # Droite
    if x < TAILLE_MINE - 1:
        go = True if is_not_et(x+1, y) else False
        if is_stable(x, y) and is_stable(x+1, y):
            pmc = 1
        else:
            pmc = 2
        if type_case((y, x+1)) == case_type.GRANITE:
            pac = compute_pac(info_minerai((y, x+1)).resistance)
        elif is_free(x+1, y):
            pac = 0
        elif nain_sur_case((y, x+1)) == adversaire():
            pac = COUT_MINER * compute_nain_resistance((y+1, x))
        else:
            go = False
        if go:
            moves.append((pac, pmc, (x+1, y)))
            if not is_stable(x+1, y):
                (nx, ny), dmg = fall(x+1, y)
                if dmg == 0: moves.append((pac, 1, (x+1, y)))
                    
    # Gauche
    if x > 0:
        go = True if is_not_et(x-1, y) else False
        if is_stable(x, y) and is_stable(x-1, y):
            pmc = COUT_DEPLACEMENT
        else:
            pmc = COUT_ESCALADER
        if type_case((y, x-1)) == case_type.GRANITE:
            pac = compute_pac(info_minerai((y, x-1)).resistance)
        elif is_free(x-1, y):
            pac = 0
        elif nain_sur_case((y, x-1)) == adversaire():
            pac = COUT_MINER * compute_nain_resistance((y+1, x))
        else:
            go = False
        if go:
            moves.append((pac, pmc, (x-1, y)))
            if not is_stable(x-1, y):
                (nx, ny), dmg = fall(x-1, y)
                if dmg == 0: moves.append((pac, 1, (x-1, y)))

    # Haut
    if y > 0:
        go = True
        if corde_sur_case((y, x)) and corde_sur_case((y-1, x)):
            pmc = COUT_ESCALADER_CORDE
        else:
            pmc = COUT_ESCALADER
        if type_case((y-1, x)) == case_type.GRANITE:
            pac = compute_pac(info_minerai((y-1, x)).resistance)
        elif is_free(x, y-1):
            pac = 0
        elif nain_sur_case((y-1, x)) == adversaire():
            pac = COUT_MINER * compute_nain_resistance((y+1, x))
        else:
            go = False
        if go:
            moves.append((pac, pmc, (x, y-1)))
    return moves

def nturns(pacsof, pmcsof):
    return max(math.ceil(pacsof/NB_POINTS_ACTION), math.ceil(pmcsof/NB_POINTS_DEPLACEMENT))

def find_chemin(start, end):
    come_from = find_shortest_path(start, end)
    chemin = path2chemin(start, end, come_from)
    return chemin

def path2chemin(start, end, come_from):
    if start == (25, 22) and end == (1, 29): d = True
    else: d = False
    next_ = end
    chemin = []
    while next_ != start:
        n2 = come_from[next_]
        x, y = n2
        nx, ny = next_
        step_hor = {0: None, 1: direction.DROITE, -1: direction.GAUCHE}[nx - x]
        dy = ny - y
        dirs_ver = {-1: direction.HAUT, 1: direction.BAS}
        if step_hor:
            if dy:
                chemin.insert(0, ("tomber", None))
            chemin.insert(0, ("deplacer", step_hor))
            if type_case((ny, nx)) == case_type.GRANITE:
                chemin.insert(0, ("miner", step_hor))
        else:
            if dy == 1:
                if is_stable(nx, ny):
                    chemin.insert(0, ("tomber", None))
                else:
                    chemin.insert(0, ("deplacer", dirs_ver[dy]))
            elif dy == -1:
                chemin.insert(0, ("deplacer", dirs_ver[dy]))
            else:
                chemin.insert(0, ("tomber", None))
            if dy in {-1, 1}:
                if type_case((ny, nx))== case_type.GRANITE:
                    chemin.insert(0, ("miner", dirs_ver[dy]))
            else:
                if type_case((y+1, x)) == case_type.GRANITE:
                    chemin.insert(0, ("miner", dirs_ver[1]))
            
        next_ = n2
    return chemin

def compute_csof(start, now, come_from, pac_so_far, pmc_so_far):
    next_ = now
    pacsof = 0
    pmcsof = 0
    while next_ != start:
        pacsof += pac_so_far[next_]
        pmcsof += pmc_so_far[next_]
        next_ = come_from[next_]
    return pacsof, pmcsof

def find_shortest_path(start, end):
    done = [start]
    x, y = end
    pmc_so_far = {start: 0}
    pac_so_far = {start: 0}
    come_from = {start: start}
    boundary = queue.PriorityQueue()
    boundary.put_nowait((0, start))
    end_turns = float("inf")
    while not boundary.empty():
        next_ = boundary.get_nowait()[1]
        for move in extend_movements(*next_):
            dpac, dpmc, nmov = move
            pacsof, pmcsof = compute_csof(start, next_, come_from, pac_so_far, pmc_so_far)
            pacsof += dpac
            pmcsof += dpmc
            nb_turns = nturns(pacsof, pmcsof)
            if nmov in done:
                if nb_turns >= nturns(*compute_csof(start, nmov, come_from, pac_so_far, pmc_so_far)):
                    continue
            else:
                done.append(nmov)
            
            pmc_so_far[nmov] = dpmc
            pac_so_far[nmov] = dpac
            come_from[nmov] = next_
            if nmov == end:
                end_turns = min(end_turns, nturns(pacsof, pmcsof))
            elif nturns(pacsof, pmcsof) < end_turns:
                boundary.put_nowait((nturns(pacsof, pmcsof), nmov)) #  + manhatan_heuristic(nmov, end)
                #if len(boundary.queue) > MAXLEN:
                #    boundary.queue.pop(-1)
    return come_from
    
def update_map():
    global mapr, mapv
    mapr = []
    for x in range(TAILLE_MINE):
        mapr.append([])
        for y in range(TAILLE_MINE):
            mapr[-1].append(type_case((x, y)))
    mapv = [[0 for i in range(TAILLE_MINE)] for j in range(TAILLE_MINE)]
    for pos in liste_minerais():
        x, y = pos
        minerai = info_minerai(pos)
        drend = minerai.rendement / minerai.resistance
        mapv[x][y] = drend

def precompute_map():
    global mapv

def update_hist():
    need_mup = False
    need_nup = False
    for action in historique():
        nain = info_nain(adversaire(), action.id_nain)
        y, x = nain.pos
        if action.dir == direction.ERREUR_DIRECTION:
            continue
        dx, dy = dir2coords[action.dir]
        x += dx
        y += dy
        del dx, dy
        need_mup = False
        need_nup = False
        if action.atype == action_type.ACTION_MINER:
            # "miner" peut mettre à jour la map ou mettre à jour les nains
            if mapr[x][y] != case_type.LIBRE:
                need_mup |= True
            if nain_sur_case((y, x)) == moi():
                need_nup |= True
    if need_mup:
        update_map()
    if need_nup:
        update_nains()

def print_mapr(map_):
    for x in range(TAILLE_MINE):
        print("%2d" % x, end=" ")
        for y in range(TAILLE_MINE):
            if map_[x][y] == case_type.LIBRE:
                print("L", end="")
            elif map_[x][y] == case_type.GRANITE:
                print("G", end="")
            elif map_[x][y] == case_type.OBSIDIENNE:
                print("O", end="")
            else:
                print("R", end="")
        print()
    print()

def print_mapn(map_):
    for x in range(TAILLE_MINE):
        print("%2d" % x, end=" ")
        for y in range(TAILLE_MINE):
            if (x, y) in [nain.pos for nain in nains]:
                print("N", end="")
            elif map_[x][y] == case_type.LIBRE:
                print("L", end="")
            elif map_[x][y] == case_type.GRANITE:
                print("G", end="")
            elif map_[x][y] == case_type.OBSIDIENNE:
                print("O", end="")
            else:
                print("R", end="")
        print()
    print()
    
    
def print_mapv(map_):
    for x in range(TAILLE_MINE):
        print("%2d" % x, end=" ")
        for y in range(TAILLE_MINE):
            print("%5s" % map_[x][y],end="")
        print()
    print()

manhatan_heuristic = lambda a, b: (abs(a[0]-b[0])+abs(a[1]-b[1]))
# Fonction appelée au début de la partie.
def partie_init():
    global timeleft, TIMEPTURN, nains, dir2coords
    TIMEPTURN = 60
    nains = [Nain(nain) for nain in range(NB_NAINS)]
    timeleft = 60
    dir2coords = {
        direction.HAUT: (0, 1),
        direction.DROITE: (1, 0),
        direction.BAS: (0, -1),
        direction.GAUCHE: (-1, 0)
    }
    update_map()
def jouer_tour():
    global timeleft, nains, TIMEPTURN
    timeleft = TIMEPTURN
    #update_hist()
    update_map()
    debug(tour_actuel())
    for nain in nains:
        nain.update()
        res = nain.step()
        while res == 2:
            res = nain.step()
        if res == 0:
            if nain.butin >= 20:
                nain.goal(position_taverne(moi())[::-1])
            else:
                nain.goal(min(liste_minerais(), key=lambda minerai: manhatan_heuristic(nain.pos, minerai))[::-1])
        res = nain.step()
        while res == 2:
            res = nain.step()
        nain.endstep()

def partie_fin():
    pass


