// This file has been generated, if you wish to
// modify it in a permanent way, please refer
// to the script file : gen/generator_rust.rb

use api::{self,
// Types de cases
CaseType,
// Points cardinaux
Direction,
// Erreurs possibles
Erreur,
// Types d'actions
ActionType,
// Types de drapeaux de débug
DebugDrapeau,
};
use std::{mem, ptr, slice};
use std::os::raw::{c_float ,c_double, c_int, c_void};

#[repr(C)]
#[derive(Clone)]
pub struct Array<T> {
    pub ptr: *const T,
    pub len: usize,
}

pub trait ToAPI {
  type To;
  unsafe fn to_api(&self) -> Self::To;
}

pub trait ToFFI {
  type To;
  fn to_ffi(&self) -> Self::To;
}

impl<T: ToAPI + Clone> ToAPI for Array<T> {
  type To = Vec<T::To>;
  unsafe fn to_api(&self) -> Self::To {
    let vec;
    {
      let slice = slice::from_raw_parts(self.ptr, self.len);
      vec = slice.iter().map(|elem| elem.to_api()).collect();
    }
    free(self.ptr as _);
    vec
  }
}

impl<T: ToFFI> ToFFI for Vec<T> {
  type To = Array<T::To>;
  fn to_ffi(&self) -> Self::To {
    unsafe {
      let ptr: *mut T::To = malloc(self.len() * mem::size_of::<T::To>()) as _;
      let len = self.len();
      for i in 0..len {
        ptr::write(ptr.add(i), self[i].to_ffi());
      }
      Array { ptr, len }
    }
  }
}

impl ToAPI for () {
  type To = ();
  unsafe fn to_api(&self) -> Self::To { self.clone() }
}

impl ToFFI for () {
  type To = ();
  fn to_ffi(&self) -> Self::To { self.clone() }
}

impl ToAPI for c_int {
  type To = c_int;
  unsafe fn to_api(&self) -> Self::To { self.clone() }
}

impl ToFFI for c_int {
  type To = c_int;
  fn to_ffi(&self) -> Self::To { self.clone() }
}

impl ToAPI for c_float {
  type To = c_float;
  unsafe fn to_api(&self) -> Self::To { self.clone() }
}

impl ToFFI for c_float {
  type To = c_float;
  fn to_ffi(&self) -> Self::To { self.clone() }
}

impl ToAPI for c_double {
  type To = c_double;
  unsafe fn to_api(&self) -> Self::To { self.clone() }
}

impl ToFFI for c_double {
  type To = c_double;
  fn to_ffi(&self) -> Self::To { self.clone() }
}

impl ToAPI for bool {
  type To = bool;
  unsafe fn to_api(&self) -> Self::To { self.clone() }
}

impl ToFFI for bool {
  type To = bool;
  fn to_ffi(&self) -> Self::To { self.clone() }
}

impl ToAPI for *const char {
  type To = *const char;
  unsafe fn to_api(&self) -> Self::To { self.clone() }
}

impl ToFFI for *const char {
  type To = *const char;
  fn to_ffi(&self) -> Self::To { self.clone() }
}

// Types de cases
impl ToAPI for CaseType {
  type To = CaseType;
  unsafe fn to_api(&self) -> Self::To { self.clone() }
}

impl ToFFI for CaseType {
  type To = CaseType;
  fn to_ffi(&self) -> Self::To { self.clone() }
}


// Points cardinaux
impl ToAPI for Direction {
  type To = Direction;
  unsafe fn to_api(&self) -> Self::To { self.clone() }
}

impl ToFFI for Direction {
  type To = Direction;
  fn to_ffi(&self) -> Self::To { self.clone() }
}


// Erreurs possibles
impl ToAPI for Erreur {
  type To = Erreur;
  unsafe fn to_api(&self) -> Self::To { self.clone() }
}

impl ToFFI for Erreur {
  type To = Erreur;
  fn to_ffi(&self) -> Self::To { self.clone() }
}


// Types d'actions
impl ToAPI for ActionType {
  type To = ActionType;
  unsafe fn to_api(&self) -> Self::To { self.clone() }
}

impl ToFFI for ActionType {
  type To = ActionType;
  fn to_ffi(&self) -> Self::To { self.clone() }
}


// Types de drapeaux de débug
impl ToAPI for DebugDrapeau {
  type To = DebugDrapeau;
  unsafe fn to_api(&self) -> Self::To { self.clone() }
}

impl ToFFI for DebugDrapeau {
  type To = DebugDrapeau;
  fn to_ffi(&self) -> Self::To { self.clone() }
}


// Position sur la banquise, donnée par deux coordonnées.
#[repr(C)]
#[derive(Clone)]
pub struct Position {
  /// Coordonnée : ligne
  pub ligne: c_int,
  /// Coordonnée : colonne
  pub colonne: c_int,
}

impl ToAPI for Position {
  type To = api::Position;
  unsafe fn to_api(&self) -> Self::To {
    api::Position {
      ligne: self.ligne.to_api(),
      colonne: self.colonne.to_api(),
    }
  }
}

impl ToFFI for api::Position {
  type To = Position;
  fn to_ffi(&self) -> Self::To {
    Position {
      ligne: self.ligne.to_ffi(),
      colonne: self.colonne.to_ffi(),
    }
  }
}


// Alien à capturer durant la mission.
#[repr(C)]
#[derive(Clone)]
pub struct AlienInfo {
  /// Position de l'alien
  pub pos: Position,
  /// Nombre de points obtenus pour la capture de cet alien
  pub points_capture: c_int,
  /// Tour où l'alien débarque sur la banquise
  pub tour_invasion: c_int,
  /// Nombre de tours où l'alien reste sur la banquise
  pub duree_invasion: c_int,
  /// Nombre de tours de la capture en cours, l'alien est considéré comme capturé si la variable atteint NB_TOURS_CAPTURE
  pub capture_en_cours: c_int,
}

impl ToAPI for AlienInfo {
  type To = api::AlienInfo;
  unsafe fn to_api(&self) -> Self::To {
    api::AlienInfo {
      pos: self.pos.to_api(),
      points_capture: self.points_capture.to_api(),
      tour_invasion: self.tour_invasion.to_api(),
      duree_invasion: self.duree_invasion.to_api(),
      capture_en_cours: self.capture_en_cours.to_api(),
    }
  }
}

impl ToFFI for api::AlienInfo {
  type To = AlienInfo;
  fn to_ffi(&self) -> Self::To {
    AlienInfo {
      pos: self.pos.to_ffi(),
      points_capture: self.points_capture.to_ffi(),
      tour_invasion: self.tour_invasion.to_ffi(),
      duree_invasion: self.duree_invasion.to_ffi(),
      capture_en_cours: self.capture_en_cours.to_ffi(),
    }
  }
}


// Action de déplacement représentée dans l'historique.
#[repr(C)]
#[derive(Clone)]
pub struct ActionHist {
  /// Type de l'action
  pub atype: ActionType,
  /// Numéro de l'agent concerné par l'action
  pub id_agent: c_int,
  /// Direction visée par l'agent durant le déplacement
  pub dir: Direction,
}

impl ToAPI for ActionHist {
  type To = api::ActionHist;
  unsafe fn to_api(&self) -> Self::To {
    api::ActionHist {
      atype: self.atype.to_api(),
      id_agent: self.id_agent.to_api(),
      dir: self.dir.to_api(),
    }
  }
}

impl ToFFI for api::ActionHist {
  type To = ActionHist;
  fn to_ffi(&self) -> Self::To {
    ActionHist {
      atype: self.atype.to_ffi(),
      id_agent: self.id_agent.to_ffi(),
      dir: self.dir.to_ffi(),
    }
  }
}


extern {
fn malloc(size: usize) -> *mut c_void;

fn free(p: *mut c_void);

// Déplace l'agent ``id_agent`` d'une case dans la direction choisie.
pub fn deplacer(id_agent: c_int, dir: Direction) -> Erreur;

// Propulse l'agent ``id_agent`` dans la direction choisie jusqu'à ce qu'il heurte un obstacle, c'est-à-dire soit un mur soit un autre agent.
pub fn glisser(id_agent: c_int, dir: Direction) -> Erreur;

// L'agent ``id_agent`` pousse tout autre agent se trouvant sur la case adjacente dans la direction indiquée. Ce dernier est propulsé jusqu'à ce qu'il rencontre un obstacle, c'est-à-dire soit un mur soit un autre agent.
pub fn pousser(id_agent: c_int, dir: Direction) -> Erreur;

// Affiche le drapeau spécifié sur la case indiquée.
pub fn debug_afficher_drapeau(pos: Position, drapeau: DebugDrapeau) -> Erreur;

// Renvoie le nombre de points d'action de l'agent ``id_agent`` restants pour le tour. Si le numéro d'agent est invalide, la fonction renvoie -1.
pub fn points_action_agent(id_agent: c_int) -> c_int;

// Renvoie le plus court chemin entre deux positions de la banquise sous la forme d'une suite de direction à emprunter. Ce chemin ne contient pas de glissade, uniquement des déplacements simples. Si la position est invalide ou que le chemin n'existe pas, le chemin renvoyé est vide.
pub fn chemin(pos1: Position, pos2: Position) -> Array<Direction>;

// Renvoie le type d'une case donnée.
pub fn type_case(pos: Position) -> CaseType;

// Renvoie le numéro du joueur à qui appartient l'agent sur la case indiquée. Renvoie -1 s'il n'y a pas d'agent ou si la position est invalide.
pub fn agent_sur_case(pos: Position) -> c_int;

// Indique si un alien se trouve sur une case donnée. Renvoie vrai si l'alien est en train d'envahir la banquise et qu'il n'a pas encore été capturé. Renvoie faux autremement, ou si la position est invalide.
pub fn alien_sur_case(pos: Position) -> bool;

// Indique la position de l'agent sur la banquise désigné par le numéro ``id_agent`` appartenant au joueur ``id_joueur``. Si la description de l'agent est incorrecte, la position (-1, -1) est renvoyée.
pub fn position_agent(id_joueur: c_int, id_agent: c_int) -> Position;

// Renvoie la description d'un alien en fonction d'une position donnée. Si l'alien n'est pas présent sur la carte, ou si la position est invalide, tous les membres de la structure ``alien_info`` renvoyée sont initialisés à -1.
pub fn info_alien(pos: Position) -> AlienInfo;

// Renvoie la liste de tous les aliens présents durant la partie.
pub fn liste_aliens() -> Array<AlienInfo>;

// Renvoie la liste des actions effectuées par l’adversaire durant son tour, dans l'ordre chronologique. Les actions de débug n'apparaissent pas dans cette liste.
pub fn historique() -> Array<ActionHist>;

// Renvoie le score du joueur ``id_joueur``. Renvoie -1 si le joueur est invalide.
pub fn score(id_joueur: c_int) -> c_int;

// Renvoie votre numéro de joueur.
pub fn moi() -> c_int;

// Renvoie le numéro de joueur de votre adversaire.
pub fn adversaire() -> c_int;

// Annule la dernière action. Renvoie faux quand il n'y a pas d'action à annuler ce tour-ci.
pub fn annuler() -> bool;

// Retourne le numéro du tour actuel.
pub fn tour_actuel() -> c_int;

// Affiche le contenu d'une valeur de type case_type
pub fn afficher_case_type(v: CaseType);

// Affiche le contenu d'une valeur de type direction
pub fn afficher_direction(v: Direction);

// Affiche le contenu d'une valeur de type erreur
pub fn afficher_erreur(v: Erreur);

// Affiche le contenu d'une valeur de type action_type
pub fn afficher_action_type(v: ActionType);

// Affiche le contenu d'une valeur de type debug_drapeau
pub fn afficher_debug_drapeau(v: DebugDrapeau);

// Affiche le contenu d'une valeur de type position
pub fn afficher_position(v: Position);

// Affiche le contenu d'une valeur de type alien_info
pub fn afficher_alien_info(v: AlienInfo);

// Affiche le contenu d'une valeur de type action_hist
pub fn afficher_action_hist(v: ActionHist);

}
