/// This file has been generated, if you wish to
/// modify it in a permanent way, please refer
/// to the script file : gen/generator_cxx.rb

#include "prologin.hh"
#include <queue>
#include <iostream>
using namespace std;

/* L'outil principal de ce programme reside dans l'algorithme de Djikstra (qui utilise pour cela
la structure lp), notamment utilise pour trouver le nombre de points d'action minimal pour
atteindre un alien en particulier, et l'atteindre ou s'en approcher. Il renplit le contenaire
associe a un manchot qui contient la liste des actions a effectuer pour atteindre un alien,
et peut l'effectuer avec la fonction moveto.
L'algorithme regarde d'abord si l'agent peut atteindre un alien en 1 tour (dans la liste v[0])
puis en 2 tours (liste v[1]), etc.

Cas particuliers : si le manchot est en phase de capture il utilise la fonction defense qui lui
permet theoriquement a la fois de rester en mode "siege" et de repousser les ennemis adjacents.
En pratique cela ne semble pas fonctionner. Si un manchot voit qu'il peut atteindre puis pousser
un agent ennemi sur le point de capturer, il fera plutot que chercher un autre alien (par le biais
du vector lp attack, qui contient a la fois la position ou on doit se placer et la direction
dans laquelle pousser, on peut donc y appliquer Djikstra).

Ce que j'aurais aime faire : une meilleure offensive (empecher une capture en deux tours au lieu
d'un, mais cela suppose de ne pas abandonner le reste des aliens pour autant...)
Et une meilleure defensive (proteger un manchot avec un autre, mais la encore ca suppose de ne pas
laisser tomber le reste)
Une meilleure gestion du score alien (mon programme fait qu'un manchot se precipite sur un
alien des qu'il peut l'attraper sans se soucier des autres, en particulier de leur score) (seule
optimisation : interdiction formelle pour les agents de se placer sur une case alien de score
negatif)

*/


int t[25][25] = {};
position delta[4] = {{0, 1}, {1, 0}, {0, -1}, {-1, 0}};
vector<int> contenaire[4];
int reste[4] = {0};
position p1[4];
position p2[4];
position ps[4];
vector<position> v[20];

struct lp
{
    int pa;
    position pos;
    bool operator<(const lp& b) const {
        return b.pa < pa;
}
};

vector<lp> attack;

int type(position a)
{
    if (type_case(a) == LIBRE)
        return 0;
    return 1;
}

bool good(position a, position b) //pour verifier qu'une case est libre
{
    return (0 <= a.ligne + b.ligne &&
            25 > a.ligne + b.ligne &&
            0 <= a.colonne + b.colonne &&
            25 > a.colonne + b.colonne &&
            t[a.ligne + b.ligne][a.colonne + b.colonne] == 0);
}

bool good2(position a, position b) //pour verifier qu'une case est occupee par l'ennemi
{
    return (0 <= a.ligne + b.ligne &&
            25 > a.ligne + b.ligne &&
            0 <= a.colonne + b.colonne &&
            25 > a.colonne + b.colonne &&
            t[a.ligne + b.ligne][a.colonne + b.colonne] == 4);
}

bool good3(position a, position b, int bound) //pour Djikstra, on utilise le deuxieme cas quand on
{                                             //se moque qu'il y ait des ennemis sur le chemin
    if(bound <= 8)
        return good(a, b);
    return good(a, b) || good2(a, b);
}


position add(position a, position b) //ajouter deux positions
{
    return {a.ligne + b.ligne, a.colonne + b.colonne};
}
position poursuite(position a, int i, int bound) //pour glisser
{
    while(good3(a, delta[i], bound))
        a = add(a, delta[i]);
    return a;
}

void re() //pour reinitialiser les infos de la carte
{
    for(int k = 0; k < 25; k++)
        for(int j = 0; j < 25; j++)
            t[k][j] = type({k, j});
    for(int k = 0; k < 4; k++)
    {
        p1[k] = position_agent(moi(), k);
        p2[k] = position_agent(adversaire(), k);
        t[p1[k].ligne][p1[k].colonne] = 3;
        t[p2[k].ligne][p2[k].colonne] = 4;
    }
}

direction convertisseur(int i)
{
    if(i == 0)
        return EST;
    if(i == 1)
        return SUD;
    if(i == 2)
        return OUEST;
    return NORD;
}


bool djikstra(position a, position b, int bound, int manchot) //Djikstra lui-meme
{
    int k[25][25] = {};
    priority_queue<lp> ko;
    ko.push({0, a});
    lp dechet[25][25];
    contenaire[manchot].clear();
    vector<int>inverse;
    while(!ko.empty())
    {
        lp r = ko.top();
        ko.pop();
        for(int i = 0; i < 4; i++)
        {
            if(good3(r.pos, delta[i], bound) && k[r.pos.ligne + delta[i].ligne][r.pos.colonne + delta[i].colonne] == false && r.pa + 1 <= bound)
            {
                ko.push({r.pa + 1, add(r.pos, delta[i])});
                k[r.pos.ligne + delta[i].ligne][r.pos.colonne + delta[i].colonne] = true;
                dechet[r.pos.ligne + delta[i].ligne][r.pos.colonne + delta[i].colonne] = {i, r.pos};
            }
        }
        for(int i = 0; i < 4; i++)
        {
            position sol = poursuite(r.pos, i, bound);
            if(k[sol.ligne][sol.colonne] == false && r.pa + 3 <= bound)
            {
                ko.push({r.pa + 3, sol});
                k[sol.ligne][sol.colonne] = true;
                dechet[sol.ligne][sol.colonne] = {i + 4, r.pos};
            }
        }

        if(r.pos == b)
        {
            position temp = b;
            while(a != temp)
            {
                inverse.push_back(dechet[temp.ligne][temp.colonne].pa);
                temp = dechet[temp.ligne][temp.colonne].pos;
            }
            for(int i = int(inverse.size()) - 1; i >= 0; i--)
                contenaire[manchot].push_back(inverse[i]);
            return true;
        }
    }
    return false;
}

int moveto(int i) //fonction de deplacement
{
    for(int k = 0; k < min(8, int(contenaire[i].size())); k++)
    {
        if(contenaire[i][k] == 0)
            deplacer(i, EST);
        if(contenaire[i][k] == 1)
            deplacer(i, SUD);
        if(contenaire[i][k] == 2)
            deplacer(i, OUEST);
        if(contenaire[i][k] == 3)
            deplacer(i, NORD);
        if(contenaire[i][k] == 4)
            glisser(i, EST);
        if(contenaire[i][k] == 5)
            glisser(i, SUD);
        if(contenaire[i][k] == 6)
            glisser(i, OUEST);
        if(contenaire[i][k] == 7)
            glisser(i, NORD);
    }
    re();
    if(int(contenaire[i].size()) >= 8)
        return 10;
    return 1;
}

int defense(int i) //fonction pour les manchots en mode "siege"
{
    for(int k = 0; k < 4; k++)
        if(good2(p1[i], delta[k]))
            pousser(i, convertisseur(k));
    return (reste[i] + 1) % 4;
}

/// Fonction appelée au début de la partie.
void partie_init()
{
}

/// Fonction appelée à chaque tour.
void jouer_tour()
{
    int tour = tour_actuel(); //initialisation des infos de la carte
    for(int i = 0; i < 25; i++)
        for(int j = 0; j < 25; j++)
            t[i][j] = type({i, j});
    for(int i = 0; i < 4; i++)
    {
        p1[i] = position_agent(moi(), i);
        p2[i] = position_agent(adversaire(), i);
        t[p1[i].ligne][p1[i].colonne] = 3;
        t[p2[i].ligne][p2[i].colonne] = 4;
        if(reste[i] == 10)
            reste[i] = 0;
        else if(reste[i] != 0 && p1[i] == position_agent(moi(), i))
            reste[i] = defense(i);
        else if(p1[i] != position_agent(moi(), i))
            reste[i] = 0;
    }
    vector<alien_info> s = liste_aliens();
    attack.clear();
    for(int j = 0; j < 20; j++) //prise d'info sur les aliens, avec retardement sur les tours
    {
        v[j].clear();
        for(int i = 0; i < int(s.size()); i++)
            if(s[i].tour_invasion <= tour + j && s[i].tour_invasion + s[i].duree_invasion >= tour + 3 + j && s[i].capture_en_cours != 3 && s[i].points_capture > 0)
                v[j].push_back(s[i].pos);
    }
    for(int i = 0; i < int(s.size()); i++) //prise d'info sur les sieges ennemis en passe d'etre pris
        if(s[i].capture_en_cours == 2 && t[s[i].pos.ligne][s[i].pos.colonne] == 4)
            for(int j = 0; j < 4; j++)
                if(good(s[i].pos, delta[i])
                   && good(s[i].pos, add(delta[i], delta[i]))
                   && good(s[i].pos, delta[(i + 2) % 4]))
                    attack.push_back({i, add(s[i].pos, delta[(i + 2) % 4])});


    for(int k = 0; k < 20; k++)
    {
        for(int i = 0; i < 4; i++)
        {
            for(int j = 0; j < int(attack.size()); j++)
            {
                if(djikstra(p1[i], attack[j].pos, 3, i) && reste[i] == 0) //pour attaquer
                {
                    reste[i] = moveto(i);
                    pousser(i, convertisseur(attack[j].pa));
                    re();
                    break;
                }
            }
            for(int j = 0; j < int(v[k].size()); j++) //pour rejoindre ou s'approcher d'un alien
            {
                if(djikstra(p1[i], v[k][j], 8*(k+1), i) && reste[i] == 0)
                {
                    reste[i] = moveto(i);
                    break;
                }
            }
        }
    }
}

/// Fonction appelée à la fin de la partie.
void partie_fin()
{
}





















