#include "distance.hh"
#include "mouvement.hh"
#include "unites.hh"
#include <vector>
#include <iostream>
using namespace std;

extern position pneg;

unite trouverPerroquet(bool estEnnemi, const vector<unite> &lesUnites) {
  unite perroquet, u;
  for(int i = 0 ; i < (int) lesUnites.size() ; i++) {
    u = lesUnites[i];
    if(u.vrai_type_unite == PERROQUET && u.ennemi == estEnnemi)
      perroquet = u;
  }
  return perroquet;
}

void guerirPlusProche(position cible, vector<unite> &lesUnites) {
  unite u;
  position aSoigner = pneg;
  int dmin = calculerTaillePlateau();
  for(int i = 0 ; i < (int) lesUnites.size() ; i++) {
    u = lesUnites[i];
    if(!u.ennemi && u.ko >= 0 && dist(u.pos, cible) < dmin) {
      dmin = dist(u.pos, cible);
      aSoigner = u.pos;
    }
  }
  potion(aSoigner);
  lesUnites = unites();
}

void trouverCasesLibres(vector<vector<bool> > &estLibre, const vector<unite> lesUnites) {
  unite u;
  for(int y = 0 ; y < 19 ; y++) {
    vector<bool> v;
    estLibre.push_back(v);
    for(int x = 0 ; x < 19 ; x++)
      estLibre[y].push_back(true);
  }
  for(int i = 0 ; i < (int) lesUnites.size() ; i++) {
    u = lesUnites[i];
    estLibre[u.pos.y][u.pos.x] = false;
  }
}

void scinderUnites(vector<unite> &lesUnites, vector<unite> &mesUnites, vector<unite> &sesUnites) {
  unite u;
  for(int i = 0 ; i < (int) lesUnites.size() ; i++) {
    u = lesUnites[i];
    if(!u.ennemi)
      mesUnites.insert(mesUnites.begin(), u);
    else
      sesUnites.insert(sesUnites.begin(), u);
  }
}

void chercherKangourou() {
  
}
