///
// This file has been generated, if you wish to
// modify it in a permanent way, please refer
// to the script file : gen/generator_cxx.rb
//

#ifndef PROLOGIN_HH_
# define PROLOGIN_HH_

# include <vector>

///
// Taille de dpart du terrain.
//
# define TAILLE_DEPART             19

///
// Le nombre maximal d'units pouvant appartenir  une quipe.
//
# define NBR_MAX_UNITES            10

///
// Le temps, en nombre de tours, entre deux rtrcissement du terrain.
//
# define TEMPS_RETRECISSEMENT      5

///
// Le nombre maximum en jeu de chaque carte.
//
# define MAX_CARTES                2

///
// numration reprsentant une erreur renvoye par une des fonctions d'action.
//
typedef enum erreur {
  OK, /* <- aucune erreur n'est survenue */
  POSITION_INVALIDE, /* <- la position spcifie est invalide */
  CASE_OCCUPEE, /* <- la case sur laquelle vous tentez de vous dplacer est occupe */
  PAS_A_PORTEE, /* <- la cible n'est pas  porte */
  UNITE_KO, /* <- l'unit que vous essayez de faire agir ou sur laquelle vous essayez d'agir  est KO */
  UNITE_DEBOUT, /* <- l'unit que vous essayez de relever est dj debout */
  QUOTA_DEPASSE, /* <- nombre maximal d'unites, de spawn ou de relevages par tour dpass */
  PLUS_DE_PA, /* <- cette unit a ralis toutes ses actions */
  DEJA_ATTAQUE, /* <- cette unit a dj attaqu */
  UNITE_INTERDITE, /* <- cette unit ne peut pas tre amene en renfort */
  RENFORT_IMPOSSIBLE, /* <- une unit est dj prsente sur le spawn */
  PAS_A_MOI, /* <- l'unit cible n'est pas  vous */
  PLUS_DE_CARTES, /* <- il n'y a plus de cartes du type spcifi dans votre main */
  PHASE_CARTES_TERMINEE, /* <- vous ne pouvez plus poser de cartes car vous avez fait une action */
} erreur;


///
// Le type d'une unit sur le terrain
//
typedef enum type_unite {
  PERROQUET, /* <- 1 PA et porte de 1 */
  SINGE, /* <- 2 PA et porte de 3 */
  CHAT, /* <- 5 PA et porte de 1 */
  KANGOUROU, /* <- 3 PA et porte de 2 (explose !) */
} type_unite;


///
// Reprsente une position sur le terrain du jeu.
//
typedef struct position {
  int x;  /* <- coordonne X */
  int y;  /* <- coordonne Y */
} position;


///
// Contient les informations sur la taille du terrain du jeu.
//
typedef struct taille_terrain {
  int taille;  /* <- taille actuelle du terrain */
  int min_coord;  /* <- coordonne minimale en X ou en Y */
  int max_coord;  /* <- coordonne maximale en X ou en Y */
} taille_terrain;


///
// Donne les caractristiques d'un type d'unit.
//
typedef struct caracs {
  int pa_init;  /* <- nombre de points d'actions par tour */
  int portee;  /* <- porte maximale de l'unit */
} caracs;


///
// Reprsente une unit sur le terrain.
//
typedef struct unite {
  position pos;  /* <- la position de l'unit */
  bool ennemi;  /* <- vrai si l'unit appartient  l'ennemi */
  type_unite type_unite_actuel;  /* <- le type de l'unit, qui change si l'unit est dguise */
  type_unite vrai_type_unite;  /* <- le vrai type de l'unit (qui ne change pas lors du dguisement) */
  int ko;  /* <- une valeur ngative si l'unit n'est pas KO, sinon le nombre de marqueurs KO sur l'unit */
  int pa;  /* <- le nombre de PA restants  l'unit */
  int attaques;  /* <- le nombre d'attaques restants  l'unit */
  int attaques_gratuites;  /* <- le nombre d'attaques gratuites (voir la partie banzai) */
  int id;  /* <- l'identifiant unique de l'unit */
} unite;


///
// Reprsente l'ensemble des cartes que vous pouvez utiliser.
//
typedef struct cartes {
  int potion;  /* <- le nombre de cartes  Potion magique  */
  int deguisement;  /* <- le nombre de cartes  Dguisement  */
  int banzai;  /* <- le nombre de cartes  Banza  */
  int pacifisme;  /* <- le nombre de cartes  Pacifisme  */
} cartes;


///
// Renvoie le nombre de points de commandements.
//
extern "C" int api_nombre_pc();
static inline int nombre_pc()
{
  return api_nombre_pc();
}


///
// Renvoie le nombre d'units en jeu.
//
extern "C" int api_nombre_unites(bool ennemi);
static inline int nombre_unites(bool ennemi)
{
  return api_nombre_unites(ennemi);
}


///
// Renvoie le numro du tour actuel.
//
extern "C" int api_tour_actuel();
static inline int tour_actuel()
{
  return api_tour_actuel();
}


///
// Renvoie la position du spawn (ennemi ou non).
//
extern "C" position api_pos_renfort(bool ennemi);
static inline position pos_renfort(bool ennemi)
{
  return api_pos_renfort(ennemi);
}


///
// Renvoie les caractristiques d'un type d'unit.
//
extern "C" caracs api_caracteristiques(type_unite tu);
static inline caracs caracteristiques(type_unite tu)
{
  return api_caracteristiques(tu);
}


///
// Retourne une structure "cartes" contenant les informations sur les cartes que vous avez en main.
//
extern "C" cartes api_mes_cartes();
static inline cartes mes_cartes()
{
  return api_mes_cartes();
}


///
// Retourne la liste des units actuellement en jeu.
//
extern "C" std::vector<unite> api_unites();
static inline std::vector<unite> unites()
{
  return api_unites();
}


///
// Retourne la taille actuelle du terrain et les coordonnes min/max dans une structure "taille_terrain".
//
extern "C" taille_terrain api_taille_terrain_actuelle();
static inline taille_terrain taille_terrain_actuelle()
{
  return api_taille_terrain_actuelle();
}


///
// Utilise une carte  Potion magique  que vous avez dans votre main.
//
extern "C" erreur api_potion(position cible);
static inline erreur potion(position cible)
{
  return api_potion(cible);
}


///
// Utilise une carte  Dguisement  que vous avez dans votre main.
//
extern "C" erreur api_deguisement(position cible, type_unite nouveau_type);
static inline erreur deguisement(position cible, type_unite nouveau_type)
{
  return api_deguisement(cible, nouveau_type);
}


///
// Utilise une carte  Banza  que vous avez dans votre main.
//
extern "C" erreur api_banzai(position cible);
static inline erreur banzai(position cible)
{
  return api_banzai(cible);
}


///
// Utilise une carte  Pacifisme  que vous avez dans votre main.
//
extern "C" erreur api_pacifisme();
static inline erreur pacifisme()
{
  return api_pacifisme();
}


///
// Dplace une unit vers une position  porte.
//
extern "C" erreur api_deplacer(position cible, position pos);
static inline erreur deplacer(position cible, position pos)
{
  return api_deplacer(cible, pos);
}


///
// Relve une unit n'ayant plus de marqueurs de KO.
//
extern "C" erreur api_relever(position cible);
static inline erreur relever(position cible)
{
  return api_relever(cible);
}


///
// Attaque une autre unit.
//
extern "C" erreur api_attaquer(position attaquant, position cible);
static inline erreur attaquer(position attaquant, position cible)
{
  return api_attaquer(attaquant, cible);
}


///
// Fait apparaitre une unit sur la case de spawn.
//
extern "C" erreur api_renfort(type_unite quoi);
static inline erreur renfort(type_unite quoi)
{
  return api_renfort(quoi);
}


///
// Annule l'effet de la dernire action et remet le jeu dans l'tat prcdent. Renvoie false s'il n'y a rien  annuler, true sinon.
//
extern "C" bool api_annuler();
static inline bool annuler()
{
  return api_annuler();
}


///
// Affiche le contenu d'une valeur de type erreur
//
extern "C" void api_afficher_erreur(erreur v);
static inline void afficher_erreur(erreur v)
{
  api_afficher_erreur(v);
}


///
// Affiche le contenu d'une valeur de type type_unite
//
extern "C" void api_afficher_type_unite(type_unite v);
static inline void afficher_type_unite(type_unite v)
{
  api_afficher_type_unite(v);
}


///
// Affiche le contenu d'une valeur de type position
//
extern "C" void api_afficher_position(position v);
static inline void afficher_position(position v)
{
  api_afficher_position(v);
}


///
// Affiche le contenu d'une valeur de type taille_terrain
//
extern "C" void api_afficher_taille_terrain(taille_terrain v);
static inline void afficher_taille_terrain(taille_terrain v)
{
  api_afficher_taille_terrain(v);
}


///
// Affiche le contenu d'une valeur de type caracs
//
extern "C" void api_afficher_caracs(caracs v);
static inline void afficher_caracs(caracs v)
{
  api_afficher_caracs(v);
}


///
// Affiche le contenu d'une valeur de type unite
//
extern "C" void api_afficher_unite(unite v);
static inline void afficher_unite(unite v)
{
  api_afficher_unite(v);
}


///
// Affiche le contenu d'une valeur de type cartes
//
extern "C" void api_afficher_cartes(cartes v);
static inline void afficher_cartes(cartes v)
{
  api_afficher_cartes(v);
}



extern "C" {

///
// Fonction appelle au dbut de la partie.
//
void init_game();

///
// Fonction appelle pour la phase de retrait de KO.
//
position retirer_ko();

///
// Fonction appelle pour la phase de jeu.
//
void jouer();

///
// Fonction appelle  la fin de la partie.
//
void end_game();

}
#endif
