#include "distance.hh"
#include <iostream>
#include <cmath>
using namespace std;

int abs(int n) {
  if(n < 0)
    return -n;
  else
    return n;
}

int dist(const position &p1, const position &p2) {
  return max(abs(p1.x - p2.x), abs(p1.y - p2.y));
}

void afficherPos(const position &p) {
  cout << "(" << p.x << ", " << p.y << ")" << endl;
}

position operator+(const position &p1, const position &p2) {
  position p3;
  p3.x = p1.x + p2.x;
  p3.y = p1.y + p2.y;
  return p3;
}

bool operator==(const position &p1, const position &p2) {
  return p1.x == p2.x && p1.y == p2.y;
}

bool operator!=(const position &p1, const position &p2) {
  return (p1.x != p2.x) || (p1.y != p2.y);
}
