#include "attaque.hh"
#include "distance.hh"
#include <vector>
#include <iostream>
using namespace std;

void viderAcc(int *****valeur) {
  for(int i = 0 ; i < 20 ; i++)
    for(int j = 0 ; j < 20 ; j++)
      for(int k = 0 ; k < 20 ; k++)
	for(int l = 0 ; l < 20 ; l++)
	  for(int m = ATTAQUER ; m <= DEPLACER ; m++)
	    valeur[i][j][k][l][m] = 0;
}

void ajouterValeur(int v, actionPossible action, vector<actionPossible> &actions, int *****valeur) {
  if(obtenirValeur(action, valeur) == 0)
    actions.insert(actions.end(), action);
  valeur[action.acteur.x][action.acteur.y][action.cible.x][action.cible.y][action.type] += v;
  cout << "L'action (" << action.acteur.x << ", " << action.acteur.y << ") " << phrase(action.type) << " (" << action.cible.x << ", " << action.cible.y << ") " << "+=" << v << "=" << obtenirValeur(action, valeur) << endl;
}

int obtenirValeur(actionPossible action, int *****valeur) {
  return valeur[action.acteur.x][action.acteur.y][action.cible.x][action.cible.y][action.type];
}

bool enDanger(position posCible, bool parEnnemi, bool justeUn, const vector<unite> &lesUnites, vector<unite> &attaquants) {
  unite u;
  caracs c;
  cartes mesCartes = mes_cartes();
  int d, dmax, nbExemplaires = (parEnnemi) ? 2 : 0;
  bool aBanzai = (mesCartes.banzai != nbExemplaires);
  bool aDeguisement = (mesCartes.deguisement != nbExemplaires);
  attaquants.clear();
  for(int i = 0 ; i < (int) lesUnites.size() ; i++) {
    u = lesUnites[i];
    d = dist(u.pos, posCible);
    if(u.ennemi == parEnnemi && u.ko < 0 && (u.ennemi || (u.pa > 0 && u.attaques > 0)) && d <= 6) {
      c = caracteristiques(u.vrai_type_unite);
      if(aDeguisement)
	c = caracteristiques(CHAT); // Il peut se dguiser en chat !
      if(u.ennemi)
	dmax = c.pa_init - 1 + c.portee;
      else
	dmax = u.pa - 1 + c.portee;
      if(aBanzai)
	dmax++; // Il peut partir d'une case plus loin
      if(d <= dmax) { // En danger !
	attaquants.insert(attaquants.end(), u);
	if(justeUn)
	  return true;
      }
    }
  }
  return !attaquants.empty();
}

bool comboMortelPossible(position perroquetAdverse, bool parEnnemi, const vector<unite> &lesUnites, unite &attaquantKO) {
  unite u;
  caracs c;
  cartes mesCartes = mes_cartes();
  int d, dmax, nbExemplaires = (parEnnemi) ? 2 : 0;
  bool aBanzai = (mesCartes.banzai != nbExemplaires);
  bool aDeguisement = (mesCartes.deguisement != nbExemplaires);
  bool aPotion = (mesCartes.potion != nbExemplaires);
  if(aBanzai) // S'il a banzai
    for(int i = 0 ; i < (int) lesUnites.size() ; i++) {
      u = lesUnites[i];
      d = dist(u.pos, perroquetAdverse);
      if(u.ennemi == parEnnemi && u.ko >= 0 && d <= 3) {
	c = caracteristiques(u.vrai_type_unite);
	if(aDeguisement)
	  c = caracteristiques(SINGE); // Il peut se dguiser en singe !
	dmax = c.portee;
	if((aPotion || u.ko == 0) && d <= dmax) { // En danger !
	  attaquantKO = u;
	  return true;
	}
      }
    }
  return false;
}

string phrase(type_action type) {
  switch(type) {
  case ATTAQUER: return "attaque"; break;
  case RELEVER: return "est relev"; break;
  default: return "se dplace vers"; break;
  }
}
