#include "attaque.hh"
#include "distance.hh"
#include "mouvement.hh"
#include "unites.hh"
#include <vector>
#include <iostream>
using namespace std;

position pneg;

void initpneg() {
  pneg.x = -1;
  pneg.y = -1;
}

position positionVers(position cible, position acteur, type_unite type, const vector<unite> &lesUnites) {
  cout << "-- positionVers " << cible.x << " " << cible.y << " --" << endl;
  caracs c = caracteristiques(type);
  position p, pPlusProche = pneg;
  int dmin = calculerTaillePlateau();
  vector<vector<bool> > estLibre;
  trouverCasesLibres(estLibre, lesUnites);
  for(int lig = -c.pa_init ; lig <= c.pa_init ; lig++)
    for(int col = -c.pa_init ; col <= c.pa_init ; col++) {
      p.x = acteur.x + col;
      p.y = acteur.y + lig;
      if(estSurInterieur(p) && estLibre[p.y][p.x] && dist(p, cible) < dmin) {
	dmin = dist(p, cible);
	pPlusProche = p;
      }
    }
  return pPlusProche;
}

void degagerCaseDApparition(position perroquet, position perroquetAdverse, const vector<unite> &lesUnites) {
  position caseDApparition = pos_renfort(false), cible;
  for(int i = 0 ; i < (int) lesUnites.size() ; i++) {
    unite u = lesUnites[i];
    if(u.pos == caseDApparition) {
      if(u.vrai_type_unite == SINGE)
	cible = positionVers(perroquet, u.pos, u.type_unite_actuel, lesUnites);
      else
	cible = positionVers(perroquetAdverse, u.pos, u.type_unite_actuel, lesUnites);
      if(cible != pneg) {
	afficherPos(cible);
	deplacer(u.pos, cible);
      }
      return;
    }
  }
}

int calculerTaillePlateau() {
  taille_terrain t = taille_terrain_actuelle();
  return t.max_coord - t.min_coord + 1;
}

bool estSurTerrain(position p) {
  taille_terrain t = taille_terrain_actuelle();
  return p.x >= t.min_coord && p.x <= t.max_coord && p.y >= t.min_coord && p.y <= t.max_coord;
}

bool estSurFrontiere(position p) {
  taille_terrain t = taille_terrain_actuelle();
  return p.x == t.min_coord || p.x == t.max_coord || p.y == t.min_coord || p.y == t.max_coord;
}

bool estSurInterieur(position p) {
  return estSurTerrain(p) && (calculerTaillePlateau() == 1 || !estSurFrontiere(p));
}

bool estSecurisee(position p, const vector<unite> &unites, vector<unite> &attaquants) {
  return estSurInterieur(p) && !enDanger(p, true, true, unites, attaquants);
}

position calculerPositionFinale(unite &attaquant, position &perroquetAdverse, const vector<unite> &lesUnites) {
  caracs c = caracteristiques(attaquant.type_unite_actuel);
  position p;
  int dmax = c.pa_init - 1 + c.portee;
  if(attaquant.attaques_gratuites > 0)
    dmax++;
  vector<vector<bool> > estLibre;
  trouverCasesLibres(estLibre, lesUnites);
  for(int lig = -c.portee ; lig <= c.portee ; lig++) {
    for(int col = -c.portee ; col <= c.portee ; col++) {
      p.x = perroquetAdverse.x + col;
      p.y = perroquetAdverse.y + lig;
      if(estSurTerrain(p) && estLibre[p.y][p.x] && dist(attaquant.pos, p) <= dmax) {
	return p;
      }
    }
  }
  return pneg;
}

position chercherBunker(int rayon, const unite &perroquet, const vector<unite> &lesUnites) {
  position posBunker = pneg, p;
  vector<unite> attaquants;
  for(int lig = -rayon ; lig <= rayon ; lig++) {
    for(int col = -rayon ; col <= rayon ; col++) {
      p.x = perroquet.pos.x + col;
      p.y = perroquet.pos.y + lig;
      if(posBunker.x == -1 && estSecurisee(p, lesUnites, attaquants))
	posBunker = p;
    }
  }
  return posBunker;
}
