///
// This file has been generated, if you wish to
// modify it in a permanent way, please refer
// to the script file : gen/generator_cxx.rb
//

#include "prologin.hh"
#include <iostream>
#include <cstdio>
#include <cstdlib>
#include <ctime>
#include <vector>
#include <queue>
using namespace std;

#define NB_DIRS 4
#define NB_DIRS2 8
#define DISTANCE_ATTEIGNABLE 4

typedef struct position position;
struct position {
  position(int xx = 0, int yy = 0) {
    x = xx;
    y = yy;
  }
  int x;
  int y;
};

position dirs[NB_DIRS] = {position(0, -1), position(1, 0), position(0, 1), position(-1, 0)};
position dirs2[NB_DIRS2] = {position(0, -1), position(1, -1), position(1, 0), position(1, 1), position(0, 1), position(-1, 1), position(-1, 0), position(-1, -1)};

vector<position> routesPossibles, maisonsPossibles;
vector<position>::iterator it;
int dejaVu[TAILLE_CARTE][TAILLE_CARTE];
int benefices[TAILLE_CARTE][TAILLE_CARTE];
int nombreDeMaisonsAutour[TAILLE_CARTE][TAILLE_CARTE];
position meilleurCoup;

void afficherListe() {
  for(it = routesPossibles.begin() ; it < routesPossibles.end() ; it++)
    printf("%d %d\n", it->x, it->y);
}

int routeAutour(int x, int y) {
  for(int dir = 0 ; dir < NB_DIRS2 ; dir++)
    if(type_case(x + dirs2[dir].x, y + dirs2[dir].y) == ROUTE)
      return 1;
  return 0;
}

int max(int a, int b) {
  return (a > b) ? a : b;
}
int min(int a, int b) {
  return (a < b) ? a : b;
}

int distanceAuReseauRoutier(int x, int y) {
  int x2 = x, y2 = y, x3, y3, distance = 0;
  int dejaVu2[TAILLE_CARTE][TAILLE_CARTE];
  position separateur = position(-1, -1);
  queue<position> cases;
  for(int i = 0 ; i < TAILLE_CARTE ; i++)
    for(int j = 0 ; j < TAILLE_CARTE ; j++)
      dejaVu2[j][i] = 0;
  cases.push(position(x, y));
  cases.push(separateur);
  dejaVu2[x][y] = 1;
  while(type_case(x2, y2) != ROUTE) {
    cases.pop();
    for(int dir = 0 ; dir < NB_DIRS ; dir++) {
      x3 = x2 + dirs[dir].x;
      y3 = y2 + dirs[dir].y;
      if(dejaVu2[x3][y3] == 0 && type_case(x3, y3) == VIDE || type_case(x3, y3) == ROUTE) {
	dejaVu2[x3][y3] = 1;
	cases.push(position(x3, y3));
      }
    }
    x2 = cases.front().x;
    y2 = cases.front().y;
    if(x2 == -1) {
      cases.push(separateur);
      distance++;
    }
  }
  return distance;
}

///
// Fonction appelee au debut de la partie
//
void init_game()
{
  srand(time(NULL));
}

///
// Fonction appelee a la fin de la partie
//
void end_game()
{
  printf("Scores finaux : %d %d %d\n", score(0), score(1), score(2));
}

///
// Fonction appelee a chaque phase de jeu
//
void jouer()
{
  printf("J'espre que cette somme de %d rouble(s) suffira  corrompre un maximum de personnes...\n", finances(0));
  printf("Aux dernires enchres : %d %d %d\n", montant_encheres(0), montant_encheres(1), montant_encheres(2));
  int r, valeurMax, valeurMaxSansRoute, x2, y2, atteignable;
  position meilleurCoup, meilleurCoupSansRoute, meilleureRoute;
  for(int tour = 0 ; tour < 2 ; tour++) {
    valeurMax = -1;
    valeurMaxSansRoute = -1;
    atteignable = 0;
    for(int x = 0 ; x < TAILLE_CARTE ; x++)
      for(int y = 0 ; y < TAILLE_CARTE ; y++)
	dejaVu[x][y] = 0;
    for(int x = 0 ; x < TAILLE_CARTE ; x++)
      for(int y = 0 ; y < TAILLE_CARTE ; y++) {
	if(type_case(x, y) == MAISON && appartenance(x, y) == 0) {
	  for(int dir = 0 ; dir < NB_DIRS2 ; dir++) {
	    x2 = x + dirs2[dir].x;
	    y2 = y + dirs2[dir].y;
	    if(type_case(x2, y2) == VIDE && distanceAuReseauRoutier(x2, y2) <= DISTANCE_ATTEIGNABLE) {
	      atteignable = 1;
	      break;
	    }
	    if(atteignable == 0)
	      vendre_maison(x, y); // Quasi-inatteignable
	  }
	}
	if(route_possible(x, y) == SUCCES) {
	  for(int dir = 0 ; dir < NB_DIRS2 ; dir++) {
	    x2 = x + dirs2[dir].x;
	    y2 = y + dirs2[dir].y;
	    if(x2 >= 0 && x2 < TAILLE_CARTE && y2 >= 0 && y2 < TAILLE_CARTE && dejaVu[x2][y2] == 0 && type_case(x2, y2) == VIDE && valeur_case(x2, y2) > valeurMax) { // Route la plus utile
	      dejaVu[x2][y2] = 1;
	      valeurMax = valeur_case(x2, y2);
	      meilleurCoup = position(x2, y2);
	      meilleureRoute = position(x, y);
	    }
	  }
	}
	if(construction_possible(x, y) == SUCCES && valeur_case(x, y) > valeurMaxSansRoute) { // Maison utile, sans construction de route
	  valeurMaxSansRoute = valeur_case(x, y);
	  meilleurCoupSansRoute = position(x, y);
	}
      }
    if(valeurMax > valeurMaxSansRoute) // Il est prfrable de construire une route
      construire_maison(meilleurCoup.x, meilleurCoup.y);
    else
      construire_maison(meilleurCoupSansRoute.x, meilleurCoupSansRoute.y);
    construire_route(meilleureRoute.x, meilleureRoute.y);
  }
}

///
// Fonction appelee a chaque phase d'enchere
//
void enchere()
{
  int portee = portee_monument(monument_en_cours()), prestige = prestige_monument(monument_en_cours()), benefice, beneficeMax = 0;
  for(int x = 0 ; x < TAILLE_CARTE ; x++)
    for(int y = 0 ; y < TAILLE_CARTE ; y++) {
      nombreDeMaisonsAutour[x][y] = 0;
      benefices[x][y] = 0;
    }
  for(int x = 0 ; x < TAILLE_CARTE ; x++)
    for(int y = 0 ; y < TAILLE_CARTE ; y++)
      if(prestige > 0) {
	if(type_case(x, y) == MAISON && appartenance(x, y) == 0)
	  for(int x2 = x - portee ; x2 <= x + portee ; x2++)
	    for(int y2 = y - portee ; y2 <= y + portee ; y2++)
	      if(x2 >= 0 && x2 < TAILLE_CARTE && y2 >= 0 && y2 < TAILLE_CARTE && (x != x2 || y != y2) && type_case(x2, y2) != ROUTE && type_case(x2, y2) != MONUMENT && type_case(x2, y2) != RESERVATION && routeAutour(x2, y2)) {
		benefices[x2][y2] += prestige;
		benefice = benefices[x2][y2];
		if(type_case(x2, y2) == MAISON) {
		  if(appartenance(x2, y2) == 0) // Vente / destruction
		    benefice++;
		  else // Destruction
		    benefice -= valeur_case(x2, y2) - 1;
		}
		if(benefice > beneficeMax) {
		  beneficeMax = benefice;
		  meilleurCoup = position(x2, y2);
		}
	      }
      } else { // Prestige ngatif
	if(type_case(x, y) == MAISON)
	  for(int x2 = x - portee ; x2 <= x + portee ; x2++)
	    for(int y2 = y - portee ; y2 <= y + portee ; y2++)
	      if(x2 >= 0 && x2 < TAILLE_CARTE && y2 >= 0 && y2 < TAILLE_CARTE && (x != x2 || y != y2) && type_case(x2, y2) != ROUTE && type_case(x2, y2) != MONUMENT && type_case(x2, y2) != RESERVATION && routeAutour(x2, y2)) {
		if(appartenance(x, y) == 0)
		  benefices[x2][y2] -= valeur_case(x, y) - 1; // Vente / destruction des maisons  proximit
		else
		  benefices[x2][y2] -= prestige; // Baisse de valeur des maisons adverses
		benefice = benefices[x2][y2];
		if(type_case(x2, y2) == MAISON) {
		  if(appartenance(x2, y2) == 0) // Vente / destruction
		    benefice++;
		  else
		    benefice -= valeur_case(x2, y2) - 1; // Destruction
		}
		if(benefice > beneficeMax) {
		  beneficeMax = benefice;
		  meilleurCoup = position(x2, y2);
		}
	      }
      }
  encherir(min(max(finances(1), finances(2)), min(beneficeMax - 1, finances(0))));
}

///
// Fonction appelee a chaque phase de placement de monument
//
void placement()
{
  int portee = portee_monument(monument_en_cours()), prestige = prestige_monument(monument_en_cours()), x = meilleurCoup.x, y = meilleurCoup.y;
  if(type_case(x, y) == MAISON) {
    if(appartenance(x, y) == 0)
      vendre_maison(x, y);
    detruire_maison(x, y);
  }
  if(prestige < 0) {
    for(int x2 = x - portee ; x2 <= x + portee ; x2++)
      for(int y2 = y - portee ; y2 <= y + portee ; y2++)
	if(x2 >= 0 && x2 < TAILLE_CARTE && y2 >= 0 && y2 < TAILLE_CARTE && type_case(x2, y2) == MAISON && appartenance(x2, y2) == 0) {
	  vendre_maison(x, y);
	  detruire_maison(x, y);
	}
  }
  construire_monument(x, y);
}
