module Prologin where

-- Renvoy par cout_achat_maison lorsque vous ne pouvez plus construire de maison pour le tour en cours.
_INFINI = 30000

-- Les coordonnes (x,y) avec lesquelles vous avez appel une fonction sont hors des bornes du terrain.
_HORS_TERRAIN = -12

-- Il n'y a pas de maison  la case indique.
_PAS_DE_MAISON = -2

-- Il n'y a pas de monument  la case indique.
_PAS_DE_MONUMENT = -3

-- Vous voulez dpenser plus d'argent que vous n'en n'avez.
_FINANCES_DEPASSEES = -4

-- Un blocage intervient lorsqu'aucune route n'est accessible depuis l'extrieur du jeu. Ce code d'erreur indique que le jeu serait bloqu si vous construisiez une maison ou un monument en (x,y) (ou si vous faisiez une rservation).
_BLOCAGE = -5

-- Le numro de joueur donn est incorrect.
_JOUEUR_INCORRECT = -7

-- La case indique n'est pas adjacente  une route (pour la 4-connexit si vous voulez construire une route, et pour la 8-connexit si vous voulez construire un btiment).
_NON_CONNEXE = -8

-- La case indique est dj occupe.
_CASE_OCCUPEE = -9

-- Ce n'est pas votre tour, ou l'action demande est interdite.
_ACTION_INTERDITE = -10

-- La distance demande est strictement suprieure  MAX_DISTANCE.
_TROP_LOIN = 50

-- L'action s'est droule avec succs.
_SUCCES = 0

-- La case (ou le btiment) est possde par la mairie.
_MAIRIE = 3

-- Case de terrain vide.
_VIDE = 0

-- Case de terrain qui contient une maison.
_MAISON = 1

-- Case de terrain rserve.
_RESERVATION = 2

-- Case de terrain qui contient un monument.
_MONUMENT = 3

-- Case de terrain qui contient une route.
_ROUTE = 4

-- Nombre de monuments qui seront mis aux enchres au cours de la partie.
_MAX_MONUMENTS = 14

-- La taille de la carte, en hauteur et en largeur.
_TAILLE_CARTE = 100

-- Distance maximale qui peut tre calcule.
_MAX_DISTANCE = 12

-- La somme d'argent possde par les champions au dbut du jeu.
_ARGENT_INITIAL = 10

-- Renvoie le type de la case, VIDE, MAISON, ROUTE, MONUMENT ou RESERVATION.
foreign import ccall type_case :: Int -> Int -> IO Int

-- Renvoie la valeur de la case, c'est--dire la somme des prestiges des monuments qui ont cette case dans leur porte. Cette valeur peut tre ngative.
foreign import ccall valeur_case :: Int -> Int -> IO Int

-- Renvoie l'entit possdant la case, 0, 1 ou 2 si la case est une maison, et MAIRIE sinon.
foreign import ccall appartenance :: Int -> Int -> IO Int

-- Renvoie le numro d'un monument sur une case donne, ou PAS_DE_MONUMENT.
foreign import ccall type_monument :: Int -> Int -> IO Int

-- Renvoie la porte d'un monument.
foreign import ccall portee_monument :: Int -> IO Int

-- Renvoie le prestige d'un monument
foreign import ccall prestige_monument :: Int -> IO Int

-- Renvoie le numro du tour
foreign import ccall numero_tour :: IO Int

-- Numro du joueur qui commence lors de la phase 1. Si cette fonction est appele pendant une phase 2 ou 3, renvoie le numro du joueur qui commencera lors de la phase 1 du tour suivant.
foreign import ccall commence :: IO Int

-- Donne le montant de la dernire enchre effectue par un joueur. Renvoie 0 au premier tour.
foreign import ccall montant_encheres :: Int -> IO Int

-- Donne le numro du joueur ayant gagn la dernire enchre. Renvoie 0 au premier tour.
foreign import ccall vainqueur_encheres :: IO Int

-- Donne le score d'un joueur.
foreign import ccall score :: Int -> IO Int

-- Donne l'argent possd par un joueur
foreign import ccall finances :: Int -> IO Int

-- Donne le numro du monument le plus rcemment mis aux enchres. Renvoie PAS_DE_MONUMENT lors de la phase 1 du premier tour.
foreign import ccall monument_en_cours :: IO Int

-- Renvoie la distance minimale pour aller de (x1,y1)  (x2,y2) (sachant qu'un dplacement en bas,  gauche, en haut ou  droite cote pour 1, et que les dplacements en diagonal ne sont pas autoriss). Lors du calcul de cette distance, seules les cases vides, les cases contenant une route, et les cases tant rserve par votre champion sont considres comme franchissables. Si le rsultat est suprieur strictement  MAX_DISTANCE, la fonction renvoie TROP_LOIN. Cette fonction ne fait aucun calcul, elle renvoie immdiatement.
foreign import ccall distance :: Int -> Int -> Int -> Int -> IO Int

-- Indique si vous pouvez construire une route en (x,y). Si non, renvoie HORS_TERRAIN, CASE_OCCUPEE ou NON_CONNEXE.
foreign import ccall route_possible :: Int -> Int -> IO Int

-- Indique si vous pouvez construire une maison ou un monument en (x,y). Si non, renvoie HORS_TERRAIN, CASE_OCCUPEE, BLOCAGE ou NON_CONNEXE.
foreign import ccall construction_possible :: Int -> Int -> IO Int

-- Renvoie le cot d'achat d'une maison (ou INFINI si vous ne pouvez plus en construire pour ce tour), en fonction de ce que vous avez dj construit (et dpens) lors de votre phase de jeu.
foreign import ccall cout_achat_maison :: IO Int

-- Renvoie le cot d'achat d'une route, en fonction de ce que vous avez dj construit (et dpens) lors de votre phase de jeu.
foreign import ccall cout_achat_route :: IO Int

-- Indique si votre champion doit jouer ou non. Si cette fonction renvoie false, votre champion ne pourra effectuer aucune action. Vous devriez toujours commencer vos fonctions jouer, enchere et placement par \texttt{if (mon_tour() == false) return;}.
foreign import ccall mon_tour :: IO Bool

-- Construit si possible une route en (x,y). Si impossible, renvoie ACTION_INTERDITE, FINANCES_DEPASSEES, NON_CONNEXE ou CASE_OCCUPEE.
foreign import ccall construire_route :: Int -> Int -> IO Int

-- Construit si possible une maison en (x,y). Si impossible, renvoie ACTION_INTERDITE, FINANCES_DEPASSEES, NON_CONNEXE, BLOCAGE ou CASE_OCCUPEE.
foreign import ccall construire_maison :: Int -> Int -> IO Int

-- Rserve la case (x,y). Si impossible, renvoie ACTION_INTERDITE, FINANCES_DEPASSEES, NON_CONNEXE, BLOCAGE ou CASE_OCCUPEE.
foreign import ccall reserver_case :: Int -> Int -> IO Int

-- Dtruit la maison en (x,y). Si impossible, renvoie ACTION_INTERDITE, FINANCES_DEPASSEES ou PAS_DE_MAISON.
foreign import ccall detruire_maison :: Int -> Int -> IO Int

-- Vend la maison en (x,y). Si impossible, renvoie ACTION_INTERDITE ou PAS_DE_MAISON.
foreign import ccall vendre_maison :: Int -> Int -> IO Int

-- Place une enchre. Renvoie ACTION_INTERDITE ou FINANCES_DEPASSEES si impossible.
foreign import ccall encherir :: Int -> IO Int

-- Construit un monument en (x,y). Si impossible, renvoie ACTION_INTERDITE, NON_CONNEXE, BLOCAGE ou CASE_OCCUPEE.
foreign import ccall construire_monument :: Int -> Int -> IO Int

-- Fonction appelee au debut de la partie
foreign export ccall init_game:: IO ()

-- Fonction appelee a la fin de la partie
foreign export ccall end_game:: IO ()

-- Fonction appelee a chaque phase de jeu
foreign export ccall jouer:: IO ()

-- Fonction appelee a chaque phase d'enchere
foreign export ccall enchere:: IO ()

-- Fonction appelee a chaque phase de placement de monument
foreign export ccall placement:: IO ()

-- Fonction appelee au debut de la partie
init_game:: IO ()
init_game = do return () -- put your code here


-- Fonction appelee a la fin de la partie
end_game:: IO ()
end_game = do return () -- put your code here


-- Fonction appelee a chaque phase de jeu
jouer:: IO ()
jouer = do return () -- put your code here


-- Fonction appelee a chaque phase d'enchere
enchere:: IO ()
enchere = do return () -- put your code here


-- Fonction appelee a chaque phase de placement de monument
placement:: IO ()
placement = do return () -- put your code here


