///
// This file has been generated, if you wish to
// modify it in a permanent way, please refer
// to the script file : gen/generator_cs.rb
//

#include "interface.hh"

#include <iostream>
#include <assert.h>
#include <cstdlib>

CSharpInterface gl_csharp;

/*
** Inititialize Mono and load the DLL file.
*/
CSharpInterface::CSharpInterface()
{
  const char*		champion_path = getenv("CHAMPION_PATH");
  std::string		champion;
  MonoMethodDesc*	method_desc;

  if (!champion_path)
    champion = "./prologin.dll";
  else
  {
    champion = champion_path;
    champion += "/prologin.dll";
  }

  _domain = mono_jit_init(champion.c_str());
  assert(_domain != NULL);

  _assembly = mono_domain_assembly_open(_domain, champion.c_str());
  assert(_assembly != NULL);

  _image = mono_assembly_get_image(_assembly);
  assert(_image != NULL);

  _class = mono_class_from_name(_image, "Prologin", "Prologin");
  assert(_class != NULL);

  const char* method_names[] = {
  "Prologin:init_game",
  "Prologin:end_game",
  "Prologin:jouer",
  "Prologin:enchere",
  "Prologin:placement",
    NULL
  };

  MonoMethod* method = NULL;

  // Get MonoMethod* hanldes to user functions
  for (int i = 0; method_names[i] != NULL; ++i)
  {
    method_desc = mono_method_desc_new(method_names[i], false);
    method = mono_method_desc_search_in_class(method_desc, _class);
    assert(method != NULL);
    _user_methods[method_names[i]] = method;
  }

  // Register API functions as internal Mono functions
  mono_add_internal_call("Prologin.API::type_case", (const void*)type_case);
  mono_add_internal_call("Prologin.API::valeur_case", (const void*)valeur_case);
  mono_add_internal_call("Prologin.API::appartenance", (const void*)appartenance);
  mono_add_internal_call("Prologin.API::type_monument", (const void*)type_monument);
  mono_add_internal_call("Prologin.API::portee_monument", (const void*)portee_monument);
  mono_add_internal_call("Prologin.API::prestige_monument", (const void*)prestige_monument);
  mono_add_internal_call("Prologin.API::numero_tour", (const void*)numero_tour);
  mono_add_internal_call("Prologin.API::commence", (const void*)commence);
  mono_add_internal_call("Prologin.API::montant_encheres", (const void*)montant_encheres);
  mono_add_internal_call("Prologin.API::vainqueur_encheres", (const void*)vainqueur_encheres);
  mono_add_internal_call("Prologin.API::score", (const void*)score);
  mono_add_internal_call("Prologin.API::finances", (const void*)finances);
  mono_add_internal_call("Prologin.API::monument_en_cours", (const void*)monument_en_cours);
  mono_add_internal_call("Prologin.API::distance", (const void*)distance);
  mono_add_internal_call("Prologin.API::route_possible", (const void*)route_possible);
  mono_add_internal_call("Prologin.API::construction_possible", (const void*)construction_possible);
  mono_add_internal_call("Prologin.API::cout_achat_maison", (const void*)cout_achat_maison);
  mono_add_internal_call("Prologin.API::cout_achat_route", (const void*)cout_achat_route);
  mono_add_internal_call("Prologin.API::mon_tour", (const void*)mon_tour);
  mono_add_internal_call("Prologin.API::construire_route", (const void*)construire_route);
  mono_add_internal_call("Prologin.API::construire_maison", (const void*)construire_maison);
  mono_add_internal_call("Prologin.API::reserver_case", (const void*)reserver_case);
  mono_add_internal_call("Prologin.API::detruire_maison", (const void*)detruire_maison);
  mono_add_internal_call("Prologin.API::vendre_maison", (const void*)vendre_maison);
  mono_add_internal_call("Prologin.API::encherir", (const void*)encherir);
  mono_add_internal_call("Prologin.API::construire_monument", (const void*)construire_monument);
}

CSharpInterface::~CSharpInterface()
{
  mono_image_close(_image);
  mono_assembly_close(_assembly);
  // XXX -- mono segfaults when calling this. Seems to be a known bug
  //        appearing when mono_jit_clean() is called from a dtor. ???
  //mono_jit_cleanup(_domain);
}

/*
** Calls C# functions from C++
*/
void CSharpInterface::callCSharpMethod(const char* name)
{
  MonoMethod*	method;
  void** args = { NULL };
  UserMethodsMap::iterator iter;

  iter = _user_methods.find(name);
  if (iter == _user_methods.end())
    return ;
  method = (*iter).second;
  mono_runtime_invoke(method, NULL, args, NULL);
}

/*
** Functions called from stechec to C.
*/
extern "C" void init_game()
{
  gl_csharp.callCSharpMethod("Prologin:init_game");
}

extern "C" void end_game()
{
  gl_csharp.callCSharpMethod("Prologin:end_game");
}

extern "C" void jouer()
{
  gl_csharp.callCSharpMethod("Prologin:jouer");
}

extern "C" void enchere()
{
  gl_csharp.callCSharpMethod("Prologin:enchere");
}

extern "C" void placement()
{
  gl_csharp.callCSharpMethod("Prologin:placement");
}

