///
// This file has been generated, if you wish to
// modify it in a permanent way, please refer
// to the script file : gen/generator_python.rb
//

#include "interface.hh"

PythonInterface gl_python;

/*
** Api functions called from Python to stechec.
*/
extern "C" {
static PyObject* p_type_case(PyObject*, PyObject* args)
{
  int arg1, arg2;
  if (!PyArg_ParseTuple(args, "ii", &arg1, &arg2))
{
    return NULL;
}
  int ret = type_case(arg1, arg2);
  return PyInt_FromLong(ret);
}

static PyObject* p_valeur_case(PyObject*, PyObject* args)
{
  int arg1, arg2;
  if (!PyArg_ParseTuple(args, "ii", &arg1, &arg2))
{
    return NULL;
}
  int ret = valeur_case(arg1, arg2);
  return PyInt_FromLong(ret);
}

static PyObject* p_appartenance(PyObject*, PyObject* args)
{
  int arg1, arg2;
  if (!PyArg_ParseTuple(args, "ii", &arg1, &arg2))
{
    return NULL;
}
  int ret = appartenance(arg1, arg2);
  return PyInt_FromLong(ret);
}

static PyObject* p_type_monument(PyObject*, PyObject* args)
{
  int arg1, arg2;
  if (!PyArg_ParseTuple(args, "ii", &arg1, &arg2))
{
    return NULL;
}
  int ret = type_monument(arg1, arg2);
  return PyInt_FromLong(ret);
}

static PyObject* p_portee_monument(PyObject*, PyObject* args)
{
  int arg1;
  if (!PyArg_ParseTuple(args, "i", &arg1))
{
    return NULL;
}
  int ret = portee_monument(arg1);
  return PyInt_FromLong(ret);
}

static PyObject* p_prestige_monument(PyObject*, PyObject* args)
{
  int arg1;
  if (!PyArg_ParseTuple(args, "i", &arg1))
{
    return NULL;
}
  int ret = prestige_monument(arg1);
  return PyInt_FromLong(ret);
}

static PyObject* p_numero_tour(PyObject*, PyObject* args)
{
  if (!PyArg_ParseTuple(args, ""))
{
    return NULL;
}
  int ret = numero_tour();
  return PyInt_FromLong(ret);
}

static PyObject* p_commence(PyObject*, PyObject* args)
{
  if (!PyArg_ParseTuple(args, ""))
{
    return NULL;
}
  int ret = commence();
  return PyInt_FromLong(ret);
}

static PyObject* p_montant_encheres(PyObject*, PyObject* args)
{
  int arg1;
  if (!PyArg_ParseTuple(args, "i", &arg1))
{
    return NULL;
}
  int ret = montant_encheres(arg1);
  return PyInt_FromLong(ret);
}

static PyObject* p_vainqueur_encheres(PyObject*, PyObject* args)
{
  if (!PyArg_ParseTuple(args, ""))
{
    return NULL;
}
  int ret = vainqueur_encheres();
  return PyInt_FromLong(ret);
}

static PyObject* p_score(PyObject*, PyObject* args)
{
  int arg1;
  if (!PyArg_ParseTuple(args, "i", &arg1))
{
    return NULL;
}
  int ret = score(arg1);
  return PyInt_FromLong(ret);
}

static PyObject* p_finances(PyObject*, PyObject* args)
{
  int arg1;
  if (!PyArg_ParseTuple(args, "i", &arg1))
{
    return NULL;
}
  int ret = finances(arg1);
  return PyInt_FromLong(ret);
}

static PyObject* p_monument_en_cours(PyObject*, PyObject* args)
{
  if (!PyArg_ParseTuple(args, ""))
{
    return NULL;
}
  int ret = monument_en_cours();
  return PyInt_FromLong(ret);
}

static PyObject* p_distance(PyObject*, PyObject* args)
{
  int arg1, arg2, arg3, arg4;
  if (!PyArg_ParseTuple(args, "iiii", &arg1, &arg2, &arg3, &arg4))
{
    return NULL;
}
  int ret = distance(arg1, arg2, arg3, arg4);
  return PyInt_FromLong(ret);
}

static PyObject* p_route_possible(PyObject*, PyObject* args)
{
  int arg1, arg2;
  if (!PyArg_ParseTuple(args, "ii", &arg1, &arg2))
{
    return NULL;
}
  int ret = route_possible(arg1, arg2);
  return PyInt_FromLong(ret);
}

static PyObject* p_construction_possible(PyObject*, PyObject* args)
{
  int arg1, arg2;
  if (!PyArg_ParseTuple(args, "ii", &arg1, &arg2))
{
    return NULL;
}
  int ret = construction_possible(arg1, arg2);
  return PyInt_FromLong(ret);
}

static PyObject* p_cout_achat_maison(PyObject*, PyObject* args)
{
  if (!PyArg_ParseTuple(args, ""))
{
    return NULL;
}
  int ret = cout_achat_maison();
  return PyInt_FromLong(ret);
}

static PyObject* p_cout_achat_route(PyObject*, PyObject* args)
{
  if (!PyArg_ParseTuple(args, ""))
{
    return NULL;
}
  int ret = cout_achat_route();
  return PyInt_FromLong(ret);
}

static PyObject* p_mon_tour(PyObject*, PyObject* args)
{
  if (!PyArg_ParseTuple(args, ""))
{
    return NULL;
}
  int ret = mon_tour();
  return PyInt_FromLong(ret);
}

static PyObject* p_construire_route(PyObject*, PyObject* args)
{
  int arg1, arg2;
  if (!PyArg_ParseTuple(args, "ii", &arg1, &arg2))
{
    return NULL;
}
  int ret = construire_route(arg1, arg2);
  return PyInt_FromLong(ret);
}

static PyObject* p_construire_maison(PyObject*, PyObject* args)
{
  int arg1, arg2;
  if (!PyArg_ParseTuple(args, "ii", &arg1, &arg2))
{
    return NULL;
}
  int ret = construire_maison(arg1, arg2);
  return PyInt_FromLong(ret);
}

static PyObject* p_reserver_case(PyObject*, PyObject* args)
{
  int arg1, arg2;
  if (!PyArg_ParseTuple(args, "ii", &arg1, &arg2))
{
    return NULL;
}
  int ret = reserver_case(arg1, arg2);
  return PyInt_FromLong(ret);
}

static PyObject* p_detruire_maison(PyObject*, PyObject* args)
{
  int arg1, arg2;
  if (!PyArg_ParseTuple(args, "ii", &arg1, &arg2))
{
    return NULL;
}
  int ret = detruire_maison(arg1, arg2);
  return PyInt_FromLong(ret);
}

static PyObject* p_vendre_maison(PyObject*, PyObject* args)
{
  int arg1, arg2;
  if (!PyArg_ParseTuple(args, "ii", &arg1, &arg2))
{
    return NULL;
}
  int ret = vendre_maison(arg1, arg2);
  return PyInt_FromLong(ret);
}

static PyObject* p_encherir(PyObject*, PyObject* args)
{
  int arg1;
  if (!PyArg_ParseTuple(args, "i", &arg1))
{
    return NULL;
}
  int ret = encherir(arg1);
  return PyInt_FromLong(ret);
}

static PyObject* p_construire_monument(PyObject*, PyObject* args)
{
  int arg1, arg2;
  if (!PyArg_ParseTuple(args, "ii", &arg1, &arg2))
{
    return NULL;
}
  int ret = construire_monument(arg1, arg2);
  return PyInt_FromLong(ret);
}

} // !api functions

/*
** Api functions to register.
*/
static PyMethodDef api_callback[] = {
  {"type_case", p_type_case, METH_VARARGS, "type_case"},
  {"valeur_case", p_valeur_case, METH_VARARGS, "valeur_case"},
  {"appartenance", p_appartenance, METH_VARARGS, "appartenance"},
  {"type_monument", p_type_monument, METH_VARARGS, "type_monument"},
  {"portee_monument", p_portee_monument, METH_VARARGS, "portee_monument"},
  {"prestige_monument", p_prestige_monument, METH_VARARGS, "prestige_monument"},
  {"numero_tour", p_numero_tour, METH_VARARGS, "numero_tour"},
  {"commence", p_commence, METH_VARARGS, "commence"},
  {"montant_encheres", p_montant_encheres, METH_VARARGS, "montant_encheres"},
  {"vainqueur_encheres", p_vainqueur_encheres, METH_VARARGS, "vainqueur_encheres"},
  {"score", p_score, METH_VARARGS, "score"},
  {"finances", p_finances, METH_VARARGS, "finances"},
  {"monument_en_cours", p_monument_en_cours, METH_VARARGS, "monument_en_cours"},
  {"distance", p_distance, METH_VARARGS, "distance"},
  {"route_possible", p_route_possible, METH_VARARGS, "route_possible"},
  {"construction_possible", p_construction_possible, METH_VARARGS, "construction_possible"},
  {"cout_achat_maison", p_cout_achat_maison, METH_VARARGS, "cout_achat_maison"},
  {"cout_achat_route", p_cout_achat_route, METH_VARARGS, "cout_achat_route"},
  {"mon_tour", p_mon_tour, METH_VARARGS, "mon_tour"},
  {"construire_route", p_construire_route, METH_VARARGS, "construire_route"},
  {"construire_maison", p_construire_maison, METH_VARARGS, "construire_maison"},
  {"reserver_case", p_reserver_case, METH_VARARGS, "reserver_case"},
  {"detruire_maison", p_detruire_maison, METH_VARARGS, "detruire_maison"},
  {"vendre_maison", p_vendre_maison, METH_VARARGS, "vendre_maison"},
  {"encherir", p_encherir, METH_VARARGS, "encherir"},
  {"construire_monument", p_construire_monument, METH_VARARGS, "construire_monument"},
  {NULL, NULL, 0, NULL}
};

PyMODINIT_FUNC initapi()
{
  Py_InitModule("api", api_callback);
}

/*
** Inititialize python, register API functions,
** and load .py file
*/
PythonInterface::PythonInterface()
{
  PyObject* pName;
  const char* pChampionPath;
      
  pChampionPath = getenv("CHAMPION_PATH");
  if (pChampionPath == NULL)
    pChampionPath = ".";

  setenv("PYTHONPATH", pChampionPath, 1);

  static char program_name[] = "stechec";
  Py_SetProgramName(program_name);
  Py_Initialize();
  initapi();

  pName = PyString_FromString("prologin");
  pModule = PyImport_Import(pName);
  Py_DECREF(pName);
  if (pModule == NULL)
    if (PyErr_Occurred())
    {
      PyErr_Print();
      abort();
    }
}

PythonInterface::~PythonInterface()
{
  Py_XDECREF(pModule);
  Py_Finalize();
}

/*
** Run a python function.
*/
void PythonInterface::callPythonFunction(const char* name)
{
  PyObject *arglist, *pFunc;
  PyObject *result = NULL;
  
  pFunc = PyObject_GetAttrString(pModule, (char*)name);
  if (pFunc && PyCallable_Check(pFunc))
    {
      arglist = Py_BuildValue("()");
      result = PyEval_CallObject(pFunc, arglist);
      Py_XDECREF(arglist);
      Py_DECREF(pFunc);
    }
  if (result == NULL && PyErr_Occurred())
    PyErr_Print();
  Py_XDECREF(result);
}

/*
** Functions called from stechec to C.
*/
extern "C" void init_game()
{
  gl_python.callPythonFunction("init_game");
}

extern "C" void end_game()
{
  gl_python.callPythonFunction("end_game");
}

extern "C" void jouer()
{
  gl_python.callPythonFunction("jouer");
}

extern "C" void enchere()
{
  gl_python.callPythonFunction("enchere");
}

extern "C" void placement()
{
  gl_python.callPythonFunction("placement");
}

