///
// This file has been generated, if you wish to
// modify it in a permanent way, please refer
// to the script file : gen/generator_ruby.rb
//

#include <ruby.h>

extern "C" {

/*
** execute 'str', protected from possible exception, ...
*/
VALUE my_rb_eval_string(VALUE str)
{
  rb_eval_string((const char*) str);
  return T_NIL;
}

extern int type_case(int x, int y);
VALUE rb_type_case(VALUE x, VALUE y)
{
  return INT2FIX(type_case(FIX2INT(x), FIX2INT(y)));
}

extern int valeur_case(int x, int y);
VALUE rb_valeur_case(VALUE x, VALUE y)
{
  return INT2FIX(valeur_case(FIX2INT(x), FIX2INT(y)));
}

extern int appartenance(int x, int y);
VALUE rb_appartenance(VALUE x, VALUE y)
{
  return INT2FIX(appartenance(FIX2INT(x), FIX2INT(y)));
}

extern int type_monument(int x, int y);
VALUE rb_type_monument(VALUE x, VALUE y)
{
  return INT2FIX(type_monument(FIX2INT(x), FIX2INT(y)));
}

extern int portee_monument(int num_monument);
VALUE rb_portee_monument(VALUE num_monument)
{
  return INT2FIX(portee_monument(FIX2INT(num_monument)));
}

extern int prestige_monument(int num_monument);
VALUE rb_prestige_monument(VALUE num_monument)
{
  return INT2FIX(prestige_monument(FIX2INT(num_monument)));
}

extern int numero_tour();
VALUE rb_numero_tour()
{
  return INT2FIX(numero_tour());
}

extern int commence();
VALUE rb_commence()
{
  return INT2FIX(commence());
}

extern int montant_encheres(int num_joueur);
VALUE rb_montant_encheres(VALUE num_joueur)
{
  return INT2FIX(montant_encheres(FIX2INT(num_joueur)));
}

extern int vainqueur_encheres();
VALUE rb_vainqueur_encheres()
{
  return INT2FIX(vainqueur_encheres());
}

extern int score(int num_joueur);
VALUE rb_score(VALUE num_joueur)
{
  return INT2FIX(score(FIX2INT(num_joueur)));
}

extern int finances(int num_joueur);
VALUE rb_finances(VALUE num_joueur)
{
  return INT2FIX(finances(FIX2INT(num_joueur)));
}

extern int monument_en_cours();
VALUE rb_monument_en_cours()
{
  return INT2FIX(monument_en_cours());
}

extern int distance(int x1, int y1, int x2, int y2);
VALUE rb_distance(VALUE x1, VALUE y1, VALUE x2, VALUE y2)
{
  return INT2FIX(distance(FIX2INT(x1), FIX2INT(y1), FIX2INT(x2), FIX2INT(y2)));
}

extern int route_possible(int x, int y);
VALUE rb_route_possible(VALUE x, VALUE y)
{
  return INT2FIX(route_possible(FIX2INT(x), FIX2INT(y)));
}

extern int construction_possible(int x, int y);
VALUE rb_construction_possible(VALUE x, VALUE y)
{
  return INT2FIX(construction_possible(FIX2INT(x), FIX2INT(y)));
}

extern int cout_achat_maison();
VALUE rb_cout_achat_maison()
{
  return INT2FIX(cout_achat_maison());
}

extern int cout_achat_route();
VALUE rb_cout_achat_route()
{
  return INT2FIX(cout_achat_route());
}

extern bool mon_tour();
VALUE rb_mon_tour()
{
  return INT2FIX(mon_tour());
}

extern int construire_route(int x, int y);
VALUE rb_construire_route(VALUE x, VALUE y)
{
  return INT2FIX(construire_route(FIX2INT(x), FIX2INT(y)));
}

extern int construire_maison(int x, int y);
VALUE rb_construire_maison(VALUE x, VALUE y)
{
  return INT2FIX(construire_maison(FIX2INT(x), FIX2INT(y)));
}

extern int reserver_case(int x, int y);
VALUE rb_reserver_case(VALUE x, VALUE y)
{
  return INT2FIX(reserver_case(FIX2INT(x), FIX2INT(y)));
}

extern int detruire_maison(int x, int y);
VALUE rb_detruire_maison(VALUE x, VALUE y)
{
  return INT2FIX(detruire_maison(FIX2INT(x), FIX2INT(y)));
}

extern int vendre_maison(int x, int y);
VALUE rb_vendre_maison(VALUE x, VALUE y)
{
  return INT2FIX(vendre_maison(FIX2INT(x), FIX2INT(y)));
}

extern int encherir(int montant);
VALUE rb_encherir(VALUE montant)
{
  return INT2FIX(encherir(FIX2INT(montant)));
}

extern int construire_monument(int x, int y);
VALUE rb_construire_monument(VALUE x, VALUE y)
{
  return INT2FIX(construire_monument(FIX2INT(x), FIX2INT(y)));
}


}

struct RubyVm
{
  void loadCallback()
  { 
    rb_define_global_function("type_case", (VALUE(*)(...))(rb_type_case), 2);
    rb_define_global_function("valeur_case", (VALUE(*)(...))(rb_valeur_case), 2);
    rb_define_global_function("appartenance", (VALUE(*)(...))(rb_appartenance), 2);
    rb_define_global_function("type_monument", (VALUE(*)(...))(rb_type_monument), 2);
    rb_define_global_function("portee_monument", (VALUE(*)(...))(rb_portee_monument), 1);
    rb_define_global_function("prestige_monument", (VALUE(*)(...))(rb_prestige_monument), 1);
    rb_define_global_function("numero_tour", (VALUE(*)(...))(rb_numero_tour), 0);
    rb_define_global_function("commence", (VALUE(*)(...))(rb_commence), 0);
    rb_define_global_function("montant_encheres", (VALUE(*)(...))(rb_montant_encheres), 1);
    rb_define_global_function("vainqueur_encheres", (VALUE(*)(...))(rb_vainqueur_encheres), 0);
    rb_define_global_function("score", (VALUE(*)(...))(rb_score), 1);
    rb_define_global_function("finances", (VALUE(*)(...))(rb_finances), 1);
    rb_define_global_function("monument_en_cours", (VALUE(*)(...))(rb_monument_en_cours), 0);
    rb_define_global_function("distance", (VALUE(*)(...))(rb_distance), 4);
    rb_define_global_function("route_possible", (VALUE(*)(...))(rb_route_possible), 2);
    rb_define_global_function("construction_possible", (VALUE(*)(...))(rb_construction_possible), 2);
    rb_define_global_function("cout_achat_maison", (VALUE(*)(...))(rb_cout_achat_maison), 0);
    rb_define_global_function("cout_achat_route", (VALUE(*)(...))(rb_cout_achat_route), 0);
    rb_define_global_function("mon_tour", (VALUE(*)(...))(rb_mon_tour), 0);
    rb_define_global_function("construire_route", (VALUE(*)(...))(rb_construire_route), 2);
    rb_define_global_function("construire_maison", (VALUE(*)(...))(rb_construire_maison), 2);
    rb_define_global_function("reserver_case", (VALUE(*)(...))(rb_reserver_case), 2);
    rb_define_global_function("detruire_maison", (VALUE(*)(...))(rb_detruire_maison), 2);
    rb_define_global_function("vendre_maison", (VALUE(*)(...))(rb_vendre_maison), 2);
    rb_define_global_function("encherir", (VALUE(*)(...))(rb_encherir), 1);
    rb_define_global_function("construire_monument", (VALUE(*)(...))(rb_construire_monument), 2);

  }

  RubyVm()
  {
    int status;
    // load ruby and evaluate candidat's file
    ruby_init();
    ruby_init_loadpath();
    rb_load_file("prologin.rb");
    if ((status = ruby_exec()))
    {
      fprintf(stderr, "failed to load ruby code (%d)\n", status);
      exit(1);
    }
    rb_protect(my_rb_eval_string, (VALUE) "game = Prologin.new", &status);
    if (status)
    {
      fprintf(stderr, "error while instantiating Prologin class\n");
      exit(1);
    }
    loadCallback();
  }

  ~RubyVm()
  {
    // finalize (don't seem to work well)
    int status = 0;
    status = ruby_cleanup(status);
    ruby_finalize();
  }
} rubyVm;

extern "C" {
///
// Fonction appelee au debut de la partie
//
void init_game()
{
  int status;
  rb_protect(my_rb_eval_string, (VALUE) "game.init_game", &status);
  if (status)
    fprintf(stderr, "error while calling ruby function: init_game (%d)\n", status);
}

///
// Fonction appelee a la fin de la partie
//
void end_game()
{
  int status;
  rb_protect(my_rb_eval_string, (VALUE) "game.end_game", &status);
  if (status)
    fprintf(stderr, "error while calling ruby function: end_game (%d)\n", status);
}

///
// Fonction appelee a chaque phase de jeu
//
void jouer()
{
  int status;
  rb_protect(my_rb_eval_string, (VALUE) "game.jouer", &status);
  if (status)
    fprintf(stderr, "error while calling ruby function: jouer (%d)\n", status);
}

///
// Fonction appelee a chaque phase d'enchere
//
void enchere()
{
  int status;
  rb_protect(my_rb_eval_string, (VALUE) "game.enchere", &status);
  if (status)
    fprintf(stderr, "error while calling ruby function: enchere (%d)\n", status);
}

///
// Fonction appelee a chaque phase de placement de monument
//
void placement()
{
  int status;
  rb_protect(my_rb_eval_string, (VALUE) "game.placement", &status);
  if (status)
    fprintf(stderr, "error while calling ruby function: placement (%d)\n", status);
}

}
