module Prologin where

-- Un des arguments passe a la fonction est incorrect.
_BAD_ARGUMENT = -4

-- Vous ne pouvez pas appeler cette commande maintenant.
_INVALID_COMMAND = -3

-- L'unite demande n'existe pas (ou plus).
_NO_UNIT = -2

-- Le resultat ne peut pas etre connu.
_UNKNOWN = -1

-- La commande s'est correctement effectuee.
_SUCCESS = 0

-- Nombre maximum de tours.
_MAX_TURN = 500

-- Taille maximum de la carte en largeur-hauteur.
_MAX_MAP_SIZE = 40

-- Nombre maximal de bacteries sur une case.
_MAX_BACTERY = 30

-- Nombre maximal de nutriments sur une case.
_MAX_NUTRIENT = 17

-- Nombre maximum de points de competence d'un leucocyte.
_MAX_SKILL = 12

-- Quantite de nutriments apportes par le sang  chaque tour.
_NEW_NUTRIENT = 10

-- Quantite de nutriments qu'une cellule peut consommer par tour.
_CELL_NUTRIENT = 10

-- Quantite de nutriments dont une cellule a besoin pour faire une mitose.
_CELL_MITOSIS_MATERIAL = 50

-- Quantite de nutriments dont une cellule a besoin pour fabriquer un virus.
_VIRUS_MATERIAL = 15

-- Quantite de nutriments qu'une bactrie peut consommer par tour.
_BACTERY_NUTRIENT = 10

-- Nombre de tours ncessaires a une cellule pour produire un virus.
_VIRUS_PRODUCTION_DURATION = 10

-- Nombre de tours ncessaires a une cellule pour produire un virus.
_VIRUS_LIFE = 50

-- Nombre de tours ncessaires a une cellule pour se diviser.
_MITOSIS_DURATION = 50

-- Nombre de tours ncessaires a un virus pour transformer une cellule.
_INFECTION_DURATION = 10

-- Nombre de tours ncessaires a un leucocyte pour digerer un virus.
_PHAGOCYTOSIS_DURATION = 30

-- Rseau sanguin.
_VESSEL = 0

-- Tissu cellulaire.
_FLESH = 1

-- Un leucocyte se trouve a cet endroit.
_WHITE_CELL = 2

-- Une cellule se trouve a cet endroit.
_CELL = 3

-- Une cellule se trouve a cet endroit.
_BACTERIA = 4

-- Un virus se trouve a cet endroit.
_VIRUS = 5

-- La cellule est saine.
_CELL_STATE_HEALTHY = 0

-- La cellule est infecte par un virus.
_CELL_STATE_INFECTED = 1

-- La cellule est entrain d'etre infectee.
_CELL_STATE_BEING_INFECTED = 2

-- La cellule est entrain d'etre phagocytee.
_CELL_STATE_BEING_PHAGOCYTED = 3

-- La cellule est morte.
_CELL_STATE_DEAD = 4

-- Le globule blanc est disponible.
_STATE_NORMAL = 0

-- Le leucocyte est en train de phagocyter.
_STATE_PHAGOCYTOSING = 1

-- Le leucocyte est en train d'etre phagocyte.
_STATE_BEING_PHAGOCYTED = 2

-- Le leucocyte est mort.
_STATE_DEAD = 3

-- Deplacement vers le haut.
_DEC_Y = 0

-- Deplacement vers la gauche.
_DEC_X = 1

-- Deplacement vers le bas.
_INC_Y = 2

-- Deplacement vers la droite.
_INC_X = 3

-- Nombre d'equipes presentes sur le terrain.
foreign import ccall equipes :: IO Int

-- Nombre de leucocytes presents sur la map qu debut du jeu.
foreign import ccall nombre_leucocyte :: IO Int

-- Nombre de leucocytes dans l'equipe.
foreign import ccall taille_equipe :: Int -> IO Int

-- Identifiant de votre equipe.
foreign import ccall mon_equipe :: IO Int

-- Identifiant de votre unite
foreign import ccall mon_identifiant :: IO Int

-- Taille du monde en largeur.
foreign import ccall taille_corps_x :: IO Int

-- Taille du monde en hauteur.
foreign import ccall taille_corps_y :: IO Int

-- Recupere le type de terrain a la position demandee. Si aucun de vos
-- joueurs ne peut voir la case en question (brouillard de guerre), la
-- fonction ne renverra que VESSEL ou FLESH. Si vous pouvez la voir,
-- alors la valeur de retour sera plus precise.

foreign import ccall regarde :: Int -> Int -> IO Int

-- Dit si des bacteries sont presentes sur la case specifiee.

foreign import ccall bacteries_presentes :: Int -> Int -> IO Int

-- Regarde si une case du terrain se trouve dans le champ de vision de vos
-- joueurs.

foreign import ccall visible :: Int -> Int -> IO Int

-- Recupere le score d'une equipe.
foreign import ccall score :: Int -> IO Int

-- Date actuelle.
foreign import ccall battement_courant :: IO Int

-- Le leucocyte est-il visible ?
foreign import ccall leucocyte_visible :: Int -> IO Int

-- Permet de savoir l'identifiant d'un leucocyte sur une case.

foreign import ccall identifiant_leucocyte :: Int -> Int -> IO Int

-- Recupere l'identifiant d'equipe auquel appartient un leucocyte.
foreign import ccall equipe :: Int -> IO Int

-- Position d'un leucocyte en largeur.
foreign import ccall position_leucocyte_x :: Int -> IO Int

-- Position d'un leucocyte en hauteur.
foreign import ccall position_leucocyte_y :: Int -> IO Int

-- Recupere l'etat d'un leucocyte.
foreign import ccall etat_leucocyte :: Int -> IO Int

-- Recupere l'etat d'une cellule.
foreign import ccall etat_cellule :: Int -> Int -> IO Int

-- Sert a se renseigner si le joueur connait deja un type de signature d'un virus.

foreign import ccall connait_type :: Int -> Int -> IO Int

-- Definit les competence d'un leucocyte

foreign import ccall definit_competence :: Int -> Int -> Int -> Int -> IO Int

-- Deplace un de ses leucocyte \emph{vers} la position indiquee. Il ne se deplace que
-- d'une seule case par tour.

foreign import ccall deplace_leucocyte :: Int -> Int -> IO Int

-- Phagocytose de l'entite qui se trouve aux coordonnees indiques.
-- S'il s'agit d'un virus dont le type n'est pas encore connu,
-- l'appel a cette fonction immobilisera plus longtemps le leucocyte
-- que si le type est connu (apprentissage de la signature).

foreign import ccall phagocyte :: Int -> Int -> IO Int

-- Le leucocyte emet des anticorps autour de lui et sur sa case

foreign import ccall emet_anticorps :: IO Int

-- Le leucocyte transmet un message.

foreign import ccall transmettre_message :: Int -> Int -> Int -> Int -> IO Int

-- Le leucocyte recoit l'identifiant prochain message qu'on lui a envoye.

foreign import ccall recevoir_prochain_message :: IO Int

-- Permet de connaitre le corps du message (le message reel en fait)

foreign import ccall corps_message :: Int -> Int -> IO Int

-- Fonction appele au debut de la partie
foreign export ccall init_game:: IO ()

-- Fonction appele a chaque tour
foreign export ccall play_turn:: IO ()

-- Fonction appele au debut de la partie
init_game:: IO ()
init_game = do return () -- put your code here


-- Fonction appele a chaque tour
play_turn:: IO ()
play_turn = do return () -- put your code here


