///
// This file has been generated, if you wish to
// modify it in a permanent way, please refer
// to the script file : gen/generator_java.rb
//

///
// Un des arguments passe a la fonction est incorrect.
//
# define BAD_ARGUMENT              -4

///
// Vous ne pouvez pas appeler cette commande maintenant.
//
# define INVALID_COMMAND           -3

///
// L'unite demande n'existe pas (ou plus).
//
# define NO_UNIT                   -2

///
// Le resultat ne peut pas etre connu.
//
# define UNKNOWN                   -1

///
// La commande s'est correctement effectuee.
//
# define SUCCESS                   0

///
// Nombre maximum de tours.
//
# define MAX_TURN                  500

///
// Taille maximum de la carte en largeur/hauteur.
//
# define MAX_MAP_SIZE              40

///
// Nombre maximal d'equipes en jeu.
//
# define MAX_TEAM                  6

///
// Nombre maximal de leucocyte par equipe.
//
# define MAX_WHITE_CELL            5

///
// Nombre maximal de bacteries sur une case.
//
# define MAX_BACTERY               20

///
// Nombre maximal de nutriments sur une case.
//
# define MAX_NUTRIENT              50

///
// Nombre maximum de points de competence d'un leucocyte.
//
# define MAX_SKILL                 12

///
// Quantite de nutriments apportes par le sang  chaque tour.
//
# define NEW_NUTRIENT              10

///
// Quantite de nutriments qu'une cellule peut consommer par tour.
//
# define CELL_NUTRIENT             10

///
// Quantite de nutriments dont une cellule a besoin pour faire une mitose.
//
# define CELL_MITOSIS_MATERIAL     50

///
// Quantite de nutriments dont une cellule a besoin pour fabriquer un virus.
//
# define VIRUS_MATERIAL            50

///
// Quantite de nutriments qu'une bactrie peut consommer par tour.
//
# define BACTERY_NUTRIENT          10

///
// Nombre de tours ncessaires a une cellule pour produire un virus.
//
# define VIRUS_PRODUCTION_DURATION 10

///
// Nombre de tours ncessaires a une cellule pour se diviser.
//
# define MITOSIS_DURATION          50

///
// Nombre de tours ncessaires a un virus pour transformer une cellule.
//
# define INFECTION_DURATION        10

///
// Nombre de tours ncessaires a un leucocyte pour digerer un virus.
//
# define PHAGOCYTOSIS_DURATION     10

///
// Rseau sanguin.
//
# define VESSEL                    0

///
// Tissu cellulaire.
//
# define FLESH                     1

///
// Un leucocyte se trouve a cet endroit.
//
# define WHITE_CELL                2

///
// Une cellule se trouve a cet endroit.
//
# define CELL                      3

///
// Une cellule se trouve a cet endroit.
//
# define BACTERIA                  4

///
// Un virus se trouve a cet endroit.
//
# define VIRUS                     5

///
// La cellule est saine.
//
# define CELL_STATE_HEALTHY        0

///
// La cellule est infecte par un virus.
//
# define CELL_STATE_INFECTED       1

///
// La cellule est morte.
//
# define CELL_STATE_PRODUCTING_VIRII 2

///
// La cellule est morte.
//
# define CELL_STATE_DEAD           3

///
// Le globule blanc est disponible.
//
# define STATE_NORMAL              0

///
// Le leucocyte est en train de phagocyter.
//
# define STATE_PHAGOCYTOSING       1

///
// Le leucocyte est mort.
//
# define STATE_DEAD                3

///
// Deplacement vers le haut.
//
# define DEC_Y                     0

///
// Deplacement vers la gauche.
//
# define DEC_X                     1

///
// Deplacement vers le bas.
//
# define INC_Y                     2

///
// Deplacement vers la droite.
//
# define INC_X                     3


extern "C" {

///
// Nombre d'equipes presentes sur le terrain.
//
extern int equipes();

///
// Nombre de leucocytes dans l'equipe.
//
extern int taille_equipe(int team_number);

///
// Identifiant de votre equipe.
//
extern int mon_equipe();

///
// Identifiant de votre unite
//
extern int mon_identifiant();

///
// Taille du monde en largeur.
//
extern int taille_corps_x();

///
// Taille du monde en hauteur.
//
extern int taille_corps_y();

///
// Recupere le type de terrain a la position demandee. Si aucun de vos
// joueurs ne peut voir la case en question (brouillard de guerre), la
// fonction ne renverra que VESSEL ou FLESH. Si vous pouvez la voir,
// alors la valeur de retour sera plus precise.

//
extern int regarde(int x, int y);

///
// Dit si des bacteries sont presentes sur la case specifiee.

//
extern int bacteries_presentes(int x, int y);

///
// Regarde si une case du terrain se trouve dans le champ de vision de vos
// joueurs.

//
extern int visible(int x, int y);

///
// Recupere le score d'une equipe.
//
extern int score(int id);

///
// Date actuelle.
//
extern int current_beat();

///
// Temps restant pour ce tour.
//
extern int time_remaining();

///
// Temps additionnel restant pour la partie.
//
extern int extra_time_remaining();

///
// Le leucocyte est-il visible ?
//
extern int leucocyte_visible(int id);

///
// Permet de savoir l'identifiant d'un leucocyte sur une case.

//
extern int identifiant_leucocyte(int x, int y);

///
// Recupere l'identifiant d'equipe auquel appartient un leucocyte.
//
extern int equipe(int id);

///
// Position d'un leucocyte en largeur.
//
extern int position_leucocyte_x(int id);

///
// Position d'un leucocyte en hauteur.
//
extern int position_leucocyte_y(int id);

///
// Recupere l'etat d'un leucocyte.
//
extern int etat_leucocyte(int id);

///
// Recupere l'etat d'une cellule.
//
extern int etat_cellule(int id);

///
// Sert a se renseigner si le joueur connait deja un type de signature d'un virus.

//
extern int connait_type(int x, int y);

///
// Defini les competence d'un leucocyte

//
extern int defini_competence(int rapidite, int anticorps, int messages, int vision);

///
// Deplace un de ses leucocyte \emph{vers} la position indiquee. Il ne se deplace que
// d'une seule case par tour.

//
extern int deplace_leucocyte(int x, int y);

///
// Phagocytose de l'entite qui se trouve aux coordonnees indiques.
// S'il s'agit d'un virus dont le type n'est pas encore connu,
// l'appel a cette fonction immobilisera plus longtemps le leucocyte
// que si le type est connu (apprentissage de la signature).

//
extern int phagocyte(int x, int y);

///
// Le leucocyte emet des anticorps autour de lui et sur sa case

//
extern int emet_anticorps();

///
// Le leucocyte transmet un message.

//
extern int transmettre_message(int message_arg1, int message_arg2, int message_arg3, int message_arg4);

///
// Le leucocyte recoit l'identifiant prochain message qu'on lui a envoye.

//
extern int recevoir_prochain_message();

///
// Permet de connaitre le corps du message (le message reel en fait)

//
extern int corps_message(int message_id, int argument_id);

///
// Fonction appele au debut de la partie
//
void init_game();

///
// Fonction appele a chaque tour
//
void play_turn();

}
