/*!
** This file has been generated, if you wish to
** modify it in a permanent way, please refer
** to the script file : gen/generator_caml.rb
*/

#include <caml/mlvalues.h>
#include <caml/callback.h>
#include <caml/alloc.h>
#include "interface.h"

/*!
** Nombre d'equipes presentes sur le terrain.
*/
value ml_equipes(void)
{
return Val_int(equipes());
}

/*!
** Nombre de leucocytes dans l'equipe.
*/
value ml_taille_equipe(value team_number)
{
return Val_int(taille_equipe(Int_val(team_number)));
}

/*!
** Identifiant de votre equipe.
*/
value ml_mon_equipe(void)
{
return Val_int(mon_equipe());
}

/*!
** Identifiant de votre unite
*/
value ml_mon_identifiant(void)
{
return Val_int(mon_identifiant());
}

/*!
** Taille du monde en largeur.
*/
value ml_taille_corps_x(void)
{
return Val_int(taille_corps_x());
}

/*!
** Taille du monde en hauteur.
*/
value ml_taille_corps_y(void)
{
return Val_int(taille_corps_y());
}

/*!
** Recupere le type de terrain a la position demandee. Si aucun de vos
** joueurs ne peut voir la case en question (brouillard de guerre), la
** fonction ne renverra que VESSEL ou FLESH. Si vous pouvez la voir,
** alors la valeur de retour sera plus precise.

*/
value ml_regarde(value x, value y)
{
return Val_int(regarde(Int_val(x), Int_val(y)));
}

/*!
** Dit si des bacteries sont presentes sur la case specifiee.

*/
value ml_bacteries_presentes(value x, value y)
{
return Val_int(bacteries_presentes(Int_val(x), Int_val(y)));
}

/*!
** Regarde si une case du terrain se trouve dans le champ de vision de vos
** joueurs.

*/
value ml_visible(value x, value y)
{
return Val_int(visible(Int_val(x), Int_val(y)));
}

/*!
** Recupere le score d'une equipe.
*/
value ml_score(value id)
{
return Val_int(score(Int_val(id)));
}

/*!
** Date actuelle.
*/
value ml_current_beat(void)
{
return Val_int(current_beat());
}

/*!
** Temps restant pour ce tour.
*/
value ml_time_remaining(void)
{
return Val_int(time_remaining());
}

/*!
** Temps additionnel restant pour la partie.
*/
value ml_extra_time_remaining(void)
{
return Val_int(extra_time_remaining());
}

/*!
** Le leucocyte est-il visible ?
*/
value ml_leucocyte_visible(value id)
{
return Val_int(leucocyte_visible(Int_val(id)));
}

/*!
** Permet de savoir l'identifiant d'un leucocyte sur une case.

*/
value ml_identifiant_leucocyte(value x, value y)
{
return Val_int(identifiant_leucocyte(Int_val(x), Int_val(y)));
}

/*!
** Recupere l'identifiant d'equipe auquel appartient un leucocyte.
*/
value ml_equipe(value id)
{
return Val_int(equipe(Int_val(id)));
}

/*!
** Position d'un leucocyte en largeur.
*/
value ml_position_leucocyte_x(value id)
{
return Val_int(position_leucocyte_x(Int_val(id)));
}

/*!
** Position d'un leucocyte en hauteur.
*/
value ml_position_leucocyte_y(value id)
{
return Val_int(position_leucocyte_y(Int_val(id)));
}

/*!
** Recupere l'etat d'un leucocyte.
*/
value ml_etat_leucocyte(value id)
{
return Val_int(etat_leucocyte(Int_val(id)));
}

/*!
** Recupere l'etat d'une cellule.
*/
value ml_etat_cellule(value id)
{
return Val_int(etat_cellule(Int_val(id)));
}

/*!
** Sert a se renseigner si le joueur connait deja un type de signature d'un virus.

*/
value ml_connait_type(value x, value y)
{
return Val_int(connait_type(Int_val(x), Int_val(y)));
}

/*!
** Defini les competence d'un leucocyte

*/
value ml_defini_competence(value rapidite, value anticorps, value messages, value vision)
{
return Val_int(defini_competence(Int_val(rapidite), Int_val(anticorps), Int_val(messages), Int_val(vision)));
}

/*!
** Deplace un de ses leucocyte \emph{vers} la position indiquee. Il ne se deplace que
** d'une seule case par tour.

*/
value ml_deplace_leucocyte(value x, value y)
{
return Val_int(deplace_leucocyte(Int_val(x), Int_val(y)));
}

/*!
** Phagocytose de l'entite qui se trouve aux coordonnees indiques.
** S'il s'agit d'un virus dont le type n'est pas encore connu,
** l'appel a cette fonction immobilisera plus longtemps le leucocyte
** que si le type est connu (apprentissage de la signature).

*/
value ml_phagocyte(value x, value y)
{
return Val_int(phagocyte(Int_val(x), Int_val(y)));
}

/*!
** Le leucocyte emet des anticorps autour de lui et sur sa case

*/
value ml_emet_anticorps(void)
{
return Val_int(emet_anticorps());
}

/*!
** Le leucocyte transmet un message.

*/
value ml_transmettre_message(value message_arg1, value message_arg2, value message_arg3, value message_arg4)
{
return Val_int(transmettre_message(Int_val(message_arg1), Int_val(message_arg2), Int_val(message_arg3), Int_val(message_arg4)));
}

/*!
** Le leucocyte recoit l'identifiant prochain message qu'on lui a envoye.

*/
value ml_recevoir_prochain_message(void)
{
return Val_int(recevoir_prochain_message());
}

/*!
** Permet de connaitre le corps du message (le message reel en fait)

*/
value ml_corps_message(value message_id, value argument_id)
{
return Val_int(corps_message(Int_val(message_id), Int_val(argument_id)));
}

/*!
** Fonction appele au debut de la partie
*/
void init_game(void)
{

  static value *fib_closure = NULL;

  if (fib_closure == NULL)
    fib_closure = caml_named_value("ml_init_game");
   callback(*fib_closure, Val_int(0));
}

/*!
** Fonction appele a chaque tour
*/
void play_turn(void)
{

  static value *fib_closure = NULL;

  if (fib_closure == NULL)
    fib_closure = caml_named_value("ml_play_turn");
   callback(*fib_closure, Val_int(0));
}

