(*
** This file has been generated, if you wish to
** modify it in a permanent way, please refer
** to the script file : gen/generator_caml.rb
*)

(*
** Un des arguments passe a la fonction est incorrect.
*)
let _BAD_ARGUMENT = -4;;

(*
** Vous ne pouvez pas appeler cette commande maintenant.
*)
let _INVALID_COMMAND = -3;;

(*
** L'unite demande n'existe pas (ou plus).
*)
let _NO_UNIT = -2;;

(*
** Le resultat ne peut pas etre connu.
*)
let _UNKNOWN = -1;;

(*
** La commande s'est correctement effectuee.
*)
let _SUCCESS = 0;;

(*
** Nombre maximum de tours.
*)
let _MAX_TURN = 500;;

(*
** Taille maximum de la carte en largeur-hauteur.
*)
let _MAX_MAP_SIZE = 40;;

(*
** Nombre maximal de bacteries sur une case.
*)
let _MAX_BACTERY = 30;;

(*
** Nombre maximal de nutriments sur une case.
*)
let _MAX_NUTRIENT = 17;;

(*
** Nombre maximum de points de competence d'un leucocyte.
*)
let _MAX_SKILL = 12;;

(*
** Quantite de nutriments apportes par le sang  chaque tour.
*)
let _NEW_NUTRIENT = 10;;

(*
** Quantite de nutriments qu'une cellule peut consommer par tour.
*)
let _CELL_NUTRIENT = 10;;

(*
** Quantite de nutriments dont une cellule a besoin pour faire une mitose.
*)
let _CELL_MITOSIS_MATERIAL = 50;;

(*
** Quantite de nutriments dont une cellule a besoin pour fabriquer un virus.
*)
let _VIRUS_MATERIAL = 15;;

(*
** Quantite de nutriments qu'une bactrie peut consommer par tour.
*)
let _BACTERY_NUTRIENT = 10;;

(*
** Nombre de tours ncessaires a une cellule pour produire un virus.
*)
let _VIRUS_PRODUCTION_DURATION = 10;;

(*
** Nombre de tours ncessaires a une cellule pour produire un virus.
*)
let _VIRUS_LIFE = 50;;

(*
** Nombre de tours ncessaires a une cellule pour se diviser.
*)
let _MITOSIS_DURATION = 50;;

(*
** Nombre de tours ncessaires a un virus pour transformer une cellule.
*)
let _INFECTION_DURATION = 10;;

(*
** Nombre de tours ncessaires a un leucocyte pour digerer un virus.
*)
let _PHAGOCYTOSIS_DURATION = 30;;

(*
** Rseau sanguin.
*)
let _VESSEL = 0;;

(*
** Tissu cellulaire.
*)
let _FLESH = 1;;

(*
** Un leucocyte se trouve a cet endroit.
*)
let _WHITE_CELL = 2;;

(*
** Une cellule se trouve a cet endroit.
*)
let _CELL = 3;;

(*
** Une cellule se trouve a cet endroit.
*)
let _BACTERIA = 4;;

(*
** Un virus se trouve a cet endroit.
*)
let _VIRUS = 5;;

(*
** La cellule est saine.
*)
let _CELL_STATE_HEALTHY = 0;;

(*
** La cellule est infecte par un virus.
*)
let _CELL_STATE_INFECTED = 1;;

(*
** La cellule est entrain d'etre infectee.
*)
let _CELL_STATE_BEING_INFECTED = 2;;

(*
** La cellule est entrain d'etre phagocytee.
*)
let _CELL_STATE_BEING_PHAGOCYTED = 3;;

(*
** La cellule est morte.
*)
let _CELL_STATE_DEAD = 4;;

(*
** Le globule blanc est disponible.
*)
let _STATE_NORMAL = 0;;

(*
** Le leucocyte est en train de phagocyter.
*)
let _STATE_PHAGOCYTOSING = 1;;

(*
** Le leucocyte est en train d'etre phagocyte.
*)
let _STATE_BEING_PHAGOCYTED = 2;;

(*
** Le leucocyte est mort.
*)
let _STATE_DEAD = 3;;

(*
** Deplacement vers le haut.
*)
let _DEC_Y = 0;;

(*
** Deplacement vers la gauche.
*)
let _DEC_X = 1;;

(*
** Deplacement vers le bas.
*)
let _INC_Y = 2;;

(*
** Deplacement vers la droite.
*)
let _INC_X = 3;;

(*
** Nombre d'equipes presentes sur le terrain.
*)
external equipes : unit -> int = "ml_equipes";;

(*
** Nombre de leucocytes presents sur la map qu debut du jeu.
*)
external nombre_leucocyte : unit -> int = "ml_nombre_leucocyte";;

(*
** Nombre de leucocytes dans l'equipe.
*)
external taille_equipe : int -> int = "ml_taille_equipe";;

(*
** Identifiant de votre equipe.
*)
external mon_equipe : unit -> int = "ml_mon_equipe";;

(*
** Identifiant de votre unite
*)
external mon_identifiant : unit -> int = "ml_mon_identifiant";;

(*
** Taille du monde en largeur.
*)
external taille_corps_x : unit -> int = "ml_taille_corps_x";;

(*
** Taille du monde en hauteur.
*)
external taille_corps_y : unit -> int = "ml_taille_corps_y";;

(*
** Recupere le type de terrain a la position demandee. Si aucun de vos
** joueurs ne peut voir la case en question (brouillard de guerre), la
** fonction ne renverra que VESSEL ou FLESH. Si vous pouvez la voir,
** alors la valeur de retour sera plus precise.

*)
external regarde : int -> int -> int = "ml_regarde";;

(*
** Dit si des bacteries sont presentes sur la case specifiee.

*)
external bacteries_presentes : int -> int -> int = "ml_bacteries_presentes";;

(*
** Regarde si une case du terrain se trouve dans le champ de vision de vos
** joueurs.

*)
external visible : int -> int -> int = "ml_visible";;

(*
** Recupere le score d'une equipe.
*)
external score : int -> int = "ml_score";;

(*
** Date actuelle.
*)
external battement_courant : unit -> int = "ml_battement_courant";;

(*
** Le leucocyte est-il visible ?
*)
external leucocyte_visible : int -> int = "ml_leucocyte_visible";;

(*
** Permet de savoir l'identifiant d'un leucocyte sur une case.

*)
external identifiant_leucocyte : int -> int -> int = "ml_identifiant_leucocyte";;

(*
** Recupere l'identifiant d'equipe auquel appartient un leucocyte.
*)
external equipe : int -> int = "ml_equipe";;

(*
** Position d'un leucocyte en largeur.
*)
external position_leucocyte_x : int -> int = "ml_position_leucocyte_x";;

(*
** Position d'un leucocyte en hauteur.
*)
external position_leucocyte_y : int -> int = "ml_position_leucocyte_y";;

(*
** Recupere l'etat d'un leucocyte.
*)
external etat_leucocyte : int -> int = "ml_etat_leucocyte";;

(*
** Recupere l'etat d'une cellule.
*)
external etat_cellule : int -> int -> int = "ml_etat_cellule";;

(*
** Sert a se renseigner si le joueur connait deja un type de signature d'un virus.

*)
external connait_type : int -> int -> int = "ml_connait_type";;

(*
** Definit les competence d'un leucocyte

*)
external definit_competence : int -> int -> int -> int -> int = "ml_definit_competence";;

(*
** Deplace un de ses leucocyte \emph{vers} la position indiquee. Il ne se deplace que
** d'une seule case par tour.

*)
external deplace_leucocyte : int -> int -> int = "ml_deplace_leucocyte";;

(*
** Phagocytose de l'entite qui se trouve aux coordonnees indiques.
** S'il s'agit d'un virus dont le type n'est pas encore connu,
** l'appel a cette fonction immobilisera plus longtemps le leucocyte
** que si le type est connu (apprentissage de la signature).

*)
external phagocyte : int -> int -> int = "ml_phagocyte";;

(*
** Le leucocyte emet des anticorps autour de lui et sur sa case

*)
external emet_anticorps : unit -> int = "ml_emet_anticorps";;

(*
** Le leucocyte transmet un message.

*)
external transmettre_message : int -> int -> int -> int -> int = "ml_transmettre_message";;

(*
** Le leucocyte recoit l'identifiant prochain message qu'on lui a envoye.

*)
external recevoir_prochain_message : unit -> int = "ml_recevoir_prochain_message";;

(*
** Permet de connaitre le corps du message (le message reel en fait)

*)
external corps_message : int -> int -> int = "ml_corps_message";;

