/*
com.cc

---

Version "propre" (mais encore, tres franchement, assez degueulasse) de l'implementation du protocole de com.
Lire : /home/goinfre/PROTOCOLE_COMMUNICATIONS

Pour utiliser le code : appeler les fonctions et recuperer les valeurs interessantes dans les variables concernees.

Rajoutez aussi com.cc et com.hh a votre Makefile.
*/

#include "prologin.hh"


int com_free_bits = 0;
int com_msg1 = 0, com_msg2 = 0, com_msg3 = 0, com_msg4 = 0;

// Infos d'identification.
int com_private = 0, com_team = 0, com_sender = 0, com_type = 0;
// Infos de caracs.
int com_whiteflag = 0, com_car_rapidite = 0, com_car_anticorps = 0, com_car_msg = 0, com_car_vision = 0;
// Infos de position.
int com_pos_x = 0, com_pos_y = 0, com_pos_type = 0, com_pos_infecte = 0, com_pos_faire = 0, com_pos_special = 0, com_pos_action = 0;
// Infos de deuxieme position si message a positions multiples.
int com_pos2_x = 0, com_pos2_y = 0, com_pos2_type = 0, com_pos2_infecte = 0, com_pos2_faire = 0, com_pos2_special = 0, com_pos2_action = 0;


enum com_element
{
    COM_WHITEFLAG,
    COM_CARACPOS,
    COM_1POS,
    COM_2POS
};

enum com_type
{
  COM_LEUCOCYTE,
  COM_VIRUS,
  COM_BACTERIA,
  COM_CELL
};


void com_set_free_bits(int n)
{
  com_free_bits = 0x3FFF & n;
}


int com_get_free_bits()
{
  return com_free_bits;
}


void com_send_whiteflag()
{
  transmettre_message(0x8000 + mon_equipe() * 0x4000 + mon_identifiant() * 0x0400, 0, 0, com_free_bits);
}


void com_send_carac_pos(int id, int r, int a, int m, int v)
{
  transmettre_message(0x8100 + mon_equipe() * 0x4000 + id * 0x0400 + (r & 0x0F) * 0x10 + (a & 0x0F), (m & 0x0F) * 0x1000 + (v & 0x0F) * 0x0100 + position_leucocyte_x(id) * 0x04 + (position_leucocyte_y(id)) & 0x30) / 0x10, (position_leucocyte_y(id) & 0x0F) * 0x1000 + id * 0x10, com_free_bits);
}


void com_send_1_pos(int x, int y, int t, int i, int f, int s, int d)
{
  transmettre_message(0x8200 + mon_equipe() * 0x4000 + mon_identifiant() * 0x0400 + x * 0x04 + (y & 0x20) / 0x10, (y & 0x0F) * 0x1000 + t * 0x0400 + i * 0x0200 + f * 0x0100 + s * 0x10 + d * 0x08, 0, com_free_bits);
}

void com_send_2_pos(int x, int y, int t, int i, int f, int s, int d, int xb, int yb, int tb, int ib, int fb, int sb, int db)
{
  transmettre_message(0x8300 + mon_equipe() * 0x4000 + mon_identifiant() * 0x0400 + x * 0x04 + (y & 0x20) / 0x10, (y & 0x0F) * 0x1000 + t * 0x0400 + i * 0x0200 + f * 0x0100 + s * 0x10 + d * 0x08 + (xb & 0x38) / 0x08, (xb & 0x07) * 0x2000 + yb * 0x80 + tb * 0x20 + ib * 0x10 + fb * 0x08 + (sb & 0x0E) / 2, (sb & 1) * 0x8000 + db * 0x4000 + com_free_bits);
}


void com_send_private(int a, int b, int c, int d)
{
  transmettre_message(a & 0x7FFF, b, c, d);
}


void com_parse_message(int msgid)
{
  com_msg1 = corps_message(msgid, 0);
  com_msg2 = corps_message(msgid, 1);
  com_msg3 = corps_message(msgid, 2);
  com_msg4 = corps_message(msgid, 3);
  com_private = ((com_msg1 & 0x8000) == 0);

  if (!com_private)
  {
    com_team = (com_msg1 & 0x4000) > 0;
    com_sender = ((com_msg1 & 0x3C00) / 0x0400);
    com_type = (com_msg1 & 0x0300) / 0x100;
    com_free_bits = (com_msg4 & 0x3F);
    
    if (com_type == COM_CARACPOS)
    {
      com_car_rapidite = (com_msg1 & 0xF0) / 0x10;
      com_car_anticorps = (com_msg1 & 0x0F);
      com_car_msg = (com_msg2 & 0xF000) / 0x1000;
      com_car_vision = (com_msg2 & 0x0F00) / 0x0100;
      com_pos_x = (com_msg2 & 0xFC) / 0x04;
      com_pos_y = (com_msg2 & 0x03) * 0x10 + (com_msg3 & 0xF000) / 0x1000;
    }
    
    else if (com_type == COM_1POS)
    {
      com_pos_x = (com_msg1 & 0xFC) / 0x04;
      com_pos_y = (com_msg1 & 0x03) * 0x10 + (com_msg2 & 0xF000) / 0x1000;
      com_pos_type = (com_msg2 & 0x0C00) / 0x0400;
      com_pos_infecte = (com_msg2 & 0x0200) > 0;
      com_pos_faire = (com_msg2 & 0x0100) > 0;
      com_pos_special = (com_msg2 & 0xF0) / 0x10;
      com_pos_action = (com_msg2 & 0x08) > 0;
    }
    
    else if (com_type == COM_2POS)
    {
      com_pos_x = (com_msg1 & 0xFC) / 0x04;
      com_pos_y = (com_msg1 & 0x03) * 0x10 + (com_msg2 & 0xF000) / 0x1000;
      com_pos_type = (com_msg2 & 0x0C00) / 0x0400;
      com_pos_infecte = (com_msg2 & 0x0200) > 0;
      com_pos_faire = (com_msg2 & 0x0100) > 0;
      com_pos_special = (com_msg2 & 0xF0) / 0x10;
      com_pos_action = (com_msg2 & 0x08) > 0;
      com_pos2_x = (com_msg2 & 0x07) * 0x80 + (com_msg3 & 0xE000) / 0x2000;
      com_pos2_x=((com_msg2&0x1E)<<3)+((com_msg3&57344)>>13);
      com_pos2_y = (com_msg3 & 0x1F80) / 0x80;
      com_pos2_type = (com_msg3 & 0x60) / 0x20;
      com_pos2_infecte = (com_msg3 & 0x10) > 0;
      com_pos2_faire = (com_msg3 & 0x04) > 0;
      com_pos2_special = (com_msg3 & 0x07) / 0x02 + ((com_msg4 & 0x8000) > 0);
      com_pos2_action = (com_msg4 & 0x4000) > 0;
    }
  }
}
