/*
 *A chaque tour à chaque nain est attribué un objectif :
 *On sélectionne pour ça le meilleur objectif calculé selon la fonction d'évaluation
 *qui valorise le rendement des minerais les plus proches ou le butin des nains adverses.
 *Si le butin d'un nain est déjà conséquent ou s'il n'y a plus de temps, il rentre.
 *Aucun algo n'a été utilisé, j'avais initialement prévu de faire un dijkstra mais ça m'a
 *pris beaucoup de temps et de bug donc j'ai abandonné au bout d'un moment, et j'ai fais
 *cet algo ad hoc un peu nul en 1h puis j'ai soumis et je suis allé mangé des crêpes.
 *
 *Si j'avais eu plus de temps j'aurais tenté de manger plus de crêpes.
*/
#include "prologin.hh"
#include <bits/stdc++.h>
using namespace std;

const int IFTY = 1000*1000;

struct Nain
{
	int id;
	nain core_nain;
	position cible;
	bool cibleJoueur=false;
};

void afficher_type (position pos)
{
	case_type ac = type_case(pos);
	switch (ac)
	{
		case OBSIDIENNE:
			cerr << "OBSIDIENNE" << endl;
			break;
		case LIBRE:
			cerr << "LIBRE" << endl;
			break;
		case GRANITE:
			cerr << "GRANITE" << endl;
			break;
		case ERREUR_CASE:
			cerr << "ERREUR_CASE" << endl;
			break;
	}
}


pair<float,bool> evaluation(position pos1, position pos2)
{
	float val = 1;
	float dist = chemin(pos1, pos2).size();
	if (dist>0)
		val *= 1.0/pow(dist, 0.3);
	else
		val = -1.0/0.0;
	bool estUnJoueur = false;
	switch(type_case(pos2))
	{
		case GRANITE:
			val += 20*pow((float)info_minerai(pos2).rendement / (float)(info_minerai(pos2).resistance*COUT_MINER), 2);
			
			break;
		case OBSIDIENNE:
			val = -1.0/0.0;
			break;
		case ERREUR_CASE:
			val = -1.0/0.0;
			break;
		case LIBRE:
			if (nain_sur_case(pos2)==adversaire())
			{
				for (int i=0; i<NB_NAINS; i++)
				{
					if (info_nain(adversaire(),i).pos==pos2)
					{
						val*=(float)info_nain(adversaire(),i).butin/2.5;
						estUnJoueur = true;
					}
				}
			}
			break;
	}
	return {val, estUnJoueur};
} 

Nain team[NB_NAINS];

void partie_init()
{
    for (int i=0; i<NB_NAINS; i++)
    {
    	Nain curNain;
    	position nul;
    	nul.ligne = -1;
    	nul.colonne = -1;
    	curNain.cible = nul;
    	curNain.id = i;
    	curNain.core_nain = info_nain(moi(), i);
    	team[i] = curNain;
    }
}

inline bool nextTo (position pos1, position pos2)
{
	return (abs(pos1.ligne-pos2.ligne)+abs(pos1.colonne-pos2.colonne)<=1 ? true : false);
}
inline position bas (position pos)
{
	pos.ligne++;
	return pos;
}
inline position haut (position pos)
{
	pos.ligne--;
	return pos;
}
inline position gauche (position pos)
{
	pos.colonne--;
	return pos;
}
inline position droite (position pos)
{
	pos.colonne++;
	return pos;
}
bool pValide(position pos)
{
	if (pos.ligne>=0 && pos.ligne<TAILLE_MINE && pos.colonne>=0 && pos.colonne<TAILLE_MINE)
		return true;
	return false;
}

void jouer_tour()
{
    auto minerais = liste_minerais();
    for (int idNain=0; idNain < NB_NAINS; idNain++)
    {
    	
    	float valMax = evaluation(team[idNain].core_nain.pos, team[idNain].cible).first;
    	position meilleurObj = team[idNain].cible;
    	bool attaque = false;
    	for (int lig=0; lig<TAILLE_MINE; lig++)
    	{
    		for (int col=0; col<TAILLE_MINE; col++)
    		{
    			position objectif;
   				objectif.ligne = lig;
   				objectif.colonne = col;
   				bool objDejaTarget=false;
   				
   				for (int i=0; i<NB_NAINS; i++)
   				{
   					if (i!= idNain && team[i].cible == objectif)
   						objDejaTarget = true;
   				}
   				if (!objDejaTarget)
   				{
   					if (evaluation(team[idNain].core_nain.pos, objectif).first>valMax)
   					{
   						valMax = evaluation(team[idNain].core_nain.pos, objectif).first;
   						meilleurObj = objectif;
   						attaque = evaluation(team[idNain].core_nain.pos, objectif).second;
   					}
   				}
    		}
    	}
    	team[idNain].cible = meilleurObj;
    	team[idNain].cibleJoueur = attaque;
    }
    //Déplacement
    for (int idNain=0; idNain < NB_NAINS; idNain++)
    {
    	agripper(idNain);
    	team[idNain].core_nain = info_nain(moi(), idNain);
    	if (team[idNain].core_nain.butin >= 20 || NB_TOURS - tour_actuel() < 26)
    	{
    		team[idNain].cible = position_taverne(moi());
    	}
    	int prev_pm = info_nain(moi(), idNain).pm+1;
    	while (info_nain(moi(), idNain).pm > 0)
    	{
    		if (info_nain(moi(), idNain).pm == prev_pm)
    			break;
    		else
    			prev_pm = info_nain(moi(), idNain).pm;
    		// Si on peut marcher : on marche
    		if (type_case(bas(info_nain(moi(), idNain).pos))!=LIBRE && pValide(droite(info_nain(moi(), idNain).pos)) && type_case(droite(info_nain(moi(), idNain).pos))==LIBRE)
    		{
    			if (team[idNain].cible.colonne > info_nain(moi(), idNain).pos.colonne)
    			{
    				if (type_case(bas(droite(info_nain(moi(), idNain).pos)))!=LIBRE
    				|| type_case(bas(bas(droite(info_nain(moi(), idNain).pos))))!=LIBRE
    				|| type_case(bas(bas(bas(droite(info_nain(moi(), idNain).pos)))))!=LIBRE)
    				{
						/*
						fprintf(stderr, "%d %d\n", info_nain(moi(), idNain).pos.colonne, info_nain(moi(), idNain).pos.ligne);
						afficher_type(bas(droite(info_nain(moi(), idNain).pos)));
						afficher_type(bas(bas(droite(info_nain(moi(), idNain).pos))));
    					debug_afficher_drapeau(info_nain(moi(), idNain).pos,DRAPEAU_ROUGE);
    					*/
    					lacher(idNain);
    					deplacer(idNain, DROITE);
    					continue;
    				}
    			}
    		}
    		
    		if (type_case(bas(info_nain(moi(), idNain).pos))!=LIBRE && pValide(gauche(info_nain(moi(), idNain).pos)) && type_case(gauche(info_nain(moi(), idNain).pos))==LIBRE)
    		{
    			if (team[idNain].cible.colonne > info_nain(moi(), idNain).pos.colonne)
    			{
    				if (type_case(bas(gauche(info_nain(moi(), idNain).pos)))!=LIBRE
    				|| type_case(bas(bas(gauche(info_nain(moi(), idNain).pos))))!=LIBRE
    				|| type_case(bas(bas(bas(gauche(info_nain(moi(), idNain).pos)))))!=LIBRE)
    				{
    					lacher(idNain);
    					deplacer(idNain, GAUCHE);
    					continue;
    				}
    			}
    		}
    		
    		auto truc = chemin(info_nain(moi(), idNain).pos, team[idNain].cible);
    		if (truc.size()>0)
    		{
    			direction whynot = truc[0];
    			agripper(idNain);
    			deplacer(idNain, whynot);
    		}
    		continue;
    	}
    }
    
    // Actions
    for (int idNain=0; idNain < NB_NAINS; idNain++)
    {
    	while (info_nain(moi(), idNain).pa >= COUT_MINER)
    	{
    		if (team[idNain].cible.colonne > info_nain(moi(), idNain).pos.colonne)
    		{
				position c = droite(info_nain(moi(), idNain).pos);
				if ( type_case(c)==GRANITE || (type_case(c)==LIBRE && nain_sur_case(c)==adversaire() ))
				{
					miner(idNain, DROITE);
					continue;
				}
    		}
    		if (team[idNain].cible.colonne < info_nain(moi(), idNain).pos.colonne)
    		{
				position c = gauche(info_nain(moi(), idNain).pos);
				if ( type_case(c)==GRANITE || (type_case(c)==LIBRE && nain_sur_case(c)==adversaire() ))
				{
					miner(idNain, GAUCHE);
					continue;
				}
    		}
    		if (team[idNain].cible.ligne > info_nain(moi(), idNain).pos.ligne)
    		{
				position c = bas(info_nain(moi(), idNain).pos);
				if ( (type_case(c)==GRANITE &&
				(type_case(bas(c))!=LIBRE || type_case(bas(bas(c)))!=LIBRE || type_case(bas(bas(bas(c))))!=LIBRE ) )
				|| (type_case(c)==LIBRE && nain_sur_case(c)==adversaire() ))
				{
					miner(idNain, BAS);
					continue;
				}
    		}
    		if (team[idNain].cible.ligne < info_nain(moi(), idNain).pos.ligne)
    		{
				position c = haut(info_nain(moi(), idNain).pos);
				if ( type_case(c)==GRANITE || (type_case(c)==LIBRE && nain_sur_case(c)==adversaire() ))
				{
					miner(idNain, HAUT);
					continue;
				}
    		}
    		position c = droite(info_nain(moi(), idNain).pos);
			if ( type_case(c)==GRANITE || (type_case(c)==LIBRE && nain_sur_case(c)==adversaire() ))
			{
				miner(idNain, DROITE);
				continue;
			}
			c = bas(info_nain(moi(), idNain).pos);
			if ( (type_case(c)==GRANITE && 
				(type_case(bas(c))!=LIBRE || type_case(bas(bas(c)))!=LIBRE || type_case(bas(bas(bas(c))))!=LIBRE ) )
				|| (type_case(c)==LIBRE && nain_sur_case(c)==adversaire() ))
			{
				miner(idNain, BAS);
				continue;
			}
			c=gauche(info_nain(moi(), idNain).pos);
			if ( type_case(c)==GRANITE || (type_case(c)==LIBRE && nain_sur_case(c)==adversaire() ))
			{
				miner(idNain, GAUCHE);
				continue;
			}
			c=haut(info_nain(moi(), idNain).pos);
			if ( type_case(c)==GRANITE || (type_case(c)==LIBRE && nain_sur_case(c)==adversaire() ))
			{
				miner(idNain, HAUT);
				continue;
			}
    		break;
		}
	}
}
void partie_fin()
{
}
