#include <bits/stdc++.h>
#include "prologin.hh"
using namespace std;

const int IFTY = 100*1000*1000;

int marque[TAILLE_MINE][TAILLE_MINE];

const int[4] directions = {HAUT, BAS, GAUCHE, DROITE};

struct objectif
{
    position pos;
    action_type action;
};

struct virtualNain
{
	nain vNain;
	int nbActs;
};


bool operator < (const& virtualNain A, const& virtualNain B)
{
	if (A.nbActs < B.nbActs)
		return true;
	else if ( A.nbActs == B.nbActs )
		return A.vNain.butin > B.vNain.butin ? true : false;
	else
		return false;
}

objectif objectifs[NB_NAINS];

bool adjacent(position pos1, position pos2)
{
    if (abs(pos1.ligne - pos2.ligne) + abs(pos1.colonne - pos2.colonne) ==1)
        return true;
    return false;
}

inline bool pValide(position pos){
return (pos.ligne>=0 && pos.ligne<TAILLE_MINE && pos.colonne>=0 && pos.colonne<TAILLE_MINE) ? true : false;
}

position droite(position pos)
{
	position ans;
	ans.ligne = pos.ligne;
	ans.colonne = pos.colonne + 1;
	return ans;
}

position gauche(position pos)
{
	position ans;
	ans.ligne = pos.ligne;
	ans.colonne = pos.colonne - 1;
	return ans;
}

position haut(position pos)
{
	position ans;
	ans.ligne = pos.ligne-1;
	ans.colonne = pos.colonne;
	return ans;
}

position bas(position pos)
{
	position ans;
	ans.ligne = pos.ligne+1;
	ans.colonne = pos.colonne;
	return ans;
}

vector<virtualNain> voisins(nbActions, const& curEtat)
{
	vector<virtualNain> ans;
	
	// Actions déplacement au mur

	// Droite
	if (type_case(droite(curEtat.vNain.pos))==LIBRE)
	{
		virtualNain d = curEtat;
		d.vNain.accroche = true;
		d.vNain.pos = droite(d.pos);
		d.nbActs += COUT_ESCALADER;
		ans.push_back(d);
	}
	// Gauche
	if (type_case(gauche(curEtat.vNain.pos))==LIBRE)
	{
		virtualNain g = curEtat;
		g.vNain.accroche = true;
		g.vNain.pos = gauche(g.pos);
		g.nbActs += COUT_ESCALADER;
		ans.push_back(g);
	}
	// Bas
	if (type_case(bas(curEtat.vNain.pos))==LIBRE)
	{	
		virtualNain b = curEtat;
		b.vNain.accroche = true;
		b.vNain.pos = bas(b.pos);
		b.nbActs += COUT_ESCALADER;
		ans.push_back(b);	
	}
	// Haut
	if (type_case(haut(curEtat.vNain.pos))==LIBRE)
	{
		virtualNain h = curEtat;
		h.vNain.accroche = true;
		h.vNain.pos = haut(h.pos);
		h.nbActs += COUT_ESCALADER;
		ans.push_back(h);	
	}
	
	// Actions déplacement au sol
	
	// Droite
	
	if (pValide(droite(curEtat.vNain.pos)) && type_case(droite(curEtat.vNain.pos))==LIBRE)
	{
		virtualNain d = curEtat;
		d.vNain.accroche = false;
		d.nbActs += COUT_DEPLACEMENT;
		d.vNain.pos = droite(d.vNain.pos);
		int chute = 0;
		while ( type_case(bas(d.vNain.pos))==LIBRE )
		{
			chute++;
			d.vNain.pos = bas(d.vNain.pos);
		}
		if (chute > 3)
			d.vNain.vie -= 1 << (chute-4);
		if (d.vNain.vie > 0)
			ans.push_back(d);
	}
	
	// Gauche
	
	if (pValide(gauche(curEtat.vNain.pos)) && type_case(gauche(curEtat.vNain.pos))==LIBRE)
	{
		virtualNain d = curEtat;
		d.vNain.accroche = false;
		d.nbActs += COUT_DEPLACEMENT;
		d.vNain.pos = gauche(d.vNain.pos);
		int chute = 0;
		while ( type_case(bas(d.vNain.pos))==LIBRE )
		{
			chute++;
			d.vNain.pos = bas(d.vNain.pos);
		}
		if (chute > 3)
			d.vNain.vie -= 1 << (chute-4);
		if (d.vNain.vie > 0)
			ans.push_back(d);
	}
	
	// Minage
	
	// en haut
	if (pValide(haut(curEtat.vNain.pos)) && type_case(haut(curEtat.vNain.pos)) == GRANITE)
	{
		virtualNain m = curEtat;
		minerai cailloux = info_minerai(haut(curEtat.vNain.pos));
		m.nbActs += cailloux.resistance*COUT_MINER;
		m.vNain.butin += cailloux.rendement;
		ans.push_back(m);
	} // en bas
	if (pValide(bas(curEtat.vNain.pos)) && type_case(bas(curEtat.vNain.pos)) == GRANITE)
	{
		virtualNain m = curEtat;
		minerai cailloux = info_minerai(bas(curEtat.vNain.pos));
		m.nbActs += cailloux.resistance*COUT_MINER;
		m.vNain.butin += cailloux.rendement;
		ans.push_back(m);
	} // à droite
	if (pValide(droite(curEtat.vNain.pos)) && type_case(droite(curEtat.vNain.pos)) == GRANITE)
	{
		virtualNain m = curEtat;
		minerai cailloux = info_minerai(droite(curEtat.vNain.pos));
		m.nbActs += cailloux.resistance*COUT_MINER;
		m.vNain.butin += cailloux.rendement;
		ans.push_back(m);
	} // à gauche
	if (pValide(gauche(curEtat.vNain.pos)) && type_case(gauche(curEtat.vNain.pos)) == GRANITE)
	{
		virtualNain m = curEtat;
		minerai cailloux = info_minerai(gauche(curEtat.vNain.pos));
		m.nbActs += cailloux.resistance*COUT_MINER;
		m.vNain.butin += cailloux.rendement;
		ans.push_back(m);
	}
	
	// Lâcher
	if (type_case(bas(curEtat.vNain.pos))==LIBRE)
	{
		virtualNain d = curEtat;
		d.vNain.accroche = false;
		d.nbActs += COUT_LACHER;
		d.vNain.pos = gauche(d.vNain.pos);
		int chute = 0;
		while ( type_case(bas(d.vNain.pos))==LIBRE )
		{
			chute++;
			d.vNain.pos = bas(d.vNain.pos);
		}
		if (chute > 3)
			d.vNain.vie -= 1 << (chute-4);
		if (d.vNain.vie > 0)
			ans.push_back(d);
	}
	
	// Déplacement sur corde
	// en bas
	if ( corde_sur_case(curEtat.vNain.pos) && corde_sur_case(bas(curEtat.vNain.pos)) )
	{
		virtualNain b = curEtat;
		b.vNain.pos = bas(b.pos);
		b.nbActs += COUT_ESCALADER_CORDE;
		ans.push_back(b);
	}  // en haut
	if ( corde_sur_case(curEtat.vNain.pos) && corde_sur_case(haut(curEtat.vNain.pos)) )
	{
		virtualNain b = curEtat;
		b.vNain.pos = haut(b.pos);
		b.nbActs += COUT_ESCALADER_CORDE;
		ans.push_back(b);
	}
	
	return ans;	
}

direction directOpti(nain etat)
{
	priority_queue<virtualNain> tas;
	
	virtualNain curNain;
	
	vector<virtualNain> marque; // Une action et le nb d'actions déjà effectués
	
	for (auto act : voisins(nbActions, curAction))
		tas.push(act);
	
	while (!tas.empty())
	{
		
	}
}

position mineraiPlusProcheNonTarget(position curPos)
{
    int distMin = IFTY;
    position minPos;
    for (int lig=0; lig<TAILLE_MINE; lig++)
    {
        for (int col=0; col<TAILLE_MINE; col++)
        {
            position posCible;
            posCible.ligne = lig;
            posCible.colonne = col;
            int curDist = chemin(curPos, posCible).size();
            if (curDist < distMin && type_case(posCible)==GRANITE
                && marque[col][lig]==-1)
            {
                minPos = posCible;
                distMin = curDist;
            }
        }
    }
    return minPos;
}

void partie_init()
{
    for (int i=0; i<TAILLE_MINE; i++)
    {
        for (int j=0; j<TAILLE_MINE; j++)
        {
            marque[i][j] = -1;
            position debug;
            debug.ligne = i;
            debug.colonne = j;
            debug_afficher_drapeau(debug, DRAPEAU_VERT); 
        }
    }

    for (int i=0; i<NB_NAINS; i++)
    {
        position posObj;
        posObj.ligne = -1;
        posObj.colonne = -1;
        objectifs[i].pos = posObj;
        objectifs[i].action = ACTION_AGRIPPER;
    }
}

void jouer_tour()
{
    debug_afficher_drapeau(position_taverne(moi()),DRAPEAU_BLEU);
    for (int idNain=0; idNain<NB_NAINS; idNain++)
    {
        nain curNain = info_nain(moi(), idNain);
        position posObj = objectifs[idNain].pos;
        fprintf(stderr, "moi: %d nain : %d x:%d y:%d objectif: (%d, %d)\n",
                moi(), idNain, curNain.pos.colonne, curNain.pos.ligne,
                posObj.colonne, posObj.ligne);
        if (posObj.ligne == -1  // Pas encore d'objectif
            || posObj == curNain.pos) // Nain retourné à la base
        {
            objectifs[idNain].pos = mineraiPlusProcheNonTarget(curNain.pos);
            marque[objectifs[idNain].pos.colonne][objectifs[idNain].pos.ligne] = idNain;
            objectifs[idNain].action = ACTION_MINER;
        }
        else if (objectifs[idNain].action == ACTION_MINER
                && adjacent(posObj, curNain.pos)) // On peut miner
        {
            if (posObj.ligne == curNain.pos.ligne + 1)
                miner(idNain, BAS);
            else if (posObj.ligne == curNain.pos.ligne-1)
                miner(idNain, HAUT);
            else if (posObj.colonne == curNain.pos.colonne+1)
                miner(idNain, DROITE);
            else
                miner(idNain, GAUCHE);
            if (type_case(posObj)==LIBRE)
            {
                objectifs[idNain].pos = position_taverne(moi());
                objectifs[idNain].action = ACTION_LACHER;
            }
        }
        else // Se déplacer vers l'objectif
        {
            direction dplct = chemin(curNain.pos, posObj)[0];
            agripper(idNain);
            deplacer(idNain, dplct);
        }
    }
}

void partie_fin()
{

}
