#include <bits/stdc++.h>
#include "prologin.hh"
using namespace std;

const int IFTY = 100*1000*1000;
const int MAXI = 1000*1000;

int marque[TAILLE_MINE][TAILLE_MINE];



//const int directions[4] = {HAUT, BAS, GAUCHE, DROITE};

struct objectif
{
    position pos;
    action_type action;
};

struct etat
{
	int id;
	pair<int,nain> position;
	int id_prec;
};

etat matrice[MAXI];
int GLBL_CNT=0;

/*
bool operator<(nain A, nain B)
{
	if (A.pm < B.pm)
		return true;
	else if ( A.pm == B.pm )
		return A.pa > B.pa ? true : false;
	else
		return false;
}
*/

bool operator < (etat A_, etat B_)
{
	pair<int,nain> A = A_.position;
	pair<int,nain> B = B_.position;
	if (A.first > B.first)
		return true;
	else if (A.first == B.first)
	{
		if (A.second.pm < B.second.pm )
			return true;
		else if (A.second.pm == B.second.pm)
		{
			if (A.second.pa < B.second.pa )
				return true;
		}
	}
	return false;
}

objectif objectifs[NB_NAINS];

bool adjacent(position pos1, position pos2)
{
    if (abs(pos1.ligne - pos2.ligne) + abs(pos1.colonne - pos2.colonne) ==1)
        return true;
    return false;
}

inline bool pValide(position pos){
return ( (pos.ligne>=0) && (pos.ligne<TAILLE_MINE) && (pos.colonne>=0) && (pos.colonne<TAILLE_MINE)) ? true : false;
}

position droite(position pos)
{
	position ans;
	ans.ligne = pos.ligne;
	ans.colonne = pos.colonne + 1;
	return ans;
}

position gauche(position pos)
{
	position ans;
	ans.ligne = pos.ligne;
	ans.colonne = pos.colonne - 1;
	return ans;
}

position haut(position pos)
{
	position ans;
	ans.ligne = pos.ligne-1;
	ans.colonne = pos.colonne;
	return ans;
}

position bas(position pos)
{
	position ans;
	ans.ligne = pos.ligne+1;
	ans.colonne = pos.colonne;
	return ans;
}

nain deplacerMur(nain n, direction dir)
{
	nain d = n;
	d.accroche = true;
	switch (dir)
	{
		case DROITE:
			d.pos = droite(d.pos);
			break;
		case GAUCHE:
			d.pos = gauche(d.pos);
			break;
		case BAS:
			d.pos = bas(d.pos);
			break;
		case HAUT:
			d.pos = haut(d.pos);
			break;
	}
	d.pm -= COUT_ESCALADER;
	return d;
}

vector<nain> voisins(nain curEtat)
{
	vector<nain> ans;
	
	// Actions déplacement au mur

	// Droite
	//fprintf(stderr, "droite de %d %d libre: %d\n", curEtat.pos.colonne, curEtat.pos.ligne,
	//type_case(droite(curEtat.pos))==LIBRE ? 1 : 0 );
	if (pValide(droite(curEtat.pos)) && type_case(droite(curEtat.pos))==LIBRE)
	{
		//cerr << "on tente d'escalader à droite" << endl;
		ans.push_back(deplacerMur(curEtat, DROITE));
	}
	// Gauche
	if (pValide(gauche(curEtat.pos))&&type_case(gauche(curEtat.pos))==LIBRE)
	{
		//cerr << "on a escladé à gauche\n";
		ans.push_back(deplacerMur(curEtat,GAUCHE));
	}
	// Bas
	if (pValide(bas(curEtat.pos))&&type_case(bas(curEtat.pos))==LIBRE)
	{	
		ans.push_back(deplacerMur(curEtat,BAS));
	}
	// Haut
	if (pValide(haut(curEtat.pos))&&type_case(haut(curEtat.pos))==LIBRE)
	{
		ans.push_back(deplacerMur(curEtat,HAUT));;	
	}
	
	// Actions déplacement au sol
	
	// Droite
	
	if (type_case(bas(curEtat.pos))!=LIBRE && pValide(droite(curEtat.pos)) && type_case(droite(curEtat.pos))==LIBRE)
	{
		nain d = curEtat;
		d.accroche = false;
		d.pm -= COUT_DEPLACEMENT;
		d.pos = droite(d.pos);
		int chute = 0;
		while ( type_case(bas(d.pos))==LIBRE )
		{
			chute++;
			d.pos = bas(d.pos);
		}
		if (chute > 3)
			d.vie -= 1 << (chute-4);
		if (d.vie > 0 && chute>0)
			ans.push_back(d);
	}
	
	// Gauche
	
	if (type_case(bas(curEtat.pos))!=LIBRE && pValide(gauche(curEtat.pos)) && type_case(gauche(curEtat.pos))==LIBRE)
	{
		nain d = curEtat;
		d.accroche = false;
		d.pm -= COUT_DEPLACEMENT;
		d.pos = gauche(d.pos);
		int chute = 0;
		while ( type_case(bas(d.pos))==LIBRE )
		{
			chute++;
			d.pos = bas(d.pos);
		}
		
		//cerr << "on a marché à gauche\n";
		//fprintf(stderr, "(v:%d pm:%d pa:%d x:%d y:%d)\n", d.vie, d.pm, d.pa, d.pos.colonne, d.pos.ligne);
		
		if (chute > 3)
			d.vie -= 1 << (chute-4);
		if (d.vie > 0)
			ans.push_back(d);
	}
	
	// Minage
	
	// en haut
	if (pValide(haut(curEtat.pos)) && type_case(haut(curEtat.pos)) == GRANITE)
	{
		//Debug
		//fprintf(stderr, "m.pa : %d ->  ",m.pa);
		//fprintf(stderr, "%d  ( cailloux.res*COUT_MINER = %d )\n", m.pa, cailloux.resistance*COUT_MINER);
		
		nain m = curEtat;
		minerai cailloux = info_minerai(haut(curEtat.pos));
		m.pa -= cailloux.resistance == -1 ? COUT_MINER : cailloux.resistance*COUT_MINER;
		m.butin += cailloux.rendement;
		ans.push_back(deplacerMur(m,HAUT));
	}

	// en bas
	
	//fprintf(stderr, "conditions pour miner en bas: %d %d\n",pValide(bas(curEtat.pos)), type_case(bas(curEtat.pos)) == GRANITE);
		
	if (pValide(bas(curEtat.pos)) && type_case(bas(curEtat.pos)) == GRANITE)
	{
		//cerr << "tentative de minage vertical descendant\n";
		nain m = curEtat;
		minerai cailloux = info_minerai(bas(curEtat.pos));
		m.pa -= cailloux.resistance == -1 ? COUT_MINER : cailloux.resistance*COUT_MINER;
		m.butin += cailloux.rendement;
		ans.push_back(deplacerMur(m,BAS));
	} 
	
	// à droite
	if (pValide(droite(curEtat.pos)) && type_case(droite(curEtat.pos)) == GRANITE)
	{
		nain m = curEtat;
		minerai cailloux = info_minerai(droite(curEtat.pos));
		m.pa -= cailloux.resistance == -1 ? COUT_MINER : cailloux.resistance*COUT_MINER;
		m.butin += cailloux.rendement;
		m.pos = droite(m.pos);
		ans.push_back(deplacerMur(m,DROITE));
	} 
	
	// à gauche
	if (pValide(gauche(curEtat.pos)) && type_case(gauche(curEtat.pos)) == GRANITE)
	{
		//cerr << "on mine à gauche" << endl;
		nain m = curEtat;
		minerai cailloux = info_minerai(gauche(curEtat.pos));
		//fprintf(stderr, "m.pa : %d ->  ",m.pa);
		m.pa -= cailloux.resistance == -1 ? COUT_MINER : cailloux.resistance*COUT_MINER;
		//fprintf(stderr, "%d  ( cailloux.res*COUT_MINER = %d )\n", m.pa, cailloux.resistance*COUT_MINER);
		m.butin += cailloux.rendement;
		ans.push_back(deplacerMur(m,GAUCHE));
	}
	
	// Lâcher
	if (type_case(bas(curEtat.pos))==LIBRE)
	{
		nain d = curEtat;
		d.accroche = false;
		d.pa -= COUT_LACHER;
		int chute = 0;
		while ( type_case(bas(d.pos))==LIBRE )
		{
			chute++;
			d.pos = bas(d.pos);
		}
		
		//fprintf(stderr, "On a lâché vers (v:%d pm:%d pa:%d x:%d y:%d)\n", d.vie, d.pm, d.pa, d.pos.colonne, d.pos.ligne);
		
		if (chute > 3)
			d.vie -= 1 << (chute-4);
		if (d.vie > 0)
			ans.push_back(d);
	}
	
	// Déplacement sur corde
	// en bas
	
	if ( corde_sur_case(curEtat.pos) && corde_sur_case(bas(curEtat.pos)) )
	{
		nain b = curEtat;
		b.pos = bas(b.pos);
		b.pm -= COUT_ESCALADER_CORDE;
		ans.push_back(b);
	}  // en haut
	if ( corde_sur_case(curEtat.pos) && corde_sur_case(haut(curEtat.pos)) )
	{
		nain b = curEtat;
		b.pos = haut(b.pos);
		b.pm -= COUT_ESCALADER_CORDE;
		ans.push_back(b);
	}
	
	//cerr << "Contenu de ans :\n";
	//for (auto nun: ans)
		//fprintf(stderr, "(v:%d pm:%d pa:%d x:%d y:%d)\n", nun.vie, nun.pm, nun.pa, nun.pos.colonne, nun.pos.ligne);
	
	return ans;	
}

etat dijkstra(nain curNain, position cible)
{
	//fprintf(stderr, "dijkstra lancé pour cible %d %d\n", cible.colonne, cible.ligne);
	priority_queue<etat> tas; // On stoque les paires (nbTours, etat)  ( etat=nain )
	
	nain nain_init;
	nain_init.vie = VIE_NAIN;
	nain_init.pos.ligne = 0;
	nain_init.pos.colonne = 0;
	nain_init.pm = NB_POINTS_DEPLACEMENT;
	nain_init.pa = NB_POINTS_ACTION;
	nain_init.butin = 0;
	nain_init.accroche = false;
	pair<int, nain> COUP_IFTY = {IFTY, nain_init};
	
	cerr << "là-bas" << endl;
	
	pair<int,nain> distance[TAILLE_MINE][TAILLE_MINE]; // Une action et le nb d'actions déjà effectués
	
	for (int i=0; i<TAILLE_MINE; i++)
	{
		for (int j=0; j<TAILLE_MINE; j++)
		{
			distance[i][j] = COUP_IFTY;
		}
	}
	etat initial;
	initial.position = {0,curNain};
	initial.id = GLBL_CNT;
	GLBL_CNT++;
	initial.id_prec = initial.id;
	matrice[initial.id] = initial;
	
	distance[curNain.pos.ligne][curNain.pos.colonne] = {0, curNain};
	
	//cerr << "voisins :" << endl;
	for (auto nun : voisins(curNain))
	{
		etat init;
		init.position = {0,nun};
		init.id = GLBL_CNT;
		init.id_prec = GLBL_CNT;
		GLBL_CNT++;
		matrice[init.id] = init;
		tas.push(init);
		//fprintf(stderr, "(v:%d pm:%d pa:%d x:%d y:%d) ", nun.vie, nun.pm, nun.pa, nun.pos.colonne, nun.pos.ligne);
	}
	//cerr << endl;
	
	while (!tas.empty())
	{
		etat curEtat = tas.top();
		pair<int,nain> coup = curEtat.position;
		tas.pop();
		if (!pValide(coup.second.pos))
			continue;
		fprintf(stderr, "curPos : %d %d\n", coup.second.pos.colonne, coup.second.pos.ligne);
		
		
		for (int i=0; i<TAILLE_MINE; i++)
		{
			for (int j=0; j<TAILLE_MINE; j++)
			{
				if (i==curNain.pos.ligne && j==curNain.pos.colonne)
					cerr << "D  ";
				else if (i==coup.second.pos.ligne && j==coup.second.pos.colonne)
					cerr << "¤  ";
				else if (distance[i][j]!=COUP_IFTY)
					cerr << "X  ";
				else
					cerr << ".  ";
			}
			cerr << endl;
		}		
		
		
		if (coup.second.pm<=0 || coup.second.pa <0)
		{
			while (coup.second.pm<=0 || coup.second.pa <0)
			{
				coup.first++;
				coup.second.pm += NB_POINTS_DEPLACEMENT;
				coup.second.pa += NB_POINTS_ACTION;
				if (coup.second.pm>NB_POINTS_DEPLACEMENT)
					coup.second.pm-=NB_POINTS_DEPLACEMENT;
				if (coup.second.pa>NB_POINTS_ACTION)
					coup.second.pa-=NB_POINTS_ACTION;
			}
		}
		if (coup.second.pos == cible)
		{
			cerr << "arrivé\n";
			while(curEtat.id_prec != initial.id)
			{
				curEtat = matrice[curEtat.id_prec];
			}
			return curEtat;
		}
		/*
		if (coup.first > 1)
		{
			cerr << "\n\n\nPLUS DE 6 !!\n\n\n";
			break;
			return -1;
		}
		*/
		
		fprintf(stderr, "(t:%d v:%d pm:%d pa:%d x:%d y:%d)\n",coup.first, coup.second.vie, coup.second.pm, coup.second.pa, coup.second.pos.colonne, coup.second.pos.ligne);
		
		cerr << distance[coup.second.pos.ligne][coup.second.pos.colonne].first << endl;
		
		if ( distance[coup.second.pos.ligne][coup.second.pos.colonne] < coup)
		{
			cerr << "Positions ajoutées :\n";
			distance[coup.second.pos.ligne][coup.second.pos.colonne] = coup;
			for (auto nun: voisins(coup.second))
			{
				fprintf(stderr, "(t:%d v:%d pm:%d pa:%d x:%d y:%d) ", coup.first, nun.vie, nun.pm, nun.pa, nun.pos.colonne, nun.pos.ligne);
				if (pair<int,nain>{coup.first, nun} > distance[nun.pos.ligne][nun.pos.colonne] )
				{
					etat nextEtat;
					nextEtat.position = {coup.first, nun};
					nextEtat.id = GLBL_CNT;
					GLBL_CNT++;
					nextEtat.id_prec = curEtat.id;
					matrice[nextEtat.id] = nextEtat;
					tas.push(nextEtat);
				}
			}
			/*
			else
			{
				//cerr << "Il y a déjà une meilleure manière d'arriver ici :" << endl;
				//pair<int,nain> coupO = distance[coup.second.pos.ligne][coup.second.pos.colonne];
				//fprintf(stderr, "(t:%d v:%d pm:%d pa:%d x:%d y:%d) ", coupO.first, coupO.second.vie, coupO.second.pm, coupO.second.pa, coupO.second.pos.colonne, coupO.second.pos.ligne);
			}
			*/
			cerr << endl << "--------------------------------------------" << endl << endl;
		}
	}
	etat E_IFTY;
	E_IFTY.position = COUP_IFTY;
	E_IFTY.id = GLBL_CNT;
	GLBL_CNT++;
	E_IFTY.id_prec = initial.id;
	matrice[E_IFTY.id] = E_IFTY;
	cerr << "on a return IFTY\n";
	return E_IFTY;
}

position mineraiPlusProcheNonTarget(position curPos)
{
    int distMin = IFTY;
    position minPos;
    for (int lig=0; lig<TAILLE_MINE; lig++)
    {
        for (int col=0; col<TAILLE_MINE; col++)
        {
            position posCible;
            posCible.ligne = lig;
            posCible.colonne = col;
            int curDist = chemin(curPos, posCible).size();
            if (curDist < distMin && type_case(posCible)==GRANITE
                && marque[col][lig]==-1)
            {
                minPos = posCible;
                distMin = curDist;
            }
        }
    }
    return minPos;
}

void partie_init()
{
    for (int i=0; i<NB_NAINS; i++)
    {
        position posObj;
        posObj.ligne = -1;
        posObj.colonne = -1;
        objectifs[i].pos = posObj;
        objectifs[i].action = ACTION_AGRIPPER;
    }
}

bool premier = true;

void jouer_tour()
{
    if (premier)
    {
    	premier = false;
    	position base = position_taverne(moi());
    	
    	nain nain_init;
		nain_init.vie = VIE_NAIN;
		nain_init.pos= base;
		nain_init.pm = NB_POINTS_DEPLACEMENT;
		nain_init.pa = NB_POINTS_ACTION;
		nain_init.butin = 0;
		nain_init.accroche = false;
		pair<int, nain> COUP_IFTY = {IFTY, nain_init};
        
        position debug;
        debug.ligne = 5;
        debug.colonne = 5;
        
        cerr << "debut\n";
        etat ans = dijkstra(nain_init, debug);
        cerr << ans.position.second.pos.ligne << " " << ans.position.second.pos.colonne << endl;
    	
    	/*
		for (int i=0; i<TAILLE_MINE; i++)
		{
		    for (int j=0; j<TAILLE_MINE; j++)
		    {
		        nain nain_init;
				nain_init.vie = VIE_NAIN;
				nain_init.pos= base;
				nain_init.pm = NB_POINTS_DEPLACEMENT;
				nain_init.pa = NB_POINTS_ACTION;
				nain_init.butin = 0;
				nain_init.accroche = false;
				pair<int, nain> COUP_IFTY = {IFTY, nain_init};
		        
		        position debug;
		        debug.ligne = i;
		        debug.colonne = j;
		        cerr << dijkstra(nain_init, debug) << "  ";
		    }
		    cerr << endl;
		}
		*/
		
		
    }
    
    /*
    debug_afficher_drapeau(position_taverne(moi()),DRAPEAU_BLEU);
    for (int idNain=0; idNain<NB_NAINS; idNain++)
    {
        nain curNain = info_nain(moi(), idNain);
        position posObj = objectifs[idNain].pos;
        fprintf(stderr, "moi: %d nain : %d x:%d y:%d objectif: (%d, %d)\n",
                moi(), idNain, curNain.pos.colonne, curNain.pos.ligne,
                posObj.colonne, posObj.ligne);
        if (posObj.ligne == -1  // Pas encore d'objectif
            || posObj == curNain.pos) // Nain retourné à la base
        {
            objectifs[idNain].pos = mineraiPlusProcheNonTarget(curNain.pos);
            marque[objectifs[idNain].pos.colonne][objectifs[idNain].pos.ligne] = idNain;
            objectifs[idNain].action = ACTION_MINER;
        }
        else if (objectifs[idNain].action == ACTION_MINER
                && adjacent(posObj, curNain.pos)) // On peut miner
        {
            if (posObj.ligne == curNain.pos.ligne + 1)
                miner(idNain, BAS);
            else if (posObj.ligne == curNain.pos.ligne-1)
                miner(idNain, HAUT);
            else if (posObj.colonne == curNain.pos.colonne+1)
                miner(idNain, DROITE);
            else
                miner(idNain, GAUCHE);
            if (type_case(posObj)==LIBRE)
            {
                objectifs[idNain].pos = position_taverne(moi());
                objectifs[idNain].action = ACTION_LACHER;
            }
        }
        else // Se déplacer vers l'objectif
        {
            direction dplct = chemin(curNain.pos, posObj)[0];
            agripper(idNain);
            deplacer(idNain, dplct);
        }
    }
    */
}

void partie_fin()
{
}
