#!/usr/bin/env python3
#codin: utf-8

from api import *
from queue import PriorityQueue

BLEAU = debug_drapeau.DRAPEAU_BLEU
NONE = debug_drapeau.AUCUN_DRAPEAU
VERT = debug_drapeau.DRAPEAU_VERT
ROUGE = debug_drapeau.DRAPEAU_ROUGE

GLISSADE = 0
MARCHE = 1

class MyCase:
    """ Class d'une case, la plupart des valeurs viennent de l'api.
        Les attribut servent pour dijkstra."""
    
    def __init__(self, pos, carte):
        """ Arguments:peau.DRAPEAU_BLEU)
                pos: (int, int), x, y
                carte: MyCarte, carte a qui appartien la case.
            Initialise.
        """
        self.carte = carte
        self.pos = pos
        self.resetDij()
    
    def getLibre(self):
        """ retour:
                bool, si la case est libre.
        """
        libre = type_case(self.pos)  == case_type.LIBRE
        agent = agent_sur_case(self.pos) != -1
        return libre and not agent
    
    libre = property(getLibre)
    
    def drapeau(self, couleur):
        """ Argument:
                couleur: debug_drapeau couleur du drapeau.
        """
        debug_afficher_drapeau(self.pos, couleur)
        
    def resetDij(self):
        """ Reset les cases pour dijkstra."""
        self.checkDij = False
        self.distDij = 0
        self.pereDij = None
        
    def getEdges(self):
        """ Retour:
                (MyCase, int)[]
        Retourne les cases atteignables depuis cette case avec leur distance."""
        x, y = self.pos
        ret = []
        if x > 0:
            if self.carte[x-1, y].libre:
                ret.append((self.carte[x-1, y], COUT_DEPLACEMENT))
            i = 0
            while x-i>0 and self.carte[x-1-i, y].libre: i+=1 
            ret.append((self.carte[x-i, y], COUT_GLISSADE))
        if y > 0:
            if self.carte[x, y-1].libre:
                ret.append((self.carte[x, y-1], COUT_DEPLACEMENT))
            i = 0
            while y-i>0 and self.carte[x, y-i-1].libre: i+=1
            ret.append((self.carte[x, y-i], COUT_GLISSADE))
        if y < TAILLE_BANQUISE-1:
            if self.carte[x, y+1].libre:
                ret.append((self.carte[x, y+1], COUT_DEPLACEMENT))
            i = 0
            while y+i < TAILLE_BANQUISE-1 and self.carte[x, y+i+1].libre: i+=1
            ret.append((self.carte[x, y+i], COUT_GLISSADE))
        if x < TAILLE_BANQUISE-1:
            if self.carte[x+1, y].libre:
                ret.append((self.carte[x+1, y], COUT_DEPLACEMENT))
            i = 0
            while x+i < TAILLE_BANQUISE-1 and self.carte[x+1+i, y].libre: i+=1
            ret.append((self.carte[x+i, y], COUT_GLISSADE))
        return ret
    
    edges = property(getEdges)
    

class MyMap:
    """ Class d'une map, construit et stock un graph representant la map. """
    
    
    def __init__(self):
        """ Initialise."""
        self.cases = [[MyCase((x,y), self) for x in range(TAILLE_BANQUISE)] for y in range(TAILLE_BANQUISE)]
        
    def afficheLibre(self):
        """ Fonction test, affiche les cases libres."""
        for x in range(TAILLE_BANQUISE):
            for y in range(TAILLE_BANQUISE):
                if self.cases[y][x].libre:
                    debug_afficher_drapeau((x,y), debug_drapeau.DRAPEAU_BLEU)

    def __getitem__(self, pos):
        """ Argument: 
                pos: (int, int), x, y
            return myCase, case x y de la map.
        """
        x, y = pos
        return self.cases[y][x]
    
    def dijkstra(self, dep, arr):
        """ Argument:
                dep: (int, int), x y de la case de depart.
                dep: (int, int), x y de la case d'arrivee.
            return int, (int,int)[], la plus courte distance et le plus court chemin. -1 si la case n'est pas atteignable.
        """
        caseDep = self[dep]
        caseArr = self[arr]
        q = PriorityQueue()
        tampon = 0 #Tampon pour les cases a egales distances.
        q.put((0, tampon, caseDep, (-1,-1))) # (distance, tampon, case, casePer)
        tampon += 1
        while not q.empty():
            dist, tmp, case, pere = q.get()
            if case.checkDij: continue
            case.checkDij = True
            case.distDij = dist
            case.pereDij = pere
            if case is caseArr:
                chemin = self.remonterChemin(case)
                self.resetDij()
                return dist, chemin
            edges = case.edges
            for node, pds in edges:
                if not node.checkDij:
                    q.put((dist+pds, tampon, node, case.pos))
                    tampon += 1
        self.resetDij()
        return -1, []
    
    def remonterChemin(self, caseDep):
        """ Argument:
                caseDep: MyCase, de de"part de la remonte.
            return: (int,int)[]
            Remonte le chemin laisse lors de Dij.
        """
        l = []
        pos = caseDep.pos
        while self[pos].pereDij != (-1, -1):
            l.append(pos)
            pos = self[pos].pereDij
        return [l[-i-1] for i in range(len(l))]

    def resetDij(self):
        """ Reset les cases pour dijkstra."""
        for l in self.cases:
            for c in l:
                c.resetDij()
        
                
    
