#!/usr/bin/env python3
#codin: utf-8


from api import *

""" Module avec des fonctions pour executer des consignes,
comme suivre un chemin.
"""

def capturee(alien):
    """ Arguments:
            alien: alien_info, info sur l'alien.
        return bool, si l'alien a ete capturee
    """
    return tour_actuel() >= alien.tour_invasion or alien_sur_case(alien.pos)

def reachable(alien, dist, pa):
    """ Arguments:
            alien: alien_info, info sur l'alien.
            dist: int, distance de l'alien au Tux.
            pa: int, les pa dispo ce tour.
        return (bool, int), si on peut rejoindres a temps et le nb de tour 
            pour le rejoindre.
        l'alien pour le capturer.
    """
    if dist == -1: return False, -1
    dureeTrajet = max((dist -pa + NB_POINTS_ACTION -1)//9, 0) 
    tourArrive = tour_actuel() + dureeTrajet
    departAlien = alien.tour_invasion + alien.duree_invasion
    return (tourArrive <= departAlien - NB_TOURS_CAPTURE), dureeTrajet

def tourDepart(alien):
    """ Arguments:
            alien: alien_info, info sur l'alien.
        return int, le tour de depart de l'alien.
    """
    return alien.tour_invasion + alien.duree_invasion

def toursAvantArrive(alien):
    """ Arguments:
            alien: alien_info, info sur l'alien.
        return int, nombre de tour restant avant l'arrive de l'alien
    """
    return alien.tour_invasion - tour_actuel() 


def suivreChemin(idJoueur, idAgent, chemin):
    """ Arguments:
            idJoueur: int, identifiant du joueur.
            idAgent: int, identifiant du Tux.
            chemin: (int, int)[], liste des differentes cases a rejoindres.
            
        Onh suppose le chemin valide.
    """
    if idJoueur != moi():
        return
    xTux, yTux = position_agent(idJoueur, idAgent)
    for x, y in chemin:
        pa = points_action_agent(idAgent)
        if (xTux, yTux) == (x,y):
            continue
        elif (xTux + 1, yTux) == (x,y) and pa >= COUT_DEPLACEMENT:
            deplacer(idAgent, direction.SUD)
        elif (xTux - 1, yTux) == (x,y) and pa >= COUT_DEPLACEMENT:
            deplacer(idAgent, direction.NORD)
        elif (xTux, yTux + 1) == (x,y) and pa >= COUT_DEPLACEMENT:
            deplacer(idAgent, direction.EST)
        elif (xTux, yTux - 1) == (x,y) and pa >= COUT_DEPLACEMENT:
            deplacer(idAgent, direction.OUEST)
        elif xTux == x and y > yTux and pa >= COUT_GLISSADE:
            glisser(idAgent, direction.EST)
        elif xTux == x and y < yTux and pa >= COUT_GLISSADE:
            glisser(idAgent, direction.OUEST)
        elif yTux == y and x < xTux and pa >= COUT_GLISSADE:
            glisser(idAgent, direction.NORD)
        elif yTux == y and x > xTux and pa >= COUT_GLISSADE:
            glisser(idAgent, direction.SUD)
        else:
            return
        xTux, yTux = x, y
            
            
