#!/usr/bin/env python3
#codin: utf-8


from api import *

""" Module avec des fonctions pour executer des consignes,
comme suivre un chemin.
"""
NORD = direction.NORD
SUD = direction.SUD
EST = direction.EST
OUEST = direction.OUEST

tNORD = (-1, 0)
tSUD = (1, 0)
tEST = (0, 1)
tOUEST = (0, -1)

DIRS = (NORD, SUD, EST, OUEST)
tDIRS = (tNORD, tSUD, tEST, tOUEST)

def addPos(pos1, pos2):
    x, y = pos1
    z, t = pos2
    return (x + z, y + t)

def subPos(pos1, pos2):
    x, y = pos1
    z, t = pos2
    return (x - z, y - t)

def alienNonCapture(alien):
    """ Arguments:
            alien: alien_info, info sur l'alien.
        return bool, si l'alien a ete capturee
    """
    alienPasEncoreLa = tour_actuel() < alien.tour_invasion
    return  alienPasEncoreLa or alien_sur_case(alien.pos)

def reachable(alien, dist, pa):
    """ Arguments:
            alien: alien_info, info sur l'alien.
            dist: int, distance de l'alien au Tux.
            pa: int, les pa dispo ce tour.
        return (bool, int), si on peut rejoindres a temps et le nb de tour 
            pour le rejoindre.
        l'alien pour le capturer.
    """
    if dist == -1: return False, -1
    if not alienNonCapture(alien): return False, -1
    dureeTrajet = max((dist -pa + NB_POINTS_ACTION -1)//9, 0) 
    tourArrive = tour_actuel() + dureeTrajet
    departAlien = alien.tour_invasion + alien.duree_invasion
    if dist == 0:
        return alien.tour_invasion + alien.duree_invasion - NB_TOURS_CAPTURE + alien.capture_en_cours > tour_actuel(), 0
    return (tourArrive <= departAlien - NB_TOURS_CAPTURE), dureeTrajet

def tourDepart(alien):
    """ Arguments:
            alien: alien_info, info sur l'alien.
        return int, le tour de depart de l'alien.
    """
    return alien.tour_invasion + alien.duree_invasion

def tourRestant(alien):
    """ Arguments:
            alien: alien_info, info sur l'alien.
        return int, nombre de tour restant a l'alien avant
            de disparraitre.
    """
    return alien.tour_invasion + alien.duree_invasion - tour_actuel()
    
def toursAvantArrive(alien):
    """ Arguments:
            alien: alien_info, info sur l'alien.
        return int, nombre de tour restant avant l'arrive de l'alien
    """
    return alien.tour_invasion - tour_actuel() 


def suivreChemin(idJoueur, idAgent, chemin):
    """ Arguments:
            idJoueur: int, identifiant du joueur.
            idAgent: int, identifiant du Tux.
            chemin: (int, int)[], liste des differentes cases a rejoindres.
            
        Onh suppose le chemin valide.
    """
    if idJoueur != moi():
        return
    xTux, yTux = position_agent(idJoueur, idAgent)
    for x, y in chemin:
        pa = points_action_agent(idAgent)
        if (xTux, yTux) == (x,y):
            continue
        elif (xTux + 1, yTux) == (x,y) and pa >= COUT_DEPLACEMENT:
            deplacer(idAgent, SUD)
        elif (xTux - 1, yTux) == (x,y) and pa >= COUT_DEPLACEMENT:
            deplacer(idAgent, NORD)
        elif (xTux, yTux + 1) == (x,y) and pa >= COUT_DEPLACEMENT:
            deplacer(idAgent, EST)
        elif (xTux, yTux - 1) == (x,y) and pa >= COUT_DEPLACEMENT:
            deplacer(idAgent, OUEST)
        elif xTux == x and y > yTux and pa >= COUT_GLISSADE:
            glisser(idAgent, EST)
        elif xTux == x and y < yTux and pa >= COUT_GLISSADE:
            glisser(idAgent, OUEST)
        elif yTux == y and x < xTux and pa >= COUT_GLISSADE:
            glisser(idAgent, NORD)
        elif yTux == y and x > xTux and pa >= COUT_GLISSADE:
            glisser(idAgent, SUD)
        else:
            return
        xTux, yTux = x, y
        
def coutChemin(idJoueur, idAgent, chemin):
    """ Arguments:
            idJoueur: int, identifiant du joueur.
            idAgent: int, identifiant du Tux.
            chemin: (int, int)[], liste des differentes cases a rejoindres.
        Retour: int, le coup en pa du chemin.
        Onh suppose le chemin valide.
    """
    xTux, yTux = position_agent(idJoueur, idAgent)
    cout = 0
    for x, y in chemin:
        if (xTux, yTux) == (x,y):
            continue
        elif (xTux + 1, yTux) == (x,y):
            cout += COUT_DEPLACEMENT
        elif (xTux - 1, yTux) == (x,y):
            cout += COUT_DEPLACEMENT
        elif (xTux, yTux + 1) == (x,y):
            cout += COUT_DEPLACEMENT
        elif (xTux, yTux - 1) == (x,y):
            cout += COUT_DEPLACEMENT
        elif xTux == x and y > yTux:
            cout += COUT_GLISSADE
        elif xTux == x and y < yTux:
            cout += COUT_GLISSADE
        elif yTux == y and x < xTux:
            cout += COUT_GLISSADE
        elif yTux == y and x > xTux:
            cout += COUT_GLISSADE
        else: return cout
        xTux, yTux = x, y
    return cout
            
            
