#!/usr/bin/env python3
#codin: utf-8

from api import *
from queue import PriorityQueue
import time

""" Module pour representert la map, 
    elle implemente notament une version de 
    dijkstra.
"""

DIPLAY_TIME = False

NORD = direction.NORD
SUD = direction.SUD
EST = direction.EST
OUEST = direction.OUEST

tNORD = (-1, 0)
tSUD = (1, 0)
tEST = (0, 1)
tOUEST = (0, -1)

DIRS = (NORD, SUD, EST, OUEST)
tDIRS = (tNORD, tSUD, tEST, tOUEST)

def addPos(pos1, pos2):
    x, y = pos1
    z, t = pos2
    return (x + z, y + t)

def subPos(pos1, pos2):
    x, y = pos1
    z, t = pos2
    return (x - z, y - t)

def aligne(pos1, pos2):
    x, y = pos1
    z, t = pos2
    return x == z or y == t

BLEAU = debug_drapeau.DRAPEAU_BLEU
NONE = debug_drapeau.AUCUN_DRAPEAU
VERT = debug_drapeau.DRAPEAU_VERT
ROUGE = debug_drapeau.DRAPEAU_ROUGE

class MyCase:
    """ Class d'une case, la plupart des valeurs viennent de l'api.
        Les attribut servent pour dijkstra."""
    
    def __init__(self, pos, carte):
        """ Arguments:peau.DRAPEAU_BLEU)
                pos: (int, int), x, y
                carte: MyCarte, carte a qui appartien la case.
            Initialise.
        """
        self.carte = carte
        self.pos = pos
        self.resetDij()
        self.resetDijTronq()
        self.virtuelle = False
        self.virtuellementLibre = -1 # -1: comme en normale, 0 en occupe, 1 libre

    def getLibre(self):
        """ retour:
                bool, si la case est libre.
        """
        if self.virtuelle and self.virtuellementLibre != -1:
            return bool(self.virtuellementLibre)
        libre = type_case(self.pos)  == case_type.LIBRE
        agent = agent_sur_case(self.pos) != -1
        return libre and not agent
    
    libre = property(getLibre)
    
    def drapeau(self, couleur):
        """ Argument:
                couleur: debug_drapeau couleur du drapeau.
        """
        debug_afficher_drapeau(self.pos, couleur)
        
    def resetDij(self):
        """ Reset les cases pour dijkstra."""
        self.checkDij = False
        self.distDij = 0
        self.pereDij = None
    
    def resetDijTronq(self):
        """ Reset les casqe pour le dijkstra tronque."""
        self.checkDijTronq = False
        self.distDijTronq = 0
        self.pereDijTronq = None
    
    def virtualisation(self):
        """ Rend la case vituelle."""
        self.virtuelle = True
    
    def devirtualisation(self):
        """ Rend retire l'etat virtuelle."""
        self.virtuelle = False
        self.virtuellementLibre = -1
        
    def getEdges(self):
        """ Retour:
                (MyCase, int)[]
        Retourne les cases atteignables depuis cette case avec leur distance."""
        x, y = self.pos
        ret = []
        if x > 0:
            if self.carte[x-1, y].libre:
                ret.append((self.carte[x-1, y], COUT_DEPLACEMENT))
            i = 0
            while x-i>0 and self.carte[x-1-i, y].libre: i+=1 
            ret.append((self.carte[x-i, y], COUT_GLISSADE))
        if y > 0:
            if self.carte[x, y-1].libre:
                ret.append((self.carte[x, y-1], COUT_DEPLACEMENT))
            i = 0
            while y-i>0 and self.carte[x, y-i-1].libre: i+=1
            ret.append((self.carte[x, y-i], COUT_GLISSADE))
        if y < TAILLE_BANQUISE-1:
            if self.carte[x, y+1].libre:
                ret.append((self.carte[x, y+1], COUT_DEPLACEMENT))
            i = 0
            while y+i < TAILLE_BANQUISE-1 and self.carte[x, y+i+1].libre: i+=1
            ret.append((self.carte[x, y+i], COUT_GLISSADE))
        if x < TAILLE_BANQUISE-1:
            if self.carte[x+1, y].libre:
                ret.append((self.carte[x+1, y], COUT_DEPLACEMENT))
            i = 0
            while x+i < TAILLE_BANQUISE-1 and self.carte[x+1+i, y].libre: i+=1
            ret.append((self.carte[x+i, y], COUT_GLISSADE))
        return ret
    
    edges = property(getEdges)
    

class MyMap:
    """ Class d'une map, construit et stock un graph representant la map. """
    
    
    def __init__(self):
        """ Initialise."""
        self.cases = [[MyCase((x,y), self) for x in range(TAILLE_BANQUISE)] for y in range(TAILLE_BANQUISE)]
        self.origineMap = (-1,-1)
        self.casesViruelles = [] #Listes des case virtuelles.
        
    def afficheLibre(self):
        """ Fonction test, affiche les cases libres."""
        for x in range(TAILLE_BANQUISE):
            for y in range(TAILLE_BANQUISE):
                if self[x,y].libre:
                    self[x,y].drapeau(BLEU)

    def __getitem__(self, pos):
        """ Argument: 
                pos: (int, int), x, y
            return myCase, case x y de la map.
        """
        x, y = pos
        return self.cases[y][x]

    def makeVirtuelle(self, pos, libre):
        """ Arguments:
                pos: (int, int), la pos de la cases a rendre virtuelle.
                libre: bool, si la case et virtuellement libre.
            Rend une case vituelle avec des proprietes virtuelles.
        """
        self[pos].virtualisation()
        if libre:
            self[pos].virtuellementLibre = 1
        else: self[pos].virtuellementLibre = 0
        self.casesViruelles.append(pos)
        
    def devirtualisation(self):
        """ Devitualise la map."""
        for pos in self.casesViruelles:
            self[pos].devirtualisation()
    
    def dijkstra(self, dep):
        """ Argument:
                dep: (int, int), x y de la case de depart.
            remplit la carte de facon a pouvoir acceder a la distance et 
            au plus court chemin vers tout points depuis dep.
        """
        self.resetDij()
        self.origineMap = dep
        caseDep = self[dep]
        q = PriorityQueue()
        tampon = 0 #Tampon pour les cases a egales distances.
        q.put((0, tampon, caseDep, (-1,-1))) # (distance, tampon, case, casePer)
        tampon += 1
        while not q.empty():
            dist, tmp, case, pere = q.get()
            if case.checkDij: continue
            case.checkDij = True
            case.distDij = dist
            case.pereDij = pere
            edges = case.edges
            for node, pds in edges:
                if not node.checkDij:
                    q.put((dist+pds, tampon, node, case.pos))
                    tampon += 1

    def dijkstraTronq(self, dep, distMax):
        """ Argument:
                dep: (int, int), x y de la case de depart.
                distMax: int, la distance maximal des chemins.
            Retour: ((int,int), (int,int))[] liste des cases atteignables 
                et des chemin associes une distance inferieur a celle donne.
            Ce dijkstra ce reset apres utilisation, il ne map pas la carte.
        """
        caseDep = self[dep]
        q = PriorityQueue()
        tampon = 0 #Tampon pour les cases a egales distances.
        q.put((0, tampon, caseDep, (-1,-1))) # (distance, tampon, case, casePer)
        tampon += 1
        cases = [dep]
        while not q.empty():
            dist, tmp, case, pere = q.get()
            if case.checkDijTronq: continue
            case.checkDijTronq = True
            case.distDijTronq = dist
            case.pereDijTronq = pere
            cases.append(case.pos)
            edges = case.edges
            for node, pds in edges:
                if not node.checkDij and dist+pds<= distMax:
                    q.put((dist+pds, tampon, node, case.pos))
                    tampon += 1
        ret = []
        for case in cases:
            if self[case].pereDijTronq == (-1,-1):
                ret.append((case, []))
            else:
                i = cases.index(self[case].pereDijTronq)
                ret.append((case, ret[i][1]+[case]))
        for case in cases:
            self[case].resetDijTronq()
        return ret
    
    def chemin(self, depart, arrivee):
        """ Arguments:
                depart: (int, int), x, y de la case de depart.
                arrivee: (int, int), de la case d'arrivee.
            retourn (dist, (int, int)[]) plus court chemin et plus 
            courte distance entre le depart et l'arrivee.
        """
        if DIPLAY_TIME: t = time.time()
        if self.origineMap != depart:
            self.dijkstra(depart)
        if self[arrivee].checkDij:
            if DIPLAY_TIME: print("CHEMIN: ", time.time() - t)
            return self[arrivee].distDij, self.remonterChemin(self[arrivee])
        else:
            if DIPLAY_TIME: print("CHEMIN: ", time.time() - t)
            return -1, []
    
    def remonterChemin(self, caseDep):
        """ Argument:
                caseDep: MyCase, de depart de la remonte (fin du chemin).
            return: (int,int)[]
            Remonte le chemin laisse lors de Dij.
        """
        l = []
        pos = caseDep.pos
        while self[pos].pereDij != (-1, -1):
            l.append(pos)
            pos = self[pos].pereDij
        return [l[-i-1] for i in range(len(l))]

    def resetDij(self):
        """ Reset les cases pour dijkstra."""
        for l in self.cases:
            for c in l:
                c.resetDij()
        self.origineMap = (-1,-1)

    def clean(self):
        """ Retire tout les drapeaux."""
        for l in self.cases:
            for c in l:
                c.drapeau(NONE)

    def afficherChemin(self, chemin):
        """ Argument:
                chemin: (int, int)[], liste des cases.
        """
        for c in chemin:
            self[c].drapeau(ROUGE)

    def casePourPousser(self, cible, virtuellesLibres = []):
        """ Argument:
                cible: (int, int), x y de la case sur laquelle ce trouve
                    la cible a pousser.
                virtuellesLibres: (int, int)[], liste des cases virtuellements
                    libre (pratiquement, celles des adversaires si on 
                    veut savoir si ils peuvent nous pousser et celle du joueur 
                    qui pousse.
            retour: ((int, int), direction)[], liste des  postions depuis
                lesquelles on peut pousser et la direction dans laquelle 
                pousser.
                
        """
        for c in virtuellesLibres: self.makeVirtuelle(c, True)
        origines = []
        x, y = cible
        if x !=0 and x != TAILLE_BANQUISE-1:
            if self[x-1, y].libre and self[x+1, y].libre:
                origines.append(((x-1, y), SUD))
                origines.append(((x+1, y), NORD))
        if y !=0 and y != TAILLE_BANQUISE-1:
            if self[x, y-1].libre and self[x, y+1].libre:
                origines.append(((x, y-1), EST))
                origines.append(((x, y+1), OUEST))
        self.devirtualisation()
        return origines
    
    def atteignableParGlissade(self, depart, arrivees):
        """ Arguments:
                depart: (int, int), x y pos cible.
                arrivees: (int, int)[], liste des pos des
                    cases a surveiller.
            Retour: direction[], les directions depuis les quelles on peut etre pousse.
            Test si les cases arrivees peuvent arriver
            au contact de depart en une glissade.
        """
        directionsARisque = []
        for i in range(4):
            v = tDIRS[i]
            pos = depart
            nouvelleCase = addPos(pos, v)
            while 0 <= nouvelleCase[0] < TAILLE_BANQUISE and 0 <= nouvelleCase[1] < TAILLE_BANQUISE  and self[nouvelleCase].libre:
                pos = nouvelleCase
                nouvelleCase = addPos(pos, v)
                if pos in arrivees: 
                    directionARisque.append(DIRS[i])
        return directionsARisque
    
    def destinationPousser(self, pos, direc):
        """ Arguments:
                pos: (int, int), pos de depart.
                direc: direction, la direction dans 
                    laquelle on pousse.
            Retourn la case d'arrive si on pousse 
            une entite en pos dans la direction dir.
        """
        i = DIRS.index(direc)
        vectDir = tDIRS[i]
        destiation = pos
        nouvelleCase = addPos(pos, vectDir)
        while 0 <= nouvelleCase[0] < TAILLE_BANQUISE and 0 <= nouvelleCase[1] < TAILLE_BANQUISE  and self[nouvelleCase].libre:
            destiation = nouvelleCase
            nouvelleCase = addPos(destiation, vectDir)
        return destiation
