#!/usr/bin/env python3
#codin: utf-8


from api import *
from myMap import *
from controles import *

"""
    Module gerant le comportement de l'ia.
"""

SUIVRE = 0
POUSSER = 1

ATTRAPEUR = 0
BATTEUR = 1
DEFENCEUR = 2
SOUTIEN = 3

COMPORTEMENTS = (ATTRAPEUR, BATTEUR, DEFENCEUR, SOUTIEN)
COMPORTEMENT_MOYEN = (1, 1, 1, 7)#(1, 1, 1, 3)

BONUS_SECURITE = 40
POIDS_DEFFENDRE_ALIEN = 100
POIDS_ASSER_PA_POUSSER = 10
POIDS_ENNEMIS_ALIGNE_SOUTIEN = 20
POIDS_ENNEMIS_ALIGNE_DEFENCE = 6
FACTEUR_POINTS = 2
BONUS_VIRER_ALIEN = 10

DIPLAY_TIME = False

class Joueur:
    """ Class qui joue. """
    
    def __init__(self):
        """ Initialisation."""
        self.myMap = MyMap()
        self.idAdv = adversaire()
        self.idJ = moi()
        self.aliens = liste_aliens()
        self.sommesTemps = 0
        self.pireTemps = 0
        self.nbTourComplet = 0
        
        self.testFunction = None
        self.pireTempsFonction = 0
        self.sommesTempsFonction = 0
    
    def jouer(self):
        """ Jouer un tour."""
        #self.myMap.clean()
        #print(("_."*9)[:-1])    
        if tour_actuel() == 98:
            print("Pire temps pour un tour:", self.pireTemps)
            print("Moyenne temps pour un tour:", self.sommesTemps/self.nbTourComplet)
            print("J'ai perdu le Jeu")
        t = time.time()
        for idAgent in range(NB_AGENTS):
            if DIPLAY_TIME: t2 = time.time()
            self.myMap[(0,0)].drapeau(ROUGE)
            self.tourAgent(idAgent, COMPORTEMENT_MOYEN)
            if time.time() -t > 0.75: return
        
            if DIPLAY_TIME: print(time.time() - t2)
            
        dt = time.time() - t
        if DIPLAY_TIME: print("Tour:", dt)
        self.pireTemps = max(self.pireTemps, dt)
        self.sommesTemps += dt
        self.nbTourComplet += 1

    def tourAgent(self, idAgent, comportement):
        """ Argument:
                idAgent: int, identifiant de l'agent.
                comportement: (int,int,int, int), les poids des differents comportements,
                    respectiement attraper, attaquer, defendre, soutenir.
            Tour d'un agent.
        """
        actions = []
        t = time.time()
        actions.extend(self.iaDefenceur(idAgent))
        if DIPLAY_TIME: print("DEFENCEUR: ", time.time()-t)
        t2 = time.time()
        if t2 - t > 0.2:
            self.execute(actions, comportement)
        actions.extend(self.iaSoutien(idAgent))
        if DIPLAY_TIME: print("SOUTIEN: ", time.time()-t2)
        t3 = time.time()
        if t3 - t > 0.2:
            self.execute(actions, comportement)
        actions.extend(self.iaBatteur(idAgent))
        if DIPLAY_TIME: print("BATTEUR: ", time.time()-t3)
        t4 = time.time()
        if t4 - t > 0.2:
            self.execute(actions, comportement)
        actions.extend(self.iaAttrappeur(idAgent))
        if DIPLAY_TIME: print("ATTRAPEUR: ", time.time()-t4)
        self.execute(actions, comportement)
        
    def execute(self, actions, comportement):
        """ Argument:
                actions: Action[], la liste des cation calculees.
        """
        if actions:
            action = max(actions, key=trieurAction(comportement))
            action.do()
    
    def iaBatteur(self, idAgent):
        """ Argument:
                idAgent: int, id du pinguin
            Retour: Action[], list des actions de ce type.
        Ia agressive d'un pour un pinguin."""
        posTux = position_agent(self.idJ, idAgent)
        actions = []
        for idBadTux in range(NB_AGENTS):
            cible = position_agent(self.idAdv, idBadTux)
            origines = self.myMap.casePourPousser(cible, [posTux])
            if not origines: continue
            bestDist, bestChemin = self.myMap.chemin(posTux, origines[0][0])
            bestDir = origines[0][1]
            for caseAdj, direct in origines:
                t = time.time()
                dist, chemin = self.myMap.chemin(posTux, caseAdj)
                if dist < bestDist or dist == -1:
                    bestDist = dist
                    bestChemin = chemin
                    bestDir = direct
            if bestDist == -1: continue
            self.myMap.makeVirtuelle(posTux, True)
            p = posTux
            if bestChemin: p = bestChemin[-1]
            self.myMap.makeVirtuelle(p, False)
            poids = self.poidsPousser(cible, idAgent, bestDist, bestDir)
            self.myMap.devirtualisation()
            action = Action(BATTEUR, idAgent, poids=poids, actions=[(SUIVRE, bestChemin), (POUSSER, bestDir)])
            paRestant = action.paRestant()
            if paRestant > 0:
                posEnnemis = []
                posPingu = posTux
                if bestChemin:
                    posPingu = bestChemin[-1]
                for idEnnemis in range(NB_AGENTS):
                    if idEnnemis == idBadTux:
                        p2 = self.myMap.destinationPousser(cible, bestDir)
                        posEnnemis.append(p2)
                    else: posEnnemis.append(position_agent(self.idAdv, idEnnemis))
                    
                self.myMap.makeVirtuelle(cible, True)
                self.myMap.makeVirtuelle(p2, False)
                self.myMap.makeVirtuelle(posTux, True)
                self.myMap.makeVirtuelle(posPingu, False)
                
                casesFinT = self.myMap.dijkstraTronq(posPingu, paRestant)
                casesFinTPond = []
                for case, chemin in casesFinT:
                    poids = 10
                    for pos in posEnnemis:
                        if aligne(pos, posPingu): poids -= POIDS_ENNEMIS_ALIGNE_DEFENCE
                    if alien_sur_case(case):
                        alien = info_alien(case)
                        if alien.points_capture < 0:
                            continue
                        if tourRestant(alien) > NB_TOURS_CAPTURE:
                            poids += alien.points_capture
                    casesFinTPond.append((poids, chemin))
                if casesFinTPond:
                    pds, chemin = max(casesFinTPond, key=lambda x: x[0])
                    action.poids += pds
                    action.actions.append((SUIVRE, chemin))
                self.myMap.devirtualisation()
            actions.append(action)
        return actions

    def iaAttrappeur(self, idAgent):
        """ Argument:
                idAgent: int, id du pinguin
            Retour: Action[], list des actions de ce type.
        Ia d'attrapeur d'un pour un pinguin."""
        posAdvs=[]
        for i in range(NB_AGENTS):
            posAdvs.append(position_agent(self.idAdv, i))
        posTux = position_agent(self.idJ, idAgent)
        actions = []
        for alien in self.aliens:
            if toursAvantArrive(alien) <= 3 and tourDepart(alien) >= tour_actuel() and alien.points_capture > 0:
                dist, chemin = self.myMap.chemin(posTux, alien.pos)
                if reachable(alien, dist, points_action_agent(idAgent))[0]:
                    self.myMap.makeVirtuelle(posTux, True)
                    self.myMap.makeVirtuelle(alien.pos, False)
                    poids = self.poidsCapture(alien, dist, posAdvs)
                    self.myMap.devirtualisation()
                    action = Action(ATTRAPEUR, idAgent, poids=poids, actions=[(SUIVRE, chemin)])
                    actions.append(action)
        return actions

    def iaDefenceur(self, idAgent):
        """ Arguments:
                idAgent: int, id de notre tux.
            Retour: Action[], list des actions de ce type.
            Ia defensive qui campe sur sa position et pousse tout 
            les puiguin ennemis adjascent.
        """
        posTux = position_agent(self.idJ, idAgent)
        actions = []
        pdCaseDef = 0
        if alien_sur_case(posTux):
            alien = info_alien(posTux)
            reach, d = reachable(alien, 0, 0)
            if reach and alien.points_capture > 0:
                pdCaseDef = POIDS_DEFFENDRE_ALIEN
                action = Action(DEFENCEUR, idAgent, poids=pdCaseDef, actions=[])
                actions.append(action)
            if alien.points_capture > 0: 
                pdCaseDef -= POIDS_DEFFENDRE_ALIEN
        for i in range(4):
            posCible = addPos(posTux, tDIRS[i])
            if agent_sur_case(posCible) == self.idAdv:
                poids = self.poidsPousser(posCible, idAgent, 0, DIRS[i]) + pdCaseDef
                action = Action(DEFENCEUR, idAgent, poids=poids, actions=[(POUSSER, DIRS[i])])
                actions.append(action)
        return actions

    def iaSoutien(self, idAgent):
        """ Argument:
                idAgent: int, identifiant de l'agent.
            Retour: Action[], list 113,des actions de ce type.
            Ia de soutien qui va ce placer de façon a empecher
            l'adversaire de pousser un allier.100
        """
        posAdvs = []
        for i in range(NB_AGENTS):
            posAdvs.append(position_agent(self.idAdv, i))
        posTux = position_agent(self.idJ, idAgent)
        actions = []
        casesSoutien = []
        for agentB in range(NB_AGENTS):
            if agentB == idAgent: continue
            else:
                self.myMap.makeVirtuelle(posTux, True)
                casesSoutien.extend(self.casesSoutien(position_agent(self.idJ, agentB), posAdvs))
                self.myMap.devirtualisation()
        for case, poids in casesSoutien:
            dist, chemin = self.myMap.chemin(posTux, case)
            if dist == -1: continue
            action = Action(SOUTIEN, idAgent, poids=poids-dist, actions=[(SUIVRE, chemin)])
            actions.append(action)
        return actions

    def poidsPousser(self, posAdv, idAgent, dist, direc):
        """ Arguments:
                posAdv: (int, int), x y de la cible a pousser.
                idAgent:int, l'identifiant de notre Tux.
                dist: int, la distance en np de pa de la case.
                direc: direction, la direction dans la quelle est
                    pousse l'ennemie
            Retour: int, represente l'avantage de pousser ce 
                tux. Plus la valeur est elevee, plus il est 
                iterresant de le pousser.
        """
        posArrive = self.myMap.destinationPousser(posAdv, direc)
        v = subPos(posAdv, posArrive)
        bonusAlien = 0
        if alien_sur_case(posAdv):
            alien = info_alien(posAdv)
            bonusAlien += alien.capture_en_cours * alien.points_capture + BONUS_VIRER_ALIEN
            if alien.points_capture < 0: return -10
        poids = max(abs(v[0]), abs(v[1]))/2 + bonusAlien
        peutPousser = COUT_POUSSER <= points_action_agent(idAgent) - 2*dist
        poids = (poids - dist)*3
        if peutPousser: poids += POIDS_ASSER_PA_POUSSER
        return poids

    def poidsCapture(self, alien, dist, posEnnemis):
        """ Argument:
                alien: alien_info, l'alien a capturer.
                dist: int, la distance a l'alien.
                posEnnemis: (int, int)[], pos des adversaires.
            Retour: int, le poids de la capture.
        """
        poids = FACTEUR_POINTS*alien.points_capture - dist - toursAvantArrive(alien)
        casesPouss = self.myMap.casePourPousser(alien.pos, virtuellesLibres=posEnnemis)
        securite = (1-len(casesPouss)/4)*BONUS_SECURITE
        return poids + securite
    
    def casesSoutien(self, pos, posAdvs):
        """ Argument:
                pos: (int, int), x y de la pos a deffendre.
                posAdvs: (int, int))[], liste des pos des adversaires.
            Retour:
                ((int, int), int)[], la pose et le poids de 
                la position.
        """
        if not(agent_sur_case(pos) == self.idJ and alien_sur_case(pos)):
            return []
        alien = info_alien(pos)
        poids = alien.capture_en_cours * alien.points_capture
        casesPourPousser = self.myMap.casePourPousser(pos, virtuellesLibres=posAdvs)
        posAdvs = []
        ret = []
        directionsARisque = self.myMap.atteignableParGlissade(pos, posAdvs)
        for case, direct in casesPourPousser:
            if (SUD in directionsARisque or NORD in directionsARisque) and direct in [SUD, NORD]:
                ret.append((case, poids+POIDS_ENNEMIS_ALIGNE_SOUTIEN*2))
            elif (EST in directionsARisque or OUEST in directionsARisque) and direct in [EST, OUEST]:
                ret.append((case, poids+POIDS_ENNEMIS_ALIGNE_SOUTIEN*2))
            else:
                ret.append((case, poids))
        return ret
        
    def testTempsFonction(self, fonction, *args, **kargs):
        """ Arguments:
                fonction:function, fonction a tester.
                *args, **kargs, ses arguments.
            Mesure le temps moyen et le pire temps de la fonction.
        """
        self.testFunction = fonction
        for i in range(10):
            t = time.time()
            fonction(*args, **kargs)
            dt = time.time() - t
            self.pireTempsFonction = max(self.pireTempsFonction, dt)
            self.sommesTempsFonction += dt

class Action:
    """ Class decrivant les actions a effectuer dans le tour d'un
        Agent."""
    
    def __init__(self, comportement, idAgent, poids=-1, actions=[]):
        """ Arguments: 
                comportement: intAction, comportement associee a 
                    l'action.
                idAgent: int, id de l'agent.
                poids: int, poids de l'action.
                action: (intAction, *): info sur les actions 
                    a effectuer.FACTEUR_POINTS
            Initialisation.
        """
        self.idAgent = idAgent
        self.comportement = comportement
        self.poids = poids
        self.actions = actions

    def do(self):
        """ Effectue le tour decrit."""
        #print(self.actions)
        for action in self.actions:
            typeAction = action[0]
            if typeAction == SUIVRE:
                chemin = action[1]
                suivreChemin(moi(), self.idAgent, chemin)
            elif typeAction == POUSSER:
                direc = action[1]
                pousser(self.idAgent, direc)
    
    def paRestant(self):
        """ Retourn le nombre de pa apres l'execution de cette action."""
        pa = NB_POINTS_ACTION
        for action in self.actions:
            typeAction = action[0]
            if typeAction == SUIVRE:
                chemin = action[1]
                pa -= coutChemin(moi(), self.idAgent, chemin)
            elif typeAction == POUSSER:
                pa -= COUT_POUSSER
        return pa

def trieurAction(comportement):
    """ Argument:
            comportement: (int,int,int), les poids des differents comportements,
                respectiement attraper, attaquer, defendre.
            retour: func Action ->int, fonction 'key' qui retourne le poids d'une
                action.
            Retourne la fonction servant a determiner le meilleur poids pour un 
            comportement donne.
    """
    def trieur(action):
        """ Argument:
                action: Action, action a effectuer.
            Retour: int, le poids de l'action.
        """
        i = COMPORTEMENTS.index(action.comportement)
        return action.poids * comportement[i]
    return trieur
            
    
    
