#!/usr/bin/env python3
#codin: utf-8


from api import *
from myMap import *
from controles import *
import time

"""
    Module gerant le comportement de l'ia.
"""

SUIVRE = 0
POUSSER = 1
ATTRAPEUR = 0
BATTEUR = 1
DEFENCEUR = 2

COMPORTEMENTS = (ATTRAPEUR, BATTEUR, DEFENCEUR)
COMPORTEMENT_MOYEN = (1, 1, 10)

POIDS_DEFFENDRE_ALIEN = 10
POIDS_ASSER_PA_POUSSER = 10


class Joueur:
    """ Class qui joue. """
    
    def __init__(self):
        """ Initialisation."""
        self.myMap = MyMap()
        self.idAdv = adversaire()
        self.idJ = moi()
        self.aliens = liste_aliens()
    
    def jouer(self):
        """ Jouer un tour."""
        self.myMap.clean()
        for idAgent in range(NB_AGENTS):
            self.tourAgent(idAgent, COMPORTEMENT_MOYEN)
                
    def tourAgent(self, idAgent, comportement):
        """ Argument:
                idAgent: int, identifiant de l'agent.
                comportement: (int,int,int), les poids des differents comportements,
                    respectiement attraper, attaquer, defendre.
            Tour d'un agent.
        """
        actions = []
        actions.extend(self.iaBatteur(idAgent))
        actions.extend(self.iaAttrappeur(idAgent))
        actions.extend(self.iaDefenceur(idAgent))
        if actions:
            action = max(actions, key=trieurAction(comportement))
            action.do()
            
    
    def iaBatteur(self, idAgent):
        """ Argument:
                idAgent: int, id du pinguin
            Retour: Action[], list des actions de ce type.
        Ia agressive d'un pour un pinguin."""
        posTux = position_agent(self.idJ, idAgent)
        actions = []
        for idBadTux in range(NB_AGENTS):
            cible = position_agent(self.idAdv, idBadTux)
            origines = self.myMap.casePourPousser(cible)
            if not origines: continue
            bestDist, bestChemin = self.myMap.chemin(posTux, origines[0][0])
            bestDir = origines[0][1]
            for caseAdj, direct in origines:
                dist, chemin = self.myMap.chemin(posTux, caseAdj)
                if dist < bestDist:
                    bestDist = dist
                    bestChemin = chemin
                    bestDir = direct
            poids = self.poidsPousser(cible, idAgent, bestDist, bestDir)
            action = Action(BATTEUR, idAgent, poids=poids, actions=[(SUIVRE, bestChemin), (POUSSER, bestDir)])
            actions.append(action)
        return actions

    def iaAttrappeur(self, idAgent):
        """ Argument:
                idAgent: int, id du pinguin
            Retour: Action[], list des actions de ce type.
        Ia d'attrapeur d'un pour un pinguin."""
        posTux = position_agent(self.idJ, idAgent)
        actions = []
        for alien in self.aliens:
            if toursAvantArrive(alien) <= 3 and tourDepart(alien) >= tour_actuel():
                dist, chemin = self.myMap.chemin(posTux, alien.pos)
                if reachable(alien, dist, points_action_agent(idAgent))[0]:
                    poids = 1.5*alien.points_capture - dist - toursAvantArrive(alien)*2
                    action = Action(ATTRAPEUR, idAgent, poids=poids, actions=[(SUIVRE, chemin)])
                    actions.append(action)
        return actions

    def iaDefenceur(self, idAgent):
        """ Arguments:
                idAgent: int, id de notre tux.
            Retour: Action[], list des actions de ce type.
            Ia defensive qui campe sur sa position et pousse tout 
            les puiguin ennemis adjascent.
        """
        posTux = position_agent(self.idJ, idAgent)
        actions = []
        pdCaseDef = 0
        if alien_sur_case(posTux):
            alien = info_alien(posTux)
            reach, d = reachable(alien, 0, 0)
            if reach:
                pdCaseDef = POIDS_DEFFENDRE_ALIEN
                poids = pdCaseDef
                action = Action(DEFENCEUR, idAgent, poids=poids, actions=[])
                actions.append(action)
        for i in range(4):
            posCible = addPos(posTux, tDIRS[i])
            if agent_sur_case(posCible) == self.idAdv:
                poids = self.poidsPousser(posCible, idAgent, 0, DIRS[i]) + pdCaseDef
                action = Action(DEFENCEUR, idAgent, poids=poids, actions=[(POUSSER, DIRS[i])])
                actions.append(action)
        return actions

    def poidsPousser(self, posAdv, idAgent, dist, direc):
        """ Arguments:
                posAdv: (int, int), x y de la cible a pousser.
                idAgent:int, l'identifiant de notre Tux.
                dist: int, la distance en np de pa de la case.
                direc: direction, la direction dans la quelle est
                    pousse l'ennemie
            Retour: int, represente l'avantage de pousser ce 
                tux. Plus la valeur est elevee, plus il est 
                iterresant de le pousser.
        """
        peutPousser = COUT_POUSSER <= points_action_agent(idAgent) - dist
        poidsPosArrive = self.myMap.poidsPousser(posAdv, direc)
        poids = (poidsPosArrive - dist)*3
        if peutPousser: poids += POIDS_ASSER_PA_POUSSER
        return poids

class Action:
    """ Class decrivant les actions a effectuer dans le tour d'un
        Agent."""
    
    def __init__(self, comportement, idAgent, poids=-1, actions=[]):
        """ Arguments: 
                comportement: intAction, comportement associee a 
                    l'action.
                idAgent: int, id de l'agent.
                poids: int, poids de l'action.
                action: (intAction, *): info sur les actions 
                    a effectuer.
            Initialisation.
        """
        self.idAgent = idAgent
        self.comportement = comportement
        self.poids = poids
        self.actions = actions

    def do(self):
        """ Effectue le tour decrit."""
        for action in self.actions:
            typeAction = action[0]
            if typeAction == SUIVRE:
                chemin = action[1]
                suivreChemin(moi(), self.idAgent, chemin)
            elif typeAction == POUSSER:
                direc = action[1]
                pousser(self.idAgent, direc)
    
    def paRestant(self):
        """ Retourn le nombre de pa apres l'execution de cette action."""
        pa = NB_POINTS_ACTION
        for action in self.actions:
            typeAction = action[0]
            if typeAction == SUIVRE:
                chemin = action[1]
                pa -= coutChemin(moi(), self.idAgent, chemin)
            elif typeAction == POUSSER:
                pa -= COUT_POUSSER
        return pa

def trieurAction(comportement):
    """ Argument:
            comportement: (int,int,int), les poids des differents comportements,
                respectiement attraper, attaquer, defendre.
            retour: func Action ->int, fonction 'key' qui retourne le poids d'une
                action.
            Retourne la fonction servant a determiner le meilleur poids pour un 
            comportement donne.
    """
    def trieur(action):
        """ Argument:
                action: Action, action a effectuer.
            Retour: int, le poids de l'action.
        """
        i = COMPORTEMENTS.index(action.comportement)
        return action.poids * comportement[i]
    return trieur
            
    
    
