from api import *
import random       # comme on le dit dans mon entreprise, c'est une véritable paille d'or

"""
Explorer de manière aléatoire la carte jusqu'à trouver éventuellement un bout de pain
Esquiver les obstacles potentiels (vérifier premièrement qu'il y a pas une troupe qui
vient foutre ses pattes sur mon passage, on me laisse passer moi, ça s'appelle du respect)
Ensuite passer en mode trouver un nid dès qu'on a suffisamment de pain, pareil toujours de manière random
car la vie est un long voyage dont on ne connaît ni le départ ni l'arrivée
Bien sûr plusieurs troupes seront mises en oeuvre parce que j'ai pas le temps de niaiser

PS : j'espère qu'il y aura davantage de techno dans la soirée.
PS 2 : plus de techno svp

Renaud BIRK <renaud.42@outlook.fr>
"""

cibles = ["PAIN" for _ in range(NB_TROUPES)]

# Fonction appelée au début de la partie.
def partie_init():
    # TODO
    pass


# Fonction appelée à chaque tour.
def jouer_tour():
    global cibles
    id_joueur = moi()
    troupes = troupes_joueur(id_joueur)

    for iAction in range(PTS_ACTION):
        iTroupe = iAction % NB_TROUPES
        troupe = troupes[iTroupe]
        mouvements_possibles = []
        case_optimale = None
        cases_a_verifier = cases_adjacentes(troupe.maman)
        action = None
        inv = 1 # TODO: change

        if cibles[iTroupe] == "PAIN":
            # ramener la troupe à la maison
            pains = []
            for case in cases_a_verifier:
                if case.contenu in [type_case.GAZON, type_case.PAPY, type_case.TROU, type_case.TUNNEL, type_case.NID] and not(canard_present(case.pos)):
                    if case.nb_pains > 0:
                        pains.append({"nb_pains": case.nb_pains, "case": case})
                    mouvements_possibles.append(case)
            if len(pains) > 0:
                case_optimale = max(pains, key = lambda x: x["nb_pains"])["case"]
        else:
            # ramener la maison dans la troupe 
            nids = []
            for case in cases_a_verifier:
                if case.contenu in [type_case.GAZON, type_case.TROU, type_case.TUNNEL] or (case.contenu == type_case.NID and (info_nid(case.pos) == 0 or info_nid(case.pos) == moi() - 1)) and not(canard_present(case.pos)):
                    if case.contenu == type_case.NID and (info_nid(case.pos) == 0 or info_nid(case.pos) == moi() - 1):
                        nids.append(case)
                    mouvements_possibles.append(case)
            if len(nids) > 0:
                case_optimale = nids[random.randint(0, len(nids) - 1)]
        
        # choisir un de ces mouvements au hasard et l'exécuter (si y en a pas, faire un move au pif pour se suicider mais c'est pas cool
        # la mort encore moins celle d'un canard)
        if case_optimale != None:
            #debug_poser_pigeon(case_optimale.pos, pigeon_debug.PIGEON_JAUNE)
            action = avancer(troupe.id, case_vers_direction(case_optimale, troupe))
        else:
            if len(mouvements_possibles) > 0:
                case_ou_avancer = mouvements_possibles[random.randint(0, len(mouvements_possibles) - 1)]
                debug_poser_pigeon(case_ou_avancer.pos, pigeon_debug.PIGEON_BLEU)
                action = avancer(troupe.id, case_vers_direction(case_ou_avancer, troupe))
            else:
                action = avancer(troupe.id, troupe.dir)
        if cibles[iTroupe] == "PAIN" and troupe.inventaire == inv and tour_actuel() > 0:
            cibles[iTroupe] = "NID"
        elif cibles[iTroupe] == "NID" and troupe.inventaire == 0 and (info_nid(case.pos) == 0 or info_nid(case.pos) == moi() - 1):
            cibles[iTroupe] = "PAIN"
        if action == None:
            action = avancer(troupe.id, troupe.dir)
        afficher_erreur(action)
    print()
    pass

def cases_adjacentes(position: Tuple[int, int, int]) -> List[etat_case]:
    cases = []
    colonne, ligne, niveau = position

    if colonne > 0:
        cases.append(info_case((colonne - 1, ligne, niveau)))
    if colonne < LARGEUR - 1:
        cases.append(info_case((colonne + 1, ligne, niveau)))
    if ligne > 0:
        cases.append(info_case((colonne, ligne - 1, niveau)))
    if ligne < HAUTEUR - 1:
        cases.append(info_case((colonne, ligne + 1, niveau)))
    
    return cases

def case_vers_direction(case: etat_case, _troupe: troupe):
    position_troupe, direction_troupe = _troupe.maman, _troupe.dir
    if case.pos[0] == position_troupe[0] - 1:
        #return rotation(direction_troupe, direction.OUEST)
        return direction.OUEST
    elif case.pos[0] == position_troupe[0] + 1:
        #return rotation(direction_troupe, direction.EST)
        return direction.EST
    elif case.pos[1] == position_troupe[1] - 1:
        #return rotation(direction_troupe, direction.NORD)
        return direction.SUD
    elif case.pos[1] == position_troupe[1] + 1:
        #return rotation(direction_troupe, direction.SUD)
        return direction.NORD
    else:
        print("problème lors du choix de la case")
        return direction.NORD

"""
def rotation(direction_actuelle, direction_desiree):
    if direction_actuelle == direction.NORD:
        return direction_desiree
    elif direction_actuelle == direction.OUEST:
        if direction_desiree == direction.OUEST:
            return direction.SUD
        elif direction_desiree == direction.SUD:
            return direction.EST
        elif direction_desiree == direction.EST:
            return direction.NORD
        elif direction_desiree == direction.NORD:
            return direction.OUEST
    elif direction_actuelle == direction.EST:
        if direction_desiree == direction.OUEST:
            return direction.NORD
        elif direction_desiree == direction.SUD:
            return direction.OUEST
        elif direction_desiree == direction.EST:
            return direction.SUD
        elif direction_desiree == direction.NORD:
            return direction.EST
    elif direction_actuelle == direction.SUD:
        if direction_desiree == direction.OUEST:
            return direction.EST
        elif direction_desiree == direction.SUD:
            return direction.NORD
        elif direction_desiree == direction.EST:
            return direction.OUEST
        elif direction_desiree == direction.NORD:
            return direction.SUD
"""

def canard_present(pos: Tuple[int, int, int]) -> bool:
    for troupe in troupes_joueur(moi()):
        if troupe.maman == pos:
            return True
        if pos in troupe.canards:
            return True
    for troupe in troupes_joueur(adversaire()):
        if troupe.maman == pos:
            return True
        if pos in troupe.canards:
            return True
    return False

# Fonction appelée à la fin de la partie.
def partie_fin():
    # TODO
    pass

"""
def test():
        a = trouver_chemin(t[0].maman, p[0])
        if len(a) > 0:
            j = avancer(1, a[0])
            afficher_erreur(j)
"""
