from api import *
from math import *

"""
Ma stratégie consiste à ramasser les pains les plus proches tant que la taille de l'inventaire le permet
puis les ramener dans le nid le plus proche de la troupe. Chaque troupe fonctionne indépendamment.
Le code fonctionne comme suit : lorsqu'une troupe n'est pas en mode_nid, elle cherche du pain. Une troupe
passe automatiquement en mode_nid dès que son inventaire est plein.
De plus, tous les tours (comptés à partir du tour 0), chaque troupe s'agrandit de 1.

Renaud BIRK <renaud.42@outlook.fr>
"""

mode_nid = [False for _ in range(NB_TROUPES)]

# Fonction appelée au début de la partie.
def partie_init():
    pass


# Fonction appelée à chaque tour.
def jouer_tour():
    global mode_nid
    
    objectif = liste_papy() if len(pains()) == 0 else pains()
    objectif_nids = liste_nids_disponibles()
    malus_grandir = 0

    #print(objectif, objectif_nids, sep='\n')

    # croissance périodique
    if (tour_actuel() + 1) % 5 == 0:
        for troupe in troupes_joueur(moi()):
            action = grandir(troupe.id)
        malus_grandir = COUT_CROISSANCE

    for iAction in range(NB_TROUPES * (PTS_ACTION - malus_grandir)):
        iTroupe = iAction % NB_TROUPES
        troupe = troupes_joueur(moi())[iTroupe]
        objectif_optimal = min(objectif_nids if mode_nid[iTroupe] else objectif, key=lambda pos: distance_min(pos, troupe, mode_nid[iTroupe])["dist"])
        dir = distance_min(objectif_optimal, troupe)["pos_optimale"]
        #print(objectif_optimal, dir)
        posActuelle = list(troupe.maman)

        action = None

        if dir != None:
            for elem in trouver_chemin(objectif_optimal, dir[0]):
                if elem == direction.NORD:
                    posActuelle[1] -= 1
                elif elem == direction.OUEST:
                    posActuelle[0] += 1
                elif elem == direction.EST:
                    posActuelle[0] -= 1
                elif elem == direction.SUD:
                    posActuelle[1] += 1
                debug_poser_pigeon(tuple(posActuelle), pigeon_debug.PIGEON_BLEU)

            if mode_nid[iTroupe]:
                not_stepped = True
                for case in cases_adjacentes(troupe.maman):
                    if info_nid(case[0].pos) in [etat_nid.LIBRE, moi() + 1]:
                        not_stepped = False
                        action = avancer(troupe.id, case[1])
                        debug_poser_pigeon(case[0].pos, pigeon_debug.PIGEON_ROUGE)
                        break   # cradingue
                if not_stepped:
                    action = avancer(troupe.id, dir[1])
            else:
                action = avancer(troupe.id, dir[1])

        mode_nid[iTroupe] = troupe.inventaire >= inventaire(troupe.taille)
    pass

# Fonction qui trouve la distance minimale et la position optimale à choisir comme prochain mouvement.
def distance_min(pos, troupe, autoriser_nids = False):
    pos_optimale, dist = None, 100 * 100 * 1000
    cases_a_verifier = cases_adjacentes(troupe.maman)

    cases_types = [type_case.GAZON, type_case.PAPY, type_case.TROU, type_case.TUNNEL]
    if autoriser_nids:
        cases_types.append(type_case.NID)

    for case, orient in cases_a_verifier:
        if autoriser_nids and info_nid(pos) in [etat_nid.LIBRE, moi() + 1]:
            pos_optimale = (case.pos, orient)
            dist = 0
        if (case.contenu in cases_types or info_barriere(case.pos) == 0) and not(canard_present(case.pos)):
            if pos_optimale == None:
                pos_optimale = (case.pos, orient)
                dist = len(trouver_chemin(pos_optimale[0], pos))
            else:
                temp = len(trouver_chemin(case.pos, pos))
                if temp < dist:
                    pos_optimale = (case.pos, orient)
                    dist = temp

    return {"dist": dist, "pos_optimale": pos_optimale}

# Fonction qui trouve toutes les cases adjacentes où une troupe pourrait se déplacer
# (avant de vérifier le type de bloc)
def cases_adjacentes(position: Tuple[int, int, int]):
    cases = []
    colonne, ligne, niveau = position

    if colonne > 0:
        cases.append((info_case((colonne - 1, ligne, niveau)), direction.OUEST))
    if colonne < LARGEUR - 1:
        cases.append((info_case((colonne + 1, ligne, niveau)), direction.EST))
    if ligne > 0:
        cases.append((info_case((colonne, ligne - 1, niveau)), direction.SUD))
    if ligne < HAUTEUR - 1:
        cases.append((info_case((colonne, ligne + 1, niveau)), direction.NORD))
    
    return cases

# Fonction qui renvoie toutes les positions des papys présents sur la carte.
def liste_papy():
    papys = []

    for colonne in range(LARGEUR):
        for ligne in range(HAUTEUR):
            if info_case((colonne, ligne, 0)).contenu == type_case.PAPY:
                papys.append((colonne, ligne, 0))
    
    return papys

# Fonction qui renvoie toutes les positions des nids disponibles.
def liste_nids_disponibles():
    nids = []
    for iLigne in range(HAUTEUR):
        for iColonne in range(LARGEUR):
            pos = info_case((iColonne, iLigne, 0)).pos
            if info_nid(pos) in [etat_nid.LIBRE, moi() + 1]:
                nids.append(pos)
    return nids

# Fonction qui renvoie vrai si un canard est présent.
def canard_present(pos: Tuple[int, int, int]) -> bool:
    for troupe in troupes_joueur(moi()):
        if troupe.maman == pos:
            return True
        if pos in troupe.canards:
            return True
    for troupe in troupes_joueur(adversaire()):
        if troupe.maman == pos:
            return True
        if pos in troupe.canards:
            return True
    return False

# Fonction appelée à la fin de la partie.
def partie_fin():
    pass
