# coding: utf-8
# This file has been generated, if you wish to
# modify it in a permanent way, please refer
# to the script file : gen/generator_python.rb

'''
****************************

Mon champion commence par souhaiter bonne chance à son adversaire.

Puis, il fait à chaque tour :
 - chaque agent sur un alien y reste, et pousse un agent adverse s'il y en a un.
 - jusqu'à utiliser chaque agent, on calcule par Dijkstra, limité à NB_POINTS_ACTION points, avec une fonction de score, quel est le meilleur coup à jouer(pour cette fonction de score) + éxécuter ce coup.

Enfin, mon champion finit par féliciter son adversaire.

****************************

****************************

J'ai essayé de protéger mes agents(qui capturaient un alien) en fonction de la configuration de la map autour de l'alien en question, mais sans succès.

****************************

****************************

Avec plus de temps, j'aurais fait un Dijkstra qui va plus loin et une fonction de score plus performante, qui prendrait plus de paramètres en compte.

****************************

P.S. : Malgré la propagande musicale, n'oublions pas qu'on est VENDREDI, et que la musique de Code Lyoko a quelque chose de différent en serbe.
'''


from api import *
from heapq import *
from random import *

# Fonction appelée au début de la partie.
def partie_init():
	print('HAVE FUN, GOOD LUCK')
	pass


# Fonction appelée à chaque tour.
def jouer_tour():
	Agents=[(k,position_agent(moi(),k)) for k in range(NB_AGENTS)]
	for agent in Agents:
		if alien_sur_case(agent[1]) and info_alien(agent[1]).points_capture>0:
			Agents.remove(agent)
			pousser_alien(agent)
		elif alien_sur_case(agent[1]) and info_alien(agent[1]).points_capture>0:
			for voisin in cases_adj(agent[1]):
				if agent_sur_case(voisin[0])!=-1 and info_alien(agent[1]).capture_en_cours==NB_TOURS_CAPTURE-1 and agent_sur_case((2*voisin[0][0]-agent[1][0],2*voisin[0][1]-agent[1][1]))==-1 and type_case((2*voisin[0][0]-agent[1][0],2*voisin[0][1]-agent[1][1]))==case_type.LIBRE:
					Agents.remove(agent)
					pousser(agent[0],voisin[1])
					deplacer(agent[0],voisin[1])				
	n=len(Agents)
	for k in range(n):
		interm=[]
		for agent in Agents:
			interm.append((agent[0],position_agent(moi(),agent[0])))
		Agents=interm
		Carte=Carte_construction()
		ListeDijkstra=[(agent[0],dijkstra(agent[1][0],agent[1][1],NB_POINTS_ACTION,Carte,points)) for agent in Agents]
		maxi=0
		pos_maxi=(0,0)
		agent_maxi=(0,0)
		for num,L in enumerate(ListeDijkstra):
			for i in range(TAILLE_BANQUISE):
				for j in range(TAILLE_BANQUISE):
					if L[1][i][j][5]!={} and L[1][i][j][5]['points']>maxi:
						maxi=L[1][i][j][5]['points']
						pos_maxi=L[1][i][j][5]['pos']
						agent_maxi=(L[0],num)
		if maxi>0:
			Liste_action=[]
			pred=pos_maxi
			pred_info=ListeDijkstra[agent_maxi[1]][1][pred[0]][pred[1]][5]
			while pred!=position_agent(moi(),agent_maxi[0]) or pred_info['ajout']>0:
				if pred_info['ajout']==COUT_DEPLACEMENT:
					Liste_action.append(('deplacer',pred_info['direction']))
				elif pred_info['ajout']==COUT_GLISSADE:
					Liste_action.append(('glisser',pred_info['direction']))
				elif pred_info['ajout']!=0:
					Liste_action.append(('pousser',pred_info['direction pousser']))
					if pred_info['ajout']==COUT_DEPLACEMENT+COUT_POUSSER:
						Liste_action.append(('deplacer',pred_info['direction']))
					elif pred_info['ajout']==COUT_POUSSER+COUT_GLISSADE:
						Liste_action.append(('glisser',pred_info['direction']))
					ListeDijkstra[agent_maxi[1]][1][pred_info['pos'][0]][pred_info['pos'][1]][5]['ajout']=0
				pred=pred_info['pred']
				pred_info=ListeDijkstra[agent_maxi[1]][1][pred[0]][pred[1]][5]
			Agents.remove((agent_maxi[0],position_agent(moi(),agent_maxi[0])))
			for i in range(len(Liste_action)-1,-1,-1):
				if Liste_action[i][0]=='deplacer':
					deplacer(agent_maxi[0],Liste_action[i][1])
				elif Liste_action[i][0]=='glisser':
					glisser(agent_maxi[0],Liste_action[i][1])
				else:
					pousser(agent_maxi[0],Liste_action[i][1])
		else:
			ListeDijkstra2=[(agent[0],dijkstra2(agent[1][0],agent[1][1],2*NB_POINTS_ACTION,Carte,points2)) for agent in Agents]
			maxi=0
			pos_maxi=(0,0)
			agent_maxi=(0,0)
			for num,L in enumerate(ListeDijkstra):
				for i in range(TAILLE_BANQUISE):
					for j in range(TAILLE_BANQUISE):
						if L[1][i][j][5]!={} and L[1][i][j][5]['points']>maxi:
							maxi=L[1][i][j][5]['points']
							pos_maxi=L[1][i][j][5]['pos']
							agent_maxi=(L[0],num)
			if maxi>0:
				Liste_action=[]
				pred=pos_maxi
				while pred!=position_agent(moi(),agent_maxi[0]):
					pred_info=ListeDijkstra[agent_maxi[1]][1][pred[0]][pred[1]][5]
					if pred_info['ajout']==COUT_DEPLACEMENT:
						Liste_action.append(('deplacer',pred_info['direction']))
					elif pred_info['ajout']==COUT_GLISSADE:
						Liste_action.append(('glisser',pred_info['direction']))
					pred=pred_info['pred']
				Agents.remove((agent_maxi[0],position_agent(moi(),agent_maxi[0])))
				cout=0
				while cout<NB_POINTS_ACTION:
					if Liste_action[i][0]=='deplacer' and cout+COUT_DEPLACEMENT<NB_POINTS_ACTION+1:
						deplacer(agent_maxi[0],Liste_action[i][1])
						cout+=COUT_DEPLACEMENT
					elif Liste_action[i][0]=='glisser' and cout+COUT_GLISSADE<NB_POINTS_ACTION+1:
						glisser(agent_maxi[0],Liste_action[i][1])
						cout+=COUT_GLISSADE
					else:
						cout=NB_POINTS_ACTION
			else:
				Agents.remove((Agents[0][0],position_agent(moi(),Agents[0][0])))
				A=[direction.EST,direction.NORD,direction.OUEST,direction.SUD]
				l=choice(A)
				deplacer(ListeDijkstra[0][0],l)
				deplacer(ListeDijkstra[0][0],l)
				deplacer(ListeDijkstra[0][0],l)
				l=choice(A)
				deplacer(ListeDijkstra[0][0],l)
				deplacer(ListeDijkstra[0][0],l)
				l=choice(A)
				deplacer(ListeDijkstra[0][0],l)
				deplacer(ListeDijkstra[0][0],l)
				deplacer(ListeDijkstra[0][0],l)
	pass


# Fonction appelée à la fin de la partie.
def partie_fin():
	print('GG xD')
	pass


def Carte_construction():
	Carte=dict()
	for i in range(TAILLE_BANQUISE):
		for j in range(TAILLE_BANQUISE):
			if type_case((i,j))==case_type.LIBRE:
				Carte[(i,j)]=voisins(i,j)
	return Carte


def voisins(i,j):
	L=[]
	if i>0:
		if type_case((i-1,j))==case_type.LIBRE and agent_sur_case((i-1,j))==-1:
			L.append({'direction':direction.NORD, 'pos':(i-1,j), 'cout':COUT_DEPLACEMENT})
			if i>1:
				k=i-2
				while k>-1 and type_case((k,j))==case_type.LIBRE and agent_sur_case((k,j))==-1:
					k-=1
				if k!=i-2:
					L.append({'direction':direction.NORD, 'pos':(k+1,j), 'cout':COUT_GLISSADE})
	if i<TAILLE_BANQUISE-1:
		if type_case((i+1,j))==case_type.LIBRE and agent_sur_case((i+1,j))==-1:
			L.append({'direction':direction.SUD, 'pos':(i+1,j), 'cout':COUT_DEPLACEMENT})
			if i<TAILLE_BANQUISE-2:
				k=i+2
				while k<TAILLE_BANQUISE and type_case((k,j))==case_type.LIBRE and agent_sur_case((k,j))==-1:
					k+=1
				if k!=i+2:
					L.append({'direction':direction.SUD, 'pos':(k-1,j), 'cout':COUT_GLISSADE})
	if j>0:
		if type_case((i,j-1))==case_type.LIBRE and agent_sur_case((i,j-1))==-1:
			L.append({'direction':direction.OUEST, 'pos':(i,j-1), 'cout':COUT_DEPLACEMENT})
			if j>1:
				k=j-2
				while k>-1 and type_case((i,k))==case_type.LIBRE and agent_sur_case((i,k))==-1:
					k-=1
				if k!=j-2:
					L.append({'direction':direction.OUEST, 'pos':(i,k+1), 'cout':COUT_GLISSADE})
	if j<TAILLE_BANQUISE-1:
		if type_case((i,j+1))==case_type.LIBRE and agent_sur_case((i,j+1))==-1:
			L.append({'direction':direction.EST, 'pos':(i,j+1), 'cout':COUT_DEPLACEMENT})
			if j<TAILLE_BANQUISE-2:
				k=j+2
				while k<TAILLE_BANQUISE and type_case((i,k))==case_type.LIBRE and agent_sur_case((i,k))==-1:
					k+=1
				if k!=j+2:
					L.append({'direction':direction.EST, 'pos':(i,k-1), 'cout':COUT_GLISSADE})
	return L
	

def dijkstra(i,j,val_max,Carte,f):
	Visites=[[(0,0,0,0,0,{}) for _ in range(TAILLE_BANQUISE)]for _ in range(TAILLE_BANQUISE)]
	A_visites=[(0,i,j,i,j,{'pos':(i,j),'pred':(i,j),'points':f(i,j),'ajout':0,'direction':direction.NORD})]
	while len(A_visites)>0:
		case=heappop(A_visites)
		x,y=case[5]['pos']
		if Visites[x][y][5]=={}:
			if case[0]<1+NB_POINTS_ACTION-COUT_POUSSER:
				(b,direct,val,tour)=pousser_alien_possible(x,y)
				if b:
					case=(case[0]+COUT_POUSSER,case[1],case[2],case[3],case[4],{'pos':(x,y),'pred':case[5]['pred'],'points':case[5]['points']+4*(1+tour)*val,'ajout':case[5]['ajout']+COUT_POUSSER,'direction':case[5]['direction'],'direction pousser':direct})
			Visites[x][y]=case
			for voisin in Carte[(x,y)]:
				(pos1,pos2)=voisin['pos']
				if Visites[pos1][pos2][5]=={} and case[0]+voisin['cout']<1+val_max:
					points=f(pos1,pos2)
					if 'direction pousser' in Visites[x][y][5].keys():
						heappush(A_visites,(case[0]+voisin['cout'],x,y,pos1,pos2,{'pos':(pos1,pos2),'pred':(x,y),'points':points+Visites[x][y][5]['direction pousser'],'ajout':voisin['cout'],'direction':voisin['direction']}))
					else:
						heappush(A_visites,(case[0]+voisin['cout'],x,y,pos1,pos2,{'pos':(pos1,pos2),'pred':(x,y),'points':points,'ajout':voisin['cout'],'direction':voisin['direction']}))
	return Visites


def points(i,j):
	a=30*(info_alien((i,j)).points_capture+1)
	if a==0:
		for case in cases_adj(i,j):
			b=agent_sur_case(case[0])
			if b==moi() and alien_sur_case(case[0]):
				autre_cote=3
				if type_case((2*i-case[0][0],2*j-case[0][1]))!=case_type.LIBRE:
					autre_cote=1/2
				elif agent_sur_case((2*i-case[0][0],2*j-case[0][1]))!=-1:
					autre_cote=5
				a+=1/4*info_alien(case[0]).points_capture*autre_cote
			elif b==adversaire() and alien_sur_case(case[0]):
				a+=3/5*info_alien(case[0]).points_capture
	return a


def pousser_alien(agent):
	k,(x,y)=agent
	b=True
	Cases=cases_adj(x,y)
	k=0
	while b and k<len(Cases):
		if agent_sur_case(Cases[k][0])==adversaire() and agent_sur_case((2*Cases[k][0][0]-x,2*Cases[k][0][1]-y))==-1 and type_case((2*Cases[k][0][0]-x,2*Cases[k][0][1]-y))==case_type.LIBRE:
			pousser(k,Cases[k][1])
			b=False
		k+=1


def cases_adj(x,y):
	L=[]
	if x>0:
		L.append(((x-1,y),direction.NORD))
	if x<TAILLE_BANQUISE-1:
		L.append(((x+1,y),direction.SUD))
	if y>0:
		L.append(((x,y-1),direction.OUEST))
	if y<TAILLE_BANQUISE-1:
		L.append(((x,y+1),direction.EST))
	return L


def pousser_alien_possible(x,y):
	possible=(False,direction.NORD,0,0)
	for case in cases_adj(x,y):
		if (alien_sur_case(case[0]) or alien_sur_case((x,y))) and  agent_sur_case(case[0])==adversaire():
			case_suiv=(2*case[0][0]-x,2*case[0][1]-y)
			if type_case(case_suiv)==case_type.LIBRE and agent_sur_case(case_suiv)==-1:
				possible=(True,case[1],info_alien(case[0]).points_capture,info_alien(case[0]).capture_en_cours)
	return possible


def prochains_aliens():
	prochains=[]
	for alien in liste_aliens():
		if tour_actuel()<alien.tour_invasion<tour_actuel()+5:
			score=30*alien.points_capture/(alien.tour_invasion-tour_actuel())
			prochains.append((score,alien))
	return prochains


def dijkstra2(i,j,val_max,Carte,f):
	prochains=prochains_aliens()
	Visites=[[(0,0,0,0,0,{}) for _ in range(TAILLE_BANQUISE)]for _ in range(TAILLE_BANQUISE)]
	A_visites=[(0,i,j,i,j,{'pos':(i,j),'pred':(i,j),'points':f(i,j,prochains),'ajout':0,'direction':direction.NORD})]
	while len(A_visites)>0:
		case=heappop(A_visites)
		x,y=case[5]['pos']
		if Visites[x][y][5]=={}:
			Visites[x][y]=case
			for voisin in Carte[(x,y)]:
				(pos1,pos2)=voisin['pos']
				if Visites[pos1][pos2][5]=={} and case[0]+voisin['cout']<1+val_max:
					points=f(pos1,pos2,prochains)
					heappush(A_visites,(case[0]+voisin['cout'],x,y,pos1,pos2,{'pos':(pos1,pos2),'pred':(x,y),'points':points,'ajout':voisin['cout'],'direction':voisin['direction']}))
	return Visites


def points2(x,y,Aliens):
	points=0
	for alien in Aliens:
		if alien[1].pos==(x,y):
			points=max(points,alien[0])
	return points

