/// This file has been generated, if you wish to
/// modify it in a permanent way, please refer
/// to the script file : gen/generator_cxx.rb

/// Je fais un dijkstra et je calcule les meilleures possibilités. Je considère les ennemis comme du minerai.

/// Je n'ai pas eu le temps d'implémenter les cordes;
/// Sinon, j'aurais voulu voir les cas à distance de moins d'un tour et de voir si placer une corde augment le score
/// pour les six meilleurs minerais par rapport au cas précédent

#include "prologin.hh"
#include <iostream>
#include <vector>
#include <unordered_map>
#include <queue>
#include <chrono>
#include <cmath>
using namespace std;

// structure utilisé pour le dijkstra, correspond au déplacement sur une case
struct deplacement_possible {
	int tours;
	int PA;
	int PM;
	int butin;
	int PV;
	position case_prec;
};

// possibiltés de stratégie
typedef enum action {
	RETOUR_TAVERNE,
	MINAGE,
	ATTAQUE,
	A_CALCULER,
	RIEN,
} action;

/* fonctions de débugages pour afficher certaines sorties */
ostream& operator<<(ostream& out, position const& a) {
	out << a.ligne << " " << a.colonne;
	return out;
}

ostream& operator<<(ostream& out, vector<int> const& a) {
	for (int x : a) {
		out << x << " ";
	}
	return out;
}

void print_drapeaux_dijkstra(unordered_map<position, deplacement_possible> const& d) {
	for (int iLig = 0; iLig < TAILLE_MINE; ++iLig) {
		for (int iCol = 0; iCol < TAILLE_MINE; ++iCol) {
			position pos = {iLig, iCol};
			if (d.find(pos) != d.end()) {
				int t = d.at(pos).tours % 3;
				switch(t) {
					case 0:
						debug_afficher_drapeau(pos, DRAPEAU_VERT);
						break;
					case 1:
						debug_afficher_drapeau(pos, DRAPEAU_BLEU);
						break;
					case 2:
						debug_afficher_drapeau(pos, DRAPEAU_ROUGE);
						break;
					default:
						break;
				}
			}
		}
	}
}

void debug_drapeau_vector(vector<position> const& pos) {
	int i = 0;
	for (position x : pos) {
		switch(i%3) {
			case 0:
				debug_afficher_drapeau(x, DRAPEAU_BLEU);
				break;
			case 1:
				debug_afficher_drapeau(x, DRAPEAU_VERT);
				break;
			case 2:
				debug_afficher_drapeau(x, DRAPEAU_ROUGE);
				break;
			default:
				break;
		}
		++i;
	}
}
/* fin des fonctions de débug */

// calcule la case suivant une direction
position case_direction(position const& pos, direction const dir) {
	switch(dir) {
		case HAUT:
			return {pos.ligne-1, pos.colonne};
			break;
		case BAS:
			return {pos.ligne+1, pos.colonne};
			break;
		case DROITE:
			return {pos.ligne, pos.colonne+1};
			break;
		case GAUCHE:
			return {pos.ligne, pos.colonne-1};
			break;
		default:
			return pos;
	}
}

// calcule la case obtenue en tombant
position case_chute(position const& pos) {
	position resultat = pos;
	while (type_case(case_direction(resultat, BAS)) == LIBRE && nain_sur_case(case_direction(resultat, BAS)) != adversaire()) {
		resultat = case_direction(resultat, BAS);
	}
	return resultat;
}

// tient compte du fait qu'on ne peut dépasser BUTIN_MAX
int gain_reel(int butin_initial, int gain) {
	if (butin_initial + gain <= BUTIN_MAX) {
		return gain;
	} else {
		return BUTIN_MAX - butin_initial;
	}
}

// détermine s'il est possible de se déplacer horizontalement sans être accroché
bool lacher_horizontal(direction const dir, position const& pos_actuelle, position const& pos_nouvelle) {
	position dessous_actuelle = case_direction(pos_actuelle, BAS);
	position dessous_nouvelle = case_direction(pos_nouvelle, BAS);
	bool actuelle_pas_libre = (type_case(dessous_actuelle) != LIBRE || nain_sur_case(dessous_actuelle) == adversaire());
	bool nouvelle_pas_libre = (type_case(dessous_nouvelle) != LIBRE || nain_sur_case(dessous_nouvelle) == adversaire());
	return ((dir == GAUCHE || dir == DROITE) && actuelle_pas_libre && nouvelle_pas_libre);
}

// code de l'opérateur pour le tas du dijkstra
bool operator<(deplacement_possible const& a, deplacement_possible const& b) {
	return (a.tours > b.tours || (a.tours == b.tours && a.PM > b.PM) || (a.tours == b.tours && a.PM == b.PM && a.butin > b.butin) ||
	(a.tours == b.tours && a.PM == b.PM && a.butin == b.butin && a.PA > b.PA) ||
	(a.tours == b.tours && a.PM == b.PM && a.butin == b.butin && a.PA == b.PA && a.PV > b.PV));
}

// on est beaucoup moins sur de gagner de l'argent dans une bataille
const int COUT_BATAILLE = 2;

// met a jour un déplacement pour aller sur une nouvelle case
void mettre_a_jour_deplacement_possible(deplacement_possible& dep, direction const dir, position const& pos_actuelle, position const& pos_nouvelle) {
	if (type_case(pos_nouvelle) == GRANITE || nain_sur_case(pos_nouvelle) == adversaire()) {
		int res;
		if (type_case(pos_nouvelle) == GRANITE) {
			res = info_minerai(pos_nouvelle).resistance;
			dep.butin += gain_reel(dep.butin, info_minerai(pos_nouvelle).rendement);
		} else {
			for (int iNain = 0; iNain < NB_NAINS; ++iNain) {
				nain nain_actuel = info_nain(adversaire(), iNain);
				if (nain_actuel.pos == pos_nouvelle) {
					res = nain_actuel.vie / DEGAT_PIOCHE;
					dep.butin += gain_reel(dep.butin, nain_actuel.butin)/COUT_BATAILLE;
					break;
				}
			}
		}
		if (res >= 2) {
			dep.tours += (res-1);
			dep.PM = 0;
		}
		if (dep.PA + COUT_MINER > NB_POINTS_ACTION) {
			dep.PA = 0;
			dep.tours += 1;
			dep.PM = 0;
		}
		dep.PA = COUT_MINER;
	}
	if (lacher_horizontal(dir, pos_actuelle, pos_nouvelle)) {
		dep.PM += COUT_DEPLACEMENT;
		if (dep.PM > NB_POINTS_DEPLACEMENT) {
			dep.tours += 1;
			dep.PA = 0;
			dep.PM = COUT_DEPLACEMENT;
		}
	} else if (corde_sur_case(pos_nouvelle)) {
		dep.PM += COUT_ESCALADER_CORDE;
		if (dep.PM > NB_POINTS_DEPLACEMENT) {
			dep.tours += 1;
			dep.PA = 0;
			dep.PM = COUT_ESCALADER_CORDE;
		}
	} else {
		dep.PM += COUT_ESCALADER;
		if (dep.PM > NB_POINTS_DEPLACEMENT) {
			dep.tours += 1;
			dep.PA = 0;
			dep.PM = COUT_ESCALADER;
		}
	}
}

// dijkstra en lui même avec un tas et qui renvoie une map pour récupérer les résultats de calcul
unordered_map<position, deplacement_possible> dijkstra(int iNain) {
	const nain nain_base = info_nain(moi(), iNain);
	unordered_map<position, deplacement_possible> d;
	priority_queue<pair<deplacement_possible, position>> dij;
	dij.push(make_pair(deplacement_possible({0, nain_base.pa, nain_base.pm, nain_base.butin, nain_base.vie, nain_base.pos}), nain_base.pos));
	while (!dij.empty()) {
		const pair<deplacement_possible, position> actuel = dij.top();
		const position pos_actuelle = actuel.second;
		dij.pop();
		if ((type_case(pos_actuelle) != LIBRE && type_case(pos_actuelle) != GRANITE) || pos_actuelle == position_taverne(adversaire())) {
			continue;
		}
		if (d.find(pos_actuelle) == d.end()) {
			d[pos_actuelle] = actuel.first;
			if (type_case(case_direction(pos_actuelle, BAS)) == LIBRE) {
				deplacement_possible dep = actuel.first;
				dep.case_prec = pos_actuelle;
				const position pos_nouvelle = case_chute(pos_actuelle);
				int h = pos_nouvelle.ligne - pos_actuelle.ligne;
				if (h >= 4) {
					dep.PV -= 1 << (h-4);
				}
				if (dep.PV >= VIE_NAIN - DEGAT_PIOCHE) {
					dij.push(make_pair(dep, pos_nouvelle));
				}
			}
			for (direction dir : {HAUT, BAS, GAUCHE, DROITE}) {
				deplacement_possible dep = actuel.first;
				dep.case_prec = pos_actuelle;
				const position pos_nouvelle = case_direction(pos_actuelle, dir);
				mettre_a_jour_deplacement_possible(dep, dir, pos_actuelle, pos_nouvelle);
				dij.push(make_pair(dep, pos_nouvelle));
			}
		}
	}
	return d;
}

// trouve la direction pour jouer un coup entre deux cases
direction trouver_direction(position const& initial, position const& but) {
	for (direction dir : {HAUT, BAS, GAUCHE, DROITE}) {
		if (case_direction(initial, dir) == but) {
			return dir;
		}
	}
	return BAS; // le coup restant est de lacher donc vers le bas
}

// joue et effectue ce coup
// la première variable renvoyé dit s'il est possible de continuer le déplacement
// la deuxième donne le nombre d'action utilisées, si on veut annuler
pair<bool, int> effectuer_deplacement(position const& initial, position const& but, int iNain) {
	int nbCoups = 0;
	bool possible = false;
	if (!info_nain(moi(), iNain).accroche) {
		agripper(iNain);
		++nbCoups;
	}
	direction dir = trouver_direction(initial, but);
	if ((type_case(but) == GRANITE || nain_sur_case(but) == adversaire()) && info_nain(moi(), iNain).pa >= COUT_MINER) {
		miner(iNain, dir);
		++nbCoups;
	}
	if (case_chute(initial) == but) {
		lacher(iNain);
		++nbCoups;
		possible = true;
	} else if (type_case(but) == LIBRE && nain_sur_case(but) != adversaire() && cout_de_deplacement(iNain, dir) != -1) {
		if (lacher_horizontal(dir, initial, but)) {
			lacher(iNain);
			++nbCoups;
		}
		if (info_nain(moi(), iNain).pm >= cout_de_deplacement(iNain, dir)) {
			deplacer(iNain, dir);
			++nbCoups;
			possible = true;
		}
	}
	if (!info_nain(moi(), iNain).accroche) {
		agripper(iNain);
		++nbCoups;
	}
	return make_pair(possible, nbCoups);
}

// enchaine le plus de déplacement possible en un tour pour se rapprocher de but
int se_deplacer(unordered_map<position, deplacement_possible> const& d, int iNain, position const& but) {
	int nbCoupsTotal = 0;
	position actuel = info_nain(moi(), iNain).pos;
	if (d.find(but) == d.end()) {
		return nbCoupsTotal;
	}
	vector<position> cases_a_faire;
	position a_faire = but;
	while (a_faire != actuel) {
		cases_a_faire.push_back(a_faire);
		a_faire = d.at(a_faire).case_prec;
	}
	cases_a_faire.push_back(actuel);
	//debug_drapeau_vector(cases_a_faire);
	auto it_a_faire = cases_a_faire.rbegin();
	bool possible = true;
	int iBoucle = 0;
	while (possible && actuel != but && iBoucle < 15) {
		++it_a_faire;
		pair<bool, int> resultat = effectuer_deplacement(actuel, *it_a_faire, iNain);
		possible = resultat.first;
		nbCoupsTotal += resultat.second;
		actuel = info_nain(moi(), iNain).pos;
		++iBoucle;
	}
	return nbCoupsTotal;
}

// au dessus de cette valeur, si un nain est gravement touché, il rentre à la taverne le plus vite possible
const int BUTIN_ININTERESSANT = 2;

// actions que doivent faire les nains
vector<action> actions_nains(NB_NAINS, A_CALCULER);

// cases sur lesquelles chaque nain veut aller (ou veut détruire ce qu'il y a dessus)
vector<position> cases_vises(NB_NAINS, {-1, -1});

// ennemis visés s'il y en a
vector<int> ennemis_vises(NB_NAINS, -1);

// pour chaque ennemi, le nombre d'alliés qui cherchent à tuer l'ennemi
vector<int> nb_attaquants(NB_NAINS, 0);

// nombre de personnes voulant miner la case
unordered_map<position, int> nb_mineurs;

// tableau contenant le résultat de chaque dijkstra par nain
vector<unordered_map<position, deplacement_possible>> dNains(NB_NAINS);

// debug pour afficher les cases choisies pour être minées
void debug_nb_mineurs() {
	auto it = nb_mineurs.begin();
	while (it != nb_mineurs.end()) {
		if (it->second > 0) {
			if (moi()%2 == 0) {
				debug_afficher_drapeau(it->first, DRAPEAU_VERT);
			} else {
				debug_afficher_drapeau(it->first, DRAPEAU_ROUGE);
			}
		}
		++it;
	}
}

// debug pour afficher les personnes choisies pour être attaqués
void debug_nb_attaquants() {
	for (int iEnnemi = 0; iEnnemi < NB_NAINS; ++iEnnemi) {
		if (nb_attaquants[iEnnemi] > 0) {
			if (moi()%2 == 0) {
				debug_afficher_drapeau(info_nain(adversaire(), iEnnemi).pos, DRAPEAU_VERT);
			} else {
				debug_afficher_drapeau(info_nain(adversaire(), iEnnemi).pos, DRAPEAU_ROUGE);
			}
		}
	}
}

// fonction à appeler pour que le nain termine son travail
void finirTravail(int iNain) {
	if (actions_nains[iNain] == MINAGE && cases_vises[iNain] != position({-1, -1})) {
		--nb_mineurs[cases_vises[iNain]];
	} else if(actions_nains[iNain] == ATTAQUE && actions_nains[iNain] != -1) {
		--nb_attaquants[ennemis_vises[iNain]];
	}
	cases_vises[iNain] = {-1, -1};
	ennemis_vises[iNain] = -1;
	actions_nains[iNain] = A_CALCULER;
}

// fonction à appeler pour que le nain retourne à la taverne
void retournerBoire(int iNain) {
	finirTravail(iNain);
	cases_vises[iNain] = position_taverne(moi());
	actions_nains[iNain] = RETOUR_TAVERNE;
}

// retourne la liste des nains ayant leur action sur A_CALCULER
vector<int> nainsSansTravail() {
	vector<int> travailTermine;
	for (int iNain = 0; iNain < NB_NAINS; ++iNain) {
		if (actions_nains[iNain] == A_CALCULER) {
			travailTermine.push_back(iNain);
		}
	}
	return travailTermine;
}

// si on est très proche de la fin, on doit rejoindre la taverne
const int NB_TOURS_RAB_POUR_RUSH = 3;

// met à jour la stratégie du nain
void mettre_a_jour_nain(int iNain, bool premiere_fois) {
	nain nain_actuel = info_nain(moi(), iNain);
	if (dNains[iNain][position_taverne(moi())].tours + tour_actuel() >= NB_TOURS - NB_TOURS_RAB_POUR_RUSH && nain_actuel.butin > 0) {
		retournerBoire(iNain);
	} else if (nain_actuel.vie == -1) {
		retournerBoire(iNain);
	// } else if (premiere_fois) {
	// 	finirTravail(iNain);
	} else if (actions_nains[iNain] == RETOUR_TAVERNE && nain_actuel.pos == position_taverne(moi())) {
		finirTravail(iNain);
	} else if (actions_nains[iNain] == ATTAQUE &&
	(info_nain(adversaire(), ennemis_vises[iNain]).vie == -1 ||
	info_nain(adversaire(), ennemis_vises[iNain]).pos == position_taverne(adversaire()))) {
		finirTravail(iNain);
	} else if (actions_nains[iNain] == MINAGE && type_case(cases_vises[iNain]) == LIBRE) {
		finirTravail(iNain);
	}
}

// deplace le nain vers son but
void deplacer_nain(int iNain) {
	if (actions_nains[iNain] == ATTAQUE) {
		cases_vises[iNain] = info_nain(adversaire(), ennemis_vises[iNain]).pos;
	}
	if (actions_nains[iNain] != RIEN && actions_nains[iNain] != A_CALCULER) {
		//debug_afficher_drapeau(cases_vises[iNain], DRAPEAU_BLEU);
		se_deplacer(dNains[iNain], iNain, cases_vises[iNain]);
		//debug_afficher_drapeau(cases_vises[iNain], AUCUN_DRAPEAU);
	}
}

const double valeurMine[] = {1, 0.6, 0.4, 0.2, 0.1, 0.05, 0};
// fonction pour évaluer le score d'une case de granite
double scoreMine(int iNain, int butin_actuel, position const& pos) {
	if (dNains[iNain].find(pos) == dNains[iNain].end()) {
		return 0;
	}
	double val = valeurMine[nb_mineurs[pos]];
	deplacement_possible dep_mine = dNains[iNain][pos];
	int gain = gain_reel(butin_actuel, dep_mine.butin);
	return 5*val*gain/pow(1+dep_mine.tours, 1.5);
}

const double valeurEnnemi[] = {1, 2, 0.3, 0.2, 0.1, 0.05, 0};
// fonction pour évaluer le score d'un ennemi
double scoreEnnemi(int iNain, int butin_actuel, int iEnnemi) {
	position pos = info_nain(adversaire(), iEnnemi).pos;
	if (dNains[iNain].find(pos) == dNains[iNain].end() ||
	info_nain(adversaire(), iEnnemi).pos == position_taverne(adversaire())) {
		return 0;
	}
	double val = valeurEnnemi[nb_attaquants[iEnnemi]];
	deplacement_possible dep_ennemi = dNains[iNain][pos];
	int gain = gain_reel(butin_actuel, dep_ennemi.butin);
	double gain_vie = pow(1 + (double)(3 - (info_nain(adversaire(), iEnnemi).vie-1)/DEGAT_PIOCHE)*2/3, 2);
	double malus_butin = pow(1 + butin_actuel, 0.6);
	return 3*val*gain_vie*gain/pow(1+dep_ennemi.tours, 1.5)/malus_butin;
}

// fonction pour évaluer le score de retour à la caverne
double scoreTaverne(int iNain, nain const& spec) {
	return 0.05*(1+spec.butin)*pow(1 + (double)(3 - (spec.vie-1)/DEGAT_PIOCHE)*2/3, 2)*
	pow(1 + dNains[iNain][position_taverne(moi())].tours, 0.5);
}

// recalcule la stratégie d'un nain sans travail
void calculer_strategie(int iNain) {
	if (actions_nains[iNain] != A_CALCULER) {
		return;
	}
	nain nain_actuel = info_nain(moi(), iNain);
	double scoreGraniteMax = 0;
	position graniteMax = {-1, -1};
	for (position pos_granite : liste_minerais()) {
		double score = scoreMine(iNain, nain_actuel.butin, pos_granite);
		if (score > scoreGraniteMax) {
			scoreGraniteMax = score;
			graniteMax = pos_granite;
		}
	}
	double scoreEnnemiMax = 0;
	int ennemiMax = -1;
	for (int iEnnemi = 0; iEnnemi < NB_NAINS; ++iEnnemi) {
		double score = scoreEnnemi(iNain, nain_actuel.butin, iEnnemi);
		if (score > scoreEnnemiMax) {
			scoreEnnemiMax = score;
			ennemiMax = iEnnemi;
		}
	}
	double scoreRetour = scoreTaverne(iNain, nain_actuel);
	if (scoreGraniteMax >= scoreEnnemiMax && scoreGraniteMax > scoreRetour && scoreGraniteMax > 0) {
		actions_nains[iNain] = MINAGE;
		cases_vises[iNain] = graniteMax;
		++nb_mineurs[graniteMax];
	} else if (scoreEnnemiMax > scoreRetour && scoreEnnemi > 0) {
		actions_nains[iNain] = ATTAQUE;
		ennemis_vises[iNain] = ennemiMax;
		++nb_attaquants[ennemiMax];
	} else if (scoreRetour > 0 && nain_actuel.pos != position_taverne(moi())) {
		retournerBoire(iNain);
	} else {
		finirTravail(iNain);
		actions_nains[iNain] = RIEN;
	}
}

// met à jour le tableau dNains pour le nain iNain
void mettre_a_jour_dijkstra(int iNain) {
	dNains[iNain] = dijkstra(iNain);
}

/// Fonction appelée au début de la partie.
void partie_init()
{
	cout << "Bonjour nain !" << endl;
	for (position pos : liste_minerais()) {
		nb_mineurs[pos] = 0;
	}
}

/// Fonction appelée à chaque tour.
void jouer_tour()
{
	cout << "Tour : " << tour_actuel() << ", temps_dijkstra : ";
	chrono::time_point debut = chrono::system_clock::now();
	// je calcule un dijkstra
	for (int iNain = 0; iNain < NB_NAINS; ++iNain) {
		mettre_a_jour_dijkstra(iNain);
	}
	chrono::time_point fin = chrono::system_clock::now();
	cout << chrono::duration_cast<chrono::milliseconds>(fin - debut).count() << ", temps : ";
	debut = chrono::system_clock::now();
	// je recalcule les fonctions des nains
	for (int iNain = 0; iNain < NB_NAINS; ++iNain) {
		if (tour_actuel() % 5 == 0) {
			mettre_a_jour_nain(iNain, true);
		} else {
			mettre_a_jour_nain(iNain, false);
		}
		calculer_strategie(iNain);
		deplacer_nain(iNain);
		mettre_a_jour_nain(iNain, false);
	}
	// je continue tant qu'il y a du chomage
	vector<int> auChomage = nainsSansTravail();
	int iBoucle = 0;
	while(!auChomage.empty() && iBoucle < 3) {
		for (int iNain : auChomage) {
			mettre_a_jour_dijkstra(iNain);
			calculer_strategie(iNain);
			deplacer_nain(iNain);
			mettre_a_jour_nain(iNain, false);
		}
		auChomage = nainsSansTravail();
		++iBoucle;
	}
	fin = chrono::system_clock::now();
	cout << chrono::duration_cast<chrono::milliseconds>(fin - debut).count() << endl;
	debug_nb_mineurs();
	debug_nb_attaquants();
}

/// Fonction appelée à la fin de la partie.
void partie_fin()
{
	cout << "Au revoir nain !" << endl;
}
