#!/bin/python3
from api import *
import heapq
from collections import namedtuple
from copy import copy
Case = namedtuple('Case', ['cout', 'parent'])

def case_libre(case):
    return agent_sur_case(case) == -1 and type_case(case) == case_type.LIBRE

def proches_voisins(case, distance=2):
    liste_vois = []
    for dx in range(- distance, distance + 1):
        for dy in range(- distance, distance + 1):
            x, y = case
            x += dx
            y += dy
            if 0 <= x < TAILLE_BANQUISE and 0 <= y < TAILLE_BANQUISE and dx**2 + dy**2 <= distance**2:
                liste_vois.append((x, y))
    return liste_vois

def voisins_pousser(case, id_j):
    liste_vois = []
    for dx, dy, dir in [(-1, 0, direction.NORD), (1, 0, direction.SUD), (0, 1, direction.EST),\
     (0, -1, direction.OUEST)]:
        x, y = case
        x += dx
        y += dy
        agent = agent_sur_case((x, y))
        if 0 <= x < TAILLE_BANQUISE and 0 <= y < TAILLE_BANQUISE and case_libre((x+dx,y+dy))\
        and agent != id_j and agent != -1:
            liste_vois.append(dir)
    return liste_vois

def voisins_pousser_case(case, id_j):
    liste_vois = []
    agent = agent_sur_case(case)
    if agent == id_j or agent == -1:
        return []
    for dx, dy, dir in [(-1, 0, direction.NORD), (1, 0, direction.SUD), (0, 1, direction.EST),\
     (0, -1, direction.OUEST)]:
        x, y = case
        x += dx
        y += dy
        if 0 <= x < TAILLE_BANQUISE and 0 <= y < TAILLE_BANQUISE and case_libre((x,y))\
        and case_libre((x-2*dx,y-2*dy)):
            liste_vois.append( (x,y) )
    return liste_vois

def voisins(case):
    liste_vois = []
    for dx, dy in [(-1,0), (1,0), (0,1), (0,-1)]:
        x, y = case
        x += dx
        y += dy
        if case_libre((x, y)):
            liste_vois.append(((x,y), COUT_DEPLACEMENT))
            while case_libre((x + dx, y + dy)):
                x += dx
                y += dy
            liste_vois.append(((x,y), COUT_GLISSADE))
    return liste_vois

def agents_voisins(case, id_j):
    l_vois = []
    for case_vois in proches_voisins(case, 3):
        agent = agent_sur_case(case_vois)
        if agent != id_j and agent != -1:
            l_vois.append(case_vois)
    return l_vois

class Cout:
    def __init__(self, tour, pa):
        self.tour = tour
        self.pa = pa

    def __lt__(self, autre):
        if autre is None:
            return True
        if self.tour < autre.tour:
            return True
        elif self.tour == autre.tour and self.pa < autre.pa:
            return True
        else:
            return False

    def __eq__(self, autre):
        if autre is None:
            return False
        if self.tour == autre.tour and self.pa == autre.pa:
            return True
        else:
            return False

    def ajoute_cout(self, nouv_cout):
        if self.pa + nouv_cout > NB_POINTS_ACTION:
            self.tour += 1
            self.pa = nouv_cout
        else:
            self.pa += nouv_cout

class Noeud:

    def __init__(self, case, cout, parent):
        self.case = case
        self.cout = cout
        self.parent = parent

    def __lt__(self, autre):
        return self.cout < autre.cout

    def __eq__(self, autre):
        return self.cout == autre.cout

def dijkstra(case_init, case_finale=None):
    n = Noeud(case_init, Cout(0, 0), None)
    mat_noeuds = [[None for y in range(TAILLE_BANQUISE)]\
     for x in range(TAILLE_BANQUISE)]
    tas_noeuds = [n]
    heapq.heapify(tas_noeuds)

    while len(tas_noeuds) > 0 and n.case != case_finale:
        n = heapq.heappop(tas_noeuds)
        x, y = n.case
        if mat_noeuds[x][y] is None:
            mat_noeuds[x][y] = Case(cout=n.cout, parent=n.parent)
            for case_vois, cout_d in voisins(n.case):
                nouveau_n = Noeud(case_vois, Cout(n.cout.tour, n.cout.pa), n.case)
                nouveau_n.cout.ajoute_cout(cout_d)
                heapq.heappush(tas_noeuds, nouveau_n)

    return mat_noeuds

def trouver_deplacement(case, parent):
    x, y = case
    x_a, y_a = parent
    if x > x_a:
        dir = direction.SUD
    elif x_a > x:
        dir = direction.NORD
    elif y > y_a:
        dir = direction.EST
    else:
        dir = direction.OUEST
    if abs(x - x_a) > 1 or abs(y - y_a) > 1:
        action = action_type.ACTION_GLISSER
    else:
        action = action_type.ACTION_DEPLACER
    return action, dir

def liste_court_chemin(case_finale, matrice_cases=None, case_init=None):
    if matrice_cases is None:
        matrice_cases = dijkstra(case_init, case_finale)
    case = case_finale
    l_deplacement = list()
    x, y = case
    if matrice_cases[x][y] is None:
        return l_deplacement
    l_deplacement.append(case)
    while True:
        x, y = case
        case_par = matrice_cases[x][y].parent
        if case_par is None:
            break
        l_deplacement.append(trouver_deplacement(case, case_par))
        case = case_par
    return l_deplacement
