#!/bin/python3
from api import *
from enum import IntEnum
from . import deplacements as dep
from . import aliens as al

class mode(IntEnum):
    ATTAQUE = 0
    DEFENSE_ACTIF = 1
    DEFENSE_PASSIF = 2
    CAPTURE = 3
    AUCUN = 4

"""class Penguin:

    def __init__(self, id_j, id_p, pos):
        self.id_j = id_j
        self.id_p = id_p
        self.pos = pos
        #self.mat_dij = dep.dijkstra(self.pos)

    def update(self):
        self.pos = position_agent(self.id_j, self.id_p)
        #self.mat_dij = dep.dijkstra(self.pos)"""

class PIB:

    def __init__(self, id_j, id_p, pos, obj, mode_pib, a_affect, c_affect=None):
        self.id_j = id_j
        self.id_p = id_p
        self.pos = pos
        self.obj = obj
        self.mode_pib = mode_pib
        self.a_affect = a_affect
        self.c_affect = c_affect
        self.mat_dij = dep.dijkstra(pos)

    def update(self):
        self.pos = position_agent(self.id_j, self.id_p)
        if al.alien_mort(self.a_affect):
            self.mode_pib = mode.AUCUN
        if self.mode_pib == mode.AUCUN:
            self.obj = self.pos
            self.a_affect = None
            self.c_affect = None
        self.mat_dij = dep.dijkstra(self.pos)

    def bouger(self, action, direction):
        if action == action_type.ACTION_DEPLACER:
            cout = COUT_DEPLACEMENT
            func = deplacer
        elif action == action_type.ACTION_GLISSER:
            cout = COUT_GLISSADE
            func = glisser
        elif action == action_type.ACTION_POUSSER:
            cout = COUT_POUSSER
            func = pousser
        else:
            raise ValueError("Pas assez de points d'action")
        if points_action_agent(self.id_p) - cout >= 0:
            func(self.id_p, direction)
        else:
            raise ValueError("Pas assez de points d'action")

    def se_deplacer(self):
        i_mov = 1
        while points_action_agent(self.id_p) > 0 and i_mov <= 2:
            i_mov += 1
            mouvements = dep.liste_court_chemin(case_finale=self.obj, case_init=self.pos)
            while len(mouvements) > 0:
                action, dir = mouvements.pop()
                try:
                    self.bouger(action, dir)
                except ValueError:
                    mouvements.append((action,dir))
                    break
            self.pos = position_agent(self.id_j, self.id_p)

            if points_action_agent(self.id_p) < COUT_POUSSER:
                break
            for dir in dep.voisins_pousser(self.pos, self.id_j):
                self.bouger(action_type.ACTION_POUSSER, dir)
                break
            if points_action_agent(self.id_p) >= COUT_POUSSER:
                break

def mettre_a_jour(l_PIB):
    for pib_t in l_PIB:
        pib_t.update()

def deplacer_pinguins(l_PIB):
    for pib_t in l_PIB:
        if pib_t.mode_pib != mode.AUCUN:
            pib_t.se_deplacer()
