/// This file has been generated, if you wish to
/// modify it in a permanent way, please refer
/// to the script file : gen/generator_cs.rb

#include "interface.hh"

#include <iostream>
#include <assert.h>
#include <cstdlib>
#include <cstring>

CSharpInterface gl_csharp;

template < class Out, class Cxx >
Out cxx2lang(Cxx in)
{
  return (Out)in;
}

template <>
MonoString* cxx2lang<MonoString*, std::string>(std::string in)
{
  return mono_string_new (gl_csharp.getDomain(), in.c_str());
}

template <>
gint32 cxx2lang< gint32, int >(int in)
{
  return (gint32)in;
}

template <>
gint32 cxx2lang< gint32, bool >(bool in)
{
  return (gint32)in;
}

template < class Out, class Cxx >
Cxx lang2cxx(Out in)
{
  return (Cxx)in;
}

template <>
std::string lang2cxx< MonoString*, std::string >(MonoString* in)
{
  std::string s_out;
  MonoError error;
  char *c_out;

  if (!in)
    return std::string("(null)");
  c_out = mono_string_to_utf8_checked(in, &error);
  if (!mono_error_ok(&error)) {
    s_out = std::string(mono_error_get_message(&error));
    mono_error_cleanup(&error);
    return s_out;
  } else {
    s_out = std::string(c_out);
    mono_free(c_out);
    return s_out;
  }
}

template <>
int lang2cxx< gint32, int >(gint32 in)
{
  return (int)in;
}

template <>
bool lang2cxx< gint32, bool >(gint32 in)
{
  return (bool)in;
}

template <>
MonoArray* cxx2lang< MonoArray*, std::vector<int> >(std::vector<int> in)
{
  gint32 size = in.size();
  MonoClass* mcKlass = mono_get_int32_class();
  MonoArray * maArray = mono_array_new(gl_csharp.getDomain(), mcKlass, size);

  for (int i = 0; i < size; ++i)
    mono_array_set(maArray, gint32, i, (cxx2lang< gint32, int >(in[i])));

  return maArray;
}

template <>
std::vector<int> lang2cxx< MonoArray*, std::vector<int> >(MonoArray* in)
{
  std::vector< int > out;
  gint32 size = mono_array_length(in);

  for (int i = 0; i < size; ++i)
    out.push_back(lang2cxx< gint32, int >(mono_array_get(in, gint32, i)));

  return out;
}
/// Types de cases
template <>
gint32 cxx2lang< gint32, case_type >(case_type in)
{
  return (gint32)in;
}

template <>
case_type lang2cxx< gint32, case_type >(gint32 in)
{
  return (case_type)in;
}
template <>
MonoArray* cxx2lang< MonoArray*, std::vector<case_type> >(std::vector<case_type> in)
{
  gint32 size = in.size();
  MonoClass* mcKlass = mono_class_from_name(gl_csharp.getImage(), "Prologin", "CaseType");
  MonoArray * maArray = mono_array_new(gl_csharp.getDomain(), mcKlass, size);
  for (int i = 0; i < size; ++i)
    mono_array_set(maArray, gint32, i, (cxx2lang< gint32, case_type >(in[i])));
  return maArray;
}

template <>
std::vector<case_type> lang2cxx< MonoArray*, std::vector<case_type> >(MonoArray* in)
{
  std::vector< case_type > out;
  gint32 size = mono_array_length(in);

  for (int i = 0; i < size; ++i)
    out.push_back(lang2cxx< gint32, case_type >(mono_array_get(in , gint32, i)));
  return out;
}

/// Direction
template <>
gint32 cxx2lang< gint32, direction >(direction in)
{
  return (gint32)in;
}

template <>
direction lang2cxx< gint32, direction >(gint32 in)
{
  return (direction)in;
}
template <>
MonoArray* cxx2lang< MonoArray*, std::vector<direction> >(std::vector<direction> in)
{
  gint32 size = in.size();
  MonoClass* mcKlass = mono_class_from_name(gl_csharp.getImage(), "Prologin", "Direction");
  MonoArray * maArray = mono_array_new(gl_csharp.getDomain(), mcKlass, size);
  for (int i = 0; i < size; ++i)
    mono_array_set(maArray, gint32, i, (cxx2lang< gint32, direction >(in[i])));
  return maArray;
}

template <>
std::vector<direction> lang2cxx< MonoArray*, std::vector<direction> >(MonoArray* in)
{
  std::vector< direction > out;
  gint32 size = mono_array_length(in);

  for (int i = 0; i < size; ++i)
    out.push_back(lang2cxx< gint32, direction >(mono_array_get(in , gint32, i)));
  return out;
}

/// Erreurs possibles
template <>
gint32 cxx2lang< gint32, erreur >(erreur in)
{
  return (gint32)in;
}

template <>
erreur lang2cxx< gint32, erreur >(gint32 in)
{
  return (erreur)in;
}
template <>
MonoArray* cxx2lang< MonoArray*, std::vector<erreur> >(std::vector<erreur> in)
{
  gint32 size = in.size();
  MonoClass* mcKlass = mono_class_from_name(gl_csharp.getImage(), "Prologin", "Erreur");
  MonoArray * maArray = mono_array_new(gl_csharp.getDomain(), mcKlass, size);
  for (int i = 0; i < size; ++i)
    mono_array_set(maArray, gint32, i, (cxx2lang< gint32, erreur >(in[i])));
  return maArray;
}

template <>
std::vector<erreur> lang2cxx< MonoArray*, std::vector<erreur> >(MonoArray* in)
{
  std::vector< erreur > out;
  gint32 size = mono_array_length(in);

  for (int i = 0; i < size; ++i)
    out.push_back(lang2cxx< gint32, erreur >(mono_array_get(in , gint32, i)));
  return out;
}

/// Types d'actions
template <>
gint32 cxx2lang< gint32, action_type >(action_type in)
{
  return (gint32)in;
}

template <>
action_type lang2cxx< gint32, action_type >(gint32 in)
{
  return (action_type)in;
}
template <>
MonoArray* cxx2lang< MonoArray*, std::vector<action_type> >(std::vector<action_type> in)
{
  gint32 size = in.size();
  MonoClass* mcKlass = mono_class_from_name(gl_csharp.getImage(), "Prologin", "ActionType");
  MonoArray * maArray = mono_array_new(gl_csharp.getDomain(), mcKlass, size);
  for (int i = 0; i < size; ++i)
    mono_array_set(maArray, gint32, i, (cxx2lang< gint32, action_type >(in[i])));
  return maArray;
}

template <>
std::vector<action_type> lang2cxx< MonoArray*, std::vector<action_type> >(MonoArray* in)
{
  std::vector< action_type > out;
  gint32 size = mono_array_length(in);

  for (int i = 0; i < size; ++i)
    out.push_back(lang2cxx< gint32, action_type >(mono_array_get(in , gint32, i)));
  return out;
}

/// Types de drapeaux de débug
template <>
gint32 cxx2lang< gint32, debug_drapeau >(debug_drapeau in)
{
  return (gint32)in;
}

template <>
debug_drapeau lang2cxx< gint32, debug_drapeau >(gint32 in)
{
  return (debug_drapeau)in;
}
template <>
MonoArray* cxx2lang< MonoArray*, std::vector<debug_drapeau> >(std::vector<debug_drapeau> in)
{
  gint32 size = in.size();
  MonoClass* mcKlass = mono_class_from_name(gl_csharp.getImage(), "Prologin", "DebugDrapeau");
  MonoArray * maArray = mono_array_new(gl_csharp.getDomain(), mcKlass, size);
  for (int i = 0; i < size; ++i)
    mono_array_set(maArray, gint32, i, (cxx2lang< gint32, debug_drapeau >(in[i])));
  return maArray;
}

template <>
std::vector<debug_drapeau> lang2cxx< MonoArray*, std::vector<debug_drapeau> >(MonoArray* in)
{
  std::vector< debug_drapeau > out;
  gint32 size = mono_array_length(in);

  for (int i = 0; i < size; ++i)
    out.push_back(lang2cxx< gint32, debug_drapeau >(mono_array_get(in , gint32, i)));
  return out;
}

/// Position dans la mine, donnée par deux coordonnées.
template <>
MonoObject* cxx2lang< MonoObject*, position >(position in)
{
  MonoClass*  mcKlass  = mono_class_from_name(gl_csharp.getImage(), "Prologin", "Position");
  MonoObject* moObj    = mono_object_new(gl_csharp.getDomain(), mcKlass);
mono_runtime_object_init(moObj);
  auto arg_ligne = cxx2lang< gint32, int >(in.ligne);
  mono_field_set_value(moObj, mono_class_get_field_from_name(mcKlass, "Ligne"), &arg_ligne);
  auto arg_colonne = cxx2lang< gint32, int >(in.colonne);
  mono_field_set_value(moObj, mono_class_get_field_from_name(mcKlass, "Colonne"), &arg_colonne);
  return moObj;
}

template <>
position lang2cxx< MonoObject*, position >(MonoObject* in)
{
    position out;
  void*      field_out;
  MonoClass* mcKlass = mono_class_from_name(gl_csharp.getImage(), "Prologin", "Position");
  (void)field_out;
  mono_field_get_value(in, mono_class_get_field_from_name(mcKlass, "Ligne"), &out.ligne);
  mono_field_get_value(in, mono_class_get_field_from_name(mcKlass, "Colonne"), &out.colonne);
  return out;
}

template <>
MonoArray* cxx2lang< MonoArray*, std::vector<position> >(std::vector<position> in)
{
  gint32 size = in.size();
  MonoClass* mcKlass = mono_class_from_name(gl_csharp.getImage(), "Prologin", "Position");
  MonoArray * maArray = mono_array_new(gl_csharp.getDomain(), mcKlass, size);
  for (int i = 0; i < size; ++i)
    mono_array_setref(maArray, i, (cxx2lang< MonoObject*, position >(in[i])));
  return maArray;
}

template <>
std::vector<position> lang2cxx< MonoArray*, std::vector<position> >(MonoArray* in)
{
  std::vector< position > out;
  gint32 size = mono_array_length(in);

  for (int i = 0; i < size; ++i)
    out.push_back(lang2cxx< MonoObject*, position >(reinterpret_cast<MonoObject*>(mono_array_get(in, MonoObject*, i))));
  return out;
}

/// Minerai à récolter
template <>
MonoObject* cxx2lang< MonoObject*, minerai >(minerai in)
{
  MonoClass*  mcKlass  = mono_class_from_name(gl_csharp.getImage(), "Prologin", "Minerai");
  MonoObject* moObj    = mono_object_new(gl_csharp.getDomain(), mcKlass);
mono_runtime_object_init(moObj);
  auto arg_resistance = cxx2lang< gint32, int >(in.resistance);
  mono_field_set_value(moObj, mono_class_get_field_from_name(mcKlass, "Resistance"), &arg_resistance);
  auto arg_rendement = cxx2lang< gint32, int >(in.rendement);
  mono_field_set_value(moObj, mono_class_get_field_from_name(mcKlass, "Rendement"), &arg_rendement);
  return moObj;
}

template <>
minerai lang2cxx< MonoObject*, minerai >(MonoObject* in)
{
    minerai out;
  void*      field_out;
  MonoClass* mcKlass = mono_class_from_name(gl_csharp.getImage(), "Prologin", "Minerai");
  (void)field_out;
  mono_field_get_value(in, mono_class_get_field_from_name(mcKlass, "Resistance"), &out.resistance);
  mono_field_get_value(in, mono_class_get_field_from_name(mcKlass, "Rendement"), &out.rendement);
  return out;
}

template <>
MonoArray* cxx2lang< MonoArray*, std::vector<minerai> >(std::vector<minerai> in)
{
  gint32 size = in.size();
  MonoClass* mcKlass = mono_class_from_name(gl_csharp.getImage(), "Prologin", "Minerai");
  MonoArray * maArray = mono_array_new(gl_csharp.getDomain(), mcKlass, size);
  for (int i = 0; i < size; ++i)
    mono_array_setref(maArray, i, (cxx2lang< MonoObject*, minerai >(in[i])));
  return maArray;
}

template <>
std::vector<minerai> lang2cxx< MonoArray*, std::vector<minerai> >(MonoArray* in)
{
  std::vector< minerai > out;
  gint32 size = mono_array_length(in);

  for (int i = 0; i < size; ++i)
    out.push_back(lang2cxx< MonoObject*, minerai >(reinterpret_cast<MonoObject*>(mono_array_get(in, MonoObject*, i))));
  return out;
}

/// Nain (standard)
template <>
MonoObject* cxx2lang< MonoObject*, nain >(nain in)
{
  MonoClass*  mcKlass  = mono_class_from_name(gl_csharp.getImage(), "Prologin", "Nain");
  MonoObject* moObj    = mono_object_new(gl_csharp.getDomain(), mcKlass);
mono_runtime_object_init(moObj);
  auto arg_pos = cxx2lang< MonoObject*, position >(in.pos);
  mono_field_set_value(moObj, mono_class_get_field_from_name(mcKlass, "Pos"), &arg_pos);
  auto arg_vie = cxx2lang< gint32, int >(in.vie);
  mono_field_set_value(moObj, mono_class_get_field_from_name(mcKlass, "Vie"), &arg_vie);
  auto arg_pa = cxx2lang< gint32, int >(in.pa);
  mono_field_set_value(moObj, mono_class_get_field_from_name(mcKlass, "Pa"), &arg_pa);
  auto arg_pm = cxx2lang< gint32, int >(in.pm);
  mono_field_set_value(moObj, mono_class_get_field_from_name(mcKlass, "Pm"), &arg_pm);
  auto arg_accroche = cxx2lang< gint32, bool >(in.accroche);
  mono_field_set_value(moObj, mono_class_get_field_from_name(mcKlass, "Accroche"), &arg_accroche);
  auto arg_butin = cxx2lang< gint32, int >(in.butin);
  mono_field_set_value(moObj, mono_class_get_field_from_name(mcKlass, "Butin"), &arg_butin);
  return moObj;
}

template <>
nain lang2cxx< MonoObject*, nain >(MonoObject* in)
{
    nain out;
  void*      field_out;
  MonoClass* mcKlass = mono_class_from_name(gl_csharp.getImage(), "Prologin", "Nain");
  (void)field_out;
  mono_field_get_value(in, mono_class_get_field_from_name(mcKlass, "Pos"), &field_out);
  out.pos = lang2cxx< MonoObject*, position >(reinterpret_cast< MonoObject* >(field_out));
  mono_field_get_value(in, mono_class_get_field_from_name(mcKlass, "Vie"), &out.vie);
  mono_field_get_value(in, mono_class_get_field_from_name(mcKlass, "Pa"), &out.pa);
  mono_field_get_value(in, mono_class_get_field_from_name(mcKlass, "Pm"), &out.pm);
  mono_field_get_value(in, mono_class_get_field_from_name(mcKlass, "Accroche"), &out.accroche);
  mono_field_get_value(in, mono_class_get_field_from_name(mcKlass, "Butin"), &out.butin);
  return out;
}

template <>
MonoArray* cxx2lang< MonoArray*, std::vector<nain> >(std::vector<nain> in)
{
  gint32 size = in.size();
  MonoClass* mcKlass = mono_class_from_name(gl_csharp.getImage(), "Prologin", "Nain");
  MonoArray * maArray = mono_array_new(gl_csharp.getDomain(), mcKlass, size);
  for (int i = 0; i < size; ++i)
    mono_array_setref(maArray, i, (cxx2lang< MonoObject*, nain >(in[i])));
  return maArray;
}

template <>
std::vector<nain> lang2cxx< MonoArray*, std::vector<nain> >(MonoArray* in)
{
  std::vector< nain > out;
  gint32 size = mono_array_length(in);

  for (int i = 0; i < size; ++i)
    out.push_back(lang2cxx< MonoObject*, nain >(reinterpret_cast<MonoObject*>(mono_array_get(in, MonoObject*, i))));
  return out;
}

/// Action de déplacement représentée dans l'historique.
template <>
MonoObject* cxx2lang< MonoObject*, action_hist >(action_hist in)
{
  MonoClass*  mcKlass  = mono_class_from_name(gl_csharp.getImage(), "Prologin", "ActionHist");
  MonoObject* moObj    = mono_object_new(gl_csharp.getDomain(), mcKlass);
mono_runtime_object_init(moObj);
  auto arg_atype = cxx2lang< gint32, action_type >(in.atype);
  mono_field_set_value(moObj, mono_class_get_field_from_name(mcKlass, "Atype"), &arg_atype);
  auto arg_id_nain = cxx2lang< gint32, int >(in.id_nain);
  mono_field_set_value(moObj, mono_class_get_field_from_name(mcKlass, "IdNain"), &arg_id_nain);
  auto arg_dir = cxx2lang< gint32, direction >(in.dir);
  mono_field_set_value(moObj, mono_class_get_field_from_name(mcKlass, "Dir"), &arg_dir);
  auto arg_sens = cxx2lang< gint32, direction >(in.sens);
  mono_field_set_value(moObj, mono_class_get_field_from_name(mcKlass, "Sens"), &arg_sens);
  return moObj;
}

template <>
action_hist lang2cxx< MonoObject*, action_hist >(MonoObject* in)
{
    action_hist out;
  void*      field_out;
  MonoClass* mcKlass = mono_class_from_name(gl_csharp.getImage(), "Prologin", "ActionHist");
  (void)field_out;
  mono_field_get_value(in, mono_class_get_field_from_name(mcKlass, "Atype"), &out.atype);
  mono_field_get_value(in, mono_class_get_field_from_name(mcKlass, "IdNain"), &out.id_nain);
  mono_field_get_value(in, mono_class_get_field_from_name(mcKlass, "Dir"), &out.dir);
  mono_field_get_value(in, mono_class_get_field_from_name(mcKlass, "Sens"), &out.sens);
  return out;
}

template <>
MonoArray* cxx2lang< MonoArray*, std::vector<action_hist> >(std::vector<action_hist> in)
{
  gint32 size = in.size();
  MonoClass* mcKlass = mono_class_from_name(gl_csharp.getImage(), "Prologin", "ActionHist");
  MonoArray * maArray = mono_array_new(gl_csharp.getDomain(), mcKlass, size);
  for (int i = 0; i < size; ++i)
    mono_array_setref(maArray, i, (cxx2lang< MonoObject*, action_hist >(in[i])));
  return maArray;
}

template <>
std::vector<action_hist> lang2cxx< MonoArray*, std::vector<action_hist> >(MonoArray* in)
{
  std::vector< action_hist > out;
  gint32 size = mono_array_length(in);

  for (int i = 0; i < size; ++i)
    out.push_back(lang2cxx< MonoObject*, action_hist >(reinterpret_cast<MonoObject*>(mono_array_get(in, MonoObject*, i))));
  return out;
}

MonoArray* chemin(MonoObject* pos1, MonoObject* pos2)
{
	return cxx2lang< MonoArray*, std::vector<direction> >(api_chemin(lang2cxx< MonoObject*, position >(pos1), lang2cxx< MonoObject*, position >(pos2)))
;
}

gint32 deplacer(gint32 id_nain, gint32 dir)
{
	return cxx2lang< gint32, erreur >(api_deplacer(lang2cxx< gint32, int >(id_nain), lang2cxx< gint32, direction >(dir)))
;
}

gint32 lacher(gint32 id_nain)
{
	return cxx2lang< gint32, erreur >(api_lacher(lang2cxx< gint32, int >(id_nain)))
;
}

gint32 agripper(gint32 id_nain)
{
	return cxx2lang< gint32, erreur >(api_agripper(lang2cxx< gint32, int >(id_nain)))
;
}

gint32 miner(gint32 id_nain, gint32 dir)
{
	return cxx2lang< gint32, erreur >(api_miner(lang2cxx< gint32, int >(id_nain), lang2cxx< gint32, direction >(dir)))
;
}

gint32 tirer(gint32 id_nain, gint32 dir_corde, gint32 sens)
{
	return cxx2lang< gint32, erreur >(api_tirer(lang2cxx< gint32, int >(id_nain), lang2cxx< gint32, direction >(dir_corde), lang2cxx< gint32, direction >(sens)))
;
}

gint32 poser_corde(gint32 id_nain, gint32 dir)
{
	return cxx2lang< gint32, erreur >(api_poser_corde(lang2cxx< gint32, int >(id_nain), lang2cxx< gint32, direction >(dir)))
;
}

gint32 debug_afficher_drapeau(MonoObject* pos, gint32 drapeau)
{
	return cxx2lang< gint32, erreur >(api_debug_afficher_drapeau(lang2cxx< MonoObject*, position >(pos), lang2cxx< gint32, debug_drapeau >(drapeau)))
;
}

gint32 type_case(MonoObject* pos)
{
	return cxx2lang< gint32, case_type >(api_type_case(lang2cxx< MonoObject*, position >(pos)))
;
}

MonoArray* liste_cordes()
{
	return cxx2lang< MonoArray*, std::vector<position> >(api_liste_cordes())
;
}

gint32 corde_sur_case(MonoObject* pos)
{
	return cxx2lang< gint32, bool >(api_corde_sur_case(lang2cxx< MonoObject*, position >(pos)))
;
}

gint32 nain_sur_case(MonoObject* pos)
{
	return cxx2lang< gint32, int >(api_nain_sur_case(lang2cxx< MonoObject*, position >(pos)))
;
}

MonoObject* info_nain(gint32 id_joueur, gint32 id_nain)
{
	return cxx2lang< MonoObject*, nain >(api_info_nain(lang2cxx< gint32, int >(id_joueur), lang2cxx< gint32, int >(id_nain)))
;
}

MonoArray* liste_minerais()
{
	return cxx2lang< MonoArray*, std::vector<position> >(api_liste_minerais())
;
}

MonoObject* info_minerai(MonoObject* pos)
{
	return cxx2lang< MonoObject*, minerai >(api_info_minerai(lang2cxx< MonoObject*, position >(pos)))
;
}

gint32 cout_de_deplacement(gint32 id_nain, gint32 dir)
{
	return cxx2lang< gint32, int >(api_cout_de_deplacement(lang2cxx< gint32, int >(id_nain), lang2cxx< gint32, direction >(dir)))
;
}

MonoObject* position_taverne(gint32 id_joueur)
{
	return cxx2lang< MonoObject*, position >(api_position_taverne(lang2cxx< gint32, int >(id_joueur)))
;
}

MonoArray* historique()
{
	return cxx2lang< MonoArray*, std::vector<action_hist> >(api_historique())
;
}

gint32 score(gint32 id_joueur)
{
	return cxx2lang< gint32, int >(api_score(lang2cxx< gint32, int >(id_joueur)))
;
}

gint32 moi()
{
	return cxx2lang< gint32, int >(api_moi())
;
}

gint32 adversaire()
{
	return cxx2lang< gint32, int >(api_adversaire())
;
}

gint32 annuler()
{
	return cxx2lang< gint32, bool >(api_annuler())
;
}

gint32 tour_actuel()
{
	return cxx2lang< gint32, int >(api_tour_actuel())
;
}

void afficher_case_type(gint32 v)
{
	api_afficher_case_type(lang2cxx< gint32, case_type >(v))
;
}

void afficher_direction(gint32 v)
{
	api_afficher_direction(lang2cxx< gint32, direction >(v))
;
}

void afficher_erreur(gint32 v)
{
	api_afficher_erreur(lang2cxx< gint32, erreur >(v))
;
}

void afficher_action_type(gint32 v)
{
	api_afficher_action_type(lang2cxx< gint32, action_type >(v))
;
}

void afficher_debug_drapeau(gint32 v)
{
	api_afficher_debug_drapeau(lang2cxx< gint32, debug_drapeau >(v))
;
}

void afficher_position(MonoObject* v)
{
	api_afficher_position(lang2cxx< MonoObject*, position >(v))
;
}

void afficher_minerai(MonoObject* v)
{
	api_afficher_minerai(lang2cxx< MonoObject*, minerai >(v))
;
}

void afficher_nain(MonoObject* v)
{
	api_afficher_nain(lang2cxx< MonoObject*, nain >(v))
;
}

void afficher_action_hist(MonoObject* v)
{
	api_afficher_action_hist(lang2cxx< MonoObject*, action_hist >(v))
;
}


/*
** Inititialize Mono and load the DLL file.
*/
CSharpInterface::CSharpInterface()
{
  const char* champion_path = getenv("CHAMPION_PATH");
  std::string champion;

  if (!champion_path)
    champion = "./champion-prologin.dll";
  else
  {
    champion = champion_path;
    champion += "/champion-prologin.dll";
  }

  _domain = mono_jit_init(champion.c_str());
  assert(_domain != NULL);

  _assembly = mono_domain_assembly_open(_domain, champion.c_str());
  assert(_assembly != NULL);

  _image = mono_assembly_get_image(_assembly);
  assert(_image != NULL);

  _class = mono_class_from_name(_image, "Prologin", "Prologin");
  assert(_class != NULL);

  _object = mono_object_new(_domain, _class);
  assert(_object);

  mono_runtime_object_init(_object);

  // Register API functions as internal Mono functions
  mono_add_internal_call("Prologin.Api::Chemin", (const void*)chemin);
  mono_add_internal_call("Prologin.Api::Deplacer", (const void*)deplacer);
  mono_add_internal_call("Prologin.Api::Lacher", (const void*)lacher);
  mono_add_internal_call("Prologin.Api::Agripper", (const void*)agripper);
  mono_add_internal_call("Prologin.Api::Miner", (const void*)miner);
  mono_add_internal_call("Prologin.Api::Tirer", (const void*)tirer);
  mono_add_internal_call("Prologin.Api::PoserCorde", (const void*)poser_corde);
  mono_add_internal_call("Prologin.Api::DebugAfficherDrapeau", (const void*)debug_afficher_drapeau);
  mono_add_internal_call("Prologin.Api::TypeCase", (const void*)type_case);
  mono_add_internal_call("Prologin.Api::ListeCordes", (const void*)liste_cordes);
  mono_add_internal_call("Prologin.Api::CordeSurCase", (const void*)corde_sur_case);
  mono_add_internal_call("Prologin.Api::NainSurCase", (const void*)nain_sur_case);
  mono_add_internal_call("Prologin.Api::InfoNain", (const void*)info_nain);
  mono_add_internal_call("Prologin.Api::ListeMinerais", (const void*)liste_minerais);
  mono_add_internal_call("Prologin.Api::InfoMinerai", (const void*)info_minerai);
  mono_add_internal_call("Prologin.Api::CoutDeDeplacement", (const void*)cout_de_deplacement);
  mono_add_internal_call("Prologin.Api::PositionTaverne", (const void*)position_taverne);
  mono_add_internal_call("Prologin.Api::Historique", (const void*)historique);
  mono_add_internal_call("Prologin.Api::Score", (const void*)score);
  mono_add_internal_call("Prologin.Api::Moi", (const void*)moi);
  mono_add_internal_call("Prologin.Api::Adversaire", (const void*)adversaire);
  mono_add_internal_call("Prologin.Api::Annuler", (const void*)annuler);
  mono_add_internal_call("Prologin.Api::TourActuel", (const void*)tour_actuel);
  mono_add_internal_call("Prologin.Api::AfficherCaseType", (const void*)afficher_case_type);
  mono_add_internal_call("Prologin.Api::AfficherDirection", (const void*)afficher_direction);
  mono_add_internal_call("Prologin.Api::AfficherErreur", (const void*)afficher_erreur);
  mono_add_internal_call("Prologin.Api::AfficherActionType", (const void*)afficher_action_type);
  mono_add_internal_call("Prologin.Api::AfficherDebugDrapeau", (const void*)afficher_debug_drapeau);
  mono_add_internal_call("Prologin.Api::AfficherPosition", (const void*)afficher_position);
  mono_add_internal_call("Prologin.Api::AfficherMinerai", (const void*)afficher_minerai);
  mono_add_internal_call("Prologin.Api::AfficherNain", (const void*)afficher_nain);
  mono_add_internal_call("Prologin.Api::AfficherActionHist", (const void*)afficher_action_hist);
}

MonoImage* CSharpInterface::getImage()
{
    return _image;
}

MonoDomain* CSharpInterface::getDomain()
{
    return _domain;
}

CSharpInterface::~CSharpInterface()
{
  mono_image_close(_image);
  mono_assembly_close(_assembly);
  // XXX -- mono segfaults when calling this. Seems to be a known bug
  //        appearing when mono_jit_clean() is called from a dtor. ???
  //mono_jit_cleanup(_domain);
}

/*
** Calls C# functions from C++
*/
MonoObject* CSharpInterface::callCSharpMethod(const char* name)
{
  MonoThread*   thread = mono_thread_attach(_domain);
  MonoMethod*   method = mono_class_get_method_from_name(_class, name, 0);
  MonoObject*   object = mono_runtime_invoke(method, _object, NULL, NULL);

  mono_thread_detach(thread);

  return object;
}

/*
** Functions called from stechec to C.
*/
void partie_init()
{
  gl_csharp.callCSharpMethod("PartieInit");
}
void jouer_tour()
{
  gl_csharp.callCSharpMethod("JouerTour");
}
void partie_fin()
{
  gl_csharp.callCSharpMethod("PartieFin");
}
