// This file has been generated, if you wish to
// modify it in a permanent way, please refer
// to the script file : gen/generator_java.rb

import java.util.*;

/**
 * Les nains agissent chacun indépendamment les uns des autres. Ils vont miner un des minerais les plus proches. Si cela
 * est possible et judicieux, une corde est posée. Il n'attaquent pas l'ennemi autrement que pour se défendre s'il est proche.
 * Le calcul de plus court chemin a été revu, tenant compte des minerais à miner ainsi que des cordes et du sol.
 * Une remontée automatique est prévue dès qu'un nain est suffisamment chargé ou qu'il reste 15 tours.
 *
 * On pourrait envisager une meilleure stratégie de groupe, et surtout d'anéantissement de l'adversaire
 * (pas très commodes ces nains quand ils n'ont pas leur quota de bière) en songeant davantage au pillage, et à la
 * sécurité des nains ayant du butin.
 * De plus, la remontée de nains en tirant sur une corde n'a pas été exploitée.
 */

@SuppressWarnings({"unused", "WeakerAccess"})
public class Prologin extends Interface
{
	public static final Random random = new Random();

	// Objectifs des différents nains
	public Position[] GOALS = new Position[NB_NAINS];

	// Pour chaque objectif, on stocke le chemin pour y arriver
	@SuppressWarnings("unchecked")
	public Map<Position, Direction>[] PATHS = new Map[6];

	// Certains blocs peuvent être inaccessibles (barrière d'obsidienne)
	public List<Position> BANNED = new ArrayList<>(); // Bloqués

	/**
	 * Fonction appelée au début de la partie.
 	 */
	public void partie_init()
	{
		for (int nainId = 0; nainId < NB_NAINS; ++nainId) {
			GOALS[nainId] = position_taverne(moi());
		}
	}


	/**
	 * Fonction appelée à chaque tour.
	 */
	public void jouer_tour()
	{
		try {
			System.out.println("TOUR " + tour_actuel());
			long time = System.currentTimeMillis();

			// Chaque nain agit indépendamment
			for (int nainId = 0; nainId < NB_NAINS; ++nainId) {
				Nain nain = info_nain(moi(), nainId);

				// Si un nain a atteint sa destination ou qu'elle n'est plus valide (bloc miné) ou qu'il est à la taverne
				// (s'il est mort), alors on met à jour son objectif.
				// S'il n'est pas plein de butin (< 20) et qu'il reste au moins 20 tours (sauf s'il n'a aucun butin),
				// on l'envoie vers un minerai. Sinon, il retourne à la taverne.
				if (nain.pos.equals(GOALS[nainId]) || (type_case(GOALS[nainId]) != CaseType.GRANITE && !GOALS[nainId].equals(position_taverne(moi())))
						|| nain.pos.equals(position_taverne(moi()))) {
					if ((nain.butin < 0.8 * BUTIN_MAX && tour_actuel() <= NB_TOURS - 15) || nain.butin <= 0) {
						// Loi géométrique de paramètre 0.5 pour choisir un minerai proche (différent des objectifs déjà donnés)
						List<Position> minerais = plus_proches_minerais(nain);
						if (minerais.isEmpty())
							minerais = Arrays.asList(liste_minerais());
						if (!minerais.isEmpty()) {
							do {
								int index = 0;
								for (int i = 0; i < minerais.size(); ++i) {
									if (random.nextBoolean())
										++index;
									else
										break;
								}
								if (index == minerais.size())
									index = 0;
								Position minerai = minerais.get(index);
								setGoal(nainId, minerai);
								if (PATHS[nainId].get(nain.pos) == null) {
									minerais.remove(minerai);
									BANNED.add(minerai);
								}
							}
							while (PATHS[nainId].get(nain.pos) == null);
						}
						// S'il ne reste pas assez de minerai, on va se vider à la taverne et on va taper l'adversaire
						else {
							if (nain.butin > 0)
								setGoal(nainId, position_taverne(moi()));
							else
								setGoal(nainId, position_taverne(adversaire()));
						}
					}
					else {
						setGoal(nainId, position_taverne(moi()));
					}
				}

				// Si le nain a du butin et qu'il reste moins de 15 tours, on rentre à la taverne
				if (nain.butin > 0 && tour_actuel() > NB_TOURS - 15 && !GOALS[nainId].equals(position_taverne(moi())))
					setGoal(nainId, position_taverne(moi()));

				// On fait des actions tant que c'est possible
				Erreur err = Erreur.OK;
				while (err == Erreur.OK && !nain.pos.equals(GOALS[nainId])) {
					// Pour se prémunir contre quelques (rares) timeouts, on s'assure que le tout ne prenne pas trop de temps
					// Et on stoppe le tour sinon
					if (System.currentTimeMillis() - time > 900) {
						System.err.println("TIMEOUT");
						return;
					}

					nain = info_nain(moi(), nainId);
					agripper(nainId);
					if (nain.butin >= 0.8 * BUTIN_MAX)
						setGoal(nainId, position_taverne(moi()));
				//	debug_afficher_drapeau(GOALS[nainId], DebugDrapeau.DRAPEAU_BLEU);
					if (nain.vie == -1) {
						System.err.println("NAIN MORT");
						err = Erreur.NAIN_MORT;
						continue;
					}

					// Direction du chemin emprunté
					Direction dir = PATHS[nainId].get(nain.pos);


					// Si le nain doit descendre et qu'il n'y a pas trop de cases libres en dessous, il est plus rentable
					// de se laisser tomber
					int nbDescentes = 0;
					Position rel = nain.pos;
					Direction dir2 = dir;
					while (dir2 == Direction.BAS) {
						++nbDescentes;
						rel = rel.move(dir2);
						dir2 = PATHS[nainId].get(rel);
					}
					int freeCases = 0;
					rel = nain.pos.move(Direction.BAS);
					while (type_case(rel) == CaseType.LIBRE) {
						rel = rel.move(Direction.BAS);
						++freeCases;
					}

					if (nbDescentes > 0 && freeCases > 0 && nbDescentes <= 3 && (freeCases <= nbDescentes || freeCases <= 3)) {
						Position oldPos = nain.pos;
						lacher(nainId);
						err = agripper(nainId);
						nain = info_nain(moi(), nainId);
						// Si le nain a bougé, on reprend au début de la boucle
						if (!oldPos.equals(nain.pos))
							continue;
					}

					// On avance si la case de destination est libre
					Position newPos = nain.pos.move(dir);
					if (type_case(newPos) == CaseType.LIBRE && nain_sur_case(newPos) != adversaire()) {
						if (type_case(nain.pos.move(Direction.BAS)) != CaseType.LIBRE
								&& type_case(newPos.move(Direction.BAS)) != CaseType.LIBRE)
							lacher(nainId);
						err = deplacer(nainId, dir);
						agripper(nainId);
					}
					// Sinon on mine / on tape sur l'ennemi s'il est trop proche
					else {
						for (Direction d : Direction.values()) {
							if (d == Direction.ERREUR_DIRECTION)
								continue;

							if (nain_sur_case(nain.pos.move(d)) == adversaire() && err == Erreur.OK)
								err = miner(nainId, d);
						}

						if (type_case(newPos.move(Direction.BAS)) == CaseType.LIBRE)
							agripper(nainId);
						err = miner(nainId, dir);
						agripper(nainId);
					}
				}
			}

			// Nouvelle vérification du délai d'exécution
			if (System.currentTimeMillis() - time > 900) {
				System.err.println("TIMEOUT");
				return;
			}

			// Si c'est possible, on regarde si on peut déployer une corde à un endroit pas trop débile
			for (int nainId = 0; nainId < NB_NAINS; ++nainId) {
				Nain nain = info_nain(moi(), nainId);

				boolean worth = nain.pa == 6 && !corde_sur_case(nain.pos);
				if (!worth)
					continue;
				Position looking = nain.pos;
				for (int i = 0; i < 4; ++i) {
					worth &= type_case(looking) == CaseType.LIBRE;
					looking = looking.move(Direction.BAS);
				}

				if (worth)
					poser_corde(nainId, Direction.HAUT);
			}

			// Si on a le temps, on met à jour éventuellement les différents chemins
			List<Integer> l = new ArrayList<>(Arrays.asList(0, 1, 2, 3, 4, 5));
			Collections.shuffle(l, random);
			for (int nainId : l) {
				if (System.currentTimeMillis() - time < 420) {
					//System.out.println("DIJSKTRA " + nainId);
					PATHS[nainId] = dijkstra(GOALS[nainId]);
				}
			}

			System.out.println((System.currentTimeMillis() - time) + " ms");
		}
		// On se prémunit d'éventuelles erreurs qui viendraient casser l'IA
		catch (Throwable t) {
			t.printStackTrace();
		}
	}


	// Fonction appelée à la fin de la partie.
	public void partie_fin()
	{
		System.out.println("Fini !");
		if (score(moi()) > score(adversaire()))
			System.out.println("galaxyoyo a gagné. Normal : il est trop fort.");
		else if (score(moi()) == score(adversaire()))
			System.out.println("Bien joué ! Aussi fort que moi !");
		else
			System.out.println("L'adversaire a eu BEAUCOUP de chance sur ce coup ...");
	}

	/**
	 * Définition de l'objectif du nain, avec calcul du chemin à emprunter
	 */
	public void setGoal(int nainId, Position goal) {
		GOALS[nainId] = goal;
		PATHS[nainId] = dijkstra(goal);
	}

	/**
	 * Récupération des minerais les plus proches d'un nain, pondérés par leur rendement
	 */
	public List<Position> plus_proches_minerais(Nain nain) {
		Position[] allMinerais = liste_minerais();
		List<Position> pos = new ArrayList<>(Arrays.asList(allMinerais));
		pos.removeIf(p -> info_minerai(p).rendement < 0 || BANNED.contains(p));
		pos.sort(Comparator.comparingInt(p -> p.distance_squared(nain.pos) / (1 + (info_minerai(nain.pos).rendement > 0 ? info_minerai(nain.pos).rendement / 4 : 0))));
		for (int i = 0; i < NB_NAINS; ++i)
			pos.remove(GOALS[i]);
		return pos;
	}

	/**
	 * On évalue le coût de déplacement sur une case pour l'algorithme de plus court chemin
	 */
	public int getCost(Position pos) {
		CaseType type = type_case(pos);
		int cost = 1;
		if (type == CaseType.GRANITE)
			cost += 3;
		if (nain_sur_case(pos) == adversaire())
			cost += 3;
		if (type_case(pos.move(Direction.BAS)) == CaseType.LIBRE && !corde_sur_case(pos))
			cost += 1;

		return cost;
	}

	/**
	 * Calcul du chemin à suivre depuis tout point de la mine vers la position pos2
	 * On part du bloc final, et on explore via un parcours en largeur toute la grille,
	 * en s'assurant de minimiser (heuristiquement) le temps qu'il faut pour s'y rendre
	 * On évite les blocs d'obsidienne, la taverne adverse ainsi que les rubis à rendement négatif
	 * L'algorithme n'est pas le plus optimal mais relativement efficace
	 */
	public Map<Position, Direction> dijkstra(Position pos2) {
		List<Position> queue = new ArrayList<>();
		queue.add(pos2);
		Map<Position, Direction> map = new HashMap<>();
		Map<Position, Integer> dists = new HashMap<>();
		map.put(pos2, Direction.ERREUR_DIRECTION);
		dists.put(pos2, 0);

		while (!queue.isEmpty()) {
			Position pos = queue.remove(0);

			for (Direction dir : Direction.values()) {
				if (dir == Direction.ERREUR_DIRECTION)
					continue;

				Position newPos = pos.move(dir);
				if (newPos.ligne < 0 || newPos.ligne >= TAILLE_MINE || newPos.colonne < 0 || newPos.colonne >= TAILLE_MINE)
					continue;

				if (type_case(newPos) == CaseType.OBSIDIENNE) {
					dists.put(newPos, Integer.MAX_VALUE / 2);
					continue;
				}
				if (type_case(newPos) == CaseType.GRANITE && info_minerai(newPos).resistance > 0 && info_minerai(newPos).rendement < 0) {
					dists.put(newPos, Integer.MAX_VALUE / 2);
					continue;
				}

				if (newPos.equals(position_taverne(adversaire()))) {
					dists.put(newPos, Integer.MAX_VALUE / 2);
					continue;
				}

				int addingCost = getCost(newPos);

				if (!dists.containsKey(newPos) && !queue.contains(newPos))
					queue.add(newPos);

				if (dists.getOrDefault(newPos, Integer.MAX_VALUE / 4) <= dists.get(pos) + addingCost)
					continue;

				map.put(newPos, dir.opposite());
				dists.put(newPos, dists.get(pos) + addingCost);
			}
		}

		return map;
	}
}
