/// This file has been generated, if you wish to
/// modify it in a permanent way, please refer
/// to the script file : gen/generator_cxx.rb

#include "prologin.hh"
#include <algorithm>
#include <random>
#include <vector>
#include <iostream>
#include <queue>

using namespace std;

int dX[4] = {0, 0, -1, 1}; //haut bas gauche droit
int dY[4] = {-1, 1, 0, 0}; //haut bas gauche droit

constexpr static direction int_to_dir[5] = {HAUT, BAS, GAUCHE, DROITE, ERREUR_DIRECTION};
const float oo = (float)1e7;

/// Fonction appelée au début de la partie.
void partie_init()
{

}

position p_nain(int nain){
    return info_nain(moi(), nain).pos;
}

vector<nain> pos_to_nain_adv(position pos){
    vector<nain> v;
    for(int iAdv = 0; iAdv < 6; iAdv++){
        if(info_nain(adversaire(), iAdv).pos == pos)
            v.push_back(info_nain(adversaire(), iAdv));
    }
    return v;
}

int get_height(position pos){
    int height = 0;

    while(type_case(pos) == LIBRE){
        height++;
        pos.ligne--;
    }
    return height;
}

bool will_die(int nain, position jump_pos){

    int height = get_height(jump_pos);
    int damage;
    if(height < 4)
        damage = 0;
    else
        damage = pow(2,height - 4);

    return info_nain(moi(), nain).vie <= damage;
}
//bool blocked
bool can_walk(position pos, direction dir){
    case_type below = type_case({pos.ligne + 1, pos.colonne});
    int d;
    if(dir == GAUCHE)
        d = -1;
    else if(dir == DROITE)
        d = 1;
    else
        return false;

    case_type below_next = type_case({pos.ligne + 1, pos.colonne + d});

    if((below == GRANITE || below == OBSIDIENNE) && (below_next == GRANITE || below_next == OBSIDIENNE)){
        return true;
    }
    return false;

}

void go_to_target(int nain, position target){

   // cout << size(chemin(p_nain(nain), target)) << '\n';
    for(direction dir : chemin(p_nain(nain), target)){   //cette boucle itere que 2 fois (ou 3)
        if(info_nain(moi(), nain).pm == 0)
            return;

        agripper(nain);
        if(can_walk((p_nain(nain)), dir))
            lacher(nain);

        deplacer(nain, dir);
    }
}

int distance(position a, position b){
    //return  abs(a.ligne - b.ligne) + abs(a.colonne - b.colonne);
    return size(chemin(a,b));
}

direction pos_to_dir(position a, position b){
    if(b.ligne == a.ligne + 1 && b.colonne == a.colonne)
        return BAS;
    if(b.ligne == a.ligne - 1 && b.colonne == a.colonne)
        return HAUT;
    if(b.ligne == a.ligne && b.colonne == a.colonne + 1)
        return DROITE;
    if(b.ligne == a.ligne && b.colonne == a.colonne - 1)
        return GAUCHE;
    return ERREUR_DIRECTION;
}

float score_function(position minerai, int id_nain){
    int d = distance(p_nain(id_nain), minerai);
    if(d == 0)
        d = oo;

    float best_score = -oo;
    if(nain_sur_case(minerai) == -1){   //c'est un granit
        best_score = (float)(10 * min(BUTIN_MAX - info_nain(moi(), id_nain).butin, info_minerai(minerai).rendement) - info_minerai(minerai).resistance) /
        (float)(pow(d,2));
    }

    else if(nain_sur_case(minerai) == adversaire()){
        vector<nain> nain_adv = pos_to_nain_adv(minerai);
        for(nain n : nain_adv){
            float score = (float)((float)(10 * n.butin) - (float)(n.vie) / (float)DEGAT_PIOCHE) /
                          ((float)(pow(d,2)));

            best_score = max(best_score, score);

        }
    }
    return best_score;

}

position get_best_minerai(int nain, vector<position> candidats){ //un nain adverse est aussi un minerai
    position best_minerai = position_taverne(moi()); //initialisation sujette a contestations
    float best_score = -oo;

    for(position minerai : candidats){
        float score = score_function(minerai, nain);
        //cout << score << " " << minerai.ligne << " " << minerai.colonne << '\n';
        if(score > best_score){
            best_score = score;
            best_minerai = minerai;
        }
    }
    return best_minerai;
}


direction best_dir_to_mine(int nain){

    vector<position> candidats;

    for(int iDir = 0; iDir < 4; iDir++){
            position new_pos;
            new_pos.ligne = p_nain(nain).ligne + dY[iDir];
            new_pos.colonne = p_nain(nain).colonne + dX[iDir];
            if(type_case(new_pos) == GRANITE || (type_case(new_pos) == LIBRE && nain_sur_case(new_pos) == adversaire()))
                candidats.push_back(new_pos);
    }

    return pos_to_dir(p_nain(nain), get_best_minerai(nain, candidats));

}


/// Fonction appelée à chaque tour.
void jouer_tour()
{
    if(tour_actuel() == 2)
        poser_corde(0, HAUT);

    for(int iNain = 0; iNain < 6; iNain++){

        position target;

        if(info_nain(moi(), iNain).butin >= 20)
            target = position_taverne(moi());
        else{
            vector<position> candidats = liste_minerais();
            for(int iAdv = 0; iAdv < 6; iAdv++)
                candidats.push_back(info_nain(adversaire(), iAdv).pos);
            target = get_best_minerai(iNain, candidats);
            debug_afficher_drapeau(target, DRAPEAU_BLEU);

        }

        go_to_target(iNain, target);

        if(distance(p_nain(iNain), target) == 1)
            miner(iNain, pos_to_dir(p_nain(iNain), target));
        else
            miner(iNain, best_dir_to_mine(iNain));

    }
}


/// Fonction appelée à la fin de la partie.
void partie_fin()
{
  // fonction a completer
}

